/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceJVM;

public class IcePM
extends IceJVM {
    public static final int CF_SLOTS = 67239944;
    public static final int CF_SNIFF = 0x4020000;
    public static final int CF_XFER = 67239952;
    public static final int CF_RESET = 67239944;
    public static int runMode;
    public static int dcfgA;
    public static int dcfgB;
    public static int delayA;
    public static int delayB;
    public static int dbg1;
    public static int dbg2;
    public static int dbg3;

    public static void run() {
        int beat = 30277923;
        IcePM.awMem(-50266116, beat);
        IcePM.reset();
        IcePM.resetCmdFifo(1);
        while (true) {
            int slots;
            IcePM.processMessages();
            if (runMode == 2) {
                IcePM.processAlgorithm();
            }
            if ((slots = IcePM.arBusSync(67239944) & 0xFFF) > 0) {
                int cmd = IcePM.arBus(0x4020000);
                if ((cmd & 0xFFF00000) != 484442112) {
                    IcePM.cleanupCmdFifo();
                } else if (slots >= (cmd & 0xF)) {
                    IcePM.processCmdFifo();
                }
            }
            IcePM.awMem(-50266116, beat);
            ++beat;
        }
    }

    public static void wdbg() {
        IcePM.awMem(768, dbg1);
        IcePM.awMem(772, dbg2);
        IcePM.awMem(776, dbg3);
    }

    public static void resetCmdFifo(int mode) {
        IcePM.awBus(67239944, mode < 0 ? 1 : mode);
        IcePM.awBus(67239944, mode < 0 ? 0 : mode);
    }

    public static void cleanupCmdFifo() {
        int cmd;
        dbg2 = IcePM.arBus(67239944);
        dbg3 = cmd = IcePM.arBus(67239952);
        IcePM.wdbg();
    }

    public static void processCmdFifo() {
        int cmd = IcePM.arBus(67239952);
        int addr = IcePM.rBus();
        if (cmd == 484507652) {
            int len;
            int data = IcePM.rBus();
            if (len < 4 || len > 256) {
                IcePM.cleanupCmdFifo();
                return;
            }
            IcePM.aBus(addr);
            IcePM.awBus(addr, data);
            for (len = IcePM.rBus(); len > 4; len -= 4) {
                while ((IcePM.arBusSync(67239944) & 0xFFF) == 0) {
                }
                IcePM.awBus(addr, IcePM.arBus(67239952));
            }
        } else if (cmd == 484573186) {
            IcePM.aBus(addr);
            int data = IcePM.arBus(addr);
            IcePM.awBus(67239952, 484638722);
            IcePM.awBus(67239952, data);
        }
    }

    public static void processWRB(int key) {
        maddr = -50331644;
        saddr = mdata;
        for (int size = key >> 8 & 0xFFFF; size > 0; size -= 4) {
            sdata = mdata;
        }
        maddr = -50331648;
        mdata = -1442840406;
    }

    public static void processMessages() {
        maddr = -50331648;
        int key = mdata;
        if (key >> 24 != 85) {
            return;
        }
        if ((key & 0xFF) == 119) {
            IcePM.processWRB(key);
            return;
        }
        int node = mdata;
        int head = mdata;
        int addr = mdata;
        int func = head & 0x3F;
        int olen = head >> 16;
        int size = olen >> 2;
        int data = -50331632;
        switch (func) {
            case 1: {
                IcePM.busr(addr, data, size);
                break;
            }
            case 2: {
                IcePM.busw(addr, data, size);
                olen = 0;
                break;
            }
            case 3: {
                IcePM.memr(addr, data, size);
                break;
            }
            case 4: {
                IcePM.memw(addr, data, size);
                olen = 0;
                break;
            }
            case 6: {
                IcePM.initAlgorithm();
                if (addr != -1) break;
                IcePM.resetCmdFifo(-1);
                break;
            }
            case 7: {
                IcePM.modifyAlgorithm(data, size);
                break;
            }
            case 8: 
            case 9: {
                int port = addr & 0xFFFF;
                int type = addr >> 16;
                int route = mdata;
                int dcfg = mdata;
                int delay = mdata;
                if (dcfg != 0) {
                    IcePM.setupDelay(dcfg, delay);
                }
                if (func == 8) {
                    IcePM.openAlgorithm(port, type, route);
                    break;
                }
                IcePM.closeAlgorithm(port, type, route);
                break;
            }
            case 14: {
                IcePM.busrwm(addr, data, size);
                break;
            }
            case 15: {
                IcePM.memi(data, size);
                olen = 0;
            }
        }
        maddr = -50331648;
        mdata = 0xAA0000AA | olen << 8;
    }

    public static void initAlgorithm() {
        IcePM.resetDMA();
        runMode = 0;
        dcfgA = 0;
        dcfgB = 0;
    }

    public static void openAlgorithm(int port, int type, int route) {
        IcePM.awBus(0x1008008, route);
    }

    public static void processDelays() {
        if (dcfgA != 0) {
            IcePM.processDelay(dcfgA, delayA);
        }
        if (dcfgB != 0) {
            IcePM.processDelay(dcfgB, delayB);
        }
    }

    public static void setupDelay(int dcfg, int delay) {
        int i = dcfg >> 8 & 0xF;
        int j = dcfg >> 12 & 0xF;
        int k = dcfg & 0xFF;
        if ((i & 1) == 0) {
            dcfgA = dcfg;
            delayA = delay;
            k |= 0x8000000;
        } else {
            dcfgB = dcfg;
            delayB = delay;
        }
        IcePM.setupDMAo(i, k, -1);
        IcePM.setupDMAi(j, k, -1);
    }

    public static void processDelay(int dcfg, int delay) {
        int ioff;
        int oc = dcfg >> 8 & 0xF;
        int ic = dcfg >> 12 & 0xF;
        int route = 1 << ic + 24;
        int croute = IcePM.arBus(0x1008000);
        if ((croute & route) != 0) {
            return;
        }
        int ooff = IcePM.arMemSync(-41926848 + (oc << 3));
        int diff = ooff - (ioff = IcePM.arMemSync(-41926912 + (ic << 3)));
        if (diff < 0) {
            diff += 0x8000000;
        }
        if ((diff -= delay) > 4096) {
            ioff = ioff & 0x8000000 | ioff + 4096 & 0x7FFFFFF;
            IcePM.awMem(-41926912 + (ic << 3) + 4, ioff);
            IcePM.awBus(0x1008008, route);
        }
    }

    public static void processAlgorithm() {
    }

    public static void closeAlgorithm(int port, int type, int route) {
        IcePM.awBus(16809996, route);
        if (IcePM.arBus(0x1008000) == 0) {
            IcePM.resetDMA();
        }
    }

    public static void modifyAlgorithm(int data, int size) {
    }

    protected static void reset() {
        IcePM.resetDMA();
        runMode = 0;
        IcePM.awMem(-50331648, 0);
    }

    protected static void resetDMA() {
        int i;
        IcePM.awBus(0x1008000, -1);
        IcePM.udelay(20);
        IcePM.awBus(0x1008000, -1);
        for (i = 0; i < 8; ++i) {
            IcePM.setupDMAi(i, 0, 0);
        }
        for (i = 0; i < 8; ++i) {
            IcePM.setupDMAo(i, 0, 0);
        }
        for (i = 0; i < 32; ++i) {
            IcePM.setupDMAt(i, 0);
        }
        IcePM.awBus(16809988, 32);
        IcePM.setupDMAo(2, 2, -1);
        IcePM.setupDMAo(3, 2, -1);
    }

    static void setupDMAno(int i, int cur_addr, int cfg_addr) {
        maddr = -41926720 + (i << 3);
        mdata = cur_addr;
        mdata = cfg_addr;
    }

    static void setupDMAo(int i, int cur_addr, int cfg_addr) {
        maddr = -41926848 + (i << 3);
        mdata = cur_addr;
        mdata = cfg_addr;
    }

    static void setupDMAi(int i, int cur_addr, int cfg_addr) {
        maddr = -41926912 + (i << 3);
        mdata = cur_addr;
        mdata = cfg_addr;
    }

    static void setupDMAt(int i, int cur_addr) {
        maddr = -41943040 + (i << 2);
        mdata = cur_addr;
    }

    protected static int dmaSync(int addr) {
        maddr = addr;
        int data = mdata;
        return data -= mdata;
    }

    public static int wait4route(int mask) {
        for (int i = 0; i < 4080; ++i) {
            if ((IcePM.arBus(0x1008000) & mask) == 0) {
                return i;
            }
            if (i <= 256) continue;
            IcePM.udelay(10);
        }
        IcePM.awBus(16809996, mask);
        return -1;
    }
}

