/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceHW;
import nxm.ice.lib.IceJVM;

public class IcePIC7
extends IceJVM {
    public static int runMode;
    public static int lastDir;
    public static int baddr;
    public static int dmaqp;
    public static int lastStkLoc;
    public static int lastStkOff;

    public static void run() {
        IcePIC7.reset();
        int tick = 1;
        while (true) {
            int stat;
            if (((stat = IcePIC7.arBus(33554504)) & 0x10000) != 0) {
                IcePIC7.processMsg();
            }
            if ((stat = IcePIC7.arMem(-50331648)) >> 24 == 85) {
                IcePIC7.processMessages();
            }
            if ((stat = IcePIC7.arMem(dmaqp)) != 0) {
                IcePIC7.processDMA(stat << 2);
            } else {
                IcePIC7.awMem(-50201100, dmaqp - -50201088 >> 2);
                dmaqp = -50201088;
                IcePIC7.awBus(33554556, tick);
            }
            IcePIC7.awMem(-50266116, tick);
            ++tick;
        }
    }

    public static int isBus(int addr) {
        if ((addr &= 0xFF000000) == -50331648) {
            return 0;
        }
        if (addr != 0) {
            return 1;
        }
        return 0;
    }

    public static void resetFifo() {
        int r1 = IcePIC7.arBus(33554504);
        if ((r1 & 0x8000000) != 0) {
            return;
        }
        while ((r1 & 0x10) != 0) {
            r1 = IcePIC7.arBus(33554504);
        }
        IcePIC7.awBus(33554504, r1 | 4);
    }

    public static void processMsg() {
        int r1 = IcePIC7.arBus(0x2000060);
        int r2 = IcePIC7.arBus(33554532);
        int r3 = IcePIC7.arBus(33554536);
        int i2 = r2 << 2;
        int r0 = r3;
        switch (r1) {
            case 0: {
                break;
            }
            case 1: {
                if (IcePIC7.isBus(i2) != 0) {
                    IcePIC7.awBus(i2, r3);
                    break;
                }
                IcePIC7.awMem(i2, r3);
                break;
            }
            case 2: {
                r0 = IcePIC7.isBus(i2) != 0 ? IcePIC7.arBus(i2) : IcePIC7.arMem(i2);
                IcePIC7.wait4dma(16);
                break;
            }
            case 3: {
                int r4;
                r0 = IcePIC7.arMem(i2);
                r0 &= r1;
                IcePIC7.awMem(i2, r0 |= (r3 &= r4));
                break;
            }
            case 4: {
                int r4;
                r0 = r3 & 0xFFFF;
                IcePIC7.resetFifo();
                IcePIC7.awBus(0x2000070, r0);
                if ((r4 & 4) != 0) {
                    IcePIC7.wfifo(i2, r0);
                } else {
                    IcePIC7.rfifo(i2, r0);
                }
                return;
            }
            case 7: {
                r0 = r3 | r2 << 28;
                IcePIC7.writemod(r0);
                break;
            }
            case 8: {
                int r4;
                int r5 = r4 & 0xFFFF0000;
                if (r4 <= 4) {
                    IcePIC7.awBus(r2, r3);
                    break;
                }
                if ((r4 &= 0xFFFF) > 4) {
                    IcePIC7.resetFifo();
                }
                IcePIC7.awBus(0x2000070, 0);
                if (r5 != 0) {
                    r0 = IcePIC7.adon_wrb(r2, r3, r4, r5);
                } else {
                    while (r4 > 0) {
                        IcePIC7.awBus(r2, IcePIC7.rafifo());
                        r4 -= 4;
                    }
                }
                return;
            }
            case 9: {
                if (r2 >= 0) {
                    IcePIC7.initMC();
                    runMode = 1;
                    break;
                }
                runMode = 0;
                break;
            }
            case 10: {
                int r4;
                r0 = IcePIC7.adon_tc(i2, r3, r4);
                break;
            }
            case 11: {
                r0 = IcePIC7.adon_mstat(r2);
                break;
            }
            case 12: {
                r0 = IcePIC7.adon_nstat(r2);
                break;
            }
            case 13: {
                IceHW.DMAStruct dma = (IceHW.DMAStruct)IcePIC7.getObjectAt(i2);
                if (dma.todo != 0) {
                    dma.stat = -dma.stat;
                    r0 = dma.hxfer;
                    break;
                }
                r0 = 0;
                break;
            }
            case 14: 
            case 15: {
                r2 = (r2 & 0xC0) << 20 | 0x400000 | r2 & 0x3F;
                if (r1 == 14) {
                    IcePIC7.awBus(r2, r3);
                    break;
                }
                r0 = IcePIC7.arBus(r2);
                break;
            }
            case 16: {
                int r4;
                IcePIC7.resetFifo();
                IcePIC7.awBus(0x2000070, 0);
                r0 = IcePIC7.adon_rwiob(r2, r3, r4, false);
                return;
            }
            case 17: {
                int r4;
                r0 = IcePIC7.adon_rwiob(r2, r3, r4, true);
                break;
            }
            case 19: {
                IceHW.DMAStruct dma = (IceHW.DMAStruct)IcePIC7.getObjectAt(i2);
                IcePIC7.awBus(33554552, dma.hcycle);
                IcePIC7.awBus(33554548, dma.hindex);
                r0 = dma.cindex - dma.caddr;
                if (r0 > 65535) {
                    r0 = 65535;
                }
                r0 |= dma.stat << 16;
                break;
            }
            case 20: {
                int r4;
                if (r2 == -10) {
                    IcePIC7.resetFifo();
                    IcePIC7.awBus(0x2000070, 0);
                    for (int i = 0; i < r3; ++i) {
                        IcePIC7.dojtagx(0, IcePIC7.rafifo(), r4 | 0xF);
                    }
                    return;
                }
                if (r2 == -11 || r2 == -12) {
                    int j = r4 & 0xFFFF;
                    int k = r4 & 0xFFFF0000;
                    r0 = IcePIC7.arMem(r3 << 2);
                    int i = 0;
                    while (i < j) {
                        if (r2 == -11) {
                            IcePIC7.dojtag(0, IcePIC7.arMem(r3 << 2), k | 0xF);
                        }
                        if (r2 == -12) {
                            r0 = IcePIC7.dojtag(0, r0, k | 0xF0F);
                            IcePIC7.awMem(r3 << 2, r0);
                            r0 = 0;
                        }
                        ++i;
                        ++r3;
                    }
                    break;
                }
                r0 = IcePIC7.dojtag(r2, r3, r4);
                break;
            }
            case 22: {
                int r4;
                r0 = IcePIC7.dompio(r2, r3, r4);
                break;
            }
            case 23: {
                IcePIC7.awBus(0x2000070, r0);
                IcePIC7.udelay(10000);
                IcePIC7.awBus(524288, r2);
                IcePIC7.awBus(524288, r3);
                return;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                int r5;
                int r4;
                r0 = r4;
                IcePIC7.wait4dma(16);
                if (r4 < 0) {
                    r0 = -r4;
                    IcePIC7.setupDMAi(1, r3 | 0x1F, r3 + r0);
                    IcePIC7.awBus(0x1008008, 0x2000000);
                    r5 = 48;
                } else {
                    IcePIC7.awBus(0x1008010, 0);
                    r5 = 4112;
                }
                IcePIC7.awBus(33554520, r2 << 6);
                if ((r2 >>= 26) > 0) {
                    r5 |= 0x800;
                }
                IcePIC7.awBus(0x2000044, r2);
                IcePIC7.awBus(33554524, r0);
                IcePIC7.awBus(33554504, r5);
                IcePIC7.wait4dma(256);
                if (r4 > 0) {
                    IcePIC7.setupDMAo(1, r3 | 0x1F, r3 + r0);
                    IcePIC7.awBus(0x1008008, 131072);
                }
                IcePIC7.wait4dma(16);
                break;
            }
            case 27: 
            case 28: {
                int r4;
                r0 = r1 == 27 ? 42405 : 53970;
                int r5 = r4 | 0xF;
                IcePIC7.dojtag(-2, r0, r5);
                IcePIC7.dojtag(-2, r2, r5);
                IcePIC7.dojtag(-2, 46260, r5);
                r0 = IcePIC7.dojtag(-2, r3, 0xF0F | r4);
                IcePIC7.dojtag(-2, -1, r5);
                IcePIC7.dojtag(-2, -1, 15);
                break;
            }
            case 29: {
                int r4;
                IcePIC7.resetFifo();
                IcePIC7.awBus(0x2000070, 0);
                r0 = IcePIC7.adon_wriop(r2, r3, r4);
                return;
            }
            case 30: {
                int r4;
                maddr = i2;
                for (r4 = IcePIC7.arBus(33554540); r4 > 0; --r4) {
                    IcePIC7.aBus(mdata);
                    IcePIC7.wBus(mdata);
                }
                break;
            }
            case 31: {
                int r4;
                IcePIC7.awBus(r3, 0);
                maddr = i2;
                IcePIC7.awBus(r4, mdata);
                r0 = IcePIC7.arBus(r3 + 11);
                IcePIC7.awBus(r4 += 4, mdata);
                IcePIC7.awBus(r4 += 4, mdata - r0);
                IcePIC7.awBus(r4 += 8, mdata);
                IcePIC7.awBus(r4 += 4, mdata);
                IcePIC7.awBus(r3, 1);
            }
        }
        IcePIC7.awBus(0x2000070, r0);
    }

    /*
     * Unable to fully structure code
     */
    public static void processDMA(int stkloc) {
        dma = (IceHW.DMAStruct)IcePIC7.getObjectAt(stkloc);
        dir = dma.dir;
        IcePIC7.dmaqp += 4;
        if (dma.todo == 0) {
            if (dma.stat > 0) {
                IcePIC7.portStop(dma);
            }
            return;
        }
        if (dma.stat == 0 && (dir <= 0 || dma.todo == -1)) {
            IcePIC7.portStart(dma);
        }
        if (dma.todo == -1) {
            if (dma.master == -1 && dma.hind != 0) {
                i = IcePIC7.arBus(dma.hind << 2);
                if ((i & (j = -16777216)) == 0 && (dma.hindex & j) != 0) {
                    ++dma.hcycle;
                }
                dma.hindex = i;
            }
            return;
        }
        i = dir == 3 ? dma.cind : dma.cindp;
        stat = IcePIC7.arMemSync(i << 2);
        if (dir == -2) {
            if (stat < dma.hindex) {
                if (stat <= 1) {
                    stat = dma.haddr;
                }
                ++dma.hcycle;
                if (dma.todo > 0) {
                    --dma.todo;
                }
            }
            dma.hindex = stat;
            IcePIC7.updateHIP(dma, stat);
            return;
        }
        stop = dma.haddr + dma.hsize;
        xfer = stop - dma.hindex;
        diff = 0x4000000 - (dma.hindex & 0x3FFFFFF);
        if (xfer > diff) {
            xfer = diff;
        }
        if (dma.frame != 0) {
            if (dma.appp == 0) {
                dma.appp = (dma.frame & 65535) << 3;
            }
            if ((i = dma.appp) < 0) {
                i = -i;
            }
            if (xfer > i) {
                xfer = i;
            }
        }
        if (xfer > dma.hxfer) {
            xfer = dma.hxfer;
        }
        cxfer = xfer << 4;
        csize = dma.csize;
        clast = dma.caddr + csize;
        nhindex = dma.hindex + xfer;
        if (nhindex >= stop) {
            nhindex = dma.haddr;
        }
        if ((ncindex = dma.cindex + cxfer) >= clast) {
            ncindex -= csize;
        }
        if ((diff = (ccur = (stat & 2147483584) >> 2) - dma.cindex) < 0 || diff == 0 && dma.stat == 0 && dma.ccycle == 0 && dir != 3) {
            diff += csize;
        }
        space = csize - diff;
        if (dir < 0) {
            if (diff < cxfer) {
                return;
            }
            if (space < csize >> 2 && dma.frame == 0) {
                ++dma.miss;
            }
        } else if (dir != 2) {
            if (dir == 3) {
                if (dma.stat != 1) {
                    if (dma.stat == 0) {
                        dma.stat = 3;
                        IcePIC7.portStart(dma);
                    }
                    if (diff < csize >> 1) {
                        return;
                    }
                    IcePIC7.awBus(0x1008008, dma.enb);
                    dma.stat = 1;
                }
                dma.fcny = diff;
                if (diff < cxfer) {
                    ++dma.miss;
                    IcePIC7.awBus(16809996, dma.enb);
                    dma.stat = 2;
                }
                if ((diff = (IcePIC7.arMemSync(dma.cindp << 2) >> 2) - dma.cindex) >= 0 && diff < cxfer) {
                    return;
                }
                dir = -3;
            } else if (dma.todo == -17) {
                if (dma.appp == 0 && ccur != dma.cindex) {
                    IcePIC7.wait4route(131072);
                    IcePIC7.awMem(dma.cindp + 1 << 2, dma.cindex << 2);
                    if (dma.stat == 0) {
                        dma.stat = 2;
                        IcePIC7.portStart(dma);
                    } else {
                        IcePIC7.awBus(0x1008008, dma.enb);
                    }
                    dma.cind = dma.cindex;
                }
                dma.appp = IcePIC7.arBus(0x1008000) & dma.enb & 0xFF0000;
                if (diff != 0 && diff < csize >> 2) {
                    return;
                }
                if (stkloc == IcePIC7.lastStkLoc) {
                    i = IcePIC7.lastStkOff;
                } else {
                    i = stkloc - -50216960 & 65535;
                    i = IcePIC7._idiv(i, 48);
                    IcePIC7.lastStkLoc = stkloc;
                    IcePIC7.lastStkOff = i;
                }
                dma.hind = IcePIC7.arBusSync(0x2000080 + i);
                i = dma.hind - dma.hindex;
                if (i >= 0 && i < dma.hxfer) {
                    return;
                }
            } else if (dma.todo == -19) {
                if (dma.stat == 0 && space >= csize) {
                    IcePIC7.portStart(dma);
                }
                if (diff < cxfer) {
                    return;
                }
                if (dma.hcycle > 0) {
                    dir = 0;
                } else if (ncindex == dma.caddr) {
                    ncindex += csize;
                }
            } else {
                if (dma.stat == 0 && space >= csize >> 1) {
                    IcePIC7.portStart(dma);
                }
                if (diff < cxfer + 256) {
                    return;
                }
                if (dma.stat != 0 && space < csize >> 2) {
                    ++dma.miss;
                }
            }
        }
        if (dma.frame == 0) ** GOTO lbl130
        if (dma.appp <= 0) {
            dma.appp += xfer;
            nhindex = dma.hindex;
        } else {
            dma.appp -= xfer;
            if (dma.appp == 0) {
                dma.appp = ((dma.frame & 65535) << 3) * (1 - (dma.frame >> 16));
            }
lbl130:
            // 4 sources

            if (dma.todo != -14) {
                start = dma.cindex << 2 | stat & 31;
                stop = ncindex << 2;
                hindex = dma.hindex;
                if (dir != IcePIC7.lastDir) {
                    if (IcePIC7.lastDir <= 0) {
                        IcePIC7.wait4dma(16);
                    } else {
                        IcePIC7.wait4route(131072);
                    }
                    IcePIC7.awBus(0x1008010, 0);
                }
                if (dir != 0) {
                    if (dir < 0) {
                        j = xfer & 31;
                        if (j != 0) {
                            i = 32 - j;
                            xfer += i;
                            hindex -= i;
                            if ((start -= i << 6) < dma.caddr << 2) {
                                start += csize << 2;
                            }
                        }
                        if (IcePIC7.wait4route(0x2000000) < 0) {
                            IcePIC7.unlockDMA(dma);
                            return;
                        }
                        IcePIC7.setupDMAi(1, start, stop);
                        IcePIC7.wait4dma(16);
                        IcePIC7.awBus(0x1008008, 0x2000000);
                    } else if (dir == 2) {
                        IcePIC7.wait4dma(16);
                    } else {
                        if (IcePIC7.wait4route(131072) < 0) {
                            IcePIC7.unlockDMA(dma);
                            return;
                        }
                        IcePIC7.awBus(0x1008010, 0);
                    }
                }
                if (dir != 0) {
                    mcsr = dma.mcsr;
                    IcePIC7.awBus(33554520, hindex << 6);
                    IcePIC7.awBus(0x2000044, hindex >> 26);
                    IcePIC7.awBus(33554524, xfer << 6);
                    IcePIC7.awBus(33554504, mcsr);
                    IcePIC7.wait4dma(256);
                }
                if (dir == 1) {
                    IcePIC7.setupDMAo(1, start, stop);
                    IcePIC7.awBus(0x1008008, 131072);
                }
                IcePIC7.updateHIP(dma, dma.hindex);
                IcePIC7.lastDir = dir;
            }
        }
        if (ncindex < dma.cindex) {
            ++dma.ccycle;
        }
        dma.cindex = ncindex;
        if (nhindex < dma.hindex) {
            ++dma.hcycle;
            if (dma.todo >= 1) {
                --dma.todo;
            }
            if (dma.todo == 0 && dma.chain != 0) {
                i = dma.chain << 2;
                dma.haddr = IcePIC7.arMem(i);
                dma.hsize = IcePIC7.arMem(i += 4);
                dma.todo = IcePIC7.arMem(i += 4);
                dma.chain = IcePIC7.arMem(i += 4);
                nhindex = dma.haddr;
            }
            if (((stat = IcePIC7.readmod(dma.mcfg)) & 4) != 0) {
                dma.err = stat >> 8 & 255;
                if (dma.err == 0) {
                    dma.err = 256;
                }
            }
        }
        dma.hindex = nhindex;
    }

    public static void portStart(IceHW.DMAStruct dma) {
        int side = IcePIC7.getside(dma);
        int dir = dma.dir;
        int ro = IcePIC7.arBus(0x1008000);
        int r = ro | dma.enb;
        int i = IcePIC7.arMem(-50200652) & 0xFFFFFF1F;
        if ((dma.feed & 0xF) != 0) {
            if ((r & 0x40003A00) != 0 && (ro & 0x40003A00) == 0) {
                IcePIC7.awBus(0x40000000, 1);
            }
            if ((r & 0x8000C500) != 0 && (ro & 0x8000C500) == 0) {
                IcePIC7.awBus(Integer.MIN_VALUE, 1);
            }
            if ((r & 0x1200) != 0 && (ro & 0x1200) == 0) {
                IcePIC7.awBus2z(0x40000010);
            }
            if ((r & 0x2800) != 0 && (ro & 0x2800) == 0) {
                IcePIC7.awBus2z(0x40000014);
            }
            if ((r & 0x4100) != 0 && (ro & 0x4100) == 0) {
                IcePIC7.awBus2z(-2147483632);
            }
            if ((r & 0x8400) != 0 && (ro & 0x8400) == 0) {
                IcePIC7.awBus2z(-2147483628);
            }
        }
        if ((r & 0x4045153) != 0 != ((r & 0x808A8AC) != 0)) {
            i |= 0x20;
        }
        if ((r & 0x400000) == 0 || (r & 0x800000) == 0) {
            i |= 0x80;
        }
        if ((dma.mcfg & 0x200000) != 0) {
            i |= 0x20;
            if ((r & 0x99) != 0) {
                i |= 0x40;
            }
        }
        if ((dma.flags & Integer.MIN_VALUE) != 0) {
            if (dir < 0) {
                i |= 0x2000000;
            } else if ((dma.flags & 0x100000) == 0) {
                i |= 0x1000000;
                IcePIC7.awBus(0x1008008, 65536);
            }
        }
        if (dir == 2) {
            i |= 0x200000;
        }
        if (dir == -2) {
            IcePIC7.awMem((dma.cindp ^ 0x10) << 2, dma.todo == 1 ? 0 : dma.haddr);
            i |= 0x100000;
        }
        IcePIC7.awMem(-50200652, i);
        IcePIC7.awBus(16809988, i);
        int cadr = side == 2 ? 0x8000004 : 0x4000004;
        int gmcfg = IcePIC7.arMem(-50200592);
        if (gmcfg != 0) {
            IcePIC7.awBus(cadr - 3, 0);
        }
        r = IcePIC7.arBusSync(cadr);
        if (side == 3 && (dma.mcfg & Integer.MIN_VALUE) != 0) {
            r += IcePIC7.arBus(0x8000004);
        }
        if (dma.stat == 0) {
            IcePIC7.awBus(0x1008008, dma.enb);
        }
        IcePIC7.writemod(gmcfg);
        IcePIC7.awMem(-50200600, r);
        IcePIC7.awMem(-50200592, 0);
        if (dma.stat != 3) {
            dma.stat = 1;
        }
        if (dir < 0) {
            IcePIC7.updateHIP(dma, 0);
        } else {
            if (dma.todo > 0 || dma.todo == -17) {
                dma.alg = 1;
            }
            if (dma.todo == -11) {
                dma.stat = -1;
                dma.todo = 1;
            }
        }
    }

    public static void portStop(IceHW.DMAStruct dma) {
        int enb = dma.enb;
        int side = IcePIC7.getside(dma);
        int ro = IcePIC7.arBus(0x1008000);
        if (dma.dir > 0 && dma.alg > 0 && dma.feed == 0) {
            if (dma.alg == 1) {
                dma.alg = 2;
                IcePIC7.awMem(dma.cindp + 1 << 2, dma.cindex << 2);
            }
            if ((enb & IcePIC7.arBus(0x1008000)) != 0) {
                return;
            }
        }
        if (dma.dir > 0 && (enb & 0xFF000000) != 0) {
            IcePIC7.awBus(16809996, enb & 0xFF000000);
            IcePIC7.udelay(100);
        }
        dma.stat = 0;
        int r = IcePIC7.getenb();
        enb &= r ^ ro;
        if ((r & 0x40003A00) == 0 && (ro & 0x40003A00) != 0) {
            IcePIC7.awBus(0x40000000, 0);
        }
        if ((r & 0x8000C500) == 0 && (ro & 0x8000C500) != 0) {
            IcePIC7.awBus(Integer.MIN_VALUE, 0);
        }
        IcePIC7.awBus(side == 2 ? 0x8000001 : 0x4000001, 0);
        IcePIC7.awBus(16809996, enb);
        if (side == 3) {
            side = 1;
        }
        int gmcfg = IcePIC7.arMem(-50200592 + (side << 2));
        IcePIC7.writemod(gmcfg);
        IcePIC7.updateHIP(dma, 0);
        if (r == 0) {
            ro = IcePIC7.arMem(-50200652);
            IcePIC7.awMem(-50200652, ro &= 0xFCCFFFFF);
        }
    }

    public static int getenb() {
        int enb = 0;
        int i = -50201088;
        int stkloc;
        while ((stkloc = IcePIC7.arMem(i)) != 0) {
            IceHW.DMAStruct dma = (IceHW.DMAStruct)IcePIC7.getObjectAt(stkloc <<= 2);
            if (dma.stat != 0) {
                enb |= dma.enb;
            }
            i += 4;
        }
        return enb;
    }

    public static int getside(IceHW.DMAStruct dma) {
        int side = dma.mcfg >> 28 & 3;
        if (side == 0) {
            side = (dma.port & 1) != 0 ? 1 : 2;
        }
        return side;
    }

    public static void updateHIP(IceHW.DMAStruct dma, int index) {
        if (dma.hindp <= 163840) {
            return;
        }
        IcePIC7.awBus(dma.hindp << 2, index);
    }

    public static void unlockDMA(IceHW.DMAStruct dma) {
        int mcsr = IcePIC7.arBus(33554504);
        if ((mcsr & 0x10) != 0) {
            IcePIC7.awBus(33554504, mcsr &= 0xFFFFFFEF);
        }
        ++dma.err;
    }

    public static int adon_mstat(int side) {
        int mcfg = 0;
        int mask = side << 28;
        int i = -50201088;
        int stkloc;
        while ((stkloc = IcePIC7.arMem(i)) != 0) {
            IceHW.DMAStruct dma = (IceHW.DMAStruct)IcePIC7.getObjectAt(stkloc <<= 2);
            if (dma.stat != 0 && (dma.mcfg & mask) != 0) {
                mcfg |= dma.mcfg;
            }
            i += 4;
        }
        return mcfg;
    }

    public static int adon_nstat(int dmac) {
        int stkloc;
        int stat = 0;
        int stki = 159744 + (dmac - 1) * 48 << 2;
        int i = -50201088;
        while ((stkloc = IcePIC7.arMem(i)) != 0) {
            IceHW.DMAStruct dma = (IceHW.DMAStruct)IcePIC7.getObjectAt(stkloc <<= 2);
            if (stkloc == stki) {
                stat |= dma.dec - 1;
                if (dma.todo != 0) {
                    stat |= 0x8000;
                }
            } else if (dma.master == dmac) {
                int mask = dma.port - 1 >> 1 & 0xF;
                stat |= 1 << 16 + mask;
            }
            i += 4;
        }
        return stat;
    }

    public static int wait4route(int mask) {
        for (int i = 0; i < 65520; ++i) {
            if ((IcePIC7.arBus(0x1008000) & mask) == 0) {
                return i;
            }
            if (i <= 4096) continue;
            IcePIC7.udelay(10);
        }
        IcePIC7.awBus(16809996, mask);
        return -1;
    }

    public static int wait4dma(int mask) {
        int i = 0;
        int mcsr;
        while (((mcsr = IcePIC7.arBus(33554504)) & mask) != 0) {
            if ((mcsr & 0x80) != 0) {
                return i;
            }
            if (i > 65520) {
                return -1;
            }
            if (i > 4096) {
                IcePIC7.udelay(10);
            }
            ++i;
        }
        return i;
    }

    public static void initMC() {
        IcePIC7.memz(0, 8191);
        IcePIC7.resetDMA();
    }

    public static void wfifo(int addr, int count) {
        int dram = addr & 0xFFF00000;
        int rmax = 64;
        maddr = dram > 0 ? -50200768 : addr;
        int i = 0;
        while (i < count) {
            int stat = IcePIC7.arBusSync(33554504);
            if ((stat & 0x10000000) != 0) continue;
            if (dram > 0 && (i & 0xF) == 0) {
                maddr = -50200768;
                ioadr = addr;
                ioctl = 65600;
                addr += rmax;
                maddr = -50200768;
            }
            int data = mdata;
            IcePIC7.awBus(0x2000000, data);
            ++i;
        }
    }

    public static int rafifo() {
        while ((IcePIC7.arBus(33554504) & 0x8000000) != 0) {
        }
        return IcePIC7.arBus(0x2000000);
    }

    public static void rfifo(int addr, int count) {
        int dram = addr & 0xFFF00000;
        int rmax = 64;
        maddr = dram > 0 ? -50200768 : addr;
        int i = 0;
        while (i < count) {
            int data;
            int stat = IcePIC7.arBusSync(33554504);
            if ((stat & 0x8000000) != 0) continue;
            mdata = data = IcePIC7.arBus(0x2000000);
            if (dram <= 0 || (++i & 0xF) != 0) continue;
            maddr = -50200768;
            ioadr = addr;
            ioctl = 131136;
            addr += rmax;
            maddr = -50200768;
        }
    }

    protected static void writemod(int iom) {
        if (iom == 0) {
            return;
        }
        int addr = (iom >> 28 & 3) << 26 | 0x400000;
        IcePIC7.awBus(addr, iom);
    }

    protected static int readmod(int iom) {
        if (iom == 0) {
            return 0;
        }
        int addr = (iom >> 28 & 3) << 26 | 0x400000;
        return IcePIC7.arBus(addr);
    }

    public static void dojtagx(int tms, int tdi, int ena) {
        IcePIC7.awBus(0x800000, tms);
        while ((IcePIC7.arBus(0x80000C) & 1) != 0) {
        }
        IcePIC7.awBus(0x800004, tdi);
        IcePIC7.awBus(0x800008, ena);
    }

    public static int dojtag(int tms, int tdi, int ena) {
        int tdo = tdi;
        IcePIC7.awBus(0x800000, tms);
        IcePIC7.awBus(0x800004, tdi);
        IcePIC7.awBus(0x800008, ena);
        while ((IcePIC7.arBus(0x80000C) & 1) != 0) {
        }
        if ((ena & 0xF00) != 0) {
            tdo = IcePIC7.arBus(0x800000);
        }
        return tdo;
    }

    public static int dompio(int addr, int data, int len) {
        int sel = addr >> 24 & 0xFF;
        int uaddr = addr >> 16 & 0xFE;
        IcePIC7.mpc_ssa(sel, 1);
        IcePIC7.mpc_dwr(sel, uaddr);
        if ((addr & 0x8000) != 0) {
            IcePIC7.mpc_dwr(sel, addr >> 8 & 0x7F);
        }
        IcePIC7.mpc_dwr(sel, addr & 0xFF);
        if (len < 0) {
            len = -len;
            data = 0;
            IcePIC7.mpc_ssa(sel, -1);
            IcePIC7.mpc_ssa(sel, 1);
            IcePIC7.mpc_dwr(sel, uaddr | 1);
            for (int i = 0; i < len; ++i) {
                int k = i == len - 1 ? 1 : 0;
                data |= IcePIC7.mpc_drd(sel, k) << (i << 3);
            }
        } else if (len > 0) {
            for (int i = 0; i < len; ++i) {
                IcePIC7.mpc_dwr(sel, data);
                data >>= 8;
            }
        }
        IcePIC7.mpc_ssa(sel, -1);
        return data;
    }

    public static int mpc_acc(int sel, int data, int dir) {
        if (dir > 0) {
            IcePIC7.awBus(0x80000C, sel << 4 | data);
        } else {
            data = IcePIC7.arBus(0x80000C) >> sel + 8;
        }
        IcePIC7.udelay(3);
        return data;
    }

    public static void mpc_ssa(int sel, int mode) {
        if (mode > 0) {
            IcePIC7.mpc_acc(sel, 15, 1);
            IcePIC7.mpc_acc(sel, 13, 1);
        } else if (mode < 0) {
            IcePIC7.mpc_acc(sel, 13, 1);
            IcePIC7.mpc_acc(sel, 15, 1);
        } else {
            IcePIC7.mpc_acc(sel, 5, 1);
        }
    }

    public static void mpc_dwr(int sel, int data) {
        IcePIC7.mpc_acc(sel, 12, 1);
        for (int i = 0; i < 8; ++i) {
            int j = (data & 0x80) != 0 ? 2 : 0;
            IcePIC7.mpc_acc(sel, 0xC | j, 1);
            IcePIC7.mpc_acc(sel, 0xD | j, 1);
            IcePIC7.mpc_acc(sel, 0xC | j, 1);
            data <<= 1;
        }
        IcePIC7.mpc_acc(sel, 4, 1);
        IcePIC7.mpc_acc(sel, 5, 1);
        IcePIC7.mpc_acc(sel, 12, 1);
    }

    public static int mpc_drd(int sel, int nack) {
        int j;
        int data = 0;
        for (int i = 0; i < 8; ++i) {
            IcePIC7.mpc_acc(sel, 4, 1);
            IcePIC7.mpc_acc(sel, 5, 1);
            j = IcePIC7.mpc_acc(sel, 0, -1);
            if ((j & 2) == 0) continue;
            data |= 1 << 7 - i;
        }
        j = nack != 0 ? 2 : 0;
        IcePIC7.mpc_acc(sel, 4, 1);
        IcePIC7.mpc_acc(sel, 0xC | j, 1);
        IcePIC7.mpc_acc(sel, 0xD | j, 1);
        IcePIC7.mpc_acc(sel, 0xC | j, 1);
        IcePIC7.mpc_acc(sel, 12, 1);
        return data;
    }

    protected static int dmaSync(int addr) {
        maddr = addr;
        int data = mdata;
        return data -= mdata;
    }

    protected static void reset() {
        IcePIC7.awBus(0x1008000, -1);
        IcePIC7.awBus(0x1008010, 0);
        dmaqp = -50201088;
        IcePIC7.awMem(dmaqp, 0);
        IcePIC7.awMem(-50331648, 0);
        runMode = 0;
    }

    protected static void resetDMA() {
        IcePIC7.awBus(0x1008000, -1);
        IcePIC7.udelay(20);
        IcePIC7.awBus(0x1008000, -1);
        IcePIC7.memz(-41926912, 16);
        IcePIC7.memz(-41926848, 16);
        IcePIC7.memz(-41943040, 64);
        IcePIC7.memz(-41926784, 16);
        IcePIC7.memz(-41926720, 16);
        IcePIC7.awBus(16809988, 0);
    }

    static void setupDMAo(int i, int cur_addr, int cfg_addr) {
        maddr = -41926848 + (i << 3);
        mdata = cur_addr;
        mdata = cfg_addr;
    }

    static void setupDMAi(int i, int cur_addr, int cfg_addr) {
        maddr = -41926912 + (i << 3);
        mdata = cur_addr;
        mdata = cfg_addr;
    }

    static int getDMAi(int i) {
        maddr = -41926912 + (i << 3);
        return mdata;
    }

    static void setupDMAt(int i, int cur_addr) {
        maddr = -41943040 + (i << 2);
        mdata = cur_addr;
    }

    static void user2jcmd(int jsel) {
        int icl = jsel >> 27 & 0xC;
        int jcbs = 22 - icl;
        if (icl == 12) {
            IcePIC7.dojtag(939524319, -265289473, jsel | 0xF);
        } else {
            IcePIC7.dojtag(939524319, 16323 << jcbs | 0xFF, jsel | 0xF);
        }
    }

    public static void processMessages() {
        maddr = -50331644;
        int node = mdata;
        int head = mdata;
        int addr = mdata;
        int func = head & 0x3F;
        int olen = head >> 16 & 0xFFFF;
        int size = olen >> 2;
        int data = -50331632;
        switch (func) {
            case 1: {
                IcePIC7.busr(addr, data, size);
                break;
            }
            case 2: {
                IcePIC7.busw(addr, data, size);
                olen = 0;
                break;
            }
            case 3: {
                IcePIC7.memr(addr, data, size);
                break;
            }
            case 4: {
                IcePIC7.memw(addr, data, size);
                olen = 0;
                break;
            }
            case 6: {
                IcePIC7.initAlgorithm();
                break;
            }
            case 8: 
            case 9: {
                int port = addr & 0xFFFF;
                int type = addr >> 16;
                int route = mdata;
                if (func == 8) {
                    IcePIC7.openAlgorithm(port, type, route);
                    break;
                }
                IcePIC7.closeAlgorithm(port, type, route);
                break;
            }
            case 14: {
                IcePIC7.busrwm(addr, data, size);
                break;
            }
            case 15: {
                IcePIC7.memi(data, size);
                olen = 0;
            }
        }
        maddr = -50331648;
        mdata = 0xAA0000AA | olen << 8;
    }

    public static void initAlgorithm() {
        IcePIC7.resetDMA();
        runMode = 0;
    }

    public static void openAlgorithm(int port, int type, int route) {
        IcePIC7.awBus(0x1008008, route);
    }

    public static void processAlgorithm() {
    }

    public static void closeAlgorithm(int port, int type, int route) {
        IcePIC7.awBus(16809996, route);
        if (IcePIC7.arBus(0x1008000) == 0) {
            IcePIC7.resetDMA();
        }
    }

    public static void modifyAlgorithm(int data, int size) {
    }

    protected static void awBus2z(int addr) {
        saddr = addr;
        sdata = 0;
        saddr = addr + 8;
        sdata = 0;
    }

    public static int adon_tc(int dmap, int port, int mode) {
        int stat;
        int i2;
        IceHW.DMAStruct dma = (IceHW.DMAStruct)IcePIC7.getObjectAt(dmap);
        int r1 = 0;
        if ((dma.mcfg & Integer.MIN_VALUE) != 0) {
            i2 = 0x4400000;
            stat = IcePIC7.arBus(i2 + 0);
            if ((stat & 0x80) == 0) {
                i2 = 0x8400000;
                r1 = 128;
            }
        } else {
            i2 = 0x400000 | ((port & 1) != 0 ? 0x4000000 : 0x8000000);
        }
        if (((stat = IcePIC7.arBus(i2 + 0)) & 0x80) == 0) {
            return 0;
        }
        int cindex = dma.cindex;
        int ccycle = dma.ccycle;
        int hindex = dma.hindex;
        int hcycle = dma.hcycle;
        maddr = -50200640;
        mdata = cindex;
        mdata = ccycle;
        mdata = hcycle;
        if (mode == 7) {
            int r2 = i2 + 128 + 8;
            if ((stat & 0x40) == 0) {
                r2 += 64;
            }
            int r0 = 3 & IcePIC7.arBus(r2);
            mdata = IcePIC7.arBus(r2 += 4);
            mdata = IcePIC7.arBus(r2 += 4);
            mdata = IcePIC7.arBus(r2 += 4);
            r1 += IcePIC7.arBus(r2 += 4);
            r1 = r0 == 0 ? (r1 <<= 3) : (r0 == 1 ? (r1 <<= 2) : (r1 <<= 1));
            mdata = r1;
        } else {
            int r2 = i2 + 32;
            if ((stat & 0x40) == 0) {
                r2 += 16;
            }
            mdata = IcePIC7.arBus(r2);
            mdata = IcePIC7.arBus(r2 += 4);
            mdata = IcePIC7.arBus(r2 += 4);
            mdata = IcePIC7.arBus(r2 += 4);
            r2 += 4;
        }
        mdata = hindex;
        return stat;
    }

    public static void user2done(int jsel) {
        IcePIC7.dojtag(255, -1, jsel | 1);
        IcePIC7.awBus(0x800008, 0);
    }

    public static int adon_rwiob(int r2, int r3, int r4, boolean rw) {
        int r0 = rw ? 0 : r3;
        int jsel = r2 & 0xFFFF0000;
        r2 &= 0xFFFF;
        if ((jsel & 0x10000000) != 0) {
            if (rw) {
                if (r2 == 0) {
                    r0 = IcePIC7.arMem(baddr);
                    baddr += 4;
                }
            } else {
                for (int i = 0; i < r4; i += 4) {
                    if (r4 > 4) {
                        r3 = IcePIC7.rafifo();
                    }
                    if (r2 == 4 || r2 == 12) {
                        baddr = r3;
                        continue;
                    }
                    if (r2 != 0) continue;
                    IcePIC7.awMem(baddr, r3);
                    baddr += 4;
                }
            }
        } else {
            IcePIC7.user2jcmd(jsel);
            int ja = (rw ? 0xE000300 : 0x2000300) | r2 >> 8 | (r2 & 0xFF) << 16;
            if (rw) {
                IcePIC7.dojtag(0, ja, jsel | 0xF);
                int i = 0;
                do {
                    int j = i + 1 == r4 ? 1280 : 3072;
                    j = IcePIC7.dojtag(0, j, jsel | 0x303);
                    r0 |= (j & 0xFF) << (i << 3);
                } while (++i < r4);
            } else {
                for (int i = 0; i < r4; ++i) {
                    if ((i & 3) == 0) {
                        IcePIC7.dojtag(0, ja, jsel | 0xF);
                        if (r4 > 4) {
                            r3 = IcePIC7.rafifo();
                        }
                    }
                    int j = 0x800 | r3 & 0xFF;
                    IcePIC7.dojtag(0, j, jsel | 3);
                    r3 >>= 8;
                }
            }
            IcePIC7.user2done(jsel);
        }
        return r0;
    }

    public static int adon_wriop(int r2, int r3, int r4) {
        int r0 = r3;
        int jsel = r2 & 0xFFFF0000;
        IcePIC7.user2jcmd(jsel);
        int ja = 0x2000300 | (r2 &= 0xFFFF) >> 8 | (r2 & 0xFF) << 16;
        r4 <<= 1;
        for (int i = 0; i < r4; ++i) {
            if ((i & 3) == 0) {
                if ((i & 4) == 0) {
                    IcePIC7.dojtag(0, ja, jsel | 0xF);
                    r3 = IcePIC7.rafifo();
                } else {
                    r3 = r0;
                }
            }
            int j = 0x800 | r3 & 0xFF;
            IcePIC7.dojtag(0, j, jsel | 3);
            r3 >>= 8;
        }
        IcePIC7.user2done(jsel);
        return r0;
    }

    public static void prep_rwdata(int jsel, int addr, boolean by4) {
        int jmsk = jsel | 0xF;
        IcePIC7.dojtag(0, 393282, jmsk);
        IcePIC7.dojtag(0, 0x80008 | addr << 4, jmsk);
        IcePIC7.dojtag(0, by4 ? 393474 : 393218, jmsk);
    }

    public static int adon_rddata(int jsel) {
        int r3 = 0;
        for (int i = 0; i < 32; i += 16) {
            int j = 851981;
            int r0 = IcePIC7.dojtag(0, j, jsel | 0xF0F);
            r3 |= (r0 >> 8 & 0xFF | r0 >> 16 & 0xFF00) << i;
        }
        return r3;
    }

    public static void adon_wrdata(int jsel, int r3) {
        for (int i = 0; i < 2; ++i) {
            int j = 0xC000C | (r3 & 0xFF00) << 12 | (r3 & 0xFF) << 4;
            IcePIC7.dojtag(0, j, jsel | 0xF);
            r3 >>= 16;
        }
    }

    public static int adon_wrb(int r2, int r3, int r4, int jsel) {
        int j;
        int stat = r4;
        int jkey = 0x55000077 | r4 << 8;
        IcePIC7.user2jcmd(jsel);
        IcePIC7.prep_rwdata(jsel, 4, false);
        IcePIC7.adon_wrdata(jsel, r2);
        if (r4 <= 4) {
            IcePIC7.adon_wrdata(jsel, r3);
        } else {
            while (r4 > 0) {
                IcePIC7.adon_wrdata(jsel, IcePIC7.rafifo());
                r4 -= 4;
            }
        }
        IcePIC7.prep_rwdata(jsel, 0, true);
        IcePIC7.adon_wrdata(jsel, jkey);
        for (int i = 0; i < 1000 && ((j = IcePIC7.adon_rddata(jsel)) & 0xFF) != 170; ++i) {
            if (i <= 100) continue;
            stat = -i;
        }
        IcePIC7.user2done(jsel);
        return stat;
    }
}

