/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceJVM;

public class IceNVME
extends IceJVM {
    public static final int DSCR = 0x800000;
    public static final int DBUF = 0x800000;
    public static final int DBUFX = 0x800010;
    public static final int BSCR = 0x810000;
    public static final int BMGM = 8455920;
    public static final int BPGL = 8455936;
    public static final int BCQ0 = 0x810800;
    public static final int BCQ1 = 8456448;
    public static final int BSQ0 = 8456704;
    public static final int BSQ1 = 8457216;
    public static final int BBUF = 0x811000;
    public static final int XMEM = 8192;
    public static final int XPGP = 16384;
    public static final int SQS0 = 8;
    public static final int CQS0 = 16;
    public static final int SQS1 = 16;
    public static final int CQS1 = 16;
    public static final int DCFG = 98304;
    public static final int DCMD = 81920;
    public static final int CF_SLOTS = 131080;
    public static final int CF_SNIFF = 131072;
    public static final int CF_XFER = 131088;
    public static final int R_STATE = 96;
    public static final int R_STATUS = 100;
    public static final int R_QIO = 104;
    public static final int R_QDIF = 108;
    public static final int Q_WRB = 0x20000000;
    public static final int Q_RDB = 0x10000000;
    public static final int CMD_RVW = 0x1000000;
    public static final int CMD_RVC = 0x2000000;
    public static final int CMD_CYC = 0x4000000;
    public static final int CMD_CFG = 0x8000000;
    public static final int CMD_RST = 0x10000000;
    public static final int CMD_ACK = 0x20000000;
    public static final int CIDTAG = 0x1000000;
    public static final int OPCODE_DELETE_SQ = 0;
    public static final int OPCODE_CREATE_SQ = 1;
    public static final int OPCODE_DELETE_CQ = 4;
    public static final int OPCODE_CREATE_CQ = 5;
    public static final int OPCODE_IDENTIFY = 6;
    public static final int OPCODE_SET_FEATURE = 9;
    public static final int OPCODE_FLUSH = 0;
    public static final int OPCODE_WRITE = 1;
    public static final int OPCODE_READ = 2;
    public static final int OPCODE_MANAGE = 9;
    public static final int OPCODE_USESGL = 16384;
    static int cqhead0;
    static int cqhead1;
    static int sqtail0;
    static int sqtail1;
    static int requests;
    static int ttt;
    static int useSGL;

    public static void run() {
        int state = 0;
        for (int i = 0; i < 256; i += 4) {
            IceNVME.awMem(i, 0);
            IceNVME.awMem(-50266116, i);
        }
        IceNVME.resetFIFOs();
        IceNVME.awMem(24, 484442112);
        useSGL = 0;
        int beat = 484442112;
        while (true) {
            int cmd;
            int slots;
            IceNVME.awMem(-50266116, beat);
            int status = IceNVME.arBus(81920);
            boolean linkup = (status & 0x80) != 0;
            IceNVME.awMem(16, status);
            if (state == 0) {
                if (linkup) {
                    IceNVME.awMem(-50266116, 484487175);
                    state = IceNVME.boot();
                }
            } else if (!linkup) {
                state = 0;
            }
            if ((slots = IceNVME.arBusSync(131080) & 0xFFF) >= 4) {
                IceNVME.processCmdFifo();
            }
            if ((cmd = IceNVME.arMemSync(24) & 0xFF) > 0) {
                if (cmd == 99) {
                    state = IceNVME.fullReset();
                } else {
                    IceNVME.command(cmd);
                }
                IceNVME.awMem(24, 484442112);
            }
            if ((beat & 0xFFF) == 0) {
                status &= 0xFFFF;
                status |= state << 16;
                if (state > 0) {
                    status |= IceNVME.rdmem(28) << 24;
                }
                IceNVME.awMem(28, status);
            }
            IceNVME.handleCompletions1();
            ++beat;
        }
    }

    public static void waitOnFI(int timeout) {
        while (timeout > 0 && (IceNVME.arBus(81920) & 0x20000) == 0) {
            IceNVME.udelay(1000);
            --timeout;
        }
    }

    public static void waitOnFO(int timeout) {
        while (timeout > 0 && (IceNVME.arBus(81920) & 0x40000) == 0) {
            IceNVME.udelay(1000);
            --timeout;
        }
    }

    public static int fullReset() {
        IceNVME.awBus(81920, 0x50000000);
        IceNVME.awBus(81920, 0);
        return 0;
    }

    public static void resetFIFOs() {
        IceNVME.awBus(81920, 0x10000000);
        IceNVME.awBus(81920, 0);
    }

    public static int boot() {
        int i = 0;
        int n = 0;
        IceNVME.resetFIFOs();
        IceNVME.zeroMem(0x800000, 64);
        for (n = 1; i == 0 && n < 8; ++n) {
            IceNVME.configRoot();
            IceNVME.udelay(100);
            IceNVME.configTarget();
            i = IceNVME.rdmem(0);
        }
        return n;
    }

    public static void command(int test) {
        int i;
        if (test == 1) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, i >= 240 ? ttt : (i >= 224 ? IceNVME.arBus(81920) : IceNVME.arMem(0x800000 + i)));
            }
        }
        if (test == 1) {
            IceNVME.awMem(2296, cqhead0);
            IceNVME.awMem(2300, cqhead1);
        }
        if (test == 2) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.rdmem(i));
            }
        }
        if (test == 2) {
            for (i = 0; i < 16; i += 4) {
                IceNVME.awMem(2272 + i, IceNVME.rdmem(4096 + i));
            }
        }
        if (test == 2) {
            for (i = 0; i < 16; i += 4) {
                IceNVME.awMem(2288 + i, IceNVME.rdmem(8192 + i));
            }
        }
        if (test == 3) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.rdcfg(i));
            }
        }
        if (test == 4) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.rdcfgl(i));
            }
        }
        if (test == 5) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.arBus(262144));
            }
        }
        if (test == 6) {
            IceNVME.enableController();
        }
        if (test == 6) {
            IceNVME.configController();
        }
        if (test == 7) {
            IceNVME.awMem(2048, IceNVME.arBus(81920));
        }
        if (test == 8) {
            IceNVME.identify(1, 512, 0);
        }
        if (test == 9) {
            IceNVME.disableController();
        }
        if (test == 10) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.arMem(0x810800 + i));
            }
        }
        if (test == 11) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.arMem(8456704 + i));
            }
        }
        if (test == 12) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.arMem(8456704 + i + 256));
            }
        }
        if (test == 20) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.arMem(8456448 + i));
            }
        }
        if (test == 21) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.arMem(8457216 + i));
            }
        }
        if (test == 22) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.arMem(8457216 + i + 256));
            }
        }
        if (test == 23) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.arMem(8457216 + i + 512));
            }
        }
        if (test == 24) {
            for (i = 0; i < 256; i += 4) {
                IceNVME.awMem(2048 + i, IceNVME.arMem(8457216 + i + 768));
            }
        }
        if (test == 30) {
            IceNVME.identify(0, 512, 0);
        }
        if (test == 31) {
            IceNVME.identify(1, 512, 0);
        }
        if (test == 32) {
            IceNVME.identify(2, 512, 0);
        }
        if (test == 33) {
            IceNVME.identify(1, 512, 512);
        }
        if (test == 40) {
            IceNVME.capabilities();
        }
        if (test == 98) {
            IceNVME.boot();
        }
    }

    public static void identify(int space, int len, int off) {
        int nsid = space == 0 ? 1 : 0;
        IceNVME.submitQueue0(6, nsid, 4096, space, 0);
        if (space == 1) {
            int data = IceNVME.arMem(0x811218);
            useSGL = (data & 3) != 0 ? 16384 : 0;
            IceNVME.awMem(8458556, useSGL);
        }
        IceNVME.copyMem(0x811000 + off, 2048, len);
    }

    public static void processCmdFifo() {
        int cmd = IceNVME.arBus(131088);
        int blocks = IceNVME.rBus();
        int block = IceNVME.rBus();
        int ublock = IceNVME.rBus();
        if (cmd == 484442173) {
            IceNVME.rwBlocks(-1, blocks, block, ublock);
        } else if (cmd == 484442174) {
            IceNVME.rwBlocks(1, blocks, block, ublock);
        } else {
            IceNVME.cleanupCmdFifo();
        }
    }

    public static void cleanupCmdFifo() {
        while ((IceNVME.arBusSync(131080) & 0xFFF) > 0) {
            int cmd = IceNVME.arBus(131072);
            if (cmd == 484442173 || cmd == 484442174) {
                return;
            }
            IceNVME.arBus(131088);
        }
    }

    public static void rwBlocks(int dir, int blocks, int blockl, int blocku) {
        int cur = cqhead1;
        int opcode = dir > 0 ? 1 : 2;
        IceNVME.submitQueue1(opcode, useSGL, 8192, blocku, blockl, blocks);
        while (cqhead1 == cur) {
            IceNVME.handleCompletions1();
        }
    }

    public static int rdcfgl(int adr) {
        IceNVME.arBus(98304 + adr);
        return IceNVME.arBus(98304 + adr);
    }

    public static int wrcfgl(int adr, int val) {
        IceNVME.awBus(98304 + adr, val);
        return val;
    }

    public static void clearresp() {
        IceNVME.aBus(81920);
        for (int i = 0; i < 1000 && (IceNVME.rBus() & 0x4000) != 0; ++i) {
            IceNVME.wBus(133189632);
            IceNVME.udelay(1);
        }
    }

    public static void wait4resp() {
        IceNVME.aBus(81920);
        for (int i = 0; i < 1000 && (IceNVME.rBus() & 0x40) != 0; ++i) {
        }
    }

    public static int getresp() {
        IceNVME.aBus(81920);
        for (int i = 0; i < 1000 && (IceNVME.rBus() & 0x4000) == 0; ++i) {
        }
        IceNVME.wBus(133189633);
        maddr = 0x800010;
        return mdata;
    }

    public static int rdcfg(int adr) {
        IceNVME.clearresp();
        maddr = 0x800000;
        mdata = adr;
        mdata = 0;
        mdata = 16385;
        mdata = 0x1000000;
        IceNVME.awBus(81920, 116396032);
        return IceNVME.getresp();
    }

    public static int wrcfg(int adr, int val) {
        maddr = 0x800000;
        mdata = adr;
        mdata = 0;
        mdata = 20481;
        mdata = 0x1000000;
        mdata = val;
        IceNVME.awBus(81920, 101720065);
        return IceNVME.getresp();
    }

    public static int rdmem(int adr) {
        IceNVME.clearresp();
        maddr = 0x800000;
        mdata = 0x1CE10000 | adr;
        mdata = 0;
        mdata = 1;
        mdata = 0x1000000;
        IceNVME.awBus(81920, 116396032);
        return IceNVME.getresp();
    }

    public static void wrmem(int adr, int val1) {
        maddr = 0x800000;
        mdata = 0x1CE10000 | adr;
        mdata = 0;
        mdata = 2049;
        mdata = 0x1000000;
        mdata = val1;
        IceNVME.awBus(81920, 101720065);
    }

    public static void wrmemx(int adr, int valu, int vall) {
        maddr = 0x800000;
        mdata = 0x1CE10000 | adr;
        mdata = 0;
        mdata = 2050;
        mdata = 0x1000000;
        mdata = vall;
        mdata = valu;
        IceNVME.awBus(81920, 104341505);
    }

    public static int sndmsgD(int type, int val) {
        maddr = 0x800000;
        mdata = 0;
        mdata = 0;
        mdata = 24577;
        mdata = 0x1040000 | type << 8;
        mdata = val;
        IceNVME.awBus(81920, 101720065);
        return val;
    }

    public static void configRoot() {
        IceNVME.wrcfgl(24, 65792);
        IceNVME.wrcfgl(4, -2147483642);
        IceNVME.wrcfgl(32, 0x40001000);
        IceNVME.wrcfgl(36, -65536);
        IceNVME.wrcfgl(40, 1);
        IceNVME.wrcfgl(44, 2);
        IceNVME.wrcfgl(48, -2147483647);
    }

    public static void configTarget() {
        IceNVME.wrcfg(4, -65536);
        IceNVME.wrcfg(16, -1);
        IceNVME.wrcfg(20, -1);
        IceNVME.wrcfg(24, -1);
        IceNVME.wrcfg(28, -1);
        IceNVME.wrcfg(16, 484507652);
        IceNVME.wrcfg(20, 0);
        IceNVME.wrcfg(4, -268435450);
    }

    public static void enableController() {
        cqhead0 = 0;
        cqhead1 = 0;
        sqtail0 = 0;
        sqtail1 = 0;
        requests = 0;
        IceNVME.wrmem(20, 0x460000);
        maddr = 8455936;
        for (int i = 1; i <= 32; ++i) {
            mdata = i << 12;
            mdata = 8192;
        }
        IceNVME.zeroMem(0x810000, 64);
        IceNVME.zeroMem(8456704, 128);
        IceNVME.zeroMem(0x810800, 64);
        IceNVME.zeroMem(8457216, 256);
        IceNVME.zeroMem(8456448, 64);
        IceNVME.wrmem(12, -1);
        IceNVME.wrmem(16, -1);
        IceNVME.wrmem(36, 983047);
        IceNVME.wrmemx(40, 2560, 0);
        IceNVME.wrmemx(48, 2048, 0);
        IceNVME.wrmem(4096, sqtail0);
        IceNVME.wrmem(4100, cqhead0);
        IceNVME.wrmem(4104, sqtail1);
        IceNVME.wrmem(4108, cqhead1);
        IceNVME.wrmem(20, 4587521);
    }

    public static void configController() {
        IceNVME.submitQueue0(9, 0, 0, 7, 0);
        IceNVME.submitQueue0(5, 0, 2304, 983041, 1);
        IceNVME.submitQueue0(1, 0, 3072, 983041, 65537);
    }

    public static void disableController() {
        IceNVME.submitQueue0(4, 0, 2304, 1, 0);
        IceNVME.submitQueue0(0, 0, 3072, 1, 0);
        IceNVME.wrmem(20, 0x460000);
    }

    public static void zeroMem(int addr, int size) {
        maddr = addr;
        for (int i = 0; i < size; ++i) {
            mdata = 0;
        }
    }

    public static void submitQueue0(int opcode, int nsid, int uaddr, int dw10, int dw11) {
        int qaddr;
        int index = sqtail0 & 7;
        maddr = qaddr = 8456704 + (index << 6);
        mdata = (0x1CE0 | index) << 16 | opcode;
        mdata = nsid;
        maddr = qaddr + 24;
        mdata = 0;
        mdata = uaddr;
        mdata = 0;
        mdata = 0;
        mdata = dw10;
        mdata = dw11;
        mdata = 0;
        index = ++sqtail0 & 7;
        IceNVME.wrmem(4096, index);
        int cur = cqhead0;
        for (int i = 0; i < 1000 && cqhead0 == cur; ++i) {
            IceNVME.udelay(1000);
            IceNVME.handleCompletions0();
        }
    }

    public static void submitQueue1(int opcode, int sgl, int uaddr, int ublock, int block, int blocks) {
        int qaddr;
        int index = sqtail1 & 0xF;
        maddr = qaddr = 8457216 + (index << 6);
        mdata = (0x1CE0 | index) << 16 | sgl | opcode;
        mdata = 1;
        maddr = qaddr + 24;
        mdata = 0;
        mdata = uaddr;
        if (sgl != 0) {
            mdata = blocks << 9;
            mdata = 0;
        } else if (blocks <= 8) {
            mdata = 0;
            mdata = 0;
        } else if (blocks <= 16) {
            mdata = 4096;
            mdata = uaddr;
        } else {
            mdata = 0;
            mdata = 1792;
        }
        mdata = block;
        mdata = ublock;
        mdata = blocks - 1;
        mdata = 82;
        index = ++sqtail1 & 0xF;
        IceNVME.wrmem(4104, index);
    }

    public static void copyMem(int addri, int addro, int bytes) {
        int words = bytes >> 2;
        for (int i = 0; i < words; ++i) {
            IceNVME.awMem(addro, IceNVME.arMem(addri));
            addri += 4;
            addro += 4;
        }
    }

    public static int handleCompletions(int head, int qaddr) {
        int index;
        int caddr;
        int data;
        int cphase;
        int phase;
        for (int i = 0; i < 32 && (phase = head >> 4) != (cphase = (data = IceNVME.arMem((caddr = qaddr + ((index = head & 0xF) << 4)) + 12)) >> 16 & 1); ++i) {
            head = head + 1 & 0x1F;
        }
        return head;
    }

    public static void handleCompletions0() {
        int stat = IceNVME.handleCompletions(cqhead0, 0x810800);
        if (stat == cqhead0) {
            return;
        }
        cqhead0 = stat;
        IceNVME.wrmem(4100, cqhead0 & 0xF);
    }

    public static void handleCompletions1() {
        int stat = IceNVME.handleCompletions(cqhead1, 8456448);
        if (stat == cqhead1) {
            return;
        }
        cqhead1 = stat;
        IceNVME.wrmem(4108, cqhead1 & 0xF);
    }

    public static void capabilities() {
        int addr = IceNVME.rdcfg(52) & 0xFF;
        for (int i = 0; i < 32; i += 4) {
            int data = addr > 0 ? IceNVME.rdcfg(addr) : 0;
            if ((data & 0xFF) == 16) {
                int dcs = IceNVME.rdcfg(addr + 8);
                IceNVME.wrcfg(addr + 8, dcs |= 0x20);
            }
            IceNVME.awMem(2048 + i, data);
            addr = data >> 8 & 0xFF;
        }
    }
}

