/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceHW;

public class IceJVM
implements IceHW {
    public static int saddr;
    public static int sdata;
    public static int maddr;
    public static int mdata;
    public static int ioadr;
    public static int ioctl;
    static final int rmax = 64;
    static final int wmax = 64;

    public static native Object getObjectAt(int var0);

    static void main() {
        IceJVM.run();
    }

    static void run() {
    }

    protected static void udelay(int usec) {
        for (int i = 0; i < usec; ++i) {
            for (int j = 0; j < 16; ++j) {
            }
        }
    }

    static int _idiv(int num, int denom) {
        boolean neg;
        boolean bl = neg = num < 0;
        if (num < 0) {
            num = -num;
        }
        if (denom < 0) {
            denom = -denom;
            neg = !neg;
        }
        int a = num;
        int b = 0;
        int i = 0;
        while (a != 0) {
            a >>= 4;
            i += 4;
        }
        while (i-- > 0) {
            a = (a << 1) + ((num & 1 << i) >> i);
            b <<= 1;
            if (a < denom) continue;
            a -= denom;
            ++b;
        }
        return neg ? -b : b;
    }

    static void stubs() {
        int a = 0;
        int b = 0;
        IceJVM._idiv(a, b);
    }

    protected static void awBus(int addr, int data) {
        saddr = addr;
        saddr = addr;
        sdata = data;
    }

    protected static void aBus(int addr) {
        saddr = addr;
    }

    protected static void wBus(int data) {
        sdata = data;
    }

    protected static int rBus() {
        return sdata;
    }

    protected static int arBus(int addr) {
        saddr = addr;
        saddr = addr;
        saddr = addr;
        saddr = addr;
        return sdata;
    }

    protected static int arBusAck(int addr, int timeout) {
        saddr = addr;
        int data = sdata;
        for (int i = 0; i < timeout; ++i) {
        }
        return sdata;
    }

    protected static int arBusSync(int addr) {
        int datal;
        saddr = addr;
        saddr = addr;
        int data = sdata;
        while ((data = sdata) != (datal = data)) {
        }
        return data;
    }

    protected static void awMem(int addr, int data) {
        maddr = addr;
        mdata = data;
    }

    protected static int arMem(int addr) {
        maddr = addr;
        return mdata;
    }

    protected static int arMemSync(int addr) {
        int datal;
        maddr = addr;
        int data = mdata;
        do {
            datal = data;
            maddr = addr;
        } while ((data = mdata) != datal);
        return data;
    }

    static void busr(int addr, int madr, int size) {
        saddr = addr;
        maddr = madr;
        for (int i = 0; i < size; ++i) {
            mdata = sdata;
        }
    }

    static void busw(int addr, int madr, int size) {
        saddr = addr;
        maddr = madr;
        for (int i = 0; i < size; ++i) {
            sdata = mdata;
        }
    }

    static void busrwm(int addr, int madr, int size) {
        saddr = addr;
        maddr = madr;
        int waddr = mdata;
        int wdata = mdata;
        maddr = madr;
        for (int i = 0; i < size; ++i) {
            saddr = waddr;
            saddr = waddr;
            sdata = wdata;
            IceJVM.udelay(10);
            saddr = addr;
            IceJVM.udelay(10);
            mdata = sdata;
        }
    }

    static void memr(int addr, int madr, int size) {
        if ((addr & 0xFFF00000) > 0) {
            size <<= 2;
            while (size > 64) {
                maddr = madr;
                ioadr = addr;
                ioctl = 65600;
                madr += 64;
                addr += 64;
                size -= 64;
            }
            maddr = madr;
            ioadr = addr;
            ioctl = 0x10000 | size;
        } else {
            for (int i = 0; i < size; ++i) {
                maddr = addr;
                int data = mdata;
                addr += 4;
                maddr = madr;
                mdata = data;
                madr += 4;
            }
        }
    }

    static void memw(int addr, int madr, int size) {
        if ((addr & 0xFFF00000) > 0) {
            size <<= 2;
            while (size > 64) {
                maddr = madr;
                ioadr = addr;
                ioctl = 131136;
                madr += 64;
                addr += 64;
                size -= 64;
            }
            maddr = madr;
            ioadr = addr;
            ioctl = 0x20000 | size;
        } else {
            for (int i = 0; i < size; ++i) {
                maddr = madr;
                int data = mdata;
                madr += 4;
                maddr = addr;
                mdata = data;
                addr += 4;
            }
        }
    }

    static void memi(int madr, int size) {
        for (int i = 0; i < size; ++i) {
            maddr = madr;
            ioadr = mdata;
            ioctl = 131076;
            madr += 4;
            IceJVM.udelay(50);
        }
    }

    static void memz(int madr, int size) {
        maddr = madr;
        for (int i = 0; i < size; ++i) {
            mdata = 0;
        }
    }
}

