/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceJVM;

public class IceIOM
extends IceJVM {
    public static final int sysdly = 2;

    public static void run() {
        IceIOM.runFAT();
        IceIOM.reset();
        int beat = 484442112;
        while (true) {
            IceIOM.awMem(-50266116, beat);
            int cmd = IceIOM.arMemSync(-50330624);
            int key = cmd >> 16;
            int cmds = cmd & 0xFF;
            if (key == 7392 && cmds > 0) {
                int par = cmd;
                maddr = -50330608;
                for (int i = 0; i < cmds; ++i) {
                    par ^= mdata;
                }
                if (par != IceIOM.arMem(-50330620)) {
                    IceIOM.awMem(-50330624, -7);
                } else {
                    IceIOM.processCmdBuf(cmds);
                }
            }
            ++beat;
        }
    }

    static void runFAT() {
        IceIOM.awMem(-50266120, 7392);
        IceIOM.awMem(-50266120, 7393);
    }

    protected static void reset() {
        IceIOM.awMem(-50331648, 0);
        IceIOM.awMem(-50330624, 0);
        IceIOM.awMem(16, IceIOM.arBus(0));
    }

    protected static void processCmdBuf(int cmds) {
        int timer = 0;
        int data = 0;
        int cbi = -50330608;
        int cbl = -50330608 + (cmds << 2);
        while (cmds > 0) {
            int code = IceIOM.arMem(cbi);
            cbi += 4;
            int cmd = code & 0xF;
            int cnt = code >> 4 & 0xF;
            int top = code >> 8;
            int addr = top & 0xFFFFFF;
            int spi = addr & 0x8000;
            switch (cmd) {
                case 1: {
                    data = spi != 0 ? IceIOM.rdSPI(addr) : IceIOM.arBus(addr);
                    IceIOM.awMem(-50330616, data);
                    break;
                }
                case 2: {
                    data = IceIOM.arMem(cbi);
                    cbi += 4;
                    IceIOM.awBus(addr, data);
                    break;
                }
                case 3: {
                    addr = top & 0xFFFF;
                    data = top >> 16 & 0xFF;
                    if (spi != 0) {
                        IceIOM.wrSPI(addr, data);
                        break;
                    }
                    IceIOM.awBus(addr, data);
                    break;
                }
                case 4: {
                    for (int i = 0; i <= cnt; ++i) {
                        data = IceIOM.arMem(cbi);
                        cbi += 4;
                        IceIOM.awBus(addr, data);
                    }
                    break;
                }
                case 5: {
                    IceIOM.vdelay(top);
                    break;
                }
                case 6: {
                    int expect = IceIOM.arMem(cbi);
                    cbi += 4;
                    if (data == expect) break;
                    if (timer >= top) {
                        cmds = -1;
                        break;
                    }
                    IceIOM.vdelay(1000);
                    timer += 1000;
                    cbi -= 12;
                    break;
                }
                case 7: {
                    int waddr = IceIOM.arMem(cbi);
                    int wdata = IceIOM.arMem(cbi += 4);
                    int wcnt = IceIOM.arMem(cbi += 4);
                    cbi += 4;
                    int raddr = -50330608;
                    for (int i = 0; i < wcnt; ++i) {
                        IceIOM.awBus(waddr, wdata);
                        IceIOM.vdelay(20);
                        IceIOM.awMem(raddr, IceIOM.arBus(addr));
                        raddr += 4;
                    }
                    break;
                }
                case 11: {
                    int mask = IceIOM.arMem(cbi);
                    data = IceIOM.arMem(cbi += 4);
                    cbi += 4;
                    top = addr >> 8 & 0xFF00;
                    addr &= 0xFFFF;
                    IceIOM.awBus(top | 0, mask);
                    IceIOM.awBus(top | 4, 12287);
                    IceIOM.part_wait(top);
                    IceIOM.awBus(top | 0, data);
                    IceIOM.awBus(top | 4, addr);
                    IceIOM.part_wait(top);
                    break;
                }
                default: {
                    IceIOM.awMem(-50330624, -9);
                    return;
                }
            }
            cmds = cbl - cbi >> 2;
            IceIOM.awMem(-50330624, 0x1CED0000 | cmds & 0xFFFF);
        }
    }

    protected static int part_wait(int addr) {
        boolean part_busy;
        int i = 0;
        int timeout = 5000;
        do {
            boolean bl = part_busy = (IceIOM.arBus(addr | 4) & 0x8000) != 0;
        } while (part_busy && ++i < timeout);
        return i;
    }

    protected static void vdelay(int usec) {
        int jmax = 2;
        for (int i = 0; i < usec; ++i) {
            for (int j = 0; j < jmax; ++j) {
            }
        }
    }

    protected static void wrSPI(int addr, int data) {
        int spireg = addr & 0x3F00 | 0x10004;
        int spiadr = addr & 0xFF;
        saddr = 0;
        sdata = 48;
        saddr = spireg;
        if ((addr & 0x4000) != 0) {
            sdata = 16;
            IceIOM.wrSPIr(0);
            IceIOM.wrSPIr(spiadr);
            sdata = 48;
            sdata = 16;
            IceIOM.wrSPIr(96);
            IceIOM.wrSPIr(data);
            sdata = 48;
        } else {
            sdata = 16;
            IceIOM.wrSPIf(spiadr);
            IceIOM.wrSPIf(data);
            sdata = 48;
        }
        saddr = 0;
    }

    protected static void wrSPIr(int data) {
        for (int i = 7; i >= 0; --i) {
            int dat = data >> i & 1;
            sdata = 0 | dat;
            sdata = 0x10 | dat;
        }
    }

    protected static void wrSPIf(int data) {
        int dat = 0;
        for (int i = 7; i >= 0; --i) {
            dat = data >> i & 1;
            sdata = 0x10 | dat;
            sdata = 0 | dat;
        }
        sdata = 0x10 | dat;
    }

    protected static int rdSPI(int addr) {
        int data;
        int spireg = addr & 0x3F00 | 0x10004;
        int spiadr = addr & 0xFF;
        saddr = 0;
        sdata = 48;
        saddr = spireg;
        if ((addr & 0x4000) != 0) {
            sdata = 16;
            IceIOM.wrSPIr(0);
            IceIOM.wrSPIr(spiadr);
            sdata = 48;
            sdata = 16;
            IceIOM.wrSPIr(160);
            data = IceIOM.rdSPIr();
            sdata = 48;
        } else {
            sdata = 16;
            IceIOM.wrSPIf(spiadr);
            data = IceIOM.rdSPIf();
            sdata = 48;
        }
        saddr = 0;
        return data;
    }

    protected static int rdSPIr() {
        int data = 0;
        for (int i = 7; i >= 0; --i) {
            sdata = 0;
            sdata = 16;
            data |= (sdata & 1) << i;
        }
        return data;
    }

    protected static int rdSPIf() {
        int data = 0;
        for (int i = 7; i >= 0; --i) {
            sdata = 16;
            sdata = 0;
            data |= (sdata & 1) << i;
        }
        sdata = 16;
        return data;
    }
}

