/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceIOM;

public class IceGPS
extends IceIOM {
    public static int lvco;
    public static int loff;
    public static int mode;
    public static int calib;
    public static int dfvco;
    public static int dpvco;
    public static int cvco;
    public static int acc_off;
    public static int acc_dif;
    public static int acc_sav;
    public static int nos;
    public static int dop;
    public static int sog;
    public static int count;
    public static int week;
    public static int sow;
    public static int alt;
    public static int lat;
    public static int lon;
    public static int mrev;
    public static int debug;
    public static int mindop;

    public static void run() {
        loff = 0;
        lvco = -1811939328;
        mode = 0;
        dop = 10;
        sog = 100;
        nos = 0;
        count = 0;
        mindop = 16;
        IceGPS.awBus(65536, 1);
        IceGPS.awBus(524288, 22);
        int cfg = IceGPS.arMem(8);
        mrev = cfg >> 24 & 0xFF;
        lvco = mrev <= 1 ? -2013265920 : -1811939328;
        int beat = 1;
        while (true) {
            IceGPS.awMem(-50266116, beat);
            if (mode != 0 || beat >= 1000) {
                int status = IceGPS.getStatus();
                int tenths = IceGPS.getTenths(status);
                if (tenths == 0) {
                    IceGPS.awMem(256, 0);
                }
                if (tenths == 1) {
                    IceGPS.processTick(status);
                    while (IceGPS.getStatusTenths() == 1) {
                        IceGPS.udelay(10);
                    }
                }
                if (tenths == 3) {
                    IceGPS.processNEMA(status);
                    while (IceGPS.getStatusTenths() == 3) {
                        IceGPS.udelay(10);
                    }
                }
            }
            ++beat;
        }
    }

    public static int getStatus() {
        return IceGPS.arBusSync(65536);
    }

    public static int getTenths(int status) {
        return status >> 28 & 7;
    }

    public static int getStatusTenths() {
        return IceGPS.getTenths(IceGPS.getStatus());
    }

    public static void processTick(int status) {
        int off = status & 0xFFFFFFF;
        if (off > 80000000) {
            off -= 160000000;
        }
        IceGPS.awMem(28, status);
        int cfg = IceGPS.arMem(8);
        int offset = cfg >> 8 & 0xFF;
        int navg = cfg >> 16 & 0xFF;
        mrev = cfg >> 24 & 0xFF;
        if ((cfg & 0x80) != 0) {
            int cmd = IceGPS.arMem(12);
            if (cmd != 0) {
                lvco = cmd;
                count = -4;
            }
            mode = 8;
            IceGPS.awMem(12, 0);
        }
        if (mode == 0 && (cfg & 8) != 0) {
            count = -4;
            mode = -1;
        }
        if (mode == 6 && ((off -= offset) > 1600 || off < -1600)) {
            count = -4;
        }
        int dif = off - loff;
        if (count <= -4 && mode == 6) {
            lvco = cvco;
        }
        if (count <= -4) {
            IceGPS.awBus(65536, 1);
        }
        if (count >= 0 && count < 64) {
            IceGPS.setOff(count, off);
            IceGPS.setDif(count, dif);
        }
        ++count;
        if (nos > 6 && dop < mindop && mode == 0) {
            mode = 1;
            count = -4;
        }
        if (mode > 0 && (nos < 3 || dop > mindop)) {
            mode = 0;
        }
        if (mode >= 1 && mode <= 4 && count >= navg) {
            acc_dif = IceGPS.getAccDif(navg);
            dpvco = 0;
            if (acc_dif > 40) {
                dpvco = -256;
                mode = 1;
            } else if (acc_dif > 20) {
                dpvco = -128;
                mode = 1;
            } else if (acc_dif > 2) {
                dpvco = -16;
                mode = 2;
            } else if (acc_dif < -40) {
                dpvco = 256;
                mode = 1;
            } else if (acc_dif < -20) {
                dpvco = 128;
                mode = 1;
            } else if (acc_dif < -2) {
                dpvco = 16;
                mode = 2;
            } else if (++mode > 4) {
                cvco = lvco;
                mode = 6;
            }
            lvco += dpvco << 16;
            count = -4;
        } else if (mode == 6 && count >= 0) {
            acc_off = IceGPS.getAccOff(1);
            acc_dif = IceGPS.getAccDif(1);
            dpvco = 0;
            if (acc_off > 0 && acc_dif >= 0) {
                dpvco = -2;
            }
            if (acc_off < 0 && acc_dif <= 0) {
                dpvco = 2;
            }
            lvco += dpvco << 16;
            count = 0;
        } else if (mode < 0 && count > 0) {
            count = 0;
        }
        loff = off;
        IceGPS.awBus(262144, lvco >> 16);
        IceGPS.awMem(32, mode << 24 | (count & 0xFF) << 16 | dop << 8 | nos);
        IceGPS.awMem(36, status);
        IceGPS.awMem(40, off);
        IceGPS.awMem(44, dif);
        IceGPS.awMem(48, acc_off);
        IceGPS.awMem(52, acc_dif);
        IceGPS.awMem(56, lvco);
        IceGPS.awMem(60, calib);
        IceGPS.awMem(64, dpvco);
        IceGPS.awMem(68, dfvco);
    }

    public static void setOff(int i, int off) {
        IceGPS.awMem(512 + (i << 2), off);
    }

    public static int getAccOff(int navg) {
        int avg = 0;
        for (int i = 0; i < navg; ++i) {
            avg += IceGPS.arMem(512 + (i << 2));
        }
        return avg;
    }

    public static void setDif(int i, int dif) {
        IceGPS.awMem(768 + (i << 2), dif);
    }

    public static int getAccDif(int navg) {
        int avg = 0;
        for (int i = 0; i < navg; ++i) {
            avg += IceGPS.arMem(768 + (i << 2));
        }
        return avg;
    }

    public static void copyNEMA(int len) {
        IceGPS.awMem(256, 1);
        IceGPS.awMem(260, week << 16 | dop << 12 | mode << 8 | nos);
        IceGPS.awMem(264, sow);
        IceGPS.awMem(268, alt);
        IceGPS.awMem(272, lat);
        IceGPS.awMem(276, lon);
        IceGPS.awMem(280, len);
        IceGPS.awMem(256, 2);
    }

    public static void processNEMA(int status) {
        int nadr = 131072;
        int iadr = 131072;
        while (iadr < 132096 && (nadr = IceGPS.checkLine(iadr)) != 0) {
            iadr = nadr;
        }
        int len = iadr - 1 - 131072;
        IceGPS.copyNEMA(len);
    }

    public static int parseDec(int iadr, int nadr, int dp) {
        boolean neg = false;
        boolean pd = false;
        int val = 0;
        while (iadr < nadr) {
            int c;
            if ((c = IceGPS.arBus(iadr++)) == 46) {
                pd = true;
            } else if (c != 43) {
                if (c == 45) {
                    neg = true;
                } else {
                    if (c < 48 || c > 57) break;
                    val = val * 10 + (c - 48);
                    if (pd) {
                        --dp;
                    }
                }
            }
            if (!pd || dp > 0) continue;
        }
        if (neg) {
            val = -val;
        }
        return val;
    }

    public static int checkLine(int iadr) {
        int a = IceGPS.arBus(iadr + 3);
        int b = IceGPS.arBus(iadr + 4);
        int c = IceGPS.arBus(iadr + 5);
        if (a == 82 && b == 77 && c == 67) {
            iadr = IceGPS.nextField(iadr, 7);
            int nadr = IceGPS.nextField(iadr, 1);
            sog = IceGPS.parseDec(iadr, nadr, 0);
            IceGPS.awMem(108, sog);
        } else if (a == 71 && b == 71 && c == 65) {
            iadr = IceGPS.nextField(iadr, 2);
            int nadr = IceGPS.nextField(iadr, 1);
            lat = IceGPS.parseDec(iadr, nadr, 4);
            if (IceGPS.arBus(nadr) == 83) {
                lat = -lat;
            }
            IceGPS.awMem(80, lat);
            iadr = IceGPS.nextField(nadr, 1);
            nadr = IceGPS.nextField(iadr, 1);
            lon = IceGPS.parseDec(iadr, nadr, 4);
            if (IceGPS.arBus(nadr) == 87) {
                lon = -lon;
            }
            IceGPS.awMem(84, lon);
            iadr = IceGPS.nextField(nadr, 4);
            nadr = IceGPS.nextField(iadr, 1);
            alt = IceGPS.parseDec(iadr, nadr, 2);
            IceGPS.awMem(88, alt);
        } else if (a == 71 && b == 83 && c == 65) {
            int nadr;
            dop = IceGPS.parseDec(iadr = IceGPS.nextField(iadr, 15), nadr = IceGPS.nextField(iadr, 1), 0);
            if (dop > 15) {
                dop = 15;
            }
            IceGPS.awMem(92, dop);
        } else if (a == 71 && b == 83 && c == 86) {
            iadr = IceGPS.nextField(iadr, 3);
            int nadr = IceGPS.nextField(iadr, 1);
            nos = IceGPS.parseDec(iadr, nadr, 0);
            IceGPS.awMem(96, nos);
        } else if (a == 76 && b == 89 && c == 84) {
            int sec = 0;
            int day = 0;
            int mon = 0;
            int year = 0;
            int nadr = IceGPS.nextField(iadr = IceGPS.nextField(iadr, 1), 1);
            if (nadr - iadr >= 6) {
                sec = IceGPS.arBCD(iadr, 5);
                sec += 10 * IceGPS.arBCD(iadr, 4);
                sec += 60 * IceGPS.arBCD(iadr, 3);
                sec += 600 * IceGPS.arBCD(iadr, 2);
                sec += 3600 * IceGPS.arBCD(iadr, 1);
                sec += 36000 * IceGPS.arBCD(iadr, 0);
            }
            if ((nadr = IceGPS.nextField(iadr = IceGPS.nextField(iadr, 1), 1)) - iadr >= 6) {
                day = 10 * IceGPS.arBCD(iadr, 0) + IceGPS.arBCD(iadr, 1);
                mon = 10 * IceGPS.arBCD(iadr, 2) + IceGPS.arBCD(iadr, 3);
                year = 10 * IceGPS.arBCD(iadr, 4) + IceGPS.arBCD(iadr, 5);
            }
            if (sec != 0 && year != 0) {
                IceGPS.processIRB(year, mon, day, sec);
            }
            iadr = IceGPS.nextField(iadr, 2);
            nadr = IceGPS.nextField(iadr, 1);
            week = IceGPS.parseDec(iadr, nadr, 0);
            if (mrev <= 1) {
                week += 1024;
            }
            IceGPS.awMem(100, week);
            iadr = IceGPS.nextField(nadr, 1);
            sow = IceGPS.parseDec(nadr, iadr, 3);
            IceGPS.awMem(104, sow);
        } else if (a == 76 && b == 89 && c == 83) {
            return 0;
        }
        return IceGPS.nextLine(iadr, 200);
    }

    public static void processIRB(int year, int mon, int day, int sec) {
        int irb0 = 0;
        int irb1 = 0;
        int irb2 = 0;
        int doy = IceGPS.getDoY(day, mon, year);
        IceGPS.awMem(16, year);
        IceGPS.awMem(20, doy);
        IceGPS.awMem(24, sec);
        if (++sec >= 86400) {
            ++doy;
            sec -= 86400;
        }
        irb2 |= sec << 8;
        int dn = 36000;
        int cn = 0;
        while (sec >= dn) {
            ++cn;
            sec -= dn;
        }
        irb0 |= cn << 23;
        dn = 3600;
        cn = 0;
        while (sec >= dn) {
            ++cn;
            sec -= dn;
        }
        irb0 |= cn << 18;
        dn = 600;
        cn = 0;
        while (sec >= dn) {
            ++cn;
            sec -= dn;
        }
        irb0 |= cn << 14;
        dn = 60;
        cn = 0;
        while (sec >= dn) {
            ++cn;
            sec -= dn;
        }
        irb0 |= cn << 9;
        dn = 10;
        cn = 0;
        while (sec >= dn) {
            ++cn;
            sec -= dn;
        }
        irb0 |= cn << 6;
        cn = sec;
        irb0 |= cn << 1;
        dn = 100;
        cn = 0;
        while (doy >= dn) {
            ++cn;
            doy -= dn;
        }
        irb1 |= cn << 4;
        dn = 10;
        cn = 0;
        while (doy >= dn) {
            ++cn;
            doy -= dn;
        }
        irb1 |= cn << 0;
        cn = doy;
        irb0 |= cn << 27;
        dn = 10;
        cn = 0;
        while (year >= dn) {
            ++cn;
            year -= dn;
        }
        irb1 |= cn << 18;
        cn = year;
        IceGPS.awBus(131072, irb0);
        IceGPS.awBus(131076, irb1 |= cn << 13);
        IceGPS.awBus(131080, irb2);
    }

    public static int nextLine(int adr, int len) {
        ++adr;
        while (IceGPS.arBus(adr) != 36 && IceGPS.arBus(adr) != 35 && IceGPS.arBus(adr) != 0 && len > 0) {
            ++adr;
            --len;
        }
        return adr;
    }

    public static int findChar(int iadr, int eind, int ac) {
        while (eind > iadr && IceGPS.arBus(iadr) != ac) {
            ++iadr;
        }
        return iadr;
    }

    public static int arBCD(int adr, int off) {
        int bcd = IceGPS.arBus(adr + off) - 48;
        return bcd;
    }

    public static int nextField(int adr, int cc) {
        while (cc > 0) {
            int c;
            if ((c = IceGPS.arBus(adr++)) == 44) {
                --cc;
            }
            if (c == 42) {
                --cc;
            }
            if (c != 0) continue;
            break;
        }
        return adr;
    }

    public static int getDoY(int day, int mon, int year) {
        if (mon > 1) {
            day += 31;
        }
        if (mon > 2) {
            day += 28;
        }
        if (mon > 3) {
            day += 31;
        }
        if (mon > 4) {
            day += 30;
        }
        if (mon > 5) {
            day += 31;
        }
        if (mon > 6) {
            day += 30;
        }
        if (mon > 7) {
            day += 31;
        }
        if (mon > 8) {
            day += 31;
        }
        if (mon > 9) {
            day += 30;
        }
        if (mon > 10) {
            day += 31;
        }
        if (mon > 11) {
            day += 30;
        }
        if (mon > 2 && (year & 3) == 0) {
            ++day;
        }
        return day;
    }

    public static int addBCD(int word, int bcd, int shft) {
        return word | bcd << shft;
    }
}

