/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import java.io.File;
import nxm.ice.lib.DevIce;
import nxm.ice.lib.FileIO;
import nxm.ice.lib.MDevIce;
import nxm.sys.lib.Convert;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class IceBlockResource
extends IOResource {
    private int fb;
    private File file;
    private static int PGSZ = 8192;
    private static int CBSZ = 131072;
    private long paddr = -1L;
    private long psize;
    private long rdaddr;
    private long rdsize;
    private String rdpath;
    public MDevIce pic;
    public DevIce.DmaMap map;
    public int type;
    public int devno;
    public int clen = 0;
    public byte[] cbuf = null;
    public static String typeList = "Raw,Ram,IceFS,PIC,NIC,PAC,IceBlk";
    public static int RAW = 0;
    public static int RAM = 1;
    public static int IFS = 2;
    public static int PIC = 3;
    public static int NIC = 4;
    public static int PAC = 5;
    public static int BLK = 6;
    private long extent = 0xFFFFFFL;
    File lockFile;

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isFile() {
        return true;
    }

    public void setURL(String str) {
        super.setURL(str);
        if (str.startsWith("ramd:")) {
            this.type = RAM;
            str = str.substring(5);
        } else if (str.startsWith("ice:")) {
            this.type = RAM;
            int i = (str = str.substring(4)).indexOf("/icefs");
            if (i > 0) {
                this.type = IFS;
                this.devno = Convert.s2l((String)str.substring(i + 6, i + 7)) - 1;
            }
            if ((i = str.indexOf("/pic")) > 0) {
                this.type = PIC;
                this.devno = Convert.s2l((String)str.substring(i + 4, i + 5)) - 1;
            }
            if ((i = str.indexOf("/nic")) > 0) {
                this.type = NIC;
                this.devno = Convert.s2l((String)str.substring(i + 4, i + 5)) - 1;
            }
        } else if (str.startsWith("file:")) {
            this.type = RAW;
            str = str.substring(5);
        } else {
            this.type = RAW;
        }
        if (this.type == RAW && str.indexOf("/icefs") >= 0) {
            this.type = IFS;
        }
        this.file = new File(str);
    }

    public boolean open() {
        if (this.type == RAM) {
            this.openRAM();
        } else if (this.type == PIC) {
            this.openPIC();
        } else if (this.type == IFS) {
            this.openFIO();
        } else if (this.type == RAW) {
            this.openFIO();
        } else {
            this.M.error("IceBlockResource type=" + this.type + " not handled yet");
        }
        this.offset = 0L;
        return this.isOpen;
    }

    public boolean openRAM() {
        this.isOpen = false;
        String devn = null;
        String auxstr = null;
        String path = this.urlstr.substring(0, this.urlstr.lastIndexOf(47) + 1);
        this.rdpath = path.substring(4);
        Table auxtbl = (Table)this.M.results.get("AUX");
        Table.Iterator ti = auxtbl.iterator();
        while (auxstr == null && ti.getNext()) {
            String s = ti.value.toString();
            if (!s.startsWith(path)) continue;
            auxstr = s;
        }
        if (auxstr == null) {
            this.M.error("IceBlock AUX entry not found for: " + this.urlstr);
        }
        Parser p = new Parser(auxstr);
        this.rdpath = p.get(1).substring(5);
        devn = p.get(2);
        this.rdaddr = Convert.s2xl((String)p.get(3));
        this.rdsize = Convert.s2xl((String)p.get(4));
        if (this.urlstr.endsWith("/")) {
            return false;
        }
        this.pic = new MDevIce(this.M, "ICERAM,DEVNO=0");
        long maxalloc = this.M.results.getL("ENV.ICE.MAXALLOC", -1);
        if (maxalloc > 0L) {
            this.pic.setMaxAlloc(maxalloc << 20);
        }
        if (this.rdaddr == 0L && this.rdsize != 0L) {
            this.pic.open();
            this.rdaddr = this.pic.phys2long(this.pic.getKeyL(0, 129));
            this.pic.close();
        }
        byte[] detbuf = new byte[16];
        if (this.dir <= 0) {
            int fd = Native.fopen((String)this.file.toString(), (int)this.dir);
            Native.freadb((int)fd, (Object)detbuf, (int)0, (int)16);
            if (fd != 0) {
                Native.fclose((int)fd);
            }
            this.paddr = Convert.unpackX((byte[])detbuf, (int)0);
            this.psize = Convert.unpackX((byte[])detbuf, (int)8);
            this.length = Math.min(this.length, this.psize);
        } else {
            this.lockFileAlloc();
            int fd = Native.fopen((String)this.file.toString(), (int)this.dir);
            Convert.packX((byte[])detbuf, (int)0, (long)-1L);
            Convert.packX((byte[])detbuf, (int)8, (long)1L);
            Native.fwriteb((int)fd, (Object)detbuf, (int)0, (int)16);
            Native.fseek((int)fd, (long)0L);
            this.psize = (this.length + (long)PGSZ - 1L) / (long)PGSZ * (long)PGSZ;
            this.getAllocation();
            Convert.packX((byte[])detbuf, (int)0, (long)this.paddr);
            Convert.packX((byte[])detbuf, (int)8, (long)this.psize);
            Native.fwriteb((int)fd, (Object)detbuf, (int)0, (int)16);
            if (fd != 0) {
                Native.fclose((int)fd);
            }
            this.lockFileFree();
        }
        this.map = this.pic.getMap();
        this.map.mode = 2;
        this.map.bytes = this.length;
        this.map.paddr = this.getPhysicalAddress();
        this.map.dev = this.pic;
        this.map.devn = null;
        this.map.setPaged(Shell.ostag.startsWith("lin"));
        this.isOpen = true;
        return this.isOpen;
    }

    public boolean openPIC() {
        this.isOpen = false;
        this.fb = FileIO.fopen("/dev/" + this.file.toString(), this.dir);
        FileIO.fseek(this.fb, this.getPhysicalAddress());
        this.isOpen = this.fb > 0;
        return this.isOpen;
    }

    public boolean openFIO() {
        this.isOpen = false;
        int flags = 0;
        boolean direct = this.urlstr.endsWith(".det") && this.dir > 0 && this.type != IFS;
        boolean cache = this.urlstr.endsWith(".pkt") && this.dir > 0;
        boolean thread = false;
        if (this.qualTable != null) {
            direct = this.qualTable.getState("USEDIRECT", direct);
        }
        if (this.qualTable != null) {
            thread = this.qualTable.getState("USETHREADED", thread);
        }
        if (direct) {
            flags |= 4;
        }
        if (thread) {
            flags |= 8;
        }
        this.fb = FileIO.fopen(this.file.toString(), this.dir, flags);
        this.isOpen = this.fb > 0;
        this.length = this.file.length();
        if (cache) {
            this.cbuf = new byte[CBSZ + 4096];
            this.clen = 0;
        }
        return this.isOpen;
    }

    public boolean close() {
        if (this.clen > 0) {
            this.flushCache();
        }
        if (this.isOpen && this.type == PIC) {
            this.pic.close();
        }
        if (!this.isOpen) {
            return false;
        }
        if (this.fb > 0) {
            FileIO.fclose(this.fb);
        }
        if (this.map != null) {
            this.map.close(10);
        }
        this.isOpen = false;
        return true;
    }

    public boolean delete() {
        return this.file.delete();
    }

    public long getLength() {
        return this.length;
    }

    public boolean seek(long offset) {
        if (this.clen > 0) {
            this.flushCache();
        }
        if (offset == this.offset) {
            return true;
        }
        if (this.fb > 0 && FileIO.fseek(this.fb, offset) != offset) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    public long avail() {
        return this.length - this.offset;
    }

    public int read(byte[] buf, int boff, int bytes) {
        bytes = (int)Math.min((long)bytes, this.length - this.offset);
        if (this.map != null) {
            long vaddr = this.map.getVirtualAddress(this.offset, bytes);
            Native.p2ja((long)vaddr, (int)0, (Object)buf, (int)boff, (int)bytes);
        } else {
            bytes = FileIO.freadb(this.fb, buf, boff, bytes);
        }
        if (bytes > 0) {
            this.offset += (long)bytes;
        }
        return bytes;
    }

    private void flushCache() {
        FileIO.fwriteb(this.fb, this.cbuf, 0, this.clen);
        this.clen = 0;
    }

    public int write(byte[] buf, int boff, int bytes) {
        if (this.map != null) {
            bytes = (int)Math.min((long)bytes, this.length - this.offset);
            long vaddr = this.map.getVirtualAddress(this.offset, bytes);
            Native.ja2p((Object)buf, (int)boff, (long)vaddr, (int)0, (int)bytes);
        } else if (this.cbuf != null) {
            if (this.clen >= CBSZ) {
                this.flushCache();
            }
            System.arraycopy(buf, boff, this.cbuf, this.clen, bytes);
            this.clen += bytes;
        } else {
            bytes = FileIO.fwriteb(this.fb, buf, boff, bytes);
        }
        if (bytes > 0) {
            this.offset += (long)bytes;
        }
        return bytes;
    }

    public int read(long lbuf, int boff, int bytes) {
        bytes = (int)Math.min((long)bytes, this.length - this.offset);
        if (this.map != null) {
            long vaddr = this.map.getVirtualAddress(this.offset, bytes);
            Native.p2p((long)vaddr, (int)0, (long)lbuf, (int)boff, (int)bytes);
        } else {
            bytes = FileIO.fread(this.fb, lbuf, boff, bytes);
        }
        if (bytes > 0) {
            this.offset += (long)bytes;
        }
        return bytes;
    }

    public int write(long lbuf, int boff, int bytes) {
        if (this.map != null) {
            bytes = (int)Math.min((long)bytes, this.length - this.offset);
            long vaddr = this.map.getVirtualAddress(this.offset, bytes);
            Native.p2p((long)lbuf, (int)boff, (long)vaddr, (int)0, (int)bytes);
        } else {
            bytes = FileIO.fwrite(this.fb, lbuf, boff, bytes);
        }
        if (bytes > 0) {
            this.offset += (long)bytes;
        }
        return bytes;
    }

    public String toString() {
        return "IceBlockResource: " + this.getURL();
    }

    private synchronized void getAllocation() {
        String[] lf = this.M.io.listFiles((Object)this.rdpath, "*", "det");
        int ndet = lf.length;
        long[] paddrs = new long[ndet + 1];
        long[] psizes = new long[ndet + 1];
        byte[] detbuf = new byte[16];
        for (int i = 0; i < ndet; ++i) {
            int j;
            String fname = this.rdpath + lf[i];
            int fd = Native.fopen((String)fname, (int)-1);
            Native.freadb((int)fd, (Object)detbuf, (int)0, (int)16);
            Native.fclose((int)fd);
            long paddri = Convert.unpackX((byte[])detbuf, (int)0);
            long psizei = Convert.unpackX((byte[])detbuf, (int)8);
            for (j = 0; j < i && paddri > paddrs[j]; ++j) {
            }
            for (int k = i - 1; k >= j; --k) {
                paddrs[k + 1] = paddrs[k];
                psizes[k + 1] = psizes[k];
            }
            paddrs[j] = paddri;
            psizes[j] = psizei;
        }
        this.paddr = -1L;
        long minsize = paddrs[ndet] = this.rdsize;
        for (int n = ndet - 1; n >= 0; --n) {
            long size = paddrs[n + 1] - (paddrs[n] + psizes[n]);
            if (size < this.psize || size > minsize) continue;
            this.paddr = paddrs[n] + psizes[n];
            minsize = size;
        }
        if (this.paddr < 0L) {
            this.M.error("Could not allocate IceBlock buffer of " + this.psize + " bytes");
        }
    }

    public int checkAllocation(int bytes) {
        long next = this.offset + (long)bytes;
        if (this.length >= next) {
            return bytes;
        }
        this.length = next;
        if (this.psize >= this.length) {
            return bytes;
        }
        this.psize = next + (long)bytes + this.extent & (this.extent ^ 0xFFFFFFFFFFFFFFFFL);
        byte[] detbuf = new byte[16];
        Convert.packX((byte[])detbuf, (int)0, (long)this.paddr);
        Convert.packX((byte[])detbuf, (int)8, (long)this.psize);
        int fd = Native.fopen((String)this.file.toString(), (int)this.dir);
        Native.fwriteb((int)fd, (Object)detbuf, (int)0, (int)16);
        Native.fclose((int)fd);
        return bytes;
    }

    public long getPhysicalAddress() {
        return this.rdaddr + this.paddr;
    }

    public Table getStatFS() {
        if (!this.isOpen) {
            this.open();
        }
        String[] lf = this.M.io.listFiles((Object)this.rdpath, "*", "det");
        int files = lf.length;
        long total = 0L;
        byte[] detbuf = new byte[16];
        for (int i = 0; i < files; ++i) {
            String fname = this.rdpath + lf[i];
            int fd = Native.fopen((String)fname, (int)-1);
            Native.freadb((int)fd, (Object)detbuf, (int)0, (int)16);
            Native.fclose((int)fd);
            long psizei = Convert.unpackX((byte[])detbuf, (int)8);
            total += psizei;
        }
        int tmby = (int)(this.rdsize / 1000000L);
        int fmby = tmby - (int)(total / 1000000L);
        int used = 100 - 100 * fmby / tmby;
        String stats = "{PATH=" + this.rdpath + ",FILES=" + files + ",TMBY=" + tmby + ",FMBY=" + fmby + ",USED=" + used + "}";
        return new Table(stats);
    }

    private void lockFileAlloc() {
        this.lockFile = new File(this.rdpath + "allocate.LOCK");
        for (int i = 0; i < 100; ++i) {
            try {
                if (this.lockFile.createNewFile()) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Time.sleep((double)0.01);
        }
        System.out.println("Overriding stale lock file " + this.lockFile);
    }

    private void lockFileFree() {
        this.lockFile.delete();
    }
}

