/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;

public class ICEPacket
implements PacketHandler {
    public static final int ABSC = 1;
    public static final int FIXED = 2;
    public static final int PKHO = 4;
    public static final int headerLength = 64;
    private int mhdrs = 8;
    public byte[] buf = new byte[this.mhdrs * 64];
    private int rhdrs = 0;
    private int whdrs = 0;
    private int count = 0;
    private int fixedSize = 0;
    private int bpa = 1;
    private int ipoff = 0;
    private int flags;
    private double npktoff;
    private byte rep = Shell.rep;
    private boolean pkho = false;
    private static final int ICE_SYNC_1 = 101;
    private static final int ICE_SYNC_2 = 102;
    private static final int ICE_SYNC_3 = 103;

    public ICEPacket() {
        this("SB", 1024, 0);
    }

    public ICEPacket(byte[] ibuf, int offset) {
        this.setBytes(ibuf, offset);
    }

    public void setBytes(byte[] ibuf, int offset) {
        System.arraycopy(ibuf, offset, this.buf, 0, 64);
        this.rep = this.getRep();
        this.bpa = this.getBPA();
        this.count = this.getCount();
    }

    public ICEPacket(String format, int size, int flags) {
        this.flags = flags;
        this.setRep(Shell.rep);
        this.setKeys((byte)0);
        this.setCount(0);
        if ((flags & 2) != 0) {
            this.setFixedSize(size);
        } else {
            this.setSize(size);
        }
        this.setUser((short)0);
        this.setChannel(1);
        this.setID((byte)0, (byte)0);
        this.setFormat(format);
        this.setTC(0, 0, 0.0, 0.0, 0.0);
        if ((flags & 1) != 0) {
            this.setAbscissa(0.0, 1.0);
        }
        if ((flags & 4) != 0) {
            this.pkho = true;
        }
    }

    public void setKeys(byte userKey) {
        this.buf[0] = 101;
        this.buf[1] = 102;
        this.buf[2] = 103;
        this.setUserKey(userKey);
    }

    public void setUserKey(byte val) {
        this.buf[3] = val;
    }

    public byte getUserKey() {
        return this.buf[3];
    }

    public boolean hasSync() {
        return ICEPacket.hasSync(this.buf, 0);
    }

    public static boolean hasSync(byte[] buf, int boffset) {
        return buf[boffset + 0] == 101 && buf[boffset + 1] == 102 && buf[boffset + 2] == 103;
    }

    public void setCount(int count) {
        this.count = count;
        Convert.packL((byte[])this.buf, (int)4, (int)count, (byte)this.rep);
    }

    public void upCount() {
        ++this.count;
        Convert.packL((byte[])this.buf, (int)4, (int)this.count, (byte)this.rep);
    }

    public void upCount(int n) {
        this.count += n;
        Convert.packL((byte[])this.buf, (int)4, (int)this.count, (byte)this.rep);
    }

    public void setSize(int size) {
        Convert.packL((byte[])this.buf, (int)8, (int)size, (byte)this.rep);
    }

    public void setUser(short user) {
        Convert.packI((byte[])this.buf, (int)12, (short)user, (byte)this.rep);
    }

    public void setChannel(int channel) {
        Convert.packI((byte[])this.buf, (int)14, (short)((short)channel), (byte)this.rep);
    }

    public void setID(byte id1, byte id2) {
        this.buf[16] = id1;
        this.buf[17] = id2;
    }

    public void setRep(byte rep) {
        this.buf[18] = rep;
    }

    public byte getRep() {
        return this.buf[18];
    }

    public static byte getRep(byte[] buf, int boffset) {
        return buf[boffset + 18];
    }

    public int getBPA() {
        return this.buf[19];
    }

    public void setBPA(int val) {
        this.buf[19] = (byte)val;
        this.bpa = this.buf[19];
    }

    public void setFormat(String format) {
        this.setBPA(Data.getBPA((String)format));
        this.buf[20] = (byte)format.charAt(0);
        this.buf[21] = (byte)format.charAt(1);
    }

    public void setTC(int mode, int status, double offset, double wsec, double fsec) {
        this.buf[22] = (byte)mode;
        this.buf[23] = (byte)status;
        Convert.packD((byte[])this.buf, (int)24, (double)offset, (byte)this.rep);
        Convert.packD((byte[])this.buf, (int)32, (double)wsec, (byte)this.rep);
        Convert.packD((byte[])this.buf, (int)40, (double)fsec, (byte)this.rep);
    }

    public void setTC(ICEPacket source) {
        System.arraycopy(source.buf, 22, this.buf, 22, 26);
    }

    public Time getTC() {
        double wsec = Convert.unpackD((byte[])this.buf, (int)32, (byte)this.rep);
        double fsec = Convert.unpackD((byte[])this.buf, (int)40, (byte)this.rep);
        return new Time(wsec, fsec);
    }

    public byte getTCMode() {
        return this.buf[23];
    }

    public byte getTCStatus() {
        return this.buf[23];
    }

    public double getTCO() {
        return Convert.unpackD((byte[])this.buf, (int)24, (byte)this.rep);
    }

    public void decTCO(int xfer) {
        double tcoff = Convert.unpackD((byte[])this.buf, (int)24, (byte)this.rep);
        Convert.packD((byte[])this.buf, (int)24, (double)(tcoff - (double)xfer), (byte)this.rep);
    }

    public int getTC(Time tc, double offset, double delta) {
        double wsec = Convert.unpackD((byte[])this.buf, (int)32, (byte)this.rep);
        double fsec = Convert.unpackD((byte[])this.buf, (int)40, (byte)this.rep);
        tc.fromJ1950(wsec, fsec);
        double tcoff = offset - Convert.unpackD((byte[])this.buf, (int)24, (byte)this.rep);
        tc.addSec(tcoff * delta);
        return this.buf[23];
    }

    public void setUserData(double val, int pos) {
        Convert.packD((byte[])this.buf, (int)(48 + 8 * pos), (double)val, (byte)this.rep);
    }

    public void setUserData(long val, int pos) {
        Convert.packX((byte[])this.buf, (int)(48 + 8 * pos), (long)val, (byte)this.rep);
    }

    public void setUserData(float val, int pos) {
        Convert.packF((byte[])this.buf, (int)(48 + 4 * pos), (float)val, (byte)this.rep);
    }

    public void setUserData(int val, int pos) {
        Convert.packL((byte[])this.buf, (int)(48 + 4 * pos), (int)val, (byte)this.rep);
    }

    public void setUserData(short val, int pos) {
        Convert.packI((byte[])this.buf, (int)(48 + 2 * pos), (short)val, (byte)this.rep);
    }

    public void setUserData(byte val, int pos) {
        this.buf[48 + pos] = val;
    }

    public double getUserDataD(int pos) {
        return Convert.unpackD((byte[])this.buf, (int)(48 + 8 * pos), (byte)this.rep);
    }

    public long getUserDataX(int pos) {
        return Convert.unpackX((byte[])this.buf, (int)(48 + 8 * pos), (byte)this.rep);
    }

    public float getUserDataF(int pos) {
        return Convert.unpackF((byte[])this.buf, (int)(48 + 4 * pos), (byte)this.rep);
    }

    public int getUserDataL(int pos) {
        return Convert.unpackL((byte[])this.buf, (int)(48 + 4 * pos), (byte)this.rep);
    }

    public short getUserDataI(int pos) {
        return Convert.unpackI((byte[])this.buf, (int)(48 + 2 * pos), (byte)this.rep);
    }

    public byte getUserDataB(int pos) {
        return this.buf[48 + pos];
    }

    public void setAbscissa(double xstart, double xdelta) {
        Convert.packD((byte[])this.buf, (int)48, (double)xstart, (byte)this.rep);
        Convert.packD((byte[])this.buf, (int)56, (double)xdelta, (byte)this.rep);
    }

    public void setMode(String mode) {
        this.flags = mode.equals("ABSC") ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setFixedSize(int size) {
        this.fixedSize = size;
        this.setSize(size);
    }

    public int getChannel() {
        return Convert.unpackI((byte[])this.buf, (int)14, (byte)this.rep);
    }

    public int getCount() {
        this.count = Convert.unpackL((byte[])this.buf, (int)4, (byte)this.rep);
        return this.count;
    }

    public String getFormat() {
        return Convert.unpackS((byte[])this.buf, (int)20, (int)2);
    }

    public int getSize() {
        int size = this.fixedSize != 0 ? this.fixedSize : Convert.unpackL((byte[])this.buf, (int)8, (byte)this.rep);
        return size;
    }

    public int getBytes() {
        int size = this.fixedSize;
        if (size == 0) {
            size = Convert.unpackL((byte[])this.buf, (int)8, (byte)this.rep);
        }
        return this.bpa * size;
    }

    public int getFixedSize() {
        return this.fixedSize;
    }

    public void setRBData(int off, int value) {
        Convert.packL((byte[])this.buf, (int)(48 + off * 4), (int)value, (byte)this.rep);
    }

    public int getRBData(int off) {
        return Convert.unpackL((byte[])this.buf, (int)(48 + off * 4), (byte)this.rep);
    }

    public String getConfiguration(DataFile df) {
        String config = "ICE";
        if (this.fixedSize != 0) {
            config = config + "/FS=" + this.fixedSize;
        }
        if ((this.flags & 1) != 0) {
            config = config + "/MODE=ABSC";
        }
        if (df.hp != null) {
            config = config + "/DET";
            if (df.hp.aux != null && df.hp.aux.length() > 0) {
                config = config + "=" + df.hp.aux;
            }
        }
        return config;
    }

    public void setFileName(DataFile df, FileName filename) {
        DataFile hp = new DataFile();
        hp.init((MidasReference)df.cmd, (Object)filename, "3000", "NH", df.getPacketHandlerFlags());
        hp.setSubRecords("KEYS|4B,CNT|SL,ELEM|SL,USER|SI,CHAN|SI,SID|2B,REP|SB,BPA|SB,MODE|SB,TYPE|SB,TCM|SB,TCS|SB,TCO|SD,TCWS|SD,TCFS|SD");
        if ((this.flags & 1) != 0) {
            hp.setSubRecords("+XDEL|SD,XSTA|SD");
        } else {
            hp.setSubRecords("+RBST|SL,RBSZ|SL,RBDO|SL,RBDS|SL");
        }
        if (this.fixedSize > 0) {
            hp.setSize((double)((int)(df.getSize() / (double)this.fixedSize)));
        }
        df.hp = hp;
    }

    public double naturalDataOffset(DataFile df, double boffset) {
        int bpp = this.fixedSize * this.bpa;
        if (bpp == 0) {
            bpp = this.getBytes();
        }
        double npkt = Math.floor(boffset / (double)bpp);
        return npkt * (double)bpp;
    }

    public double dataToPacketOffset(DataFile df, double boffset) {
        int bpp = this.fixedSize * this.bpa;
        if (bpp == 0) {
            bpp = this.getBytes();
        }
        double npkt = Math.floor(boffset / (double)bpp);
        double bpkthdr = npkt * 64.0;
        this.ipoff = (int)(boffset - npkt * (double)bpp);
        if (df.hp == null) {
            boffset += bpkthdr;
            if (this.ipoff > 0) {
                boffset += 64.0;
            }
        } else {
            if (this.ipoff > 0) {
                npkt += 1.0;
            }
            this.npktoff = npkt;
        }
        return boffset;
    }

    public double packetToDataOffset(DataFile df, double boffset) {
        if (df.hp != null) {
            return boffset;
        }
        int bpp = this.fixedSize * this.bpa;
        if (bpp == 0) {
            bpp = this.getBytes();
        }
        double npkt = Math.floor(boffset / (double)(bpp + 64));
        return npkt * (double)bpp;
    }

    public void open(DataFile df) {
        this.setFormat(df.getFormat());
        if (df.hp != null) {
            Object rg = df.fn.getQualifier("RG");
            if (rg != null) {
                df.hp.setQualifier("RG", rg);
            }
            df.hp.open();
        }
    }

    public void seek(DataFile df, double boffset) {
        boffset = this.dataToPacketOffset(df, boffset);
        if (df.hp != null) {
            df.hp.seek(this.npktoff);
        }
        if (!this.pkho) {
            df.io.seek((long)(df.getDataStart() + boffset));
        }
    }

    public int read(DataFile df, byte[] buf, int boff, int bytes, long lbuf) {
        int nb;
        int nbp = this.getBytes();
        this.rhdrs = 0;
        for (int ndo = bytes; ndo > 0; ndo -= nb) {
            if (this.ipoff == 0) {
                if (this.rhdrs == this.mhdrs) {
                    this.setMaxHeaders(this.mhdrs * 2);
                }
                if (df.hp != null) {
                    df.hp.read(this.buf, this.rhdrs * 64, 64);
                } else {
                    df.io.read(this.buf, this.rhdrs * 64, 64);
                }
                ++this.rhdrs;
            }
            nb = Math.min(ndo, nbp - this.ipoff);
            nb = buf != null ? df.io.read(buf, boff, nb) : df.io.read(lbuf, boff, nb);
            if (nb <= 0) {
                return nb;
            }
            boff += nb;
            this.ipoff += nb;
            if (this.ipoff != nbp) continue;
            this.ipoff = 0;
        }
        return bytes;
    }

    public int write(DataFile df, byte[] buf, int boff, int bytes, long lbuf) {
        int nb;
        int nbp = this.getBytes();
        this.whdrs = 0;
        for (int ndo = bytes; ndo > 0; ndo -= nb) {
            if (this.ipoff == 0) {
                if (df.hp != null) {
                    df.hp.write(this.buf, this.whdrs * 64, 64);
                } else if (df.io != null) {
                    df.io.write(this.buf, this.whdrs * 64, 64);
                }
                ++this.whdrs;
            }
            nb = Math.min(ndo, nbp - this.ipoff);
            if (!this.pkho) {
                nb = buf != null ? df.io.write(buf, boff, nb) : df.io.write(lbuf, boff, nb);
            }
            if (nb < 0) {
                return nb;
            }
            boff += nb;
            this.ipoff += nb;
            if (this.ipoff != nbp) continue;
            this.ipoff = 0;
        }
        return bytes;
    }

    public void close(DataFile df) {
        if (df.hp != null) {
            df.hp.close();
        }
    }

    public boolean hasHeader() {
        return this.rhdrs > 0;
    }

    public String listHeader() {
        String list = "ICE-Packet Count=" + this.getCount() + " Elem=" + this.getSize() + " Chan=" + this.getChannel() + " Form=" + this.getFormat() + " TC=" + this.getTC() + " at " + this.getTCO();
        return list;
    }

    public PacketHandler cloneOf() {
        PacketHandler ph = null;
        try {
            ph = (PacketHandler)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ph;
    }

    public void copyFrom(ICEPacket source) {
        this.setBytes(source.buf, 0);
    }

    private void setMaxHeaders(int nmhdrs) {
        byte[] nbuf = new byte[nmhdrs * 64];
        if (this.rhdrs > 0) {
            System.arraycopy(this.buf, 0, nbuf, 0, this.rhdrs * 64);
        }
        this.buf = nbuf;
        this.mhdrs = nmhdrs;
    }

    public void setBuffer(byte[] ibuf, int offset) {
        System.arraycopy(ibuf, offset, this.buf, 0, 64);
    }
}

