/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

public class DevIce {
    protected long handle;
    protected static boolean useNative;
    protected long MAXALLOC = 0x10000000L;
    public static final int ICEPIC1 = 1;
    public static final int ICEPIC2 = 2;
    public static final int ICEPIC3 = 3;
    public static final int ICEPIC4 = 4;
    public static final int ICEPIC5 = 5;
    public static final int ICEPIC6 = 6;
    public static final int ICEPIC7 = 7;
    public static final int ICEPIC8 = 8;
    public static final int ICEPIC9 = 9;
    public static String cardList;
    public static final int IOPT_NONE = 0;
    public static final int IOPT_STREAM = 1;
    public static final int IOPT_LINK = 2;
    public static final int IOPT_MODULE = 3;
    public static final int IOPT_TUNER = 4;
    public static final int IOPT_INTERNAL = 5;
    public static final int IOPT_EXTERNAL = 6;
    public static final int IOPT_CORE = 7;
    public static final int IOPT_MCORE = 8;
    public static final int IOPT_TBANK = 9;
    public static final int IOPT_CBANK = 10;
    public static String ioptList;
    public static final int IOMT_UNKNOWN = -101;
    public static final int IOMT_TEST = -100;
    public static final int IOMT_AUTO = -99;
    public static final int IOMT_NONE = 0;
    public static final int IOMT_E2D = -1;
    public static final int IOMT_LV2D = -2;
    public static final int IOMT_A2D = -3;
    public static final int IOMT_CXD = -4;
    public static final int IOMT_T2D = -5;
    public static final int IOMT_UXD = -6;
    public static final int IOMT_VXD = -7;
    public static final int IOMT_DR2D = -8;
    public static final int IOMT_PSE2D = -9;
    public static final int IOMT_DXFPDP = -10;
    public static final int IOMT_DXFPQC = -11;
    public static final int IOMT_DXUDP = -12;
    public static final int IOMT_SNTXD = -13;
    public static final int IOMT_SDDSXD = -14;
    public static final int IOMT_GXD = -15;
    public static final int IOMT_NFXD = -16;
    public static final int IOMT_CDR2D = -17;
    public static final int IOMT_LB2D = -18;
    public static final int IOMT_FLZRXD = -19;
    public static final int IOMT_RFXD = -20;
    public static final int IOMT_MSASXD = -21;
    public static final int IOMT_DSFPXD = -22;
    public static final int IOMT_SFPXD = -23;
    public static final int IOMT_SFPPXD = -24;
    public static final int IOMT_SE2D = -25;
    public static final int IOMT_TGSDDS2D = -26;
    public static final int IOMT_AWG2D = -27;
    public static final int IOMT_UFLZXD = -28;
    public static final int IOMT_GPSXD = -29;
    public static final int IOMT_DIODEI = -30;
    public static final int IOMT_TGVXD = -31;
    public static final int IOMT_RF2D = -32;
    public static String imtList;
    public static final int IOMT_D2E = 1;
    public static final int IOMT_D2LV = 2;
    public static final int IOMT_D2A = 3;
    public static final int IOMT_DXC = 4;
    public static final int IOMT_D2T = 5;
    public static final int IOMT_DXU = 6;
    public static final int IOMT_DXV = 7;
    public static final int IOMT_D2DR = 8;
    public static final int IOMT_D2PSE = 9;
    public static final int IOMT_FPDPXD = 10;
    public static final int IOMT_FPQCXD = 11;
    public static final int IOMT_UDPXD = 12;
    public static final int IOMT_DXSNT = 13;
    public static final int IOMT_DXSDDS = 14;
    public static final int IOMT_DXG = 15;
    public static final int IOMT_DXNF = 16;
    public static final int IOMT_D2CDR = 17;
    public static final int IOMT_D2LB = 18;
    public static final int IOMT_DXFLZR = 19;
    public static final int IOMT_DXRF = 20;
    public static final int IOMT_DXMSAS = 21;
    public static final int IOMT_DXDSFP = 22;
    public static final int IOMT_DXSFP = 23;
    public static final int IOMT_DXSFPP = 24;
    public static final int IOMT_D2SE = 25;
    public static final int IOMT_D2TGSDDS = 26;
    public static final int IOMT_D2AWG = 27;
    public static final int IOMT_DXUFLZ = 28;
    public static final int IOMT_GPS = 29;
    public static final int IOMT_DIODE = 30;
    public static final int IOMT_DXTGV = 31;
    public static final int IOMT_D2RF = 32;
    public static String omtList;
    public static final int PMT_DTDM = 1;
    public static final int PMT_DTDMX = 2;
    public static final int PMT_ZPPM = 3;
    public static final int PMT_S6M = 4;
    public static final int PMT_V5M = 5;
    public static final int PMT_V6M = 6;
    public static final int PMT_V7M = 7;
    public static final int PMT_K8M = 8;
    public static String pmList;
    public static final int DMA_LOOPNSPIN = -23;
    public static final int DMA_INDEX = -22;
    public static final int DMA_ALLOCATE = -21;
    public static final int DMA_ENABLE = -20;
    public static final int DMA_LOADNSPIN = -19;
    public static final int DMA_STATUS_W64 = -18;
    public static final int DMA_ONDEMAND = -17;
    public static final int DMA_BURY = -16;
    public static final int DMA_KILL = -15;
    public static final int DMA_LOOP = -14;
    public static final int DMA_POLL = -13;
    public static final int DMA_ACTIVE = -12;
    public static final int DMA_RESHOT = -11;
    public static final int DMA_LOST = -10;
    public static final int DMA_CANCEL = -9;
    public static final int DMA_RESET = -8;
    public static final int DMA_LOAD = -7;
    public static final int DMA_CYCLE = -5;
    public static final int DMA_STATUS = -4;
    public static final int DMA_WAIT = -3;
    public static final int DMA_CONTINUOUS = -2;
    public static final int DMA_SPIN = -1;
    public static final int DMA_STOP = 0;
    public static final int DMA_ONESHOT = 1;
    public static final int FLG_TEST = 1;
    public static final int FLG_NOBRK = 2;
    public static final int FLG_BIGEND = 4;
    public static final int FLG_HS = 8;
    public static final int FLG_MUXCLK = 16;
    public static final int FLG_INTCLK = 32;
    public static final int FLG_TC = 64;
    public static final int FLG_LOOP = 128;
    public static final int FLG_NOLOCK = 256;
    public static final int FLG_DISABLE = 512;
    public static final int FLG_VERBOSE = 1024;
    public static final int FLG_NCCLK = 2048;
    public static final int FLG_BOOT = 4096;
    public static final int FLG_TUNER = 8192;
    public static final int FLG_CLKI = 16384;
    public static final int FLG_MSBI = 32768;
    public static final int FLG_VHS = 65536;
    public static final int FLG_DUAL = 131072;
    public static final int FLG_MUX = 262144;
    public static final int FLG_ALT = 524288;
    public static final int FLG_SGO = 0x100000;
    public static final int FLG_TGO = 0x200000;
    public static final int FLG_GGO = 0x400000;
    public static final int FLG_XGO = 0x800000;
    public static final int FLG_OP1 = 0x1000000;
    public static final int FLG_OP2 = 0x2000000;
    public static final int FLG_OP3 = 0x4000000;
    public static final int FLG_OP4 = 0x8000000;
    public static final int FLG_BIT0 = 0x10000000;
    public static final int FLG_BIT4 = 0x20000000;
    public static final int FLG_RGO = 0x40000000;
    public static final int FLG_BACKEND = Integer.MIN_VALUE;
    public static final int FLG_BIT1 = 0x30000000;
    public static final int FLG_NIO = Integer.MIN_VALUE;
    public static final String flagList = "Test,NoBrk,BigEnd,HS,MuxClk,IntClk,TC,Resv,NoLock,Disable,Verbose,NcClk,Boot,Tuner,ClkInv,MsbInv,VHS,Dual,Mux,Alt,SGo,TGo,GGo,XGo,Op1,Op2,Op3,Op4,Bit0,Bit4,RGo,NIO";
    public static final int FLG_XTGO = 0xA00000;
    public static final int FLG_STGO = 0x300000;
    public static final int FLG_XSTGO = 0xB00000;
    public static final int FLG_NOWAIT = 0x1000000;
    public static final int FLG_LINK = 0x2000000;
    public static final int FLG_FTUN = 0x1000000;
    public static final int FLG_DTUN = 0x2000000;
    public static final int FLG_GTUN = 0x4000000;
    public static final int FLG_MTUN = 0x8000000;
    public static final int FLG_TCINTERP = 0x1000000;
    public static final int FLG_TCDELTA = 0x2000000;
    public static final int FLG_INFO = 0x1000000;
    public static final int FLG_XFER = 0x2000000;
    public static final int FLG_SHARC = 0x1000000;
    public static final int FLG_IOC = 0x2000000;
    public static final int FLG_PM = 0x3000000;
    public static final int FLG_FC = 0x4000000;
    public static final int FLG_PPC = 0x5000000;
    public static final int FLG_FLASH = 0x6000000;
    public static final int FLG_MOD = 0x8000000;
    public static final int FLG_STRATIX = 0x9000000;
    public static final int FLG_VIRTEX = 0xA000000;
    public static final int FLG_UFILT = 1;
    public static final int FLG_UCFIR = 2;
    public static final int FLG_NCFIR = 4;
    public static final int FLG_PFIR4 = 8;
    public static final int FLG_AOVSR = 16;
    public static final int FLG_POVSR = 32;
    public static final int FLG_ITDEC = 64;
    public static final int FLG_RESAMP = 128;
    public static final int FLG_DSYNC = 256;
    public static final int FLG_TALT1 = 512;
    public static final int FLG_FSYNC = 1024;
    public static final int FLG_GSYNC = 2048;
    public static final int FLG_TBANK = 4096;
    public static final int FLG_URFIR = 8192;
    public static final int FLG_PRESAMP = 16384;
    public static final int FLG_FIRONLY = 32768;
    public static final int FLG_ITCPC = 65536;
    public static final int FLG_ITFMT = 131072;
    public static final int FLG_PMWBR = 262144;
    public static final int FLG_PMWBT = 524288;
    public static final String tflagList = "UFilt,UCFir,NCFir,PFir4,AOVSR,POVSR,ITDec,Resamp,DSync,TAlt1,FSync,GSync,TBank,URFir,PreSamp,FirOnly,ITCPC,ITFmt,PMWBR,PMWBT";
    public static final int FLG_PPC_MEM = 0;
    public static final int FLG_PPC_BUS = 1;
    public static final int FLG_CTL_BUS = 2;
    public static final String drvFlgList = "RefX,PPSX,IrbX,,,,,,Ref1,PPS1,,,Ref2,PPS2";
    public static final String rfOptsList = "Enable,XRef,XADClk,Atten,LNA,DCS,AIS,AGC,BBAmp,Mute";
    public static final int KEY_RATE = 1;
    public static final int KEY_FREQ = 2;
    public static final int KEY_DEC = 3;
    public static final int KEY_GAIN = 4;
    public static final int KEY_OVSR = 5;
    public static final int KEY_FRAME = 6;
    public static final int KEY_ALG = 7;
    public static final int KEY_FEED = 8;
    public static final int KEY_TCOFF = 9;
    public static final int KEY_FLAG = 10;
    public static final int KEY_SWAP = 11;
    public static final int KEY_CHAIN = 12;
    public static final int KEY_RATIO = 13;
    public static final int KEY_MCFG = 14;
    public static final int KEY_BREAK = 15;
    public static final int KEY_CHAN = 16;
    public static final int KEY_ACTIVE = 17;
    public static final int KEY_DELAY = 18;
    public static final int KEY_PKTLEN = 19;
    public static final int KEY_DFREQ = 20;
    public static final int KEY_FRAMEDEC = 28;
    public static final int KEY_PRCCLK = 21;
    public static final int KEY_IOCCLK = 22;
    public static final int KEY_ICLK = 23;
    public static final int KEY_CCLK = 24;
    public static final int KEY_MCLK = 25;
    public static final int KEY_PCLK = 26;
    public static final int KEY_TUNCLK = 27;
    public static final int KEY_DRATE = 29;
    public static final int KEY_CLKI = 31;
    public static final int KEY_MSBI = 32;
    public static final int KEY_BIT = 33;
    public static final int KEY_BITS = 34;
    public static final int KEY_CLKDLY = 35;
    public static final int KEY_ATCCALIB = 36;
    public static final int KEY_NODMA = 37;
    public static final int KEY_TODO = 38;
    public static final int KEY_GAP = 39;
    public static final int KEY_FLGBSET = 41;
    public static final int KEY_FLGBCLR = 42;
    public static final int KEY_TFLGBSET = 43;
    public static final int KEY_TFLGBCLR = 44;
    public static final int KEY_STIME = 47;
    public static final int KEY_NFREQ = 51;
    public static final int KEY_NDEC = 52;
    public static final int KEY_HUNG = 53;
    public static final int KEY_CRC32 = 54;
    public static final int KEY_SEQERR = 55;
    public static final int KEY_SEQFILL = 56;
    public static final int KEY_PKTHDR = 57;
    public static final int KEY_NRATIO = 58;
    public static final int KEY_INBYTE = 59;
    public static final int KEY_INBYTE_W64 = 60;
    public static final int KEY_RFFREQ = 61;
    public static final int KEY_RFGAIN = 62;
    public static final int KEY_RFBW = 63;
    public static final int KEY_RFOPTS = 64;
    public static final int KEY_RFATTN = 65;
    public static final int KEY_RFPWR = 66;
    public static final int KEY_RFAIS = 67;
    public static final int KEY_RFCAIS = 68;
    public static final int KEY_TCXO = 69;
    public static final int KEY_AGCTC = 70;
    public static final int KEY_MCORES = 79;
    public static final int KEY_AGCCF = 71;
    public static final int KEY_MGAIN = 72;
    public static final int KEY_MFREQ = 73;
    public static final int KEY_NTPOFF = 74;
    public static final int KEY_GPS = 75;
    public static final int KEY_SYSMON = 76;
    public static final int KEY_GPSMODE = 77;
    public static final int KEY_LOG = 78;
    public static final int KEY_NFGAIN = 81;
    public static final int KEY_NYBW = 82;
    public static final int KEY_FBWF = 83;
    public static final int KEY_CTYPE = 101;
    public static final int KEY_PTYPE = 102;
    public static final int KEY_PINDEX = 103;
    public static final int KEY_MTYPE = 104;
    public static final int KEY_MREV = 105;
    public static final int KEY_TEMP = 106;
    public static final int KEY_CHNS = 107;
    public static final int KEY_CPC = 108;
    public static final int KEY_STATUS = 109;
    public static final int KEY_VERSION = 110;
    public static final int KEY_MCHNS = 111;
    public static final int KEY_CBUFSZ = 112;
    public static final int KEY_IOCTYPE = 113;
    public static final int KEY_TINC = 114;
    public static final int KEY_DRIVER = 115;
    public static final int KEY_TCMODE = 116;
    public static final int KEY_IDCODE = 117;
    public static final int KEY_UIDCODE = 118;
    public static final int KEY_USER1 = 119;
    public static final int KEY_USER2 = 120;
    public static final int KEY_PMSTAT = 121;
    public static final int KEY_BSCAN = 122;
    public static final int KEY_PMTYPE = 125;
    public static final int KEY_PMCODE = 126;
    public static final int KEY_CONFIG = 127;
    public static final int KEY_DETECT = 128;
    public static final int KEY_QALLOC = 129;
    public static final int KEY_VERBOSE = 130;
    public static final int KEY_RSTIME = 131;
    public static final int KEY_TPOE = 132;
    public static final int KEY_ROUTE = 133;
    public static final int KEY_TIMEOUT = 134;
    public static final int KEY_PMHBT = 135;
    public static final int KEY_GCHIP = 136;
    public static final int KEY_JTAGPORT = 137;
    public static final int KEY_FPGAREV = 138;
    public static final int KEY_FPGASIG = 139;
    public static final int KEY_TPD = 140;
    public static final int KEY_TPDX = 141;
    public static final int KEY_RMPL = 142;
    public static final int KEY_WMPL = 143;
    public static final int KEY_ROUTF = 144;
    public static final int KEY_DMACHK = 145;
    public static final int KEY_DMAOFF = 146;
    public static final int KEY_STATE = 147;
    public static final int KEY_DUMP = 148;
    public static final int KEY_MBITS = 149;
    public static final int KEY_TPSR = 150;
    public static final int KEY_MPCIO = 151;
    public static final int KEY_CUID = 152;
    public static final int KEY_EMT = 153;
    public static final int KEY_EYESCAN = 154;
    public static final int KEY_ADLM = 155;
    public static final int KEY_NAME = 156;
    public static final int KEY_HWREV = 157;
    public static final int KEY_EVCNT = 158;
    public static final int KEY_RTCLK = 159;
    public static final int KEY_MGTDUMP = 160;
    public static final int KEY_DRVFLG = 161;
    public static final int KEY_DCSBN = 162;
    public static final int KEY_CLKSTAT = 163;
    public static final int KEY_MTOFF = 164;
    public static final int KEY_ENABLE = 165;
    public static final int KEY_SPEEDS = 166;
    public static final int KEY_FPGADSG = 167;
    public static final int KEY_ROUTIOS = 168;
    public static final int KEY_DSGTYPE = 169;
    public static final int KEY_NVME = 170;
    public static final int KEY_NIOP = 171;
    public static final int KEY_NVMS = 172;
    public static final int KEY_NIOS = 173;
    public static final int KEY_VCTL = 174;
    public static final int KEY_NPM = 175;
    public static final int KEY_MTYPE1 = 191;
    public static final int KEY_MTYPE2 = 192;
    public static final int KEY_MREV1 = 193;
    public static final int KEY_MREV2 = 194;
    public static final int KEY_PMTYPE1 = 195;
    public static final int KEY_PMTYPE2 = 196;
    public static final int KEY_PM1CODE = 197;
    public static final int KEY_PM2CODE = 198;
    public static final int KEY_PMINDEX = 199;
    public static final int KEY_PCICLK = 201;
    public static final int KEY_PCIBUS = 202;
    public static final int KEY_PCIBW = 203;
    public static final int KEY_PCIREV = 204;
    public static final int KEY_PFIFO = 205;
    public static final int KEY_AFIFO = 206;
    public static final int KEY_PCINACK = 207;
    public static final int KEY_PCIGEN = 208;
    public static final int KEY_PCILANES = 209;
    public static final int KEY_IPADDR = 401;
    public static final int KEY_IPCONN = 402;
    public static final int KEY_IPDISC = 403;
    public static final int KEY_IPVLAN = 404;
    public static final int KEY_IPSOCK = 405;
    public static final int KEY_PING = 408;
    public static final int KEY_IOC = 4096;
    public static final int KEY_IOCIOM = 4096;
    public static final int KEY_IOCALG = 4112;
    public static final int KEY_IOCRAM = 4128;
    public static final int KEY_MOD = 8192;
    public static final int KEY_APP = 16384;
    public static final int KEY_FLASH = 32768;
    public static final int KEY_CORE = 0x1000000;
    public static final int KEY_MCORE = 0x2000000;
    public static final int KEY_ARGS = 300;
    public static final int KEY_TABLE = 350;
    public static final int KEY_TRACE = 360;
    public static final int KEY_CNAME = 370;
    public static final int KEY_QSTAT = 380;
    public static final int KEY_NULL = -1;
    public static final int QUERY_FPLAN = 1;
    protected static String[] keys;
    public static final int ALG_NULL = 0;
    public static final int ALG_NOOP = 1;
    public static final int ALG_USER = 2;
    public static final int ALG_SWAP = 3;
    public static final int ALG_LUT = 4;
    public static final int ALG_AM = 5;
    public static final int ALG_FM = 6;
    public static final int ALG_PM = 7;
    public static final int ALG_PSK = 8;
    public static final int ALG_QPSK = 9;
    public static final int ALG_TTDM = 10;
    public static final String algList = "NOOP,USER,SWAP,LUT,AM,FM,PM,PSK,QPSK";
    public static final int TCM_OFF = 0;
    public static final int TCM_CPU = 1;
    public static final int TCM_ZTC = 2;
    public static final int TCM_SDN = 3;
    public static final int TCM_SMS = 4;
    public static final int TCM_DTL = 5;
    public static final int TCM_IRB = 6;
    public static final int TCM_SDDS = 7;
    public static final int TCM_ICE = 8;
    public static final int TCM_VRT = 9;
    public static final int TCM_FILE = 10;
    public static final int TCM_STC = 12;
    public static final String tcmodeList = "CPU,ZTC,SDN,SMS,DTL,IRB,SDDS,ICE,VRT,FILE,,STC";
    public static final int TC_OKNC = 2;
    public static final int TC_OK = 1;
    public static final int TC_INACTIVE = -1;
    public static final int TC_BADPARAM = -2;
    public static final int TC_NOBITS = -3;
    public static final int TC_NOBARKER = -4;
    public static final int TC_BCDERR = -5;
    public static final int TC_NAN = -6;
    public static final int TC_NOCLOCK = -7;
    public static final String tcerrList = "InActive,BadParam,NoBits,NoBarker,BCDErr,NAN,NoClock";
    public static final int VCTX_CHX = 0;
    public static final int VCTX_SEC = 1;
    public static final int VCTX_BW = 2;
    public static final int VCTX_IF = 3;
    public static final int VCTX_RF = 4;
    public static final int VCTX_REFL = 7;
    public static final int VCTX_GAIN = 8;
    public static final int VCTX_SR = 10;
    public static final int VCTX_TEMP = 13;
    public static final int VCTX_FMT = 16;
    public static final int VCTX_GPS = 17;
    public static final int VCTX_DSEC = 20;
    public static final int VCTX_HSEC = 21;
    public static final int VCTX_MSEC = 22;
    public static final int VCTX_NOCID = 23;
    public static final int VCTX_XSR = 24;
    public static final int VCTX_XIF = 25;
    public static final int VCTX_XRF = 26;
    public static final int VCTX_XGAIN = 27;
    public static final String vctxList = "OnChx,OnSec,BW,IF,RF,,,REFL,GAIN,,SR,,,TEMP,,,FMT,GPS,,---,dSec,cSec,mSec,NoCID,xSR,xIF,xRF,xGAIN";
    public static final int BUF_MASK = 1;
    public static final int BUF_EXPAND = 2;
    public static final int PKT_RMIF = 0x100000;
    public static final int PKT_ACMD = 0x200000;
    public static final int PKTF_BUS_RD = 1;
    public static final int PKTF_BUS_WR = 2;
    public static final int PKTF_MEM_RD = 3;
    public static final int PKTF_MEM_WR = 4;
    public static final int PKTF_MEM_TEST = 5;
    public static final int PKTF_INIT = 6;
    public static final int PKTF_MODIFY = 7;
    public static final int PKTF_RUN = 8;
    public static final int PKTF_RESET = 9;
    public static final String mcfgXList = "ENA,LEN,TEN,SEN,PLY,COE,MCOE,MCEN,8BIT,1BIT,BIT1,BIT4,LSBX,UOPT,CLKI,MSBI,SGO,TGO,GGO,XGO,DUAL,MUX,VHS,ALT,LP1,LP2,LP3,SP1,IOM1,IOM2,?,?";
    public static final String mcfgYList = "ENA,LEN,TEN,SEN,PLY,COE,MCOE,MCEN,8BIT,1BIT,BIT1,BIT4,LSBX,UOPT,CLKI,MSBI,SGO,TGO,GGO,XGO,IQ,MUX,VHS,ALT,LP1,LP2,FLIP,CLKM,IOM1,IOM2,?,BMUX";
    public static final String routeListMB = "CA2HA,CB2HA,CA2HB,CB2HB,HA2CA,HB2CA,HA2CB,HB2CB,CA2TB,CA2TA,CB2TB,CB2TA,HA2TA,HB2TA,HA2TB,HB2TB,NP2R,HP2R,HA2R,HB2R,CA2R,CB2R,TA2R,TB2R,R2NP,R2HP,R2HA,R2HB,R2CA,R2CB,R2TA,R2TB";
    public static final String routeListMBP = "CA2HA,CB2HA,CA2HB,CB2HB,HA2CA,HB2CA,HA2CB,HB2CB,TA2HA,CA2TA,CB2TB,TB2HB,HA2TA,HB2TA,HA2TB,HB2TB,NP2R,HP2R,HA2R,HB2R,CA2R,CB2R,TA2R,TB2R,R2NP,R2HP,R2HA,R2HB,R2CA,R2CB,R2TA,R2TB";
    public static final String routeListPM = "CA2HA,TA2CA,TB2CB,CB2HB,HA2CA,HB2CA,HA2CB,HB2CB,TA2HA,CA2TA,CB2TB,TB2HB,HA2TA,HB2TA,HA2TB,HB2TB,NP2R,TC2R,HA2R,HB2R,CA2R,CB2R,TA2R,TB2R,R2NP,R2TC,R2HA,R2HB,R2CA,R2CB,R2TA,R2TB";
    public static final String routfList = "TMuxA,TMuxB,TMuxC,TxOut,HPFDP,HXFDP,CXFDP,TXFDP,CA2CB,CB2CA,TA2TB,TB2TA,TX2HX,CX2HX,TX2CX,CXAOB,HXAOB,TXAOB,TA2HX,TB2HX,DIO2P,P2DIO,CXMIX,TXTAG,NIO2M,M2NIO,NV2M,M2NV,NIO2HX,HX2NIO,NV2HX,HX2NV";
    public static final String iostatList = "iPR,iHP,iHA,iHB,iCA,iCB,iTA,iTB,iNIO,iDIO,iHA1,iHB2,iTA1,iTA2,iTB1,iTB2,oPR,oHP,oHA,oHB,oCA,oCB,oTA,oTB,oNIO,oDIO,oHA1,oHB2,oTA1,oTA2,oTB1,oTB2";

    public static boolean load() {
        if (!useNative) {
            try {
                System.loadLibrary("DevIce");
                useNative = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return useNative;
    }

    public static int detect() {
        DevIce.load();
        return DevIce.detect(0);
    }

    public static native int detect(int var0);

    public native int open(String var1, int var2);

    public native int close();

    public native int reset(int var1);

    public native int sniff(int var1);

    public native int test(int var1, int var2);

    public native int spec(DmaMap var1, DmaSpec var2, int var3);

    public native int read(int var1);

    public native int write(int var1, int var2);

    public native int writem(int var1, int var2, int var3);

    public native int name2offset(String var1, int var2);

    public native int name2key(String var1);

    public native int sendrecv(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6, int var7);

    public native int send(int var1, byte[] var2, byte[] var3, int var4, int var5);

    public native int recv(int var1, byte[] var2, byte[] var3, int var4, int var5);

    public native byte getKeyType(int var1);

    public native int getKeySize(int var1);

    public native int setKey(int var1, int var2, byte[] var3, int var4);

    public native int getKey(int var1, int var2, byte[] var3, int var4);

    public native int getKeyV(int var1, int var2);

    public native int getKeyL(int var1, int var2);

    public native int getKeyL(int var1, int var2, int var3);

    public native int setKeyL(int var1, int var2, int var3);

    public native double getKeyD(int var1, int var2);

    public native double getKeyD(int var1, int var2, double var3);

    public native int setKeyD(int var1, int var2, double var3);

    public native int getIntFlagDef(String var1, int var2);

    public native double getDblFlagDef(String var1, double var2);

    public native int getRawFlag(String var1, byte[] var2, int var3);

    public native int wpm(int var1, int var2, int var3);

    public native int rpm(int var1, int var2);

    public native int wpb(int var1, int var2, int var3);

    public native int rpb(int var1, int var2);

    public native int wpc(int var1, int var2, int var3, int var4);

    public native int rpc(int var1, int var2, int var3);

    public native int ioPort(int var1, int var2, int var3, int var4, int var5, int var6, double var7, int var9, int var10, int var11);

    public native int mapMem(DmaMap var1, int var2, int var3);

    public native int dmaSetup(int var1, int var2, DmaMap var3, int var4, int var5);

    public native int dmaChain(int var1, int var2, DmaMap var3, int var4, int var5);

    public native int dmaFunc(int var1, int var2);

    public native long dmaFuncX(int var1, int var2);

    public native int dmaStat(int var1, DmaStat var2);

    public native int dmaDump(int var1, int var2);

    public native int loadFile(String var1, int var2);

    public native int loadFC(int var1, byte[] var2, int var3, int var4);

    public native int timer(int var1, int var2);

    public native int nvRam(String var1, int var2);

    public native int tc(int var1, double var2, double var4, TimeCode var6, int var7);

    public native int tcInsert(DmaMap var1, TimeCode var2, int var3);

    public native int buffer(DmaMap var1, int var2, byte[] var3, int var4, int var5);

    public native int str2ip(String var1);

    public native int setMapData(long var1, int var3, byte[] var4, int var5, int var6);

    public native int getMapData(long var1, int var3, byte[] var4, int var5, int var6);

    public native int compress(byte[] var1, int var2, byte[] var3, int var4, int var5);

    public native int cvt12(long var1, byte[] var3, int var4, int var5);

    public native int query(int var1, int var2, byte[] var3, int var4);

    public DmaMap mapMem(int psize) {
        DmaMap map = new DmaMap();
        map.mode = 1;
        map.bytes = this.phys2long(psize);
        if (this.mapMem(map, psize, 1) < 0) {
            return null;
        }
        map.dev = this;
        return map;
    }

    public DmaMap getMap() {
        return new DmaMap();
    }

    public void setMaxAlloc(long maxalloc) {
        this.MAXALLOC = maxalloc;
    }

    protected int long2phys(long l) {
        l = l >> 32 != 0L ? l >> 5 & 0xFFFFFFFFFFFFFFFEL | 1L : (l &= 0xFFFFFFFFFFFFFFFCL);
        return (int)l;
    }

    protected long phys2long(int i) {
        long l = i;
        l = (i & 1) != 0 ? (l & 0xFFFFFFFFFFFFFFFEL) << 5 : ((i & 0x10) != 0 ? (l & 0xFFFFFFFFFFFFFFFCL) << 10 : (l & 0xFFFFFFFFFFFFFFFCL) << 0);
        return l;
    }

    protected int int2phys(int i) {
        return i &= 0xFFFFFFFC;
    }

    protected int phys2int(int i) {
        if ((i & 1) != 0) {
            i = -1;
        }
        return i;
    }

    protected int phys2word(int i) {
        i = (i & 1) != 0 ? i << 3 & 0xFFFFFFF0 : ((i & 0x10) != 0 ? i << 8 & 0xFFFFFC00 : i >> 2 & 0x3FFFFFFF);
        return i;
    }

    protected int word2phys(int i) {
        i = (i & 0xC0000000) != 0 ? i >> 3 & 0x1FFFFFFE | 1 : (i <<= 2);
        return i;
    }

    protected int phys2page(int i) {
        i = (i & 1) != 0 ? i << 5 & 0xFFFFFFC0 : ((i & 0x10) != 0 ? i << 0 & 0xFFFFFFFC : i >> 10 & 0x3FFFFC);
        i = (i & 1) != 0 ? i << 8 & 0xFFFFFE00 : i >> 8 & 0xFFFFFF;
        return i;
    }

    protected int page2phys(int i) {
        i = (i & 0xFFC00000) != 0 ? i & 0xFFFFFFFC | 0x10 : (i <<= 10);
        return i;
    }

    protected int long2word(long l) {
        l = l >> 2 & 0xFFFFFFFFFFFFFFFFL;
        return (int)l;
    }

    protected long word2long(int i) {
        long l = i;
        l = (l & 0xFFFFFFFFFFFFFFFFL) << 2;
        return l;
    }

    public void unpack12xxx(byte[] buf, int bytes) {
        int nin;
        int nout = bytes / 4;
        int i = nin = nout * 3;
        int j = nout;
        while (i > 0) {
            buf[(j -= 4) + 0] = (byte)(buf[(i -= 3) + 0] << 4);
            buf[j + 1] = (byte)(buf[i + 0] << 4 | buf[i + 1] >> 4 & 0xF);
            buf[j + 2] = (byte)(buf[i + 1] & 0xF0);
            buf[j + 3] = buf[i + 2];
        }
    }

    public String getStrFlagDef(String flagname, String def) {
        int len = 128;
        byte[] buf = new byte[len];
        int ls = this.getRawFlag(flagname, buf, len);
        if (ls <= 0) {
            return def;
        }
        return new String(buf, 0, ls);
    }

    public String getKeyS(int dmac, int key, int len) {
        int ls;
        byte[] buf = new byte[len];
        for (ls = this.getKey(dmac, key, buf, len); ls > 0 && buf[ls - 1] < 32; --ls) {
        }
        if (ls <= 0) {
            return null;
        }
        return new String(buf, 0, ls);
    }

    public int setKeyS(int dmac, int key, String string) {
        int len = string.length();
        string = string + "0";
        byte[] buf = string.getBytes();
        buf[len] = 0;
        return this.setKey(dmac, key, buf, len + 1);
    }

    static {
        cardList = "ICEPIC1,ICEPIC2,ICEPIC3,ICEPIC4,ICEPIC5,ICEPIC6,ICEPIC7,ICEPIC8,ICEPIC9";
        ioptList = "STREAM,LINK,MODULE,TUNER,INTERNAL,EXTERNAL,CORE,MCORE,TBANK,CBANK";
        imtList = "E2D,LV2D,A2D,CXD,T2D,UXD,VXD,DR2D,PSE2D,FPDPXD,FPQCXD,UDPXD,SNTXD,SDDSXD,GXD,NFXD,CDR2D,LB2D,FLZRXD,RFXD,MSASXD,DSFPXD,SFPXD,SFPPXD,ES2D,TGSDDSXD,AWG2D,UFLZXD,GPS,DIODEI,TGVXD,RF2D";
        omtList = "D2E,D2LV,D2A,DXC,D2T,DXU,DXV,D2DR,D2PSE,DXFPDP,DXFPQC,DXUDP,DXSNT,DXSDDS,DXG,DXNF,D2CDR,D2LB,DXFLZR,DXRF,DXMSAS,DXDSFP,DXSFP,DXSFPP,DXD2SE,TGSDDSXD,D2AWG,DXUFLZ,GPS,DIODE,DXTGV,D2RF";
        pmList = "DTDM,DTDMX,ZPPM,S6M,V5M,V6M,V7M,K8M";
        keys = new String[]{"ACTIVE", "CTYPE", "VERSION", "RATE", "FREQ", "DEC", "GAIN"};
    }

    public class IoPort {
        public int type;
        public int index;
        public int dmac;
        public int dir;
        public int flags;
        public int pad;
        public double rate;
        public double fcny;
        public double dec;
        public double gain;
    }

    public static class TimeCode {
        public double offset;
        public double delta;
        public double wsec;
        public double fsec;

        public double getSeconds() {
            return this.wsec + this.fsec;
        }

        public void update(TimeCode tc) {
            this.offset = tc.offset;
            this.delta = tc.delta;
            this.wsec = tc.wsec;
            this.fsec = tc.fsec;
        }

        public void computeMetrics(TimeCode tc, double defDelta) {
            double tdiff = this.diff(tc);
            double sdiff = this.offset - tc.offset;
            if (tc.offset >= 0.0 && tdiff > 0.0 && sdiff > 0.0) {
                this.delta = tdiff / sdiff;
            }
        }

        public double diff(TimeCode tc) {
            double diff = this.wsec - tc.wsec;
            return diff += this.fsec - tc.fsec;
        }

        public double err(TimeCode tc) {
            double diff = this.diff(tc);
            return diff -= (this.offset - tc.offset) * this.delta;
        }

        public void initMetrics() {
            this.offset = -1.0;
            this.delta = -1.0;
            this.wsec = 0.0;
            this.fsec = 0.0;
        }

        public String toString() {
            return "TC Offset=" + this.offset + " WSec=" + this.wsec + " FSec=" + this.fsec + " Delta=" + this.delta;
        }
    }

    public static class DmaSpec {
        public int block;
        public int total;
        public int sjump;
        public int bjump;
        public float srate;
        public float brate;

        public String toString() {
            return "Spec Total=" + this.total + " SRate=" + this.srate + " BRate=" + this.brate;
        }
    }

    public class DmaMap {
        public static final long PGSZ = 8192L;
        public static final long PGMSK = 8191L;
        public static final int MEM = 1;
        public static final int RAMD = 2;
        public static final int DISK = 3;
        public static final int COPY = 4;
        public static final int NOCHK = 10;
        public long vaddr = 0L;
        public long paddr = 0L;
        public long offset = 0L;
        public long bytes = 0L;
        public long vbytes = 0L;
        public int mode = 0;
        public boolean paged;
        public byte[] buf;
        public String devn;
        protected DevIce dev;

        public void close() {
            this.close(0);
        }

        public void close(int flag) {
            int psize = DevIce.this.long2phys(this.bytes);
            if (this.mode == 2) {
                if (this.vbytes > 0L) {
                    this.dev.mapMem(this, 0, this.paged ? -4 : -3);
                    this.vbytes = 0L;
                }
                if (flag != 10) {
                    this.dev.mapMem(this, 0, 0);
                }
            } else {
                this.dev.mapMem(this, psize, -1);
            }
        }

        public String toString() {
            return "DmaMap bytes=" + this.bytes + " paddr=" + this.paddr + " vaddr=" + this.vaddr;
        }

        public void setBufferSize(int bytes) {
            this.buf = new byte[bytes];
        }

        public int setBuffer(int moff, int bytes) {
            long addr = this.getVirtualAddress(moff, bytes);
            return this.dev.setMapData(addr, 0, this.buf, 0, bytes);
        }

        public int getBuffer(int moff, int bytes) {
            long addr = this.getVirtualAddress(moff, bytes);
            return this.dev.getMapData(addr, 0, this.buf, 0, bytes);
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public DmaMap getSubMap(int chan, int multi) {
            DmaMap map = new DmaMap();
            if (multi <= 0) {
                multi = 1;
            }
            map.bytes = this.bytes / (long)multi;
            map.paddr = this.paddr;
            map.vaddr = this.vaddr;
            map.offset = map.bytes * (long)chan;
            map.dev = this.dev;
            map.devn = this.devn;
            map.paged = this.paged;
            map.mode = this.mode;
            return map;
        }

        public void copyTo(DmaMap map) {
            map.dev = this.dev;
            map.mode = this.mode;
            map.paddr = this.paddr;
            map.vaddr = this.vaddr;
            map.bytes = this.bytes;
            map.offset = this.offset;
            map.vbytes = this.vbytes;
        }

        public long getVirtualAddress(long off, long len) {
            if (this.vbytes == this.bytes) {
                return this.vaddr + off;
            }
            if (off < this.offset || off + len > this.offset + this.vbytes) {
                if (this.paged) {
                    if (this.vbytes > 0L) {
                        this.dev.mapMem(this, 0, -4);
                    }
                    this.offset = off & (DevIce.this.MAXALLOC - 1L ^ 0xFFFFFFFFFFFFFFFFL);
                    this.vbytes = Math.min(DevIce.this.MAXALLOC + len, this.bytes - this.offset) + 8191L & 0xFFFFFFFFFFFFE000L;
                    this.dev.mapMem(this, 0, 4);
                } else {
                    this.vbytes = this.bytes;
                    this.dev.mapMem(this, 0, 3);
                }
            }
            return this.vaddr + (off - this.offset);
        }

        public void setPaged(boolean onoff) {
            this.paged = onoff;
        }
    }

    public static class DmaStat {
        public int index;
        public int cycle;
    }
}

