/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.sys.lib.Data;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;

public class CoreNative
extends Core {
    protected long handle;
    protected String config;
    public static boolean useNative = false;

    public native long alloc();

    public native int config(long var1, int var3, int var4);

    public native int init(long var1);

    public native int setkey(long var1, String var3, char var4, byte[] var5, int var6, int var7);

    public native int getkey(long var1, String var3, char var4, byte[] var5, int var6, int var7);

    public native int work(long var1, long var3, long var5, long var7, long var9);

    public native int free(long var1);

    public native int sysrd(long var1, int var3);

    public native int syswr(long var1, int var3, int var4);

    public static synchronized native int open(long var0);

    public static synchronized native int poll(long var0);

    public static synchronized native int upload(long var0);

    public static native long newStream(int var0, int var1, int var2);

    public static native void freeStream(long var0);

    public static native long loadStreamBuffer(long var0);

    public static native int loadStreamAvail(long var0);

    public static native int loadStreamStatus(long var0, int var2);

    public static native long unloadStreamBuffer(long var0);

    public static native int unloadStreamAvail(long var0);

    public static native int unloadStreamStatus(long var0, int var2);

    public static native int xgetL(long var0, int var2);

    public static native void xwrL(long var0, int var2);

    public static native void fp2fptx(long var0, int var2);

    public static native void fptx2fp(long var0, int var2);

    public CoreNative() {
        useNative |= CoreNative.loadNative("nxm.ice.lib.CoreNative");
        CoreNative.loadNative(this.getClass().getName());
    }

    private static boolean loadNative(String libName) {
        boolean ok = Shell.loadLibrary((String)libName);
        if (!ok) {
            throw new MidasException("Problem with load of native library: " + libName);
        }
        return ok;
    }

    @Override
    public int setFormats(String fmt1, String fmt2) {
        return this.config(this.handle, 1, CoreNative.getFormats(fmt1, fmt2));
    }

    @Override
    public int setMCID(int index) {
        return this.config(this.handle, 6, index);
    }

    @Override
    public int setTraceMode(int mode) {
        return this.config(this.handle, 4, mode << 24);
    }

    @Override
    public int getTraceData(int addr) {
        return this.sysrd(this.handle, 4092);
    }

    @Override
    public void allocNative(String config) {
        this.config = config;
        this.handle = this.alloc();
        if (this.handle == 0L) {
            throw new MidasException("Problem with alloc of native config=" + config);
        }
        this.config(this.handle, 3, this.halo.impl);
        this.config(this.handle, 2, this.halo.flow);
        this.config(this.handle, 4, this.halo.flgs);
        this.config(this.handle, 6, this.halo.mcid);
        this.config(this.handle, 7, this.halo.vbpr);
        this.init(this.handle);
    }

    @Override
    public synchronized int set(String key, Data value) {
        int len;
        char ctype = (char)value.type;
        if (ctype == 'A') {
            ctype = 'S';
        }
        if ((len = this.setkey(this.handle, key, ctype, value.buf, 0, value.size * value.bpe)) >= 0) {
            return len;
        }
        return super.set(key, value);
    }

    @Override
    public synchronized Data get(String key, byte type) {
        byte[] buffer = new byte[256];
        char ctype = (char)type;
        if (key.length() > 2 && key.charAt(1) == ':') {
            ctype = key.charAt(0);
            key = key.substring(2);
        }
        int len = this.getkey(this.handle, key, ctype, buffer, 0, buffer.length);
        if (type == 83) {
            type = (byte)65;
            while (len % 8 != 0) {
                buffer[len++] = 0;
            }
        }
        if (len > 0) {
            return new Data(buffer, 0, len, (int)type, 1);
        }
        return super.get(key, type);
    }

    @Override
    public synchronized int get(String key, Data data) {
        char ctype = (char)data.type;
        if (key.length() > 2 && key.charAt(1) == ':') {
            ctype = key.charAt(0);
            key = key.substring(2);
        }
        int len = this.getkey(this.handle, key, ctype, data.buf, 0, data.buf.length);
        if (data.type == 65) {
            while (len % 8 != 0) {
                data.buf[len++] = 0;
            }
        }
        if (len > 0) {
            return len;
        }
        return super.get(key, data);
    }

    @Override
    public synchronized int get(String key, Data data, int off, int len) {
        char ctype = (char)data.type;
        if (key.length() > 2 && key.charAt(1) == ':') {
            ctype = key.charAt(0);
            key = key.substring(2);
        }
        len = this.getkey(this.handle, key, ctype, data.buf, off, len);
        if (data.type == 65) {
            while (len % 8 != 0) {
                data.buf[len++] = 0;
            }
        }
        return len;
    }

    @Override
    public int open() {
        return CoreNative.open(this.handle);
    }

    public synchronized int process(CoreComponent.Stream so) {
        return this.work(this.handle, 0L, 0L, so.handle, 0L);
    }

    @Override
    public synchronized int process(CoreComponent.Stream si, CoreComponent.Stream so) {
        return this.work(this.handle, si.handle, 0L, so.handle, 0L);
    }

    @Override
    public synchronized int process(CoreComponent.Buffer bi, CoreComponent.Buffer bo) {
        return this.work(this.handle, bi.handle, 0L, bo.handle, 0L);
    }

    @Override
    public synchronized int process(CoreComponent.Buffer bi, CoreComponent.Stream so) {
        return this.work(this.handle, bi.handle, 0L, so.handle, 0L);
    }

    @Override
    public synchronized int process(CoreComponent.Buffer bi, CoreComponent.Stream sip, CoreComponent.Stream so, CoreComponent.Stream sop) {
        return this.work(this.handle, bi.handle, sip.handle, so.handle, sop.handle);
    }

    @Override
    public int poll() {
        return CoreNative.poll(this.handle);
    }

    @Override
    public int close() {
        return this.free(this.handle);
    }
}

