/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.Core;
import nxm.ice.lib.MDevIce;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;

public class CoreFactory {
    public static final String factoryList = "JVM,CPU,PHI,GPU,MLS,VHS,ICE";
    public static final int JVM = 0;
    public static final int CPU = 1;
    public static final int PHI = 2;
    public static final int GPU = 3;
    public static final int MLS = 4;
    public static final int VHS = 5;
    public static final int ICE = 6;
    public static final int CORE_TYPE_FPGA = 5;
    public static final int CORE_TYPE_ICE = 6;
    public static final int VERBOSE = 0;
    public static final int ARRAY = 0;
    public static final int STREAM = 1;
    public static final int BUFFER = 2;
    public static final int BUFSTR = 3;
    public static final int PACKET = 4;
    public static final int FRAW = 0;
    public static final int FCXI = 8;
    public static final int FBIT = 2;
    public static final int FAXI = 3;
    public static final int FALL = 4;
    public static final int FSWP = 5;
    public static final int BCIO = 0;
    public static final int BCI = 1;
    public static final int BCO = 2;
    public static final int BCIIO = 3;
    public static final int BCIOO = 4;
    public static final int BCIIOO = 5;
    public static final int BC_IO = 0;
    public static final int BC_I = 1;
    public static final int BC_O = 2;
    public static final int BC_IIO = 3;
    public static final int BC_IOO = 4;
    public static final int BC_IIOO = 5;
    public static final int BF_RAW = 0;
    public static final int BF_CXI = 8;
    public static final int BF_BIT = 2;
    public static final int BF_AXI = 3;
    public static final int BF_ALL = 4;
    public static String defKeys = null;

    public static Core getCore(String name, Args args) {
        String config = null;
        String cflags = null;
        String opt = args.option;
        int i = name.indexOf(";");
        if (i > 0) {
            opt = name.substring(i + 1);
            name = name.substring(0, i);
        }
        opt = args.getS("/COREOPT", opt);
        String path = "nxm." + opt.toLowerCase() + ".core";
        int impl = 6;
        int coreio = 1;
        if (args.getS("/CORE").equals("ICEX")) {
            coreio = 0;
        } else {
            impl = args.getSelectionIndex("/CORE", factoryList, 0, -1);
        }
        if (impl == 5) {
            config = "VHS-CORE,NOLOCK,IOM=NONE,PM=NONE,";
        }
        if (impl == 6) {
            String alias = args.getS("/COREDEV", "PIC1AUTO:11");
            int ib = alias.indexOf(124);
            int ic = alias.indexOf(58);
            if (ib > 0) {
                cflags = alias.substring(ib);
                alias = alias.substring(0, ib);
            }
            int cindex = 11;
            if (ic > 0) {
                cindex = 0;
                String cport = alias.substring(ic + 1);
                if (cport.startsWith("PM")) {
                    cindex = Convert.s2l((String)cport.substring(2, 3)) * 10;
                    cport = cport.substring(3);
                }
                if (cport.startsWith("CORE")) {
                    cport = cport.substring(4);
                }
                if ((cindex += Convert.s2l((String)cport)) < 0) {
                    cindex = 40 - cindex;
                }
                alias = alias.substring(0, ic);
            }
            int pmi = cindex / 10;
            int ci = cindex % 10;
            int side = (ci + 1) % 2 + 1;
            config = MDevIce.getConfig(args, alias);
            if (config.indexOf(",IPORT=") < 0) {
                config = config + ",IPORT=PM0CORE" + side;
            }
            if (config.indexOf(",OPORT=") < 0) {
                config = config + ",OPORT=PM" + pmi + "CORE" + ci;
            }
            config = config + ",COREIO=" + coreio;
            if (cflags != null) {
                config = config + cflags;
            }
        }
        if ((cflags = args.getS("/COREFLG")) != null) {
            config = config + "," + cflags + ",";
        }
        Core core = CoreFactory.getCore(path, name, impl);
        core.halo.mcid = args.getL("/MCID", -1);
        core.halo.vbpr = args.getL("/COREVB", 0);
        if (core != null && args.getState("/XAB")) {
            core.halo.flgs |= 8;
        }
        if (core != null && args.getState("/XIO")) {
            core.halo.flgs |= 0x10;
        }
        if (impl > 0) {
            core.allocNative(config);
        } else {
            core.init();
        }
        return core;
    }

    public static Core getCore(String path, String name, int impl) {
        String cname = path + "." + name + "$" + Parser.get((String)factoryList, (int)impl, (int)-1);
        Core core = (Core)Shell.getInstanceForClassName((String)cname);
        core.name = name;
        core.halo.impl = impl;
        return core;
    }

    public static byte getDataType(int impl) {
        if (impl == 5) {
            return 73;
        }
        if (impl == 6) {
            return 73;
        }
        return 70;
    }

    public static class TypeDef {
    }
}

