/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreNative;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;

public class CoreComponent
extends CoreCommon {
    public short V2s(Value v) {
        return v.getI(0);
    }

    public int V2i(Value v) {
        return v.getL(0);
    }

    public float V2f(Value v) {
        return v.getF(0);
    }

    public double V2d(Value v) {
        return v.getD(0);
    }

    public int process(Stream si, Stream so) {
        return -1;
    }

    public static class Viterbi {
        public static final String handleArgs = "noinit,i:load,i:uint8:bi,i:uint4:pflg,i:uint8:vflg,o:uint4:bo";
        public static final String handleAuto = "process=iii";
        public static final String handleMethod_process = "$load==T,$bi==%1,$pflg==%2,$vflg==%3,x=0,%0=$bo,o=1";

        public int process(int bi, int pflg, int vflg) {
            return 8 | bi;
        }
    }

    public static class DelayLine {
        double[] dar;
        float[] far;
        float[] fai;
        int n;

        public DelayLine(int size) {
            this.n = size;
            this.dar = new double[this.n + 1];
            this.far = new float[this.n + 1];
            this.fai = new float[this.n + 1];
            System.out.println("New DelayLine size=" + this.n);
        }

        public double loadD(double d) {
            for (int i = 0; i < this.n; ++i) {
                this.dar[i] = this.dar[i + 1];
            }
            this.dar[this.n] = d;
            return this.dar[0];
        }

        public float loadF(float f) {
            for (int i = 0; i < this.n; ++i) {
                this.far[i] = this.far[i + 1];
            }
            this.far[this.n] = f;
            return this.far[0];
        }
    }

    public static class CxRamBuf {
        int N;
        int n;
        int rdOnly;
        DataFile df;
        public float[] datax;
        public float[] datay;
        public static final String handleArgs = "sets,noinit,i:wen[#3],i:#1:wadr[#3],i:CxFptx:wbus[#2],i:ren[#3],i:#1:radr[#3],o:CxFptx:rbus[#3],i:rdonly";
        public static final String handleAuto = "set=ii,get=io,setxy=iii,setRdOnly=i,setLength=i";
        public static final String handleMethod_set = "$wen[IX]==T,$wadr[IX]==%1,$wbus[IX]==%2";
        public static final String handleMethod_get = "$ren[IX]==T,$radr[IX]==%1,x=0,%2=$rbus[IX],o=1";
        public static final String handleMethod_setRdOnly = "x=0,$rdonly==%1";

        public CxRamBuf(int ord, int iw, int ow) {
            this.N = 1 << ord;
            this.datax = new float[this.N];
            this.datay = new float[this.N];
        }

        public void setLength(int len) {
            this.n = CoreCommon.imin(len, this.N);
            if (len > this.N) {
                System.out.println("RamBuffer limited from " + len + " to " + this.n + " taps");
            }
        }

        public void setRdOnly(int ro) {
            this.rdOnly = ro;
        }

        public void get(int i, CoreCommon.CxFloat cf) {
            cf.x = this.datax[i];
            cf.y = this.datay[i];
        }

        public void set(int i, CoreCommon.CxFloat cf) {
            if ((this.rdOnly & 1) == 0) {
                this.datax[i] = cf.x;
            }
            if ((this.rdOnly & 2) == 0) {
                this.datay[i] = cf.y;
            }
        }

        public void setxy(int i, float x, float y) {
            if ((this.rdOnly & 1) == 0) {
                this.datax[i] = x;
            }
            if ((this.rdOnly & 2) == 0) {
                this.datay[i] = y;
            }
        }

        public void print() {
            float sumx = 0.0f;
            float sumy = 0.0f;
            System.out.print("Taps ");
            for (int i = 0; i < this.n; ++i) {
                System.out.printf("(%7.3f,%6.3f) ", Float.valueOf(this.datax[i]), Float.valueOf(this.datay[i]));
                sumx += this.datax[i];
                sumy += this.datay[i];
            }
            System.out.printf(" [%d] (%7.3f,%6.3f)\n", this.n, Float.valueOf(sumx), Float.valueOf(sumy));
        }

        public void getSum(CoreCommon.CxFloat v) {
            float sumx = 0.0f;
            float sumy = 0.0f;
            for (int i = 0; i < this.n; ++i) {
                sumx += this.datax[i];
                sumy += this.datay[i];
            }
            v.x = sumx;
            v.y = sumy;
        }

        public void dump(String fname) {
            if (this.df == null) {
                this.df = new DataFile(null, (Object)fname, "1000", "CF", 0, 128.0, null);
                this.df.setFS(this.n);
                this.df.setXUnits(1);
                this.df.setYUnits(1);
                this.df.open(2);
            }
            byte[] buffer = new byte[8];
            for (int i = 0; i < this.n; ++i) {
                Convert.packF((byte[])buffer, (int)0, (float)this.datax[i]);
                Convert.packF((byte[])buffer, (int)4, (float)this.datay[i]);
                this.df.write(buffer, 0, 8);
            }
            this.df.flush();
        }

        public String toString() {
            return "RamBufCF N=" + this.N;
        }
    }

    public static class RamBuf {
        int N;
        int n;
        boolean rdOnly;
        public float[] data;
        public static final String handleArgs = "sets,noinit,i:wen[#3],i:#1:wadr[#3],i:fptx:wbus[#2],i:ren[#3],i:#1:radr[#3],o:fptx:rbus[#3],i:rdonly";
        public static final String handleAuto = "set=ii,get=i";
        public static final String handleMethod_set = "$wen[IX]==T,$wadr[IX]==%1,wbus[IX]==%2";
        public static final String handleMethod_get = "$ren[IX]==T,$radr[IX]==%1,x=0,%0=$rbus[IX],o=1";
        public static final String handleMethod_setRdOnly = "x=0,$rdonly=%1";

        public RamBuf(int ord, int iw, int ow) {
            this.N = 1 << ord;
            this.data = new float[this.N];
        }

        public void setLength(int len) {
            this.n = CoreCommon.imin(len, this.N);
            if (len > this.N) {
                System.out.println("RamBuffer limited from " + len + " to " + this.n + " taps");
            }
        }

        public void setRdOnly(boolean ro) {
            this.rdOnly = ro;
        }

        public void set(int i, float x) {
            if (this.rdOnly) {
                return;
            }
            this.data[i] = x;
        }

        public float get(int i) {
            return this.data[i];
        }

        public String toString() {
            return "RamBuf N=" + this.N;
        }
    }

    public static class StatBuf {
        int N;
        int n;
        int m;
        public float[] data;
        public static final String handleArgs = "sets,noinit,i:load,i:fptx:vbus,i:intx:mode,i:domid,o:fptx:omid,i:domin,i:dominm,o:fptx:omin,i:domax,i:domaxm,o:fptx:omax,i:domini,o:intx:omini";
        public static final String handleAuto = "load=i,getMid=,getMin=,getMax=,getMinM=i,getMaxM=i,getMinI=i";
        public static final String handleMethod_load = "$load==T,$vbus==%1,o=1";
        public static final String handleMethod_getMid = "$domid==T,x=0,%0=$omid,o=1";
        public static final String handleMethod_getMin = "$domin==T,x=0,%0=$omin,o=4";
        public static final String handleMethod_getMax = "$domax==T,x=0,%0=$omax,o=4";
        public static final String handleMethod_getMinM = "$dominm==T,$mode=%1,x=0,%0=$omin,o=4";
        public static final String handleMethod_getMaxM = "$domaxm==T,$mode=%1,x=0,%0=$omax,o=4";
        public static final String handleMethod_getMinI = "$domini==T,$mode=%1,x=0,%0=$omini,o=4";

        public StatBuf(int ord) {
            this.n = this.N = 1 << ord;
            this.data = new float[this.N];
        }

        public void setLength(int len) {
            this.n = CoreCommon.imin(len, this.N);
            this.m = this.n >> 1;
            if (len > this.N) {
                System.out.println("Vector limited from " + len + " to " + this.n + " taps");
            }
        }

        public void load(float v) {
            for (int i = this.n - 1; i > 0; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[0] = v;
        }

        public float getMid() {
            return this.data[this.m];
        }

        public float getMin() {
            float v = this.data[0];
            for (int i = 1; i < this.n; ++i) {
                if (!(this.data[i] < v)) continue;
                v = this.data[i];
            }
            return v;
        }

        public float getMax() {
            float v = this.data[0];
            for (int i = 1; i < this.n; ++i) {
                if (!(this.data[i] > v)) continue;
                v = this.data[i];
            }
            return v;
        }

        public float getMinM(int mode) {
            if (mode > 0) {
                return this.getMinFilt(1, this.m);
            }
            if (mode < 0) {
                return this.getMinFilt(this.m, this.n - 1);
            }
            return CoreCommon.fmaxf(this.getMinFilt(1, this.m), this.getMinFilt(this.m, this.n - 1));
        }

        public float getMaxM(int mode) {
            if (mode > 0) {
                return this.getMaxFilt(1, this.m);
            }
            if (mode < 0) {
                return this.getMaxFilt(this.m, this.n - 1);
            }
            return CoreCommon.fminf(this.getMaxFilt(1, this.m), this.getMaxFilt(this.m, this.n - 1));
        }

        public float getMinFilt(int n1, int n2) {
            float v = 1.0E32f;
            for (int i = n1; i < n2; ++i) {
                float vx = this.data[i];
                if (this.data[i - 1] > vx) {
                    vx = this.data[i - 1];
                }
                if (this.data[i + 1] > vx) {
                    vx = this.data[i + 1];
                }
                if (!(vx < v)) continue;
                v = vx;
            }
            return v;
        }

        public float getMaxFilt(int n1, int n2) {
            float v = -1.0E32f;
            for (int i = n1; i < n2; ++i) {
                float vx = this.data[i];
                if (this.data[i - 1] < vx) {
                    vx = this.data[i - 1];
                }
                if (this.data[i + 1] < vx) {
                    vx = this.data[i + 1];
                }
                if (!(vx > v)) continue;
                v = vx;
            }
            return v;
        }

        public int getMinI(int mode) {
            float v;
            int i = 0;
            int j = this.m;
            float vmin = this.data[j];
            i = 1;
            while (i < this.m - 1 && !((v = this.data[j]) > vmin)) {
                vmin = v;
                ++i;
                j += mode;
            }
            return i;
        }

        public String toString() {
            return "StatBuf N=" + this.N;
        }
    }

    public static class CxTapBuf_NPO
    extends CxTapBuf {
        public static final String handleArgs = "noinit,i:load,i:CxFptx:wbus,i:fptx:fps[#5],i:ren[#5][#3],i:#1:radr[#5][#3],o:CxFptx:rbus[#5][#3]";

        public CxTapBuf_NPO(int ord, int iw, int ow, int dly, int nps) {
            super(ord, iw, ow, dly);
        }
    }

    public static class CxTapBuf_NP2
    extends CxTapBuf {
        public static final String handleArgs = "noinit,i:4:stride,i:load,i:CxFptx:wbus[#5],i:ren[#3],i:#1:radr[#3],o:CxFptx:rbus[#3],o:CxFptx:rbus2[#3]";

        public CxTapBuf_NP2(int ord, int iw, int ow, int dly, int nps) {
            super(ord, iw, ow, dly);
        }
    }

    public static class CxTapBuf_NP
    extends CxTapBuf {
        public static final String handleArgs = "noinit,i:4:stride,i:split,i:load,i:CxFptx:wbus[#5],i:ren[#3],i:#1:radr[#3],o:CxFptx:rbus[#3]";

        public CxTapBuf_NP(int ord, int iw, int ow, int dly, int nps) {
            super(ord, iw, ow, dly);
        }
    }

    public static class CxTapBuf {
        int N;
        int IW;
        int n;
        int NH;
        public float[] datax;
        public float[] datay;
        public static final String handleArgs = "noinit,i:4:stride,i:split,i:load,i:CxFptx:wbus,i:ren[#3],i:#1:radr[#3],o:CxFptx:rbus[#3]";
        public static final String handleAuto = "load=i,loadA=ii,get=io,get2=ioo,get_vs=ioi,getrN_NPO=iioi,set=ii,setxy=iii";
        public static final String handleMethod_load = "$load==T,$wbus==%1";
        public static final String handleMethod_loadA = "$load==T,$wbus==%1";
        public static final String handleMethod_get = "$stride==#2,$ren[IX]==T,$radr[IX]==%1,x=0,%2=$rbus[IX],o=1";
        public static final String handleMethod_get2 = "$stride==#2,$ren[IX]==T,$radr[IX]==%1,x=0,%2=$rbus[IX],%3=$rbus2[IX],o=1";
        public static final String handleMethod_get_vs = "$stride==%3,$ren[IX]==T,$radr[IX]==%1,x=0,%2=$rbus[IX],o=1";
        public static final String handleMethod_getrN_NPO = "$ren[%4][IX]==T,$radr[%4][IX]==%2,$fps[%4]==%1,x=0,%3=$rbus[%4][IX],o=1";

        public CxTapBuf(int ord, int iw, int ow, int dly) {
            this.N = 1 << ord;
            this.NH = this.N >> 1;
            this.IW = iw;
            this.n = this.N + this.IW;
            this.datax = new float[this.n];
            this.datay = new float[this.n];
        }

        public void setLength(int len) {
            this.n = CoreCommon.imin(len, this.N);
            if (len > this.N) {
                System.out.println("CxTapBuffer limited from " + len + " to " + this.n + " taps");
            }
            this.n += this.IW;
        }

        public void setStride(int len) {
            if (len > this.N) {
                System.out.println("CxTapBuffer stride limited from " + len + " to " + this.N + " taps");
            }
        }

        public void load(CoreCommon.CxFloat v) {
            for (int i = this.n - 1; i > 0; --i) {
                this.datax[i] = this.datax[i - 1];
                this.datay[i] = this.datay[i - 1];
            }
            this.datax[0] = v.x;
            this.datay[0] = v.y;
        }

        public void loadA(CoreCommon.CxFloat[] v, int nv) {
            int i;
            for (i = this.n - 1; i >= nv; --i) {
                this.datax[i] = this.datax[i - nv];
                this.datay[i] = this.datay[i - nv];
            }
            i = nv - 1;
            int j = 0;
            while (i >= 0) {
                this.datax[i] = v[j].x;
                this.datay[i] = v[j].y;
                --i;
                ++j;
            }
        }

        public void get(int i, CoreCommon.CxFloat cf) {
            cf.x = this.datax[i];
            cf.y = this.datay[i];
        }

        public void get2(int i, CoreCommon.CxFloat cf, CoreCommon.CxFloat df) {
            cf.x = this.datax[i];
            cf.y = this.datay[i];
            df.x = this.datax[i + 1];
            df.y = this.datay[i + 1];
        }

        public void getrN(float ifps, int i, CoreCommon.CxFloat cf) {
            int off = (int)ifps;
            if (i > 0) {
                i -= off;
            }
            cf.x = this.datax[i];
            cf.y = this.datay[i];
        }

        public void set(int i, CoreCommon.CxFloat cf) {
            this.datax[i] = cf.x;
            this.datay[i] = cf.y;
        }

        public void setxy(int i, float x, float y) {
            this.datax[i] = x;
            this.datay[i] = y;
        }

        public void print() {
            float sumx = 0.0f;
            float sumy = 0.0f;
            System.out.print("Taps ");
            for (int i = 0; i < this.n - this.IW; ++i) {
                System.out.printf("(%7.3f,%6.3f) ", Float.valueOf(this.datax[i]), Float.valueOf(this.datay[i]));
                sumx += this.datax[i];
                sumy += this.datay[i];
            }
            System.out.printf(" [%d] (%7.3f,%6.3f)\n", this.n, Float.valueOf(sumx), Float.valueOf(sumy));
        }

        public void getSum(CoreCommon.CxFloat v) {
            float sumx = 0.0f;
            float sumy = 0.0f;
            for (int i = 0; i < this.n - this.IW; ++i) {
                sumx += this.datax[i];
                sumy += this.datay[i];
            }
            v.x = sumx;
            v.y = sumy;
        }

        public String toString() {
            return "TapBufCF N=" + this.N;
        }
    }

    public static class TapBuf {
        int N;
        int IW;
        int n;
        public float[] data;
        public static final String handleArgs = "noinit,i:load,i:fptx:wbus,i:ren[#3],i:#1:radr[#3],o:fptx:rbus[#3]";
        public static final String handleAuto = "load=i,loadA=ii,get=i";
        public static final String handleMethod_load = "$load==T,$wbus==%1";
        public static final String handleMethod_loadA = "$load==T,$wbus==%1";
        public static final String handleMethod_get = "$ren[IX]==T,$radr[IX]==%1,x=0,%0=$rbus[IX],o=1";

        public TapBuf(int ord, int iw, int ow, int dly) {
            this.N = 1 << ord;
            this.IW = iw;
            this.n = this.N + this.IW;
            this.data = new float[this.n];
        }

        public void setLength(int len) {
            this.n = CoreCommon.imin(len, this.N);
            if (len > this.N) {
                System.out.println("TapBuffer limited from " + len + " to " + this.n + " taps");
            }
            this.n += this.IW;
        }

        public void load(float v) {
            for (int i = this.n - 1; i > 0; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[0] = v;
        }

        public void loadA(float[] v, int nv) {
            int i;
            for (i = this.n - 1; i >= nv; --i) {
                this.data[i] = this.data[i - nv];
            }
            i = nv - 1;
            int j = 0;
            while (i >= 0) {
                this.data[i] = v[j];
                --i;
                ++j;
            }
        }

        public float get(int i) {
            return this.data[i];
        }

        public String toString() {
            return "TapBufSF N=" + this.N;
        }
    }

    public static class RomF2Di_CX
    extends RomF2Di {
        public static final String handleArgs = "sets,noinit,i:renr,i:fptx:rNr,i:#1:rN,i:#2:rM[#3],i:cx,o:CxFptx:rbus[#3]";

        public RomF2Di_CX(int oN, int oM, int ow) {
            super(oN, oM, ow);
        }
    }

    public static class RomF2Di_NP
    extends RomF2Di {
        public static final String handleArgs = "sets,noinit,i:renr,i:fptx:rNr[#4],i:#1:rN,i:#2:rM[#3],o:fptx:rbus[#4][#3]";

        public RomF2Di_NP(int oN, int oM, int ow, int nps, int nla) {
            super(oN, oM, ow);
        }
    }

    public static class RomF2Di {
        int N;
        int M;
        int L;
        int MC;
        public float[] data;
        public static final String handleArgs = "sets,noinit,i:renr,i:fptx:rNr,i:#1:rN,i:#2:rM[#3],o:fptx:rbus[#3]";
        public static final String handleAuto = "getrN=ii,getrN_NP=iii,getrNc=iiio,set=iii";
        public static final String handleMethod_getrN = "$renr==T,$rNr==%1,$rM[IX]==%2,x=1,%0==$rbus[IX],o=2";
        public static final String handleMethod_getrN_NP = "$renr==T,$rNr[%3]==%1,$rM[IX]==%2,x=1,%0==$rbus[%3][IX],o=2";
        public static final String handleMethod_getrNc = "$renr==T,$rNr==%1,$rM[IX]==%2,$cx==%3,x=1,%4==$rbus[IX],o=3";

        public RomF2Di(int oN, int oM, int ow) {
            this.N = 1 << oN;
            this.M = 1 << oM;
            this.L = this.N * this.M + 1;
            this.MC = ow / 2;
            this.data = new float[this.L + 1];
        }

        public void clear() {
            for (int i = 0; i < this.L; ++i) {
                this.data[i] = 0.0f;
            }
        }

        public void set(int n, int m, float d) {
            int i = n + m * this.N;
            if (i >= this.L) {
                System.out.println("RomF2D set out of range: N=" + this.N + " M=" + this.M + " n=" + n + " m=" + m);
                return;
            }
            this.data[i] = d;
            if (++i == this.L) {
                this.data[i] = 2.0f * this.data[i - 1] - this.data[i - 2];
            }
        }

        public float getrN(float n, int m) {
            float nN = n * (float)this.N;
            int n0 = (int)nN;
            int mn = n0 + m * this.N;
            if (mn >= this.L) {
                return this.data[this.L];
            }
            float p = nN - (float)n0;
            float d0 = this.data[mn];
            float d1 = this.data[mn + 1];
            return d0 + (d1 - d0) * p;
        }

        public void getrNc(float n, int m, boolean cx, CoreCommon.CxFloat c) {
            c.x = this.getrN(n, m);
            c.y = cx ? this.getrN(n, m + this.MC) : c.x;
        }

        public String toString() {
            return "RomF2Di N=" + this.N + " M=" + this.M;
        }
    }

    public static class RomF2D {
        int N;
        int M;
        int L;
        public float[] data;
        public static final String handleArgs = "sets,noinit,i:ren,i:#1:rN,i:#2:rM[#3],o:fptx:rbus[#3]";
        public static final String handleAuto = "get=ii,set=iii";
        public static final String handleMethod_get = "$ren==T,$rN==%1,$rM[IX]==%2,x=0,%0==$rbus[IX],o=1";

        public RomF2D(int oN, int oM, int ow) {
            this.N = 1 << oN;
            this.M = 1 << oM;
            this.L = this.N * this.M + 4;
            this.data = new float[this.L];
        }

        public void clear() {
            for (int i = 0; i < this.L; ++i) {
                this.data[i] = 0.0f;
            }
        }

        public void set(int n, int m, float d) {
            this.data[n + m * this.N] = d;
        }

        public float get(int n, int m) {
            return this.data[n + m * this.N];
        }

        public String toString() {
            return "RomF2D N=" + this.N + " M=" + this.M;
        }
    }

    public static class RomF {
        int N;
        int M;
        int L;
        public float[] data;
        public static final String handleArgs = "sets,noinit,i:ren,i:#1:rM[#2],o:fptx:rbus[#2]";
        public static final String handleAuto = "get=i,set=ii";
        public static final String handleMethod_get = "$ren==T,$rM[IX]==%1,x=0,%0==$rbus[IX],o=1";

        public RomF(int oM, int RP) {
            this.M = 1 << oM;
            this.L = this.M + 2;
            this.data = new float[this.L];
        }

        public void clear() {
            for (int i = 0; i < this.L; ++i) {
                this.data[i] = 0.0f;
            }
        }

        public void set(int m, float d) {
            this.data[m] = d;
        }

        public float get(int m) {
            return this.data[m];
        }

        public String toString() {
            return "RomF M=" + this.M;
        }
    }

    public static class Dma {
        public static int SWP2 = 1;
        public static int SWP4 = 2;
        public static int C12T16 = 4;
        public static int C16T12 = 8;
        public int flags;
        public static final String handleArgs = "i:start,i:#1:cnt,s:8:flags,o:shrd,o:busy,NL2,i:rok,i:#1:radr,i:#2:rbus,d:32:rdma,NL2,i:wok,i:#1:wadr,o:#2:wbus,o:32:wdma";
        public static final String handleAuto = "r2r=iioii,r2b=iioii,b2r=iioii,b2b=iioii,b2s=iioii,r2s=iioii,addReader=i,sync=,setFlags=i";
        public static final String handleMethod_r2r = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_rdma==$rdma,$rbus=%1_rbus,$wok=%3_wok,%3_wdma=$wdma,%3_wbus=$wbus,a=$busy";
        public static final String handleMethod_r2b = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_rdma==$rdma,$rbus=%1_rbus,$wok=%3_wok,%3_dma=$wdma,%3_bus=$wbus,a=$busy";
        public static final String handleMethod_b2r = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_dma==$rdma,$rbus=%1_bus,$wok=%3_wok,%3_wdma=$wdma,%3_wbus=$wbus,a=$busy";
        public static final String handleMethod_b2b = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_dma==$rdma,$rbus=%1_bus,$wok=%3_wok,%3_dma=$wdma,%3_bus=$wbus,a=$busy";
        public static final String handleMethod_b2s = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_dma==$rdma,$rbus=%1_bus,$wok=%3_wok,%3_wen=$wdma[31],%3_wbus=$wbus,a=$busy";
        public static final String handleMethod_r2s = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_rdma==$rdma,$rbus=%1_rbus,$wok=%3_wok,%3_wen=$wdma[31],%3_wbus=$wbus,a=$busy";
        public static final String handleMethod_addReader = "$shrd==%1_rd";
        public static final String handleMethod_sync = "s=1,a=$busy";
        public static final String handleMethod_setFlags = "$flags=%1";

        public Dma(int AW, int BW) {
        }

        private void ba2ba(byte[] bi, int offi, int leni, byte[] bo, int offo, int leno, int len) {
            boolean swap;
            int maski = leni - 1;
            int masko = leno - 1;
            boolean bl = swap = (this.flags & SWP2) != 0;
            while (len > 0) {
                int ido = len;
                offo &= masko;
                if ((offi &= maski) + ido > leni) {
                    ido = leni - offi;
                }
                if (offo + ido > leno) {
                    ido = leno - offo;
                }
                System.arraycopy(bi, offi, bo, offo, ido);
                if (swap) {
                    Convert.swap2((byte[])bo, (int)offo, (int)(ido >> 1));
                }
                offi += ido;
                offo += ido;
                len -= ido;
            }
        }

        private void ba2bs(byte[] bi, int offi, int leni, byte[] bo, int offo, int leno, int len, Stream so) {
            int maski = leni - 1;
            int masko = leno - 1;
            offi &= maski;
            offo &= masko;
            if ((this.flags & SWP2) != 0) {
                for (int i = 0; i < len; i += 2) {
                    bo[offo] = bi[offi + 1];
                    bo[offo + 1] = bi[offi];
                    offi += 2;
                    offi &= maski;
                    offo += 2;
                    offo &= masko;
                }
            } else if ((this.flags & C16T12) != 0) {
                for (int i = 0; i < len; i += 4) {
                    bo[offo++] = (byte)(bi[offi + 1] << 4 & 0xF0 | bi[offi + 0] >> 4 & 0xF);
                    offo &= masko;
                    bo[offo++] = (byte)(bi[offi + 2] & 0xF0 | bi[offi + 1] >> 4 & 0xF);
                    offo &= masko;
                    bo[offo++] = bi[offi + 3];
                    offo &= masko;
                    offi += 4;
                    offi &= maski;
                }
                len = len / 4 * 3;
            } else if ((this.flags & C12T16) != 0) {
                for (int i = 0; i < len; i += 3) {
                    byte b0 = bi[offi++];
                    offi &= maski;
                    byte b1 = bi[offi++];
                    offi &= maski;
                    byte b2 = bi[offi++];
                    offi &= maski;
                    bo[offo++] = (byte)(b0 << 4);
                    bo[offo++] = (byte)(b1 << 4 & 0xF0 | b0 >> 4 & 0xF);
                    bo[offo++] = (byte)(b1 & 0xF0);
                    bo[offo++] = b2;
                    offo &= masko;
                }
                len = len / 3 * 4;
            } else {
                for (int i = 0; i < len; ++i) {
                    bo[offo++] = bi[offi++];
                    offi &= maski;
                    offo &= masko;
                }
            }
            so.update(len);
        }

        public void r2b(RamRWC ri, int off, Buffer bo, int boff, int len) {
            int xlen = (off &= ri.ML) + len - ri.AL;
            if (xlen > 0) {
                len -= xlen;
            } else {
                xlen = 0;
            }
            System.arraycopy(ri.b, ri.chn << ri.OL | off, bo.b, bo.woff + boff, len);
            if (xlen > 0) {
                System.arraycopy(ri.b, ri.chn << ri.OL, bo.b, bo.woff + boff + len, xlen);
            }
        }

        public void b2r(Buffer bi, int boff, RamRWC ro, int off, int len) {
            int xlen = (off &= ro.ML) + len - ro.AL;
            if (xlen > 0) {
                len -= xlen;
            } else {
                xlen = 0;
            }
            System.arraycopy(bi.b, bi.roff + boff, ro.b, ro.chn << ro.OL | off, len);
            if (xlen > 0) {
                System.arraycopy(bi.b, bi.roff + boff + len, ro.b, ro.chn << ro.OL, xlen);
            }
        }

        public void r2r(RamRWC ri, int offi, RamRWC ro, int offo, int len) {
            this.ba2ba(ri.b, ri.chn << ri.OL | offi, ri.len, ro.b, ro.chn << ro.OL | offo, ro.len, len);
        }

        public void b2b(Buffer bi, int boffi, Buffer bo, int boffo, int len) {
            this.ba2ba(bi.b, bi.roff + boffi, bi.len, bo.b, bo.woff + boffo, bo.len, len);
        }

        public void b2s(Buffer bi, int boffi, Stream so, int soffo, int len) {
            this.ba2bs(bi.b, bi.roff + boffi, bi.len, so.b, so.woff, so.len, len, so);
        }

        public void r2s(RamRWC ri, int offi, Stream so, int soffo, int len) {
            this.ba2ba(ri.b, ri.chn << ri.OL | offi, ri.len, so.b, so.woff, so.len, len);
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        public static void sync() {
        }

        public static void addReader(Object o) {
        }
    }

    public static class RamRWC {
        public byte[] b;
        public int WA;
        public int WB;
        public int OL;
        public int OC;
        private int AL;
        private int AC;
        private int ML;
        private int MC;
        private int chn;
        private int len;
        public static final String handleArgs = "i:wr,c:32:wdma,i:#4:wchn,i:#1:wadr,i:#2:wbus,NL2,i:rd,d:32:rdma,i:#4:rchn,i:#1:radr,o:#3:rbus,o:8:rbusb";
        public static final String handleAuto = "rd=io,wr=ii,rdB=i,wrB=ii,rdF=i,wrF=ii,setC=i";
        public static final String handleMethod_setC = "x=0,$rchn=%1,$wchn=%1";
        public static final String handleMethod_wr = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rd = "$rd=T,$radr=%1,x=2,%2=$rbus,o=3";
        public static final String handleMethod_wrB = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdB = "$rd=T,$radr=%1,x=2,%0=$rbusb,o=3";
        public static final String handleMethod_wrF = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdF = "$rd=T,$radr=%1,x=2,%0=$rbus,o=3";

        public RamRWC(int orderLength, int widthA, int widthB, int orderChannel) {
            this.WA = widthA;
            this.WB = widthB;
            this.OL = orderLength;
            this.AL = 1 << this.OL;
            this.ML = this.AL - 1;
            this.OC = orderChannel;
            this.AC = 1 << this.OC;
            this.MC = this.AC - 1;
            this.len = 1 << this.OL + this.OC;
            this.b = new byte[this.len];
            this.chn = 0;
        }

        public void setC(int chn) {
            this.chn = chn;
        }

        public void rd(int off, Value val) {
            System.arraycopy(this.b, this.chn << this.OL | off, val.buf, 0, val.len);
        }

        public void wr(int off, Value val) {
            System.arraycopy(val.buf, 0, this.b, this.chn << this.OL | off, val.len);
        }

        public byte rdB(int off) {
            return this.b[this.chn << this.OL | (off &= this.ML)];
        }

        public float rdF(int off) {
            return Convert.unpackF((byte[])this.b, (int)(this.chn << this.OL | (off &= this.ML)));
        }

        public void wrB(int off, int val) {
            this.b[this.chn << this.OL | (off &= this.ML)] = (byte)val;
        }

        public void wrF(int off, float val) {
            Convert.packF((byte[])this.b, (int)(this.chn << this.OL | (off &= this.ML)), (float)val);
        }

        public String toString() {
            return "Ram len=" + (1 << this.OL) + " chn=" + (1 << this.OC);
        }
    }

    public static class Ram {
        public byte[] b;
        public int OL;
        public int WA;
        public int WB;
        private int AL;
        private int ML;
        private int len;
        public static final String handleArgs = "i:wr,c:32:wdma,i:#1:wadr,i:#2:wbus,NL2,i:rd,d:32:rdma,i:#1:radr,o:#3:rbus,o:8:rbusb";
        public static final String handleAuto = "rd=io,wr=ii,rdB=i,wrB=ii,rdI=i,wrI=ii,rdL=i,wrL=ii,rdF=i,wrF=ii,wrX=ii";
        public static final String handleMethod_wr = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rd = "$rd=T,$radr=%1,x=2,%2=$rbus,o=3";
        public static final String handleMethod_wrB = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdB = "$rd=T,$radr=%1,x=2,%0=$rbusb,o=3";
        public static final String handleMethod_wrI = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdI = "$rd=T,$radr=%1,x=2,%0=$rbus,o=3";
        public static final String handleMethod_wrL = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdL = "$rd=T,$radr=%1,x=2,%0=$rbus,o=3";
        public static final String handleMethod_wrF = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdF = "$rd=T,$radr=%1,x=2,%0=$rbus,o=3";
        public static final String handleMethod_wrX = "$wr=T,$wadr=%1,$wbus=%2,x=1,$wr=T,$wadr=%1+4,$wbus=%2>>32";

        public Ram(int orderLength, int widthA, int widthB) {
            this.OL = orderLength;
            this.AL = 1 << this.OL;
            this.ML = this.AL - 1;
            this.WA = widthA;
            this.WB = widthB;
            this.len = 1 << this.OL;
            this.b = new byte[this.len];
        }

        public void rd(int off, Value val) {
            System.arraycopy(this.b, off, val.buf, 0, val.len);
        }

        public void wr(int off, Value val) {
            System.arraycopy(val.buf, 0, this.b, off, val.len);
        }

        public byte rdB(int off) {
            return this.b[off &= this.ML];
        }

        public short rdI(int off) {
            return Convert.unpackI((byte[])this.b, (int)(off &= this.ML));
        }

        public int rdL(int off) {
            return Convert.unpackL((byte[])this.b, (int)(off &= this.ML));
        }

        public float rdF(int off) {
            return Convert.unpackF((byte[])this.b, (int)(off &= this.ML));
        }

        public void wrB(int off, int val) {
            this.b[off &= this.ML] = (byte)val;
        }

        public void wrI(int off, short val) {
            Convert.packI((byte[])this.b, (int)(off &= this.ML), (short)val);
        }

        public void wrL(int off, int val) {
            Convert.packL((byte[])this.b, (int)(off &= this.ML), (int)val);
        }

        public void wrF(int off, float val) {
            Convert.packF((byte[])this.b, (int)(off &= this.ML), (float)val);
        }

        public String toString() {
            return "Ram len=" + (1 << this.OL) + " widthA=" + this.WA + " widthB=" + this.WB;
        }
    }

    public static class Queue {
        public int len;
        public int roff;
        public int woff;
        public int bpe;
        public int shft;
        public int mask;
        public int afull;
        public int aempty;
        public boolean wok;
        public boolean rok;
        public byte[] b;
        public static final String handleArgs = "o:wok,i:wen,i:BPW:wbus,o:rok,i:ren,o:BPW:rbus";
        public static final String handleAuto = "rd=o,rdB,rdI,rdL,rdF,rdD,rdCF=o,rok,wr=i,wrB=i,wrI=i,wrL=i,wrF=i,wrD=i,wrCF=i,wok";
        public static final String handleMethod_wr = "x=0,$wen==T,$wbus==%1_rbus";
        public static final String handleMethod_wrB = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_wrI = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_wrL = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_wrF = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_wrD = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_wrCF = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_rd = "$ren==T,x=0,%1_wen=T,%1_wbus==$rbus,o=0";
        public static final String handleMethod_rdB = "$ren==T,x=0,%0==$rbus,o=0";
        public static final String handleMethod_rdI = "$ren==T,x=0,%0==$rbus,o=0";
        public static final String handleMethod_rdL = "$ren==T,x=0,%0==$rbus,o=0";
        public static final String handleMethod_rdF = "$ren==T,x=0,%0==$rbus,o=0";
        public static final String handleMethod_rdD = "$ren==T,x=0,%0==$rbus,o=0";
        public static final String handleMethod_rdCF = "$ren==T,x=0,%1==$rbus,o=0";
        public static final String handleMethod_wok = "x=0,%0==$wok,o=0";
        public static final String handleMethod_rok = "x=0,%0==$rok,o=0";

        public Queue(int size, int bw, int AFULL, int AEMPTY) {
            this.bpe = (bw + 7) / 8;
            this.len = size * this.bpe;
            this.mask = this.len - 1;
            this.shft = 0;
            while (1 << this.shft < this.bpe) {
                ++this.shft;
            }
            this.roff = 0;
            this.woff = 0;
            this.rok = false;
            this.wok = true;
            this.afull = AFULL;
            this.aempty = AEMPTY;
            this.b = new byte[this.len];
        }

        public void update(int rw) {
            int nin;
            if (rw > 0) {
                this.woff = this.woff + this.bpe & this.mask;
            }
            if (rw < 0) {
                this.roff = this.roff + this.bpe & this.mask;
            }
            this.wok = (nin = (this.woff - this.roff & this.mask) >> this.shft) <= this.afull;
            this.rok = nin > this.aempty;
        }

        public boolean rok() {
            return this.rok;
        }

        public boolean wok() {
            return this.wok;
        }

        public void wr(Value v) {
            System.arraycopy(v.buf, 0, this.b, this.woff, this.bpe);
            this.update(1);
        }

        public void wrB(int v) {
            this.b[this.woff] = (byte)v;
            this.update(1);
        }

        public void wrI(int v) {
            Convert.packI((byte[])this.b, (int)this.woff, (short)((short)v));
            this.update(1);
        }

        public void wrL(int v) {
            Convert.packL((byte[])this.b, (int)this.woff, (int)v);
            this.update(1);
        }

        public void wrF(float v) {
            Convert.packF((byte[])this.b, (int)this.woff, (float)v);
            this.update(1);
        }

        public void wrD(double v) {
            Convert.packD((byte[])this.b, (int)this.woff, (double)v);
            this.update(1);
        }

        public void wrCF(CoreCommon.CxFloat v) {
            Convert.packF((byte[])this.b, (int)this.woff, (float)v.x);
            Convert.packF((byte[])this.b, (int)(this.woff + 4), (float)v.y);
            this.update(1);
        }

        public void rd(Value v) {
            System.arraycopy(this.b, this.roff, v.buf, 0, this.bpe);
            this.update(-1);
        }

        public byte rdB() {
            byte v = this.b[this.roff];
            this.update(-1);
            return v;
        }

        public short rdI() {
            short v = Convert.unpackI((byte[])this.b, (int)this.roff);
            this.update(-1);
            return v;
        }

        public int rdL() {
            int v = Convert.unpackL((byte[])this.b, (int)this.roff);
            this.update(-1);
            return v;
        }

        public float rdF() {
            float v = Convert.unpackF((byte[])this.b, (int)this.roff);
            this.update(-1);
            return v;
        }

        public double rdD() {
            double v = Convert.unpackD((byte[])this.b, (int)this.roff);
            this.update(-1);
            return v;
        }

        public void rdCF(CoreCommon.CxFloat v) {
            v.x = Convert.unpackF((byte[])this.b, (int)this.roff);
            v.y = Convert.unpackF((byte[])this.b, (int)(this.roff + 4));
            this.update(-1);
        }

        public String toString() {
            return "Queue len=" + this.len + " woff=" + this.woff + " wok=" + this.wok + " roff=" + this.roff + " rok=" + this.rok;
        }
    }

    public static interface BufferO {
        public static final String handleArgs = "o:wok,i:wr,c:32:dma,i:nxt,i:AW:adr,o:AW:len,i:BW:bus";
        public static final String handleAuto = "wr=ii,wnxt=i,setX=ii,setF=ii,setL=ii,setB=ii,setC=i,wptr=i,setBPE=i,wokLen=i";
        public static final String handleMethod_wr = "x=0,$wr=T,$adr=%1,$bus=%2.bus";
        public static final String handleMethod_wnxt = "$nxt=T,$adr=%1";
        public static final String handleMethod_setX = "x=0,$wr=T,$adr=%1,$bus=%2";
        public static final String handleMethod_setF = "x=0,$wr=T,$adr=%1,$bus=%2";
        public static final String handleMethod_setL = "x=0,$wr=T,$adr=%1,$bus=%2";
        public static final String handleMethod_setB = "x=0,$wr=T,$adr=%1,$bus=%2";
        public static final String handleMethod_setC = "x=0,$sel=%1";
        public static final String handleMethod_setBPE = "$nxt=F,$adr=%1";
        public static final String handleMethod_wokLen = "$len=%1";
    }

    public static interface BufferI {
        public static final String handleArgs = "o:rok,i:rd,d:32:dma,i:nxt,i:AW:adr,o:AW:len,o:BW:bus,o:8:busb";
        public static final String handleAuto = "rd=io,rnxt=i,getX=i,getF=i,getL=i,getB=i,setC=i,rptr=i,setBPE=i,rokLen=i";
        public static final String handleMethod_rd = "$rd=T,$adr=%1,x=2,%2.bus=$bus,o=3";
        public static final String handleMethod_rnxt = "$nxt=T,$adr=%1";
        public static final String handleMethod_getX = "$rd=T,$adr=%1,x=2,%0=$bus,o=3";
        public static final String handleMethod_getL = "$rd=T,$adr=%1,x=2,%0=$bus,o=3";
        public static final String handleMethod_getF = "$rd=T,$adr=%1,x=2,%0=$bus,o=3";
        public static final String handleMethod_getB = "$rd=T,$adr=%1,x=2,%0=$busb,o=3";
        public static final String handleMethod_setC = "x=0,$sel=%1";
        public static final String handleMethod_setBPE = "$nxt=F,$adr=%1";
        public static final String handleMethod_rokLen = "$len=%1";
    }

    public static class Buffer
    extends Stream {
        public Buffer(int size, int IBW, int OBW, boolean useNative) {
            super(size, IBW, OBW, useNative);
        }

        public void setBPE(int n) {
            this.rbpe = n;
            this.wbpe = n;
            this.update(0);
        }

        public void rd(int ioff, Value val) {
            System.arraycopy(this.b, this.roff + ioff, val.buf, 0, val.len);
        }

        public void wr(int ioff, Value val) {
            System.arraycopy(val.buf, 0, this.b, this.woff + ioff, val.len);
        }

        public byte getB(int ioff) {
            return Convert.unpackB((byte[])this.b, (int)(this.roff + ioff & this.mask));
        }

        public void setB(int ioff, byte val) {
            Convert.packB((byte[])this.b, (int)(this.woff + ioff & this.mask), (byte)val);
        }

        public int getL(int ioff) {
            return Convert.unpackL((byte[])this.b, (int)(this.roff + ioff & this.mask));
        }

        public void setL(int ioff, int val) {
            Convert.packL((byte[])this.b, (int)(this.woff + ioff & this.mask), (int)val);
        }

        public float getF(int ioff) {
            return Convert.unpackF((byte[])this.b, (int)(this.roff + ioff & this.mask));
        }

        public void setF(int ioff, float val) {
            Convert.packF((byte[])this.b, (int)(this.woff + ioff & this.mask), (float)val);
        }

        public long getX(int ioff) {
            return ((long)Convert.unpackL((byte[])this.b, (int)(this.roff + ioff + 4 & this.mask)) << 32) + (long)Convert.unpackL((byte[])this.b, (int)(this.roff + ioff & this.mask));
        }

        public void setX(int ioff, long val) {
            Convert.packX((byte[])this.b, (int)(this.woff + ioff & this.mask), (long)val);
        }

        public void rokLen(int len) {
            this.rper = len;
        }

        public void wokLen(int len) {
            this.wper = len;
        }

        public void rnxt(int n) {
            this.update(-n);
        }

        public void wnxt(int n) {
            this.update(n);
        }

        @Override
        public String toString() {
            return "Buffer len=" + this.len + " woff=" + this.woff + " wok=" + this.wok + " roff=" + this.roff + " rok=" + this.rok;
        }
    }

    public static interface StreamO {
        public static final String handleArgs = "o:wok,i:wen,i:BWP:wsel,i:BW:wbus";
        public static final String handleAuto = "wr=i,wrx=ii,wrCI=i,wrCF=i,wrCFx=ii,wrCFB=i,wrCFBA=ii,wrCFI=i,wrCFIA=ii,wrCFIAX=iii,wrCFIx=ii,wrCFIS=ii,wrCFISA=iii,wrCFxy=ii,wrCIxy=ii,wrBits=ii,wrB=i,wrL=i,wrLS=ii,wrLC=ii,wrX=i,wrF=i,setC=i";
        public static final String handleMethod_wr = "x=0,$wen=T,%1_ren==$wen,$wbus==%1_rbus";
        public static final String handleMethod_wrx = "x=0,$wen=%2,%1_ren==$wen,$wbus==%1_rbus";
        public static final String handleMethod_wrCI = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrCF = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrCFx = "x=0,$wen=%2,$wbus=%1";
        public static final String handleMethod_wrCFB = "x=0,$wen=T,$wbus=CF2CB(%1)";
        public static final String handleMethod_wrCFBA = "x=0,$wen=T,t=CFA2CBB_task(%2)(%1,$wbus)";
        public static final String handleMethod_wrCFI = "x=0,$wen=T,$wbus=CF2CI(%1)";
        public static final String handleMethod_wrCFIA = "x=0,$wen=T,t=CFA2CIB_task(%2)(%1,$wbus)";
        public static final String handleMethod_wrCFIAX = "x=0,$wen=T,t=CFA2CIB_task(%2,%3)(%1,$wbus)";
        public static final String handleMethod_wrCFIx = "x=0,$wen=T,t=CFx2CIB_task(%2)(%1_rbus,$wbus)";
        public static final String handleMethod_wrCFIS = "x=0,$wen=T,$wbus=CF2CIS(%1,%2)";
        public static final String handleMethod_wrCFISA = "x=0,$wen=T,t=CFA2CIBS_task(%3)(%1,%2,$wbus)";
        public static final String handleMethod_wrCFxy = "x=0,$wen=T,$wbus=muxf(%1,%2)";
        public static final String handleMethod_wrCIxy = "x=0,$wen=T,$wbus=muxs(%1,%2)";
        public static final String handleMethod_wrBits = "x=0,$wen=T,$bits=%1,$wbus=%2";
        public static final String handleMethod_wrB = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrI = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrL = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrLC = "x=0,$wen=T,$wbus=%1,$wsel=%2,$swaps=0";
        public static final String handleMethod_wrLS = "x=0,$wen=T,$wbus=%1,$swaps=%2";
        public static final String handleMethod_wrF = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrX = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_setC = "x=0,$wsel=%1";
    }

    public static interface StreamI {
        public static final String handleArgs = "o:rok,i:ren,o:BWP:rsel,o:BW:rbus";
        public static final String handleAuto = "rd=o,rdx=oi,rdCI=o,rdCF=o,rdCIF=o,rdCIFA=oi,rdCIFx=oi,rdBits=i,rdB=,rdL=,rdF=,getC=";
        public static final String handleMethod_rd = "$ren=T,x=2,%1_wen==xn,%1_wbus==$rbus,o=2";
        public static final String handleMethod_rdx = "$ren=T,x=2,%1_wen==xn,%1_wbus==$rbus,o=2";
        public static final String handleMethod_rdCI = "$ren=T,x=2,%1=$rbus,o=3";
        public static final String handleMethod_rdCF = "$ren=T,x=2,%1=$rbus,o=3";
        public static final String handleMethod_rdCIF = "$ren=T,x=2,%1=CI2CF($rbus),o=3";
        public static final String handleMethod_rdCIFA = "$ren=T,x=2,t=CIB2CFA_task(%2)($rbus,%1),o=3";
        public static final String handleMethod_rdCIFx = "$ren=T,x=2,t=CIB2CFx_task(%2)($rbus,%1_wbus),o=3";
        public static final String handleMethod_rdBits = "$ren=T,$bits=%1,x=2,%0=$rbus,o=3";
        public static final String handleMethod_rdB = "$ren=T,x=2,%0=$rbus,o=3";
        public static final String handleMethod_rdI = "$ren=T,x=2,%0=$rbus,o=3";
        public static final String handleMethod_rdL = "$ren=T,x=2,%0=$rbus,o=3";
        public static final String handleMethod_rdF = "$ren=T,x=2,%0=$rbus,o=3";
        public static final String handleMethod_getC = "x=0,%0=$rsel";
    }

    public static class Stream {
        public int len;
        public int bib;
        public int woff;
        public int roff;
        public int wboff;
        public int rboff;
        public int wbpe;
        public int rbpe;
        public int wper;
        public int rper;
        public int mtl;
        public int mask;
        public int chn;
        public int cvt;
        public boolean wok;
        public boolean rok;
        public boolean useNative;
        public byte[] b;
        public byte[] c;
        public long handle;
        public CoreCommon.CxFloat cxt;
        private int dbgmod;
        private int dbgcnt;
        public static final String handleArgs = "b:swaps,b:wok,b:wen,b:BWP:wsel,b:BW:wbus,b:rok,b:ren,b:BWP:rsel,b:BW:rbus";
        public static final String handleMethod_rd = "$ren=T,x=2,%1_wen==xn,%1_wbus==$rbus,o=2";
        public static final String handleMethod_wr = "x=0,$wen=T,%1_ren==$wen,$wbus==%1_rbus";

        public Stream() {
            this(1024);
        }

        public Stream(int size) {
            this(size, 32, 32);
        }

        public Stream(int size, int IBW, int OBW) {
            this(size, IBW, OBW, false);
        }

        public Stream(int size, int IBW, int OBW, boolean useNative) {
            this.len = size;
            this.mtl = this.len / 2;
            this.mask = this.len - 1;
            this.wok = true;
            this.rper = this.rbpe = IBW / 8;
            this.wper = this.wbpe = OBW / 8;
            if (useNative) {
                this.handle = CoreNative.newStream(size, IBW, OBW);
            } else {
                this.b = new byte[this.len];
            }
            this.useNative = useNative;
        }

        public int load(DataFile df) {
            int n = 0;
            int avail = this.roff - this.woff;
            if (avail < 0 || this.bib == 0) {
                avail = this.len - this.woff;
            }
            if (avail > this.mtl) {
                avail = this.mtl;
            }
            if (this.cvt == 1) {
                n = df.read(this.b, this.woff, avail >> 1) << 1;
                int ib = n >> 1;
                int ii = n;
                while (ib > 0) {
                    this.b[this.woff + --ii] = this.b[this.woff + --ib];
                    this.b[this.woff + --ii] = 0;
                }
            } else if (this.cvt == 2) {
                int m = avail >> 2;
                n = df.read(this.b, this.woff, m * 3) / 3 * 4;
                int ij = this.woff + m * 3;
                int ii = this.woff + m * 4;
                for (int i = 0; i < m; ++i) {
                    this.b[(ii -= 4) + 0] = (byte)(this.b[(ij -= 3) + 0] << 4);
                    this.b[ii + 1] = (byte)(this.b[ij + 1] << 4 | this.b[ij + 0] >> 4 & 0xF);
                    this.b[ii + 2] = (byte)(this.b[ij + 1] & 0xF0);
                    this.b[ii + 3] = this.b[ij + 2];
                }
            } else {
                n = df.read(this.b, this.woff, avail);
            }
            if (n == 0 && !df.isStream()) {
                n = -1;
            }
            if (n > 0) {
                this.update(n);
            }
            return n;
        }

        public int unload(DataFile df) {
            int avail = this.woff - this.roff;
            if (avail < 0 || this.bib == this.len) {
                avail = this.len - this.roff;
            }
            if (avail == 0) {
                return 0;
            }
            int n = df.write(this.b, this.roff, avail);
            if (n > 0) {
                this.update(-n);
            }
            return n;
        }

        public void update(int xfer) {
            this.bib += xfer;
            if (xfer > 0) {
                if (this.c != null) {
                    this.c[this.woff >> 2] = (byte)this.chn;
                }
                this.woff += xfer;
                if (this.woff >= this.len) {
                    this.woff -= this.len;
                }
            } else {
                if (this.dbgmod != 0) {
                    if (this.dbgcnt % this.dbgmod == 0) {
                        System.out.printf("Stream cnt=%x value=%x\n", this.dbgcnt, Convert.unpackL((byte[])this.b, (int)this.roff));
                    }
                    this.dbgcnt -= xfer;
                }
                this.roff += -xfer;
                if (this.roff >= this.len) {
                    this.roff -= this.len;
                }
            }
            this.rok = this.bib >= this.rper;
            this.wok = this.len - this.bib >= this.wper;
        }

        public void rd(Value val) {
            System.arraycopy(this.b, this.roff, val.buf, 0, val.len);
            this.update(-val.len);
        }

        public void rdx(Value val, int n) {
            int bpe = n * val.bps * val.spa;
            System.arraycopy(this.b, this.roff, val.buf, 0, bpe);
            this.update(-bpe);
        }

        public float rdF() {
            float x = Convert.unpackF((byte[])this.b, (int)this.roff);
            this.update(-4);
            return x;
        }

        public int rdL() {
            int x = Convert.unpackL((byte[])this.b, (int)this.roff);
            this.update(-4);
            return x;
        }

        public int rdI() {
            short x = Convert.unpackI((byte[])this.b, (int)this.roff);
            this.update(-2);
            return x;
        }

        public byte rdB() {
            byte x = this.b[this.roff];
            this.update(-1);
            return x;
        }

        public int rdBits(int n) {
            int x = 0;
            for (int i = 0; i < n; ++i) {
                if ((this.b[this.roff] & 1 << this.rboff) != 0) {
                    x |= 1 << i;
                }
                if (++this.rboff != 8) continue;
                this.update(-1);
                this.rboff = 0;
            }
            return x;
        }

        public void rdCI(CoreCommon.CxShort val) {
            val.x = Convert.unpackI((byte[])this.b, (int)(this.roff + 0));
            val.y = Convert.unpackI((byte[])this.b, (int)(this.roff + 2));
            this.update(-4);
        }

        public void rdCF(CoreCommon.CxFloat val) {
            val.x = Convert.unpackF((byte[])this.b, (int)(this.roff + 0));
            val.y = Convert.unpackF((byte[])this.b, (int)(this.roff + 4));
            this.update(-8);
        }

        public void rdCIF(CoreCommon.CxFloat val) {
            val.x = (float)Convert.unpackI((byte[])this.b, (int)(this.roff + 0)) / 32768.0f;
            val.y = (float)Convert.unpackI((byte[])this.b, (int)(this.roff + 2)) / 32768.0f;
            this.update(-4);
        }

        public void rdCIFA(CoreCommon.CxFloat[] val, int n) {
            for (int i = 0; i < n; ++i) {
                this.rdCIF(val[i]);
            }
        }

        public void rdCIFx(Value val, int n) {
            if (this.cxt == null) {
                this.cxt = new CoreCommon.CxFloat();
            }
            for (int i = 0; i < n; ++i) {
                this.rdCIF(this.cxt);
                val.setCF(i, this.cxt);
            }
        }

        public void wr(Value val) {
            System.arraycopy(val.buf, 0, this.b, this.woff, val.len);
            this.update(val.len);
        }

        public void wrx(Value val, int n) {
            if (n == 0) {
                return;
            }
            int bpe = n * val.bps * val.spa;
            System.arraycopy(val.buf, 0, this.b, this.woff, bpe);
            this.update(bpe);
        }

        public void wrX(long x) {
            Convert.packX((byte[])this.b, (int)this.woff, (long)x);
            this.update(8);
        }

        public void wrF(float x) {
            Convert.packF((byte[])this.b, (int)this.woff, (float)x);
            this.update(4);
        }

        public void wrL(int x) {
            Convert.packL((byte[])this.b, (int)this.woff, (int)x);
            this.update(4);
        }

        public void wrI(short x) {
            Convert.packI((byte[])this.b, (int)this.woff, (short)x);
            this.update(2);
        }

        public void wrB(byte x) {
            this.b[this.woff] = x;
            this.update(1);
        }

        public void wrLC(int x, int c) {
            this.setC(c);
            Convert.packL((byte[])this.b, (int)this.woff, (int)x);
            this.update(4);
        }

        public void wrLS(int x, int swaps) {
            if (swaps == 1) {
                x = CoreCommon.bswap2s(x);
            } else if (swaps == 2) {
                x = CoreCommon.bswap4(x);
            }
            Convert.packL((byte[])this.b, (int)this.woff, (int)x);
            this.update(4);
        }

        public void wrBits(int n, int x) {
            for (int i = 0; i < n; ++i) {
                if ((x & 1) == 0) {
                    int n2 = this.woff;
                    this.b[n2] = (byte)(this.b[n2] & ~(1 << this.wboff));
                } else {
                    int n3 = this.woff;
                    this.b[n3] = (byte)(this.b[n3] | 1 << this.wboff);
                }
                if (++this.wboff == 8) {
                    this.update(1);
                    this.wboff = 0;
                }
                x >>= 1;
            }
        }

        public void wrCI(CoreCommon.CxShort val) {
            Convert.packI((byte[])this.b, (int)(this.woff + 0), (short)val.x);
            Convert.packI((byte[])this.b, (int)(this.woff + 2), (short)val.y);
            this.update(4);
        }

        public void wrCF(CoreCommon.CxFloat val) {
            Convert.packF((byte[])this.b, (int)(this.woff + 0), (float)val.x);
            Convert.packF((byte[])this.b, (int)(this.woff + 4), (float)val.y);
            this.update(8);
        }

        public void wrCFx(CoreCommon.CxFloat val, int n) {
            if (n <= 0) {
                return;
            }
            Convert.packF((byte[])this.b, (int)(this.woff + 0), (float)val.x);
            Convert.packF((byte[])this.b, (int)(this.woff + 4), (float)val.y);
            this.update(8);
        }

        public void wrCFI(CoreCommon.CxFloat val) {
            Convert.packI((byte[])this.b, (int)(this.woff + 0), (short)((short)Math.round(val.x * 32768.0f)));
            Convert.packI((byte[])this.b, (int)(this.woff + 2), (short)((short)Math.round(val.y * 32768.0f)));
            this.update(4);
        }

        public void wrCFIA(CoreCommon.CxFloat[] val, int n) {
            for (int i = 0; i < n; ++i) {
                this.wrCFI(val[i]);
            }
        }

        public void wrCFIx(Value val, int n) {
            if (this.cxt == null) {
                this.cxt = new CoreCommon.CxFloat();
            }
            for (int i = 0; i < n; ++i) {
                val.getCF(i, this.cxt);
                this.wrCFI(this.cxt);
            }
        }

        public void wrCFIS(CoreCommon.CxFloat val, int shf) {
            int scl = 32768 << shf;
            Convert.packI((byte[])this.b, (int)(this.woff + 0), (short)((short)Math.round(val.x * (float)scl)));
            Convert.packI((byte[])this.b, (int)(this.woff + 2), (short)((short)Math.round(val.y * (float)scl)));
            this.update(4);
        }

        public void wrCFISA(CoreCommon.CxFloat[] val, int shf, int n) {
            for (int i = 0; i < n; ++i) {
                this.wrCFIS(val[i], shf);
            }
        }

        public void wrCFB(CoreCommon.CxFloat val) {
            Convert.packB((byte[])this.b, (int)(this.woff + 0), (byte)((byte)Math.round(val.x * 128.0f)));
            Convert.packB((byte[])this.b, (int)(this.woff + 1), (byte)((byte)Math.round(val.y * 128.0f)));
            this.update(2);
        }

        public void wrCFBA(CoreCommon.CxFloat[] val, int n) {
            for (int i = 0; i < n; ++i) {
                this.wrCFB(val[i]);
            }
        }

        public void wrCFxy(float x, float y) {
            Convert.packF((byte[])this.b, (int)(this.woff + 0), (float)x);
            Convert.packF((byte[])this.b, (int)(this.woff + 4), (float)y);
            this.update(8);
        }

        public void wrCIxy(int x, int y) {
            Convert.packI((byte[])this.b, (int)(this.woff + 0), (short)((short)x));
            Convert.packI((byte[])this.b, (int)(this.woff + 2), (short)((short)y));
            this.update(4);
        }

        public void setC(int chn) {
            if (this.c == null) {
                this.c = new byte[this.len >> 2];
            }
            this.chn = chn;
        }

        public int getC() {
            return this.c != null ? this.c[this.roff >> 2] : this.chn;
        }

        public int xgetL(int ioff) {
            if (this.useNative) {
                return CoreNative.xgetL(this.handle, ioff);
            }
            return Convert.unpackL((byte[])this.b, (int)(this.woff + ioff & this.mask));
        }

        public void xwrL(int x) {
            if (this.useNative) {
                CoreNative.xwrL(this.handle, x);
            } else {
                this.wrL(x);
            }
        }

        public void setDebug(int cnt) {
            this.dbgmod = cnt;
            this.dbgcnt = 0;
        }

        public String toString() {
            return "Stream len=" + this.len + " woff=" + this.woff + " wok=" + this.wok + " roff=" + this.roff + " rok=" + this.rok;
        }
    }

    public static interface ValueIF {
        public static final String handleMethod_getCF = "$.ren=T,$.roff=%1,x=1,%0=$.rbus,o=1";
        public static final String handleMethod_setCF = "$.wen=T,$.woff=%1,$.wbus=%2,x=0,o=1";
        public static final String handleMethod_setCFxy = "$.wen=T,$.woff=%1,$.wbus=muxf(%2,%3),x=0,o=1";
    }

    public static interface ValueO {
        public static final String handleAuto = "setCF=ii,setCFxy=iii";
        public static final String handleMethod_setCF = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setCFxy = "$wen=T,$woff=%1,$wbus=muxf(%2,%3),x=0,o=1";
    }

    public static interface ValueI {
        public static final String handleMethod_getCF = "$ren=T,$roff=%1,x=1,%0=$rbus,o=1";
        public static final String handleAuto = "getCF=io";
    }

    public static class Value {
        public int bps;
        public int spa;
        public int bpa;
        public int boff;
        public int len;
        public byte mode;
        public byte type;
        public byte[] buf;
        private int scalars;
        public static final String handleArgs = "i:wen,i:8:woff,i:BPW:wbus,i:ren,i:8:roff,o:BPW:rbus";
        public static final String handleAuto = "getB=i,getI=i,getL=i,getF=i,getCF=io,getCIF=io,getCIFx=i,getCIFy=i,setB=ii,setI=ii,setL=ii,setF=ii,setCF=ii,setCFxy=iii,setCFI=ii,setCFIS2=iii";
        public static final String handleMethod_getB = "$ren=T,$roff=%1,x=1,%0=$rbus,o=1";
        public static final String handleMethod_getI = "$ren=T,$roff=%1,x=1,%0=$rbus,o=1";
        public static final String handleMethod_getL = "$ren=T,$roff=%1,x=1,%0=$rbus,o=1";
        public static final String handleMethod_getF = "$ren=T,$roff=%1,x=1,%0=$rbus,o=1";
        public static final String handleMethod_getCF = "$ren=T,$roff=%1,x=1,%2=$rbus,o=1";
        public static final String handleMethod_getCIF = "$ren=T,$roff=%1,x=1,%2=CI2CF($rbus),o=1";
        public static final String handleMethod_setB = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setI = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setL = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setF = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setCF = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setCFxy = "$wen=T,$woff=%1,$wbus=muxf(%2,%3),x=0,o=1";
        public static final String handleMethod_setCFI = "$wen=T,$woff=%1,$wbus=CF2CI(%2),x=0,o=1";
        public static final String handleMethod_setCFIS2 = "$wen=T,$woff=0,$wbus=CF2CIS2(%1,%2,%3),x=0,o=1";

        public Value(String format, int size, int BW) {
            this(format, size);
        }

        public Value(String format, int size) {
            this.mode = (byte)format.charAt(0);
            this.type = (byte)format.charAt(1);
            this.spa = Data.getSPA((byte)this.mode);
            this.bps = Data.getBPS((byte)this.type);
            this.bpa = this.spa * this.bps;
            this.len = this.bpa * size;
            this.scalars = this.len / this.bps;
            this.buf = new byte[this.len];
        }

        public Value(byte[] buf, byte mode, byte type, int boff, int elem) {
            this.buf = buf;
            this.mode = mode;
            this.type = type;
            this.boff = boff;
            this.spa = Data.getSPA((byte)mode);
            this.bps = Data.getBPS((byte)type);
            this.bpa = this.spa * this.bps;
            this.len = this.bpa * elem;
            this.scalars = this.len / this.bps;
        }

        public void setSize(int size) {
            int nlen = size * this.bpa;
            if (nlen > this.len) {
                System.out.println("Value setSize=" + size + " with BPA=" + this.bpa + " greater than allocated len=" + this.len);
            }
            this.len = nlen;
        }

        public void setBPA(int bpa) {
            if (bpa > this.bpa) {
                System.out.println("Value setBPA=" + bpa + " greater than allocated BPA=" + this.bpa);
            }
            this.bpa = bpa;
        }

        public void fromL(int value) {
            Convert.packL((byte[])this.buf, (int)this.boff, (int)value);
        }

        public void fromF(float value) {
            Convert.packF((byte[])this.buf, (int)this.boff, (float)value);
        }

        public void fromD(double value) {
            Convert.packD((byte[])this.buf, (int)this.boff, (double)value);
        }

        public void fromS(String value) {
            this.setS(value);
        }

        public int toL() {
            return this.type == 76 ? Convert.unpackL((byte[])this.buf, (int)this.boff) : this.getxL(0);
        }

        public float toF() {
            return this.type == 70 ? Convert.unpackF((byte[])this.buf, (int)this.boff) : (float)this.getxD(0);
        }

        public double toD() {
            return this.type == 68 ? Convert.unpackD((byte[])this.buf, (int)this.boff) : this.getxD(0);
        }

        public String toS() {
            int alen;
            for (alen = this.len; alen > 0 && this.buf[alen - 1] <= 32; --alen) {
            }
            return new String(this.buf, 0, alen);
        }

        public String toString() {
            if (this.type == 83 || this.type == 65) {
                return this.toS();
            }
            if (this.type == 68) {
                return Convert.d2s((double)this.toD());
            }
            if (this.type == 70) {
                return Convert.d2s((double)this.toF());
            }
            return Convert.l2s((int)this.toL());
        }

        public void fromList(String list, int index) {
            String s = CoreCommon.getListItem(list, index, -2);
            this.len = s.length();
            Convert.packS((byte[])this.buf, (int)0, (int)this.len, (String)s);
        }

        public int toItem(String list) {
            String sitem = Convert.unpackS((byte[])this.buf, (int)0, (int)this.len);
            int item = CoreCommon.findListItem(list, sitem, -2);
            if (item < -1) {
                System.out.println("Item=" + sitem + " not found in list=" + list);
            }
            return item;
        }

        public int toMask(String list) {
            int mask = 0;
            String sitem = Convert.unpackS((byte[])this.buf, (int)0, (int)this.len);
            if (sitem.equalsIgnoreCase("None")) {
                return 0;
            }
            if (sitem.equalsIgnoreCase("All")) {
                return -1;
            }
            for (int i = 0; i < 32; ++i) {
                String s = CoreCommon.getListItem(sitem, i, 0);
                this.len = s.length();
                if (s == null || s.length() == 0) continue;
                if (s.equals("Undefined")) break;
                int bit = CoreCommon.findListItem(list, s, 0);
                if (bit < 0) {
                    System.out.println("Item=" + s + " not found in list=" + list);
                    continue;
                }
                mask |= 1 << bit;
            }
            return mask;
        }

        public int[] toLA() {
            int[] ia = new int[this.scalars];
            Convert.bb2ja((byte[])this.buf, (int)0, (byte)this.type, (Object)ia, (int)0, (byte)73, (int)this.scalars);
            return ia;
        }

        public float[] toFA() {
            float[] fa = new float[this.scalars];
            Convert.bb2ja((byte[])this.buf, (int)0, (byte)this.type, (Object)fa, (int)0, (byte)70, (int)this.scalars);
            return fa;
        }

        public double[] toDA() {
            double[] da = new double[this.scalars];
            Convert.bb2ja((byte[])this.buf, (int)0, (byte)this.type, (Object)da, (int)0, (byte)68, (int)this.scalars);
            return da;
        }

        public double getxD(int off) {
            switch (this.type) {
                case 66: {
                    return this.getB(off);
                }
                case 73: {
                    return this.getI(off);
                }
                case 76: {
                    return this.getL(off);
                }
                case 70: {
                    return this.getF(off);
                }
                case 68: {
                    return this.getD(off);
                }
            }
            return 0.0;
        }

        public int getxL(int off) {
            switch (this.type) {
                case 66: {
                    return this.getB(off);
                }
                case 73: {
                    return this.getI(off);
                }
                case 76: {
                    return this.getL(off);
                }
                case 70: {
                    return (int)this.getF(off);
                }
                case 68: {
                    return (int)this.getD(off);
                }
            }
            return 0;
        }

        public void setS(String s) {
            this.type = (byte)83;
            this.bps = 1;
            this.spa = 1;
            this.bpa = 1;
            this.buf = s.getBytes();
            this.len = this.buf.length;
        }

        public void setB(int off, byte value) {
            this.buf[off] = value;
        }

        public void setI(int off, short value) {
            Convert.packI((byte[])this.buf, (int)(off <<= 1), (short)value);
        }

        public void setL(int off, int value) {
            Convert.packL((byte[])this.buf, (int)(off <<= 2), (int)value);
        }

        public void setF(int off, float value) {
            Convert.packF((byte[])this.buf, (int)(off <<= 2), (float)value);
        }

        public void setD(int off, double value) {
            Convert.packD((byte[])this.buf, (int)(off <<= 3), (double)value);
        }

        public void setCF(int off, CoreCommon.CxFloat value) {
            Convert.packF((byte[])this.buf, (int)(off <<= 3), (float)value.x);
            Convert.packF((byte[])this.buf, (int)(off + 4), (float)value.y);
        }

        public void setCFxy(int off, float x, float y) {
            Convert.packF((byte[])this.buf, (int)(off <<= 3), (float)x);
            Convert.packF((byte[])this.buf, (int)(off + 4), (float)y);
        }

        public void setCFIxy(int off, float x, float y) {
            Convert.packI((byte[])this.buf, (int)(off <<= 2), (short)((short)Math.rint(x * 32768.0f)));
            Convert.packI((byte[])this.buf, (int)(off + 2), (short)((short)Math.rint(y * 32768.0f)));
        }

        public void setCFI(int off, CoreCommon.CxFloat value) {
            Convert.packI((byte[])this.buf, (int)(off <<= 2), (short)((short)Math.rint(value.x * 32768.0f)));
            Convert.packI((byte[])this.buf, (int)(off + 2), (short)((short)Math.rint(value.y * 32768.0f)));
        }

        public void setCFIS2(int shf, CoreCommon.CxFloat value1, CoreCommon.CxFloat value2) {
            int scl = shf < 0 ? 32768 >> -shf : 32768 << shf;
            Convert.packI((byte[])this.buf, (int)0, (short)((short)Math.rint(value1.x * (float)scl)));
            Convert.packI((byte[])this.buf, (int)2, (short)((short)Math.rint(value1.y * (float)scl)));
            Convert.packI((byte[])this.buf, (int)4, (short)((short)Math.rint(value2.x * (float)scl)));
            Convert.packI((byte[])this.buf, (int)6, (short)((short)Math.rint(value2.y * (float)scl)));
        }

        public byte getB(int off) {
            return this.type == 66 ? this.buf[off] : (byte)this.getxL(off);
        }

        public short getI(int off) {
            return this.type == 73 ? Convert.unpackI((byte[])this.buf, (int)(off << 1)) : (short)this.getxL(off);
        }

        public int getL(int off) {
            return this.type == 76 ? Convert.unpackL((byte[])this.buf, (int)(off << 2)) : this.getxL(off);
        }

        public float getF(int off) {
            return this.type == 70 ? Convert.unpackF((byte[])this.buf, (int)(off << 2)) : (float)this.getxD(off);
        }

        public double getD(int off) {
            return this.type == 68 ? Convert.unpackD((byte[])this.buf, (int)(off << 3)) : this.getxD(off);
        }

        public void getCF(int off, CoreCommon.CxFloat value) {
            value.x = Convert.unpackF((byte[])this.buf, (int)(off <<= 3));
            value.y = Convert.unpackF((byte[])this.buf, (int)(off + 4));
        }

        public float getCFx(int off) {
            return Convert.unpackF((byte[])this.buf, (int)(off <<= 3));
        }

        public float getCFy(int off) {
            return Convert.unpackF((byte[])this.buf, (int)((off <<= 3) + 4));
        }

        public void getCIF(int off, CoreCommon.CxFloat value) {
            value.x = (float)Convert.unpackI((byte[])this.buf, (int)(off <<= 2)) / 32768.0f;
            value.y = (float)Convert.unpackI((byte[])this.buf, (int)(off + 2)) / 32768.0f;
        }

        public float getCIFx(int off) {
            return (float)Convert.unpackI((byte[])this.buf, (int)(off <<= 2)) / 32768.0f;
        }

        public float getCIFy(int off) {
            return (float)Convert.unpackI((byte[])this.buf, (int)((off <<= 2) + 2)) / 32768.0f;
        }

        public char charAt(int off) {
            return (char)this.buf[off];
        }
    }
}

