/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class Core
extends CoreComponent {
    public HALO halo = new HALO();
    public String name;

    public static Core forName(String name, Args args) {
        Core c = CoreFactory.getCore(name, args);
        return c;
    }

    public Core() {
        this.setFlow(0);
    }

    public void initSub(int sc, HALO halo) {
        this.halo.scid = sc;
        this.halo.vbpr = halo.vbpr;
        this.halo.impl = halo.impl;
        if (sc > 0) {
            this.init();
        }
    }

    public void allocNative(String config) {
        System.out.println("Err: Should not be calling allocNative from this implementation");
    }

    public CoreComponent.Buffer getBuffer(int tl, int ibw, int obw) {
        boolean useNative = this.halo.impl > 0;
        return new CoreComponent.Buffer(tl * 2, ibw * 8, obw * 8, useNative);
    }

    public CoreComponent.Buffer getBuffer(int tl, String ifmt, String ofmt) {
        int cvt = 0;
        int ibpa = Data.getBPA((String)ifmt);
        int obpa = Data.getBPA((String)ofmt);
        if (!(ifmt.equals(ofmt) || ifmt.equals("NH") || ofmt.equals("NH"))) {
            if (ifmt.charAt(1) == 'B' && ofmt.charAt(1) == 'I') {
                cvt = 1;
            } else if (ifmt.equals("CJ") && ofmt.equals("CI")) {
                cvt = 2;
            } else if (ibpa != obpa) {
                System.out.println("Buffer format convert " + ifmt + " to " + ofmt + " not handled yet");
            }
        }
        CoreComponent.Buffer b = this.getBuffer(tl, ibpa, obpa);
        b.cvt = cvt;
        return b;
    }

    public void setFlow(int flow) {
        this.halo.flow = flow;
    }

    public int init() {
        return 0;
    }

    public int open() {
        this.halo.state = 1;
        return 0;
    }

    public int process() {
        System.out.println("This method process() should have been overridden");
        Time.sleep((double)1.0);
        return -1;
    }

    public int process(CoreComponent.Buffer bi, CoreComponent.Buffer bo) {
        if (this.halo.flow == 1) {
            return this.process((CoreComponent.Stream)bi, (CoreComponent.Stream)bo);
        }
        System.out.println("This flow=BUFFER method process(bi,bo) should have been overridden");
        Time.sleep((double)1.0);
        return -1;
    }

    public int process(CoreComponent.Buffer bi, CoreComponent.Stream so) {
        System.out.println("This flow=BUFSTR method process(bi,so) should have been overridden");
        Time.sleep((double)1.0);
        return -1;
    }

    @Override
    public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
        System.out.println("This flow=STREAM method process(si,so) should have been overridden");
        Time.sleep((double)1.0);
        return -1;
    }

    public int process(CoreComponent.Buffer bi, CoreComponent.Stream sip, CoreComponent.Stream so, CoreComponent.Stream sop) {
        System.out.println("This flow=PACKET method process(bi,sip,so,sop) should have been overridden");
        Time.sleep((double)1.0);
        return -1;
    }

    public int poll() {
        return 0;
    }

    public int close() {
        this.halo.state = 0;
        return 0;
    }

    public boolean isMatch(String key, String name) {
        boolean nht;
        if (key.endsWith("?")) {
            key = key.substring(0, key.length() - 1);
        }
        boolean kht = key.length() > 2 && key.charAt(1) == ':';
        boolean bl = nht = name.length() > 2 && name.charAt(1) == ':';
        if (!(!kht || nht && key.startsWith("S:"))) {
            key = key.substring(2);
        }
        if (!(!nht || kht && name.startsWith("S:"))) {
            name = name.substring(2);
        }
        return name.equalsIgnoreCase(key);
    }

    public boolean isSubMatch(String key, String name) {
        int ip = key.indexOf(95);
        if (ip <= 0) {
            return false;
        }
        key = key.substring(0, ip);
        return this.isMatch(key, name);
    }

    public String subKey(String key) {
        int ip = key.indexOf(95);
        if (ip <= 0) {
            return "";
        }
        return key.substring(ip + 1);
    }

    public int set(String key, CoreComponent.Value value) {
        if (this.halo.scid > 0) {
            return -1;
        }
        if (!key.startsWith("NAME") && !key.startsWith("S:NAME")) {
            if (key.equals("ICE.CONFIG")) {
                System.out.println("Setting the key=" + key + " to " + value);
            } else {
                throw new MidasException("Problem setting key=" + key + " to value=" + value);
            }
        }
        return 0;
    }

    public synchronized int set(String key, Data data) {
        CoreComponent.Value value = new CoreComponent.Value(data.buf, data.mode, data.type, 0, data.size);
        return this.set(key, value);
    }

    public int set(String key, String value) {
        return this.set(key, new Data(value));
    }

    public int set(String key, double value) {
        return this.set(key, new Data(value));
    }

    public int set(String key, float value) {
        return this.set(key, new Data(value));
    }

    public int set(String key, int value) {
        return this.set(key, new Data(value));
    }

    public int set(String key, boolean value) {
        return this.set(key, new Data(value ? 1 : 0));
    }

    public int set(String key, float[] value) {
        return this.set(key, new Data(value));
    }

    public int set(String key, int[] value) {
        return this.set(key, new Data(value));
    }

    public int set(String key, short[] value) {
        return this.set(key, new Data(value));
    }

    public int set(String key, byte[] value) {
        return this.set(key, new Data(value));
    }

    public int setKeyFile(String fn, boolean verbose) {
        Table keys = Convert.o2t((Object)fn, (Object)Shell.getMidasContext());
        return this.setKeyTable(null, keys, verbose);
    }

    public int setKeyTable(String root, Table keys, boolean verbose) {
        int n = 0;
        keys.setMode("KV");
        String[] list = keys.getKeys();
        for (int i = 0; i < list.length; ++i) {
            String key = list[i];
            Object value = keys.get(key);
            if (value instanceof Table) {
                this.setKeyTable(key, (Table)value, verbose);
                continue;
            }
            if (value == null || value.equals("") || value.equals("NULL")) continue;
            Data d = keys.getData(key);
            String type = d.getFormat().substring(1, 2);
            if (type.equals("A")) {
                type = "S";
            }
            if (root != null) {
                key = root + "_" + key;
            }
            if ("SLFD".indexOf(type) >= 0) {
                key = type + ":" + key;
            }
            if (verbose) {
                System.out.println("Set Key=" + key + " Value=" + value);
            }
            this.set(key, d);
            ++n;
        }
        return n;
    }

    public int get(String key, CoreComponent.Value value) {
        value = null;
        int stat = 0;
        if (this.halo.scid > 0) {
            return -1;
        }
        if (!key.startsWith("BOGUS")) {
            if (key.equals("NAME") || key.equals("S:NAME")) {
                value.fromS(this.name);
            } else if (key.endsWith("?")) {
                stat = -1;
            } else if (key.equals("TIME") || key.equals("D:TIME")) {
                value.fromD(Time.current());
            } else if (key.equals("SSM") || key.equals("F:SSM")) {
                value.fromF((float)Time.currentTime().getSoD());
            } else {
                System.out.println("Core get of key=" + key + " not handled");
                stat = -1;
            }
        }
        return stat;
    }

    public int get(String key, Data data) {
        CoreComponent.Value value = new CoreComponent.Value(data.buf, data.mode, data.type, 0, data.size);
        return this.get(key, value);
    }

    public int get(String key, Data data, int off, int len) {
        CoreComponent.Value value = new CoreComponent.Value(data.buf, data.mode, data.type, off, len);
        return this.get(key, value);
    }

    public Data get(String key, byte type) {
        Data data = new Data();
        data.setType(type);
        data.setSize(1);
        int stat = this.get(key, data);
        return stat < 0 ? null : data;
    }

    public Data get(String key) {
        byte type = 76;
        if (key.indexOf(58) == 1) {
            type = (byte)key.charAt(0);
        }
        return this.get(key, type);
    }

    public String getS(String key) {
        Data value = this.get(key, (byte)83);
        return value.toString();
    }

    public double getD(String key) {
        Data value = this.get(key, (byte)68);
        return value.toD();
    }

    public float getF(String key) {
        Data value = this.get(key, (byte)70);
        return value.toF();
    }

    public int getL(String key) {
        Data value = this.get(key, (byte)76);
        return value.toL();
    }

    public boolean getState(String key) {
        Data value = this.get(key, (byte)76);
        return value.toL() > 0;
    }

    public int getList(String keys, Data data) {
        int off = 0;
        boolean len = false;
        int i = 0;
        int j = 0;
        int ls = keys.length();
        if (keys.charAt(0) == '(') {
            ++i;
            --ls;
        }
        while (i < ls) {
            String key;
            j = keys.indexOf(44, i);
            if (j < 0) {
                j = ls;
            }
            char type = (key = keys.substring(i, j)).charAt(1) == ':' ? (char)key.charAt(0) : (char)'F';
            int status = this.get(key, data, off, 1);
            if (status >= 0) {
                off += Data.getBPS((char)type);
            }
            i = j + 1;
        }
        return off;
    }

    public boolean isSet(String list, String key, int mask) {
        int kmask = Parser.mask((String)list, (String)key, (int)0);
        return (mask & kmask) != 0;
    }

    public byte getDataType() {
        return CoreFactory.getDataType(this.halo.impl);
    }

    public static int getFormats(String formats) {
        char fm = formats.charAt(0);
        char ft = formats.charAt(1);
        int fmt = 0;
        if (ft == 'I') {
            fmt = 0;
        } else if (ft == 'B') {
            fmt = 1;
        } else if (ft == 'N') {
            fmt = 2;
        } else if (ft == 'P') {
            fmt = 3;
        } else if (ft == 'L') {
            fmt = 4;
        } else if (ft == 'X') {
            fmt = 5;
        } else if (ft == 'F') {
            fmt = 6;
        } else if (ft == 'D') {
            fmt = 7;
        }
        if (fm == 'C') {
            fmt |= 8;
        }
        return fmt;
    }

    public static int getFormats(String fmt1, String fmt2) {
        return Core.getFormats(fmt1) << 0 | Core.getFormats(fmt2) << 8;
    }

    public static int getFormats(String fmt1, String fmt2, String fmt3) {
        return Core.getFormats(fmt1) << 0 | Core.getFormats(fmt2) << 8 | Core.getFormats(fmt3) << 16;
    }

    public int getFormatBits(int fmts, int n) {
        int fmt = fmts >> (n - 1) * 8 & 0xFF;
        int bps = 1;
        if ((fmt & 8) != 0) {
            bps = 2;
            fmt &= 7;
        }
        if (fmt == 0) {
            bps *= 16;
        } else if (fmt == 1) {
            bps *= 8;
        } else if (fmt == 2) {
            bps *= 4;
        } else if (fmt == 3) {
            bps *= 1;
        } else if (fmt == 4) {
            bps *= 32;
        } else if (fmt == 5) {
            bps *= 64;
        } else if (fmt == 6) {
            bps *= 32;
        } else if (fmt == 7) {
            bps *= 64;
        }
        return bps;
    }

    public int getFormatBytes(int fmts, int n) {
        int byps = this.getFormatBits(fmts, n) >> 3;
        return byps <= 0 ? 1 : byps;
    }

    public int getFormatBytes(int n) {
        return this.getFormatBytes(this.halo.fmts, n);
    }

    public int getFormatBits(int n) {
        return this.getFormatBits(this.halo.fmts, n);
    }

    public int getFormatMode(int fmts, int n) {
        int fmt = fmts >> (n - 1) * 8 & 0xFF;
        int spa = (fmt & 8) != 0 ? 2 : 1;
        return spa;
    }

    public int getFormatMode(int n) {
        return this.getFormatMode(this.halo.fmts, n);
    }

    public int setFormats(String fmt1, String fmt2) {
        this.halo.fmts = Core.getFormats(fmt1, fmt2);
        return this.halo.fmts;
    }

    public int setSCID(int index) {
        this.halo.scid = index;
        return this.halo.scid;
    }

    public int setMCID(int index) {
        this.halo.mcid = index;
        return this.halo.mcid;
    }

    public int setTraceMode(int mode) {
        this.halo.flgs |= mode << 24;
        return this.halo.flgs;
    }

    public int getTraceData(int addr) {
        return 0;
    }

    public void getVars(String list) {
    }

    public void putVars(String list) {
    }

    public void upDate(String list) {
    }

    public int load(CoreComponent.Stream si, DataFile df) {
        if (this.halo.impl > 0) {
            long lbuf = CoreNative.loadStreamBuffer(si.handle);
            int bytes = CoreNative.loadStreamAvail(si.handle);
            int status = df.read(lbuf, 0, bytes);
            if (df.getFormatType() == 70 && this.halo.impl >= 5) {
                CoreNative.fp2fptx(lbuf, status);
            }
            return CoreNative.loadStreamStatus(si.handle, status);
        }
        return si.load(df);
    }

    public int unload(CoreComponent.Stream so, DataFile df) {
        if (this.halo.impl > 0) {
            long lbuf = CoreNative.unloadStreamBuffer(so.handle);
            int bytes = CoreNative.unloadStreamAvail(so.handle);
            if (df.getFormatType() == 70 && this.halo.impl >= 5) {
                CoreNative.fptx2fp(lbuf, bytes);
            }
            int status = df.write(lbuf, 0, bytes);
            return CoreNative.unloadStreamStatus(so.handle, status);
        }
        return so.unload(df);
    }

    public class HALO {
        public int sys;
        public int dec;
        public int gain;
        public int rate;
        public int ratio;
        public int frame;
        public int freq;
        public int flag;
        public int user0;
        public int user1;
        public int user2;
        public int user3;
        public int user4;
        public int user5;
        public int user6;
        public int user7;
        public int func;
        public int fmts;
        public int flow;
        public int impl;
        public int flgs;
        public int psize;
        public int status;
        public int scid;
        public int mcid;
        public int ncvar;
        public int name1;
        public int name2;
        public int state;
        public int vbpr;
        public int ldum2;
        public int ldum3;
        public long config;
        public long setkey;
        public long getkey;
        public long init;
        public long work;
        public long free;
        public long set;
        public long get;
        public long open;
        public long process;
        public long close;
    }
}

