/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import java.util.Map;
import nxm.ice.lib.FileIO;
import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.NetIO;
import nxm.ice.lib.SDDSPacket;
import nxm.ice.lib.VRTPacket;
import nxm.ice.prim.sourcepic;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.libm.Add;
import nxm.sys.libm.Fft;
import nxm.sys.libm.Multiply;
import nxm.sys.libm.Noop;
import nxm.sys.libm.Window;

public class Archiver
extends DataFile {
    public static final String propertyList = "Func,Multi,MaxLines,MaxLineSize,Channel,Channels,Cleanup";
    public static final String functionList = "Normal,ICEUnpack,SDDSUnpack,IceDemux,RawMulti,ICEMulti,SDDSMulti,VRTMulti";
    public static final int NORMAL = 0;
    public static final int ICEUNPACK = 1;
    public static final int SDDSUNPACK = 2;
    public static final int ICEDEMUX = 3;
    public static final int RAWMULTI = 4;
    public static final int ICEMULTI = 5;
    public static final int SDDSMULTI = 6;
    public static final int VRTMULTI = 7;
    public static final int NIO = 4;
    public static final int SDDSBUFSZ = 0x110000;
    public static final int ICEBUFSZ = 65536;
    public static final int MAXNIOBUF = 8256;
    public static final int RAWMULTISZ = 131072;
    private sourcepic sp;
    private NetIO nio;
    private ToC toc;
    private PSD psd;
    private KeyVector channels;
    private Channel channel;
    private int multi = 0;
    private int nchan = 0;
    private int func = 0;
    private int sock = 0;
    private double maxLineSize = 1.073741824E9;
    private int maxLines = 0;
    private DataFile dfSuper;
    private String aaux;
    private String aaux1;
    private String aaux2;
    private Parser auxes;
    private int naux = 0;
    private int headerLength = 0;
    private boolean netio;
    private long niobufp;
    private long niobuft;
    private SDDSPacket spkh;
    private VRTPacket vpkh;
    private ICEPacket ipkh;
    private Time stime;
    private int seqNext = 0;
    private int[] seqNextChn;
    private double niodelayfactor = 0.0;
    private long maxlen = 0L;
    private int pktlen = 0;
    private int pktflg = 0;
    private int pktelem;
    private int nfft = 8192;
    private int navg = 16;
    private double psdr = 1.0;
    private int ncpa = 1;
    private String event = "";
    private int tcmode;
    private boolean needTimeUpdate;
    private boolean needCloseOut;
    private boolean needCleanUp;
    private int ctxi;
    private int ctxm;
    private int nioFlg = 0;
    private int tocr = 1;
    private int eventCnt = 0;
    private String gpsfn;
    byte[] buffer = new byte[8];

    public Archiver(sourcepic sp) {
        this.sp = sp;
        this.dfSuper = this;
        this.tcmode = sp.getTCMode();
    }

    public Archiver() {
        this.dfSuper = this;
    }

    public int getMulti() {
        return this.multi;
    }

    public String getFunc() {
        return Parser.get((String)functionList, (int)this.func, (int)-1);
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public double getMaxLineSize() {
        return this.maxLineSize;
    }

    public String getEvent() {
        return this.event;
    }

    public void setMulti(int channels) {
        this.multi = channels;
    }

    public void setNChan(int channels) {
        this.nchan = channels;
    }

    public void setFunc(String function) {
        this.func = Parser.find((String)functionList, (String)function, (int)this.func, (int)-1);
    }

    public void setMaxLines(int lines) {
        this.maxLines = lines;
    }

    public void setMaxLineSize(double bytes) {
        this.maxLineSize = bytes;
    }

    public void setEvent(String str) {
        this.event = str;
        this.needCloseOut = true;
    }

    public void setCleanup(String str) {
        this.needCleanUp = true;
    }

    public void setThrottle(double rate) {
        double drate = 1.0 / this.getDelta() * this.getBPE();
        if (this.multi > 0) {
            drate *= (double)this.multi;
        }
        if (this.nchan > 0) {
            drate *= (double)this.nchan;
        }
        drate *= 1.0E-6;
        drate = rate > 0.0 ? rate : (drate *= -rate);
        this.niodelayfactor = rate == 0.0 || drate == 0.0 ? 0.0 : 1.0 / drate;
    }

    public boolean open() {
        Channel c;
        String pfname;
        String fname = this.fn.getFullName();
        this.netio = fname.startsWith("udp:") || fname.startsWith("stp:");
        String tfname = this.netio ? "network_toc" : this.fn.getRoot() + "_toc";
        String string = pfname = this.netio ? "network_psd" : this.fn.getRoot() + "_psd";
        if (this.netio) {
            this.flags &= 0xFFFFFF7F;
        }
        this.isInput = (this.flags & 1) != 0;
        this.isOutput = (this.flags & 2) != 0;
        Object qual = this.getQualifier("FUNC");
        if (qual != null) {
            this.setFunc((String)qual);
        }
        if ((qual = this.getQualifier("MULTI")) != null) {
            this.setMulti(Convert.o2l((Object)qual));
        }
        if ((qual = this.getQualifier("THROTTLE")) != null) {
            this.setThrottle(Convert.o2d((Object)qual));
        }
        if ((qual = this.getQualifier("MAXLEN")) != null) {
            this.maxlen = Convert.o2x((Object)qual);
        }
        if ((qual = this.getQualifier("PKTLEN")) != null) {
            this.pktlen = Convert.o2l((Object)qual);
        }
        if ((qual = this.getQualifier("PKTFLG")) != null) {
            this.pktflg = Convert.o2l((Object)qual);
        }
        if ((qual = this.getQualifier("NFFT")) != null) {
            this.nfft = Convert.o2l((Object)qual);
        }
        if ((qual = this.getQualifier("NAVG")) != null) {
            this.navg = Convert.o2l((Object)qual);
        }
        if ((qual = this.getQualifier("PSDR")) != null) {
            this.psdr = Convert.o2d((Object)qual);
        }
        if ((qual = this.getQualifier("NCPA")) != null) {
            this.ncpa = Convert.o2l((Object)qual);
        }
        if ((qual = this.getQualifier("NIOTHR")) != null) {
            this.nioFlg = NetIO.THREAD;
        }
        if ((qual = this.getQualifier("TOCR")) != null) {
            this.tocr = Convert.o2l((Object)qual);
        }
        if ((qual = this.getQualifier("GPS")) != null) {
            this.gpsfn = (String)qual;
        }
        this.toc = new ToC((Object)this, tfname, this.maxLines, this.maxLineSize, this.flags);
        if (this.isOutput && this.psdr > 0.0) {
            this.psd = new PSD(this, pfname, this.nfft, this.flags);
        }
        if (this.isOutput && this.gpsfn != null && this.gpsfn.length() > 0 && !this.gpsfn.equalsIgnoreCase("NONE") && this.toc != null) {
            Table gpst = null;
            TextFile tf = new TextFile(this.gpsfn);
            if (tf.exists()) {
                gpst = new Table(tf);
            }
            if (gpst != null) {
                this.toc.df.keywords.put("GPS", (Object)gpst.toString());
            } else {
                this.M.warning((CharSequence)("Could not open GPS file=" + this.gpsfn + " for archive=" + this.getURL()));
                this.gpsfn = null;
            }
        } else {
            this.gpsfn = null;
        }
        qual = this.getQualifier("TOP");
        if (qual != null) {
            this.setTop(Convert.o2d((Object)qual));
        }
        if ((qual = this.getQualifier("DUR")) != null) {
            this.setDur(Convert.o2d((Object)qual));
        }
        if ((qual = this.getQualifier("EVENT")) != null) {
            this.setEvent(Convert.o2s((Object)qual));
        }
        this.ipkh = (ICEPacket)this.pkh;
        if (this.func >= 4) {
            if (this.pkh == null) {
                this.M.error("Must use /APACKET=ICE for NetIO options");
            }
            this.nio = new NetIO(true);
            this.sock = this.nio.nioOpen(this.fn.getFullName(), this.multi, this.nioFlg);
            this.niobufp = this.nio.nioAlloc(8256);
            if (this.pktlen == 0) {
                this.pktlen = this.ipkh.getSize() * this.ipkh.getBPA();
            }
            this.pktelem = this.pktlen / this.ipkh.getBPA();
            if (this.func == 5) {
                this.ipkh = new ICEPacket(this.getFormat(), this.pktelem, this.pktflg);
            }
            if (this.func == 6) {
                this.spkh = new SDDSPacket(this.getFormat(), 2);
            }
            if (this.func == 7) {
                this.vpkh = new VRTPacket(this.getFormat(), this.pktelem, this.pktflg);
            }
            if (this.func == 6) {
                this.spkh.setDelta(this.getDelta());
            }
            if (this.func == 7) {
                int rate = (int)(1.0 / this.getXDelta() + 0.5);
                this.vpkh.createContextFor(1, rate, 0, 0);
                this.ctxm = rate / this.pktelem;
            }
            this.stime = new Time();
            this.isOpen = this.sock > 0;
            this.headerLength = this.func == 7 ? this.vpkh.getHeaderLength() : 64;
            this.seqNext = 0;
        } else if (this.func == 4) {
            super.open();
            this.offset = 0.0;
            String curl = this.getURL().replace(".tmp", "");
            this.channels = new KeyVector(this.nchan);
            for (int m = 0; m < this.nchan; ++m) {
                c = new Channel(this, curl, m);
                c.open(m);
                this.channels.put(m, "CHAN_" + m, (Object)c);
            }
            this.isOpen = true;
        } else if (this.func == 1) {
            this.nio = new NetIO(true);
            this.sock = this.nio.nioOpen(this.fn.getFullName(), 1, 0);
            this.isOpen = this.sock > 0;
        } else if (this.multi <= 0) {
            this.channel = new Channel(this, this.multi);
            this.channel.tocr.setFreq(this.getChannelFreq());
            this.channel.tocr.setTime(this.getChannelTime().getSec());
            this.channel.open(-1);
            if (this.multi == 0) {
                super.open();
            } else {
                this.isOpen = this.channel.df.isOpen;
            }
            this.needTimeUpdate = this.tcmode > 0;
        } else {
            this.channels = new KeyVector(this.multi);
            for (int i = 0; i < this.multi; ++i) {
                c = new Channel(this, i);
                this.channels.put(i, "CHAN_" + i, (Object)c);
            }
            super.open();
        }
        int maxChan = Math.max(1, Math.max(this.multi, this.nchan));
        this.seqNextChn = new int[maxChan];
        if (this.ipkh != null) {
            this.ipkh.setTC(this.tcmode, 0, 0.0, 0.0, 0.0);
        }
        this.needCloseOut = false;
        return this.isOpen;
    }

    public void flush() {
        if (!this.isOutput || !this.isOpen) {
            return;
        }
        if (this.nio == null) {
            if (this.func != 4) {
                if (this.multi <= 0) {
                    this.channel.flush();
                } else {
                    for (int i = 0; i < this.multi; ++i) {
                        this.getChannel(i).flush();
                    }
                }
            }
            if (this.multi == 0) {
                super.flush();
            }
        }
        if (this.toc != null) {
            this.toc.flush();
        }
        if (this.psd != null) {
            this.psd.flush();
        }
    }

    public void close() {
        if (this.nio != null) {
            this.nio.nioClose(this.sock);
            this.nio.nioFree(this.niobufp);
        } else {
            if (this.func == 4) {
                for (int i = 0; i < this.nchan; ++i) {
                    this.getChannel(i).close();
                }
            } else if (this.multi <= 0) {
                this.channel.close();
            } else {
                for (int i = 0; i < this.multi; ++i) {
                    this.getChannel(i).close();
                }
            }
            if (this.multi == 0) {
                super.close();
            }
        }
        if (this.toc != null) {
            this.toc.close();
            if (this.needCleanUp) {
                this.toc.df.erase(true);
            }
        }
        if (this.psd != null) {
            this.psd.close();
            if (this.needCleanUp) {
                this.psd.df.erase(true);
            }
        }
    }

    public void setPktHeader(ICEPacket icepkh) {
        if (this.func != 5) {
            this.ipkh.copyFrom(icepkh);
        } else {
            ((ICEPacket)this.pkh).copyFrom(icepkh);
        }
    }

    public int read(long lbuf, byte[] buf, int boff, int bytes, int chan) {
        int stat = 0;
        if (lbuf != 0L) {
            stat = this.read(lbuf, boff, bytes);
        } else if (buf != null) {
            stat = this.read(buf, boff, bytes);
        }
        this.channel.bytes += (double)stat;
        return stat;
    }

    public int write(long lbuf, int boff, int bytes, int chan) {
        return this.write(lbuf, null, boff, bytes, chan);
    }

    public int write(long lbuf, byte[] buf, int boff, int bytes, int chan) {
        int stat = 0;
        if (this.nio != null) {
            int niodelay = (int)(this.niodelayfactor * (double)bytes);
            int ic = chan;
            if (ic < 0) {
                ic = 0;
            }
            if (this.ncpa > 1) {
                ic /= this.ncpa;
            }
            if (this.func == 5) {
                ICEPacket jpkh = (ICEPacket)this.pkh;
                this.ipkh.setCount(this.seqNextChn[ic]);
                this.ipkh.setChannel(chan + 1);
                this.ipkh.setTC(jpkh);
                double delta = jpkh.getUserDataD(1);
                if (delta > 0.0) {
                    this.ipkh.setUserData(delta, 1);
                }
                if (chan == -2) {
                    Native.ja2p((Object)this.ipkh.buf, (int)0, (long)this.niobufp, (int)0, (int)this.headerLength);
                    this.nio.nioSendBank(this.sock, this.nchan, this.ncpa, this.niobufp, this.headerLength, this.pktlen, lbuf + (long)boff, bytes, 0);
                    this.ipkh.upCount(bytes / this.pktlen / (this.nchan / this.ncpa));
                } else {
                    for (int i = 0; i < bytes; i += this.pktlen) {
                        if (buf != null) {
                            Native.ja2p((Object)this.ipkh.buf, (int)0, (long)this.niobufp, (int)0, (int)this.headerLength);
                            Native.ja2p((Object)buf, (int)(boff + i), (long)this.niobufp, (int)this.headerLength, (int)this.pktlen);
                            this.nio.nioSend(this.sock, ic, this.niobufp, this.headerLength + this.pktlen, i == 0 ? niodelay : 0);
                        } else if (boff >= this.headerLength) {
                            Native.ja2p((Object)this.ipkh.buf, (int)0, (long)(lbuf + (long)boff + (long)i), (int)(-this.headerLength), (int)this.headerLength);
                            this.nio.nioSend(this.sock, ic, lbuf + (long)boff + (long)i - (long)this.headerLength, this.headerLength + this.pktlen, i == 0 ? niodelay : 0);
                        } else {
                            Native.ja2p((Object)this.ipkh.buf, (int)0, (long)this.niobufp, (int)0, (int)this.headerLength);
                            Native.p2p((long)lbuf, (int)(boff + i), (long)this.niobufp, (int)this.headerLength, (int)this.pktlen);
                            this.nio.nioSend(this.sock, ic, this.niobufp, this.headerLength + this.pktlen, i == 0 ? niodelay : 0);
                        }
                        this.ipkh.upCount();
                        if (bytes == this.pktlen) continue;
                        this.ipkh.decTCO(this.pktelem);
                    }
                }
                this.seqNextChn[ic] = this.ipkh.getCount();
            } else if (this.func == 6) {
                double delta = this.ipkh.getUserDataD(1);
                if (delta > 0.0) {
                    this.spkh.setDelta(delta);
                } else {
                    delta = this.getDelta();
                }
                this.ipkh.getTC(this.stime, 0.0, delta);
                if (this.ipkh.getTCStatus() > 0) {
                    this.spkh.setTC(0, delta, this.stime.getWSec(), this.stime.getFSec());
                }
                this.spkh.setCount(this.seqNextChn[ic]);
                niodelay = (int)(this.niodelayfactor * 1024.0);
                for (int i = 0; i < bytes; i += 1024) {
                    Native.ja2p((Object)this.spkh.buf, (int)0, (long)this.niobufp, (int)0, (int)this.headerLength);
                    if (buf != null) {
                        Native.ja2p((Object)buf, (int)(boff + i), (long)this.niobufp, (int)this.headerLength, (int)1024);
                    } else {
                        Native.p2p((long)lbuf, (int)(boff + i), (long)this.niobufp, (int)this.headerLength, (int)1024);
                    }
                    this.nio.nioSend(this.sock, ic, this.niobufp + 8L, 1080, niodelay);
                    if (i == 0) {
                        this.spkh.setTC(0, 0.0, 0.0, 0.0);
                    }
                    this.spkh.upCount();
                }
                this.seqNextChn[ic] = this.spkh.getCount();
            } else if (this.func == 7) {
                for (int i = 0; i < bytes; i += this.pktlen) {
                    if (this.ctxi == 0 && this.vpkh.cbuf != null) {
                        int lc = this.vpkh.ctx2pkt(this.niobufp);
                        this.nio.nioSend(this.sock, ic, this.niobufp, lc, 0);
                    }
                    Native.ja2p((Object)this.vpkh.buf, (int)0, (long)this.niobufp, (int)0, (int)(this.headerLength - 4));
                    if (buf != null) {
                        Native.ja2p((Object)buf, (int)(boff + i), (long)this.niobufp, (int)(this.headerLength - 4), (int)this.pktlen);
                    } else {
                        Native.p2p((long)lbuf, (int)(boff + i), (long)this.niobufp, (int)(this.headerLength - 4), (int)this.pktlen);
                    }
                    Native.ja2p((Object)this.vpkh.buf, (int)(this.headerLength - 4), (long)this.niobufp, (int)(this.headerLength + this.pktlen - 4), (int)4);
                    this.nio.nioSend(this.sock, ic, this.niobufp, this.headerLength + this.pktlen, niodelay);
                    this.vpkh.upCount();
                    if (++this.ctxi < this.ctxm) continue;
                    this.ctxi = 0;
                }
            } else if (this.func == 1) {
                for (int i = 0; i < bytes; i += this.pktlen) {
                    this.nio.nioSend(this.sock, ic, lbuf + (long)i, this.pktlen, i == 0 ? niodelay : 0);
                }
            }
        } else if (this.func == 2 && chan < 0) {
            int ndo = Math.min(bytes, 1088);
            int bend = boff + bytes;
            while (boff < bend) {
                chan = this.findSDDSChannel(lbuf, boff, bytes);
                if (chan < 0) {
                    this.M.error("Out of archive channels");
                }
                stat += this.write(lbuf, boff, ndo, chan);
                boff += ndo;
            }
        } else if (this.func == 3 && chan < 0) {
            int ndo = 1024;
            int bend = boff + bytes;
            while (boff < bend) {
                chan = this.findDemuxChannel(lbuf, boff, bytes);
                stat += this.write(lbuf, boff, ndo, chan);
                boff += ndo;
            }
        } else if (this.func == 4) {
            int cbytes = (int)(this.maxlen <= 0L || this.offset + (double)bytes <= (double)this.maxlen ? (double)bytes : (double)this.maxlen - this.offset);
            if (cbytes > 0) {
                int step = this.getFrameSize() * this.bpa;
                for (int m = 0; m < cbytes; m += step) {
                    Channel c = this.getChannel(this.seqNext);
                    Native.p2p((long)lbuf, (int)m, (long)c.lbuf, (int)c.inbuf, (int)step);
                    c.inbuf += step;
                    if (c.inbuf + step > 131072) {
                        c.df.write(c.lbuf, 0, c.inbuf);
                        c.inbuf = 0;
                    }
                    this.seqNext = (this.seqNext + 1) % this.nchan;
                }
                this.offset += (double)cbytes;
                stat = cbytes;
            }
        } else if (this.multi == 0) {
            if (lbuf != 0L) {
                stat = this.write(lbuf, boff, bytes);
            } else if (buf != null) {
                stat = this.write(buf, boff, bytes);
            }
            if (this.psd != null) {
                this.psd.proc(lbuf, buf, boff, bytes);
            }
            this.channel.bytes += (double)stat;
        } else {
            if (chan < 0 && this.multi == 1) {
                chan = 0;
            }
            Channel c = this.getChannel(chan);
            if (this.needCloseOut) {
                c.close();
                this.needCloseOut = false;
            }
            if (!c.isOpen) {
                int tocoff;
                Time t = this.getChannelTime();
                this.needTimeUpdate = this.tcmode > 0;
                int n = tocoff = this.multi > 1 ? chan : -1;
                if (this.func == 2) {
                    t = SDDSPacket.getTC(null, boff, lbuf);
                }
                c.tocr.setFreq(this.getChannelFreq());
                c.tocr.setTime(t);
                c.tocr.setEvent(this.event);
                c.time.fromTime(t);
                c.open(tocoff);
                if (this.func == 2) {
                    c.df.keywords.putMain("PACKET", "SDDS/ICE");
                }
            }
            if (this.needTimeUpdate) {
                ICEPacket jpkh;
                ICEPacket iCEPacket = this.ipkh != null ? this.ipkh : (jpkh = this.sp != null ? this.sp.getAPkt() : null);
                if (jpkh != null && jpkh.getTCStatus() > 0) {
                    Time t = c.time;
                    double tcoff = c.df.getOffset();
                    jpkh.getTC(t, -tcoff, this.getXDelta());
                    c.tocr.setTime(t);
                    if (this.toc != null) {
                        this.toc.df.write(c.tocr.dtoc, (double)this.toc.offset, 1);
                    }
                    this.setTimeNicely(c.df, t);
                    this.needTimeUpdate = false;
                }
            }
            if (c.buf != null) {
                Native.p2ja((long)lbuf, (int)boff, (Object)c.buf, (int)c.inbuf, (int)bytes);
                c.inbuf += bytes;
                if (c.inbuf >= c.buf.length) {
                    c.df.write(c.buf, 0, c.inbuf);
                    c.inbuf = 0;
                }
                stat = bytes;
            } else if (lbuf != 0L) {
                stat = c.df.write(lbuf, boff, bytes);
            } else if (buf != null) {
                stat = c.df.write(buf, boff, bytes);
            }
            if (this.psd != null) {
                this.psd.proc(lbuf, buf, boff, bytes);
            }
            c.bytes += (double)stat;
            if (this.maxLineSize > 0.0 && c.bytes >= this.maxLineSize) {
                c.close();
            }
            c.hasNewData = true;
        }
        return stat;
    }

    public void addEventKey(String key, double value) {
        if (!this.isOutput || this.sp == null || this.toc == null || this.toc.df == null || !this.toc.df.isOpen) {
            return;
        }
        if (this.eventCnt == 0 && this.seek() == 0.0) {
            return;
        }
        ++this.eventCnt;
        this.toc.df.keywords.put("EVENTS", (Object)this.eventCnt);
        this.toc.df.keywords.add("EVENT" + this.eventCnt, (Object)("{TIME=" + this.sp.getTime().getSec() + "," + key + "=" + value + "}"));
    }

    public static Archiver openForExport(Midas M, String path, byte[] hdr, int dir) {
        Archiver ha = new Archiver();
        int flags = dir > 0 ? 3 | 8 : 1;
        boolean validHeader = new String(hdr, 0, 4).equals("BLUE");
        if (dir <= 0 || !validHeader) {
            ha.init((MidasReference)M, path);
        } else {
            ha.init(M, path, hdr, flags);
        }
        ha.open(flags | 0x20);
        ha.setMaxLines(ha.toc.nsf);
        ha.setMaxLineSize(ha.toc.lineSize);
        if (dir > 0 && validHeader) {
            double dstart = Convert.unpackD((byte[])hdr, (int)32);
            double dsize = Convert.unpackD((byte[])hdr, (int)40);
            long tbytes = (long)(dstart + dsize);
            ha.toc.topLength = (long)dsize;
        }
        return ha;
    }

    public long getExportSize() {
        DataFile df = this.channel.df;
        long bytes = 512L;
        bytes = this.toc.topLength > 0L ? (bytes += this.toc.topLength) : (long)((double)bytes + this.getLengthBytes());
        return bytes;
    }

    public int readExport(byte[] buf, long offset, int bytes) {
        if (offset == 0L) {
            DataFile df = this.channel.df;
            DataFile dfo = new DataFile((MidasReference)this.M, (Object)"NULL", "1000", df.getFormat(), 2);
            dfo.setXUnits(df.getXUnits());
            dfo.setXDelta(df.getXDelta());
            dfo.setDataSize((double)(this.getExportSize() - 512L));
            Time tc = df.getTime();
            if (this.toc.topIndex != 0L) {
                tc.addSec(df.getXDelta() * (double)this.toc.topIndex / this.getBPE());
            }
            dfo.setTime(tc);
            System.arraycopy(dfo.hb, 0, buf, 0, 512);
            return 512;
        }
        long doff = this.toc.readOffset(offset - 512L);
        if (this.toc.isf != this.channel.offset) {
            this.channel.open(this.toc.isf);
        }
        this.channel.df.io.seek(doff);
        this.channel.df.io.read(buf, 0, bytes);
        return bytes;
    }

    public int writeExport(byte[] buf, int bytes) {
        return this.write(0L, buf, 0, bytes, 0);
    }

    public ToC getToC() {
        return this.toc;
    }

    public PSD getPSD() {
        return this.psd;
    }

    public double getLengthBytes() {
        double len = this.multi < 0 ? (double)this.toc.size * this.toc.lineSize : this.getDataSize();
        return len;
    }

    public double getLength() {
        double len = this.getLengthBytes() / this.getBPE();
        return len * this.getDelta();
    }

    public double getOffset() {
        double off = this.multi < 0 ? (double)this.channel.offset * this.toc.lineSize / this.getBPE() + this.channel.df.getOffset() : super.getOffset();
        return off;
    }

    public void setAAux(String aux) {
        this.naux = 0;
        if (aux == null || aux.length() == 0) {
            return;
        }
        int ic = aux.indexOf("<>");
        if (ic > 0) {
            int i1 = Convert.s2l((String)aux.substring(0, ic));
            int i2 = Convert.s2l((String)aux.substring(ic + 2));
            aux = "" + i1;
            for (int i = i1 + 1; i <= i2; ++i) {
                aux = aux + "|" + i;
            }
        }
        if (aux.indexOf(124) > 0) {
            this.auxes = new Parser(aux, '|');
            this.naux = this.auxes.elements();
        } else {
            this.naux = 1;
            this.aaux = aux;
        }
    }

    public void setAAux1(String aux) {
        if (aux == null || aux.length() == 0) {
            return;
        }
        this.M.deprecate((CharSequence)"AAUX1=x,AAUX2=y changed to AAUX=x|y");
        this.aaux1 = aux;
        if (this.aaux2 != null) {
            this.setAAux(this.aaux1 + "|" + this.aaux2);
        }
    }

    public void setAAux2(String aux) {
        if (aux == null || aux.length() == 0) {
            return;
        }
        this.M.deprecate((CharSequence)"AAUX1=x,AAUX2=y changed to AAUX=x|y");
        this.aaux2 = aux;
        if (this.aaux1 != null) {
            this.setAAux(this.aaux1 + "|" + this.aaux2);
        }
    }

    public double getChannelFreq() {
        if (this.sp != null) {
            return this.sp.getRfFreq() * 1000000.0 + this.sp.getFreq();
        }
        return 0.0;
    }

    public Time getChannelTime() {
        if (this.sp != null) {
            return this.sp.getTime();
        }
        return this.getTime();
    }

    public String getChannelFormat() {
        if (this.sp != null) {
            return this.sp.getFormat();
        }
        return this.getFormat();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Channel getChannel(int i) {
        return this.channels != null ? (Channel)this.channels.get(i) : this.channel;
    }

    public KeyVector getChannels() {
        return this.channels;
    }

    public int findSDDSChannel(long lbuf, int boff, int bytes) {
        Native.p2ja((long)lbuf, (int)boff, (Object)this.buffer, (int)0, (int)8);
        Convert.swap4((byte[])this.buffer, (int)4, (int)1);
        int addr = Convert.unpackL((byte[])this.buffer, (int)4);
        Convert.swap2((byte[])this.buffer, (int)2, (int)1);
        short port = Convert.unpackI((byte[])this.buffer, (int)2);
        int iopen = -1;
        for (int i = 0; i < this.multi; ++i) {
            Channel c = (Channel)this.channels.get(i);
            if (c.port == port && c.addr == addr) {
                return i;
            }
            if (c.isOpen || iopen >= 0) continue;
            iopen = i;
        }
        if (iopen >= 0) {
            Channel c = (Channel)this.channels.get(iopen);
            c.port = port;
            c.tocr.setPort(port);
            c.addr = addr;
            c.tocr.setAddress(addr);
        }
        return iopen;
    }

    public int findDemuxChannel(long lbuf, int boff, int bytes) {
        Native.p2ja((long)lbuf, (int)boff, (Object)this.buffer, (int)0, (int)8);
        int chan = (this.buffer[0] & 1) + ((this.buffer[2] & 1) << 1) + ((this.buffer[4] & 1) << 2) + ((this.buffer[6] & 1) << 3);
        return chan;
    }

    public void checkChannels() {
        for (int i = 0; i < this.multi; ++i) {
            Channel c = (Channel)this.channels.get(i);
            if (c.isOpen && !c.hasNewData) {
                c.close();
            }
            c.hasNewData = false;
        }
    }

    public void discontinue() {
        if (this.multi < 0) {
            Channel c = this.getChannel(0);
            c.close();
            if (this.ipkh != null) {
                this.ipkh.setTC(this.tcmode, 0, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean isFinished() {
        return this.isOpen && this.maxlen > 0L && this.offset >= (double)this.maxlen;
    }

    public void setTop(double top) {
        if (this.toc != null) {
            this.toc.setTop(top);
        }
    }

    public void setDur(double dur) {
        if (this.toc != null) {
            this.toc.setDur(dur);
        }
    }

    public void setTime(Time time) {
        Archiver.setTimeNicely(this, time.getWSec(), time.getFSec());
    }

    public void setTimeNicely(DataFile df, Time time) {
        Archiver.setTimeNicely(df, time.getWSec(), time.getFSec());
    }

    public void setTime(double wsec, double fsec) {
        Archiver.setTimeNicely(this, wsec, fsec);
    }

    public static void setTimeNicely(DataFile df, double wsec, double fsec) {
        double timeu = 1.0E-6 * Math.floor(fsec * 1000000.0 + 0.5);
        int timep = (int)Math.floor((fsec - timeu) * 1.0E12 + 0.5);
        df.setTimeCode(wsec + timeu);
        df.keywords.putMain("TC_PREC", "" + timep + "e-12");
    }

    public static int doFunc(Object ref, String func, String fname, double ttop, double tdur, String event, String file) {
        int status = 0;
        boolean doErase = func.equals("ERASE");
        boolean doAssign = func.equals("ASSIGN");
        boolean doSelect = func.equals("SELECT");
        boolean doImport = func.equals("IMPORT");
        boolean doExport = func.equals("EXPORT");
        boolean doProtect = func.equals("PROTECT");
        boolean doUnProtect = func.equals("UNPROTECT");
        boolean allEvents = event == null || event.length() == 0 || event.equals("*");
        int flags = 3;
        ToC toc = new ToC(ref, fname + "_toc", -1, -1.0, flags);
        ToCR tocr = toc.tocr;
        for (int i = 0; i < toc.size; ++i) {
            boolean match;
            toc.read(tocr, i);
            int ckey = i + 1;
            double ctop = tocr.getTime();
            double cdur = tocr.getLength();
            String cevn = tocr.getEvent();
            boolean opened = tocr.getStatus().startsWith("OPENED");
            boolean bl = match = doAssign || allEvents || event.equals(cevn);
            if (opened) {
                cdur = toc.lineSize / ((double)Data.getBPA((String)tocr.getFormat()) * tocr.getRate());
            }
            match = ttop < 0.0 ? (match &= (double)i >= -ttop - 1.0 && (double)i < -ttop - 1.0 - tdur) : (match &= ctop + cdur >= ttop && ctop <= ttop + tdur);
            if (!match) continue;
            if (doAssign) {
                tocr.setEvent(event);
            }
            if (doProtect) {
                tocr.setStatus(opened ? "OPENED/S" : "SAVED");
            }
            if (doUnProtect) {
                tocr.setStatus("CLOSED");
            }
            if (doAssign || doProtect || doUnProtect) {
                toc.write(tocr, i);
            }
            ++status;
        }
        toc.close();
        return status;
    }

    public static String getFileAt(Object ref, String fname, double ttop, double tdur, int xfer) {
        int flags = 1;
        DataFile df = new DataFile(ref, (Object)(fname + "_toc"));
        if (!df.find(-1)) {
            return fname;
        }
        ToC toc = new ToC(ref, fname + "_toc", -1, -1.0, flags);
        if (ttop > 0.0) {
            toc.setTop(ttop);
        }
        if (tdur > 0.0) {
            toc.setDur(tdur);
        }
        int bpe = Data.getBPA((String)toc.tocr.getFormat());
        long top = toc.topIndex / (long)bpe;
        long len = toc.topLength / (long)bpe;
        top = Math.max(0L, top / (long)xfer) * (long)xfer;
        String fn = fname + "_" + toc.tocr.getKey();
        if (ttop > 0.0 && tdur > 0.0) {
            fn = fn + "(" + top + ":+" + len + ")";
        }
        return fn;
    }

    public class PSD {
        DataFile df;
        int nfft;
        int nout;
        int nrot;
        int pass;
        int itot;
        int iper;
        int spa;
        int bpe;
        String format;
        boolean cx;
        boolean isOutput;
        byte dtype;
        Fft fft;
        float[] wind;
        float[] fbuf;
        float[] fout;
        byte[] bbuf;

        public PSD(DataFile ha, String fname, int nfft, int flags) {
            double factor;
            this.format = ha.getFormat();
            this.nfft = nfft;
            this.spa = ha.getSPA();
            this.dtype = ha.getFormatType();
            this.bpe = (int)ha.getBPE();
            this.cx = this.spa == 2;
            double delx = ha.getXDelta();
            double dely = delx * (double)nfft;
            double delf = 1.0 / ((double)nfft * delx);
            this.iper = (int)(1.0 / delx / (double)Archiver.this.navg * (double)this.bpe);
            int fftf = 8;
            if (this.cx) {
                this.nout = nfft;
                fftf |= 2;
                factor = 1.0 / (double)nfft;
                this.nrot = nfft / 2 - 1;
            } else {
                this.nout = nfft / 2;
                fftf |= 0x21;
                factor = 0.5 / (double)nfft;
                this.nrot = 0;
            }
            this.fft = new Fft(nfft, fftf);
            this.wind = Window.get((String)"HANN", (int)nfft, (double)factor);
            this.fbuf = new float[this.nout * 2];
            this.fout = new float[this.nout * 2];
            this.bbuf = new byte[this.nout * 8];
            this.isOutput = ((flags &= 0xB) & 2) != 0;
            this.df = new DataFile((MidasReference)ha.M, (Object)fname, "2000", "CF", flags);
            this.df.setSubsize(this.nout);
            this.df.setXStart((double)(-this.nrot) * delf);
            this.df.setXDelta(delf);
            this.df.setXUnits(3);
            this.df.setYUnits(1);
            this.df.setYStart(0.0);
            this.df.setYDelta(1.0 / Archiver.this.psdr);
            this.df.open();
        }

        public void proc(long lbuf, byte[] buf, int boff, int bytes) {
            this.itot += bytes;
            if (this.itot < this.iper) {
                return;
            }
            this.itot = 0;
            int elem = bytes / this.bpe;
            if (elem > this.nfft) {
                elem = this.nfft;
            }
            if (lbuf != 0L) {
                buf = this.bbuf;
                boff = 0;
                int xfer = Math.min(bytes, this.nout * 8);
                Native.p2ja((long)lbuf, (int)0, (Object)buf, (int)boff, (int)xfer);
            }
            Convert.bb2ja((byte[])buf, (int)boff, (byte)this.dtype, (Object)this.fbuf, (int)0, (byte)70, (int)(elem * this.spa));
            for (int i = elem * this.spa; i < this.nout * 2; ++i) {
                this.fbuf[i] = 0.0f;
            }
            if (this.cx) {
                Multiply.CSC((float[])this.fbuf, (float[])this.wind, (float[])this.fbuf, (int)this.nfft);
            } else {
                Multiply.SSS((float[])this.fbuf, (float[])this.wind, (float[])this.fbuf, (int)this.nfft);
            }
            this.fft.work((Object)this.fbuf);
            if (this.cx) {
                this.fft.rotateCF(this.fbuf);
            }
            if (this.pass == 0) {
                Noop.CC((float[])this.fbuf, (float[])this.fout, (int)this.nout);
            } else {
                Add.CCC((float[])this.fbuf, (float[])this.fout, (float[])this.fout, (int)this.nout);
            }
            ++this.pass;
            if (Archiver.this.multi == 0 && this.pass >= Archiver.this.navg) {
                this.write();
            }
        }

        public void write(int index) {
            this.df.seek((double)index);
            this.write();
            this.df.update();
        }

        public void write() {
            Convert.ja2bb((Object)this.fout, (int)0, (byte)70, (byte[])this.bbuf, (int)0, (byte)70, (int)(this.nout * 2));
            this.df.write(this.bbuf, 0, this.nout * 8);
            this.zero();
        }

        public void zero() {
            this.pass = 0;
            this.itot = 0;
        }

        public void flush() {
            if (this.isOutput) {
                this.df.flush();
            }
        }

        public void close() {
            if (this.df.isOpen()) {
                this.df.close();
            }
        }

        public boolean isOpen() {
            return this.df.isOpen();
        }
    }

    public static class ToCR {
        Data dtoc;

        public ToCR(DataFile df) {
            this.dtoc = df.getDataBuffer(1);
        }

        public void setEvent(String event) {
            this.dtoc.packS(0, 8, event);
        }

        public void setStatus(String status) {
            this.dtoc.packS(8, 8, status);
        }

        public void setKey(short key) {
            this.dtoc.packI(16, key);
        }

        public void setPort(short port) {
            this.dtoc.packI(18, port);
        }

        public void setAddress(int addr) {
            this.dtoc.packL(20, addr);
        }

        public void setFormat(String format) {
            this.dtoc.packS(24, 8, format);
        }

        public void setRate(double rate) {
            this.dtoc.packD(32, rate);
        }

        public void setFreq(double freq) {
            this.dtoc.packD(40, freq);
        }

        public void setTime(double time) {
            this.dtoc.packD(48, time);
        }

        public void setLength(double sec) {
            this.dtoc.packD(56, sec);
        }

        public void setTime(Time time) {
            if (time != null) {
                this.setTime(time.getSec());
            }
        }

        public String getEvent() {
            return this.dtoc.unpackS(0, 8);
        }

        public String getStatus() {
            return this.dtoc.unpackS(8, 8);
        }

        public short getKey() {
            return this.dtoc.unpackI(16);
        }

        public short getPort() {
            return this.dtoc.unpackI(18);
        }

        public int getAddress() {
            return this.dtoc.unpackL(20);
        }

        public String getFormat() {
            return this.dtoc.unpackS(24, 8);
        }

        public double getRate() {
            return this.dtoc.unpackD(32);
        }

        public double getFreq() {
            return this.dtoc.unpackD(40);
        }

        public double getTime() {
            return this.dtoc.unpackD(48);
        }

        public double getLength() {
            return this.dtoc.unpackD(56);
        }
    }

    public static class ToC {
        int offset;
        int topOffset;
        DataFile df;
        ToCR tocr;
        int isf;
        int nsf;
        int size;
        boolean isInput = ((flags &= 0xB) & 1) != 0;
        boolean isOutput;
        long topIndex;
        long topLength;
        long clen;
        double lineSize;
        double topTime;

        public ToC(Object ref, String fname, int nsf, double bpsf, int flags) {
            this.isOutput = (flags & 2) != 0;
            this.df = new DataFile();
            this.df.init(ref, (Object)fname, "3000", "NH", flags);
            this.df.setSubRecords("EVNT|1A,STAT|1A,KEY|SI,PORT|SI,ADDR|4B,FORM|1A,RATE|SD,FREQ|SD,TIME|SD,LEN|SD");
            if (this.isOutput & !this.isInput) {
                this.df.keywords.put("LINES", Convert.l2o((int)nsf));
                this.df.keywords.put("LINESIZE", Convert.d2o((double)bpsf));
                this.df.keywords.put("CUROFFSET", Convert.d2o((double)0.0));
            }
            this.df.open();
            this.nsf = this.df.keywords.getL("LINES", nsf);
            bpsf = this.df.keywords.getD("LINESIZE", bpsf);
            this.offset = this.df.keywords.getL("CUROFFSET", 0);
            this.size = (int)this.df.getSize();
            this.lineSize = bpsf;
            this.tocr = new ToCR(this.df);
        }

        public void write(ToCR tocr, int offset) {
            this.df.write(tocr.dtoc, (double)offset, 1);
            this.df.update();
            if (offset >= this.size) {
                this.size = offset + 1;
                this.df.setSize((double)this.size);
            }
        }

        public void nextOffset(int offset) {
            this.offset = offset;
        }

        public int nextOffset() {
            ++this.offset;
            if (this.nsf > 0) {
                if (this.offset >= this.nsf) {
                    this.offset = 0;
                }
                while (this.offset < this.size) {
                    this.read(this.tocr, this.offset);
                    if (!this.tocr.getStatus().startsWith("SAVE")) break;
                    ++this.offset;
                    if (this.offset < this.nsf) continue;
                    this.offset = 0;
                }
            }
            this.df.keywords.put("CUROFFSET", Convert.l2o((int)this.offset));
            if (this.isOutput) {
                this.df.flush();
            }
            return this.offset;
        }

        public long readOffset(long offset) {
            int noff;
            long doff = offset + this.topIndex;
            long dper = (long)this.lineSize;
            int ioff = (int)(doff / dper);
            long joff = doff - (long)ioff * dper;
            this.isf = noff = (this.topOffset + ioff) % Math.max(1, this.size);
            return joff;
        }

        public void read(int offset) {
            this.read(this.tocr, offset);
        }

        public void read(ToCR tocr, int offset) {
            this.df.read(tocr.dtoc, (double)offset, 1);
        }

        public void flush() {
            if (this.isOutput && this.df.isOpen()) {
                this.df.flush();
            }
        }

        public void close() {
            if (this.df.isOpen()) {
                this.df.close();
            }
        }

        public boolean isOpen() {
            return this.df.isOpen();
        }

        public int size() {
            return this.size;
        }

        public double getLength() {
            double len = 0.0;
            for (int i = 0; i < this.size; ++i) {
                this.read(this.tocr, i);
                len += this.tocr.getLength();
            }
            return len;
        }

        public void setTop(double top) {
            int i = 0;
            double t = 0.0;
            double d = 1.0;
            for (i = 0; i < this.size; ++i) {
                this.read(i);
                t = this.tocr.getTime();
                d = this.tocr.getLength();
                if (t <= top && top < t + d) break;
            }
            if (i >= this.size) {
                System.out.println("Top time=" + top + " not found. Starting at 1st record.");
                i = 0;
                this.read(i);
                top = t = this.tocr.getTime();
            }
            this.topOffset = i;
            this.topIndex = (long)((top - t) * this.tocr.getRate()) * (long)Data.getBPA((String)this.tocr.getFormat());
            this.topIndex = Math.max(0L, this.topIndex);
            this.topTime = top;
            this.nextOffset(i);
            this.clen = 0L;
        }

        public void setDur(double dur) {
            this.topLength = (long)(dur * this.tocr.getRate() * (double)Data.getBPA((String)this.tocr.getFormat()));
            this.topLength = Math.max(1L, this.topLength / 0x100000L) * 0x100000L;
        }

        public double getSavedSpace() {
            double len = 0.0;
            for (int i = 0; i < this.size; ++i) {
                this.read(this.tocr, i);
                if (!this.tocr.getStatus().equals("SAVED")) continue;
                len += this.lineSize;
            }
            return len;
        }

        public double getTotalSpace() {
            return this.lineSize * (double)this.size;
        }
    }

    public class Channel {
        short port;
        int addr;
        int offset;
        double bytes;
        boolean isOpen;
        boolean hasNewData;
        byte[] buf;
        int inbuf = 0;
        long lbuf;
        DataFile df;
        Time time = new Time();
        FileName mfn;
        ToCR tocr;
        String quals;

        public Channel(DataFile df, int index) {
            this.df = df;
            this.tocr = new ToCR(((Archiver)Archiver.this).toc.df);
            this.tocr.setEvent(Archiver.this.getEvent());
            this.tocr.setStatus("");
            this.tocr.setKey((short)(index + 1));
            this.tocr.setPort((short)0);
            this.tocr.setAddress(0);
            this.tocr.setFormat(Archiver.this.getChannelFormat());
            this.tocr.setFreq(0.0);
            this.tocr.setTime(0.0);
            if (Archiver.this.func == 2) {
                this.buf = new byte[0x110000];
            }
            this.quals = Archiver.this.fn.getQualifiers();
            if (this.quals.indexOf("+APPEND") > 0) {
                this.quals = this.quals.replace("+APPEND", "|");
            } else if (this.quals.indexOf("APPEND") > 0) {
                this.quals = this.quals.replace("APPEND", "|");
            }
        }

        public Channel(DataFile dfi, String url, int index) {
            this(dfi, index);
            String cname = String.format("%s_ch_%04d", url, index);
            this.mfn = new FileName(cname);
            this.mfn.setExt("tmp");
            this.lbuf = FileIO.malloc(131072L);
            this.inbuf = 0;
            this.buf = null;
        }

        public boolean open(int offset) {
            if (this.isOpen) {
                this.close();
            }
            if (offset < 0) {
                offset = ((Archiver)Archiver.this).toc.offset;
            }
            this.tocr.setStatus("OPENED");
            this.bytes = 0.0;
            boolean stat = true;
            if (Archiver.this.multi != 0) {
                int suffix = offset + 1;
                this.tocr.setKey((short)suffix);
                String format = Archiver.this.fn.getRoot() + "_%d";
                String fname = String.format(format, suffix);
                Command ref = Archiver.this.cmd;
                if (ref == null) {
                    ref = Archiver.this.M;
                }
                if (Archiver.this.isInput) {
                    this.df = new DataFile((Object)ref, (Object)(fname + this.quals), "1000", "", Archiver.this.flags & 0xFFFFFFF7);
                }
                if (Archiver.this.isOutput) {
                    this.df = new DataFile((Object)ref, (Object)(fname + this.quals), Archiver.this.dfSuper, Archiver.this.flags & 0xFFFFFFF7);
                }
                int entry = offset;
                if (Archiver.this.naux == 1) {
                    this.df.setAux(Archiver.this.aaux);
                } else if (Archiver.this.naux > 1) {
                    this.df.setAux(Archiver.this.auxes.get(entry % Archiver.this.naux + 1));
                }
                if (this.time != null) {
                    Archiver.this.setTimeNicely(this.df, this.time);
                }
                stat = this.df.open();
            } else if (Archiver.this.func == 4) {
                Command ref = Archiver.this.cmd;
                if (ref == null) {
                    ref = Archiver.this.M;
                }
                this.df = new DataFile((Object)ref, (Object)this.mfn, "1000", Archiver.this.getFormat(), 0);
                this.df.setDetached(1);
                stat = this.df.open(130);
                this.df.setDataStart(0.0);
                this.df.setXUnits(1);
                this.df.setXDelta(Archiver.this.dfSuper.getXDelta() * (double)Archiver.this.nchan);
            }
            if (((Archiver)Archiver.this).dfSuper.isOutput) {
                this.tocr.setRate(1.0 / this.df.getXDelta());
                this.tocr.setLength(0.0);
                Archiver.this.toc.write(this.tocr, offset);
            }
            this.offset = offset;
            this.isOpen = stat;
            return stat;
        }

        public void flush() {
            if (!((Archiver)Archiver.this).dfSuper.isOutput || !this.isOpen) {
                return;
            }
            if (this.inbuf > 0) {
                if (Archiver.this.func == 4) {
                    this.df.write(this.lbuf, 0, this.inbuf, false);
                } else {
                    this.df.write(this.buf, 0, this.inbuf);
                }
                this.inbuf = 0;
            }
            if (Archiver.this.multi != 0) {
                this.df.flush();
            }
            double databytes = this.bytes;
            if (Archiver.this.func == 2) {
                databytes = this.bytes * 1024.0 / 1088.0;
            }
            this.tocr.setLength(databytes / this.df.dbpe * this.df.getDelta());
        }

        public void close() {
            if (!this.isOpen) {
                return;
            }
            this.tocr.setStatus("CLOSED");
            this.tocr.setFreq(Archiver.this.getChannelFreq());
            this.updateKeys(this.df);
            this.flush();
            if (Archiver.this.multi != 0 && this.df != Archiver.this.dfSuper) {
                this.df.close();
            } else if (Archiver.this.func == 4) {
                this.df.close();
                FileIO.mfree(this.lbuf);
            }
            if (((Archiver)Archiver.this).dfSuper.isOutput) {
                if (this.offset < ((Archiver)Archiver.this).toc.size) {
                    Archiver.this.toc.read(this.offset);
                    this.tocr.setEvent(((Archiver)Archiver.this).toc.tocr.getEvent());
                    if (((Archiver)Archiver.this).toc.tocr.getStatus().equals("OPENED/S")) {
                        this.tocr.setStatus("SAVED");
                    }
                }
                Archiver.this.toc.write(this.tocr, this.offset);
                if (Archiver.this.multi != 0 && Archiver.this.psd != null) {
                    Archiver.this.psd.write(this.offset);
                }
            }
            if (Archiver.this.multi <= 0) {
                Archiver.this.toc.nextOffset();
            }
            this.isOpen = false;
        }

        public void updateKeys(DataFile df) {
            Table akw;
            if (!Archiver.this.isOutput) {
                return;
            }
            if (Archiver.this.sp == null) {
                return;
            }
            df.keywords.put("PORT", (Object)Archiver.this.sp.getPort());
            if (Archiver.this.sp.getRfFreq() > 0.0) {
                df.keywords.put("RFFREQ", (Object)Archiver.this.sp.getRfFreq());
                df.keywords.put("RFGAIN", (Object)Archiver.this.sp.getRfGain());
            }
            if (Archiver.this.sp.isTuner()) {
                df.keywords.put("FREQ", (Object)Archiver.this.sp.getFreq());
                df.keywords.put("GAIN", (Object)Archiver.this.sp.getGain());
            }
            if ((akw = Archiver.this.sp.getArchKW()) != null) {
                df.keywords.putAll((Map)akw);
            }
        }
    }
}

