/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.Archiver;
import nxm.sys.lib.Convert;

public class ArchSFN {
    private String format;
    private String quals;
    private int indx;
    private int indx0;
    private int indxt;
    private int nsf;
    private int xfer = 1;
    private boolean legit;
    private Archiver.ToC toc;
    private Object ref;
    private double clen;
    private double flen;
    private double tlen;
    private double rate = 1.0;
    private double top;
    private double toff;
    private double dur = -1.0;

    public ArchSFN() {
    }

    public ArchSFN(Object ref, String fn, int nsf) {
        this.ref = ref;
        this.setSize(nsf);
        this.setSFN(fn);
    }

    public boolean setSFN(String fn) {
        int n;
        int j = -1;
        int k = -1;
        int p = fn.indexOf("%");
        int q = fn.indexOf("{");
        int t = fn.indexOf("(");
        if (t > 0 && (t < q || q < 0)) {
            q = t;
        }
        if (q > 0) {
            this.quals = fn.substring(q);
            fn = fn.substring(0, q);
        }
        int s = fn.lastIndexOf("/") + 1;
        char cl = '.';
        for (int i = fn.length() - 1; i > s; --i) {
            char c = fn.charAt(i);
            if (k < 0 && this.isDigit(c) && this.isDelimit(cl)) {
                k = i;
            }
            if (k > 0 && this.isDigit(c)) {
                j = i;
            }
            if (k > 0 && !this.isDigit(c)) break;
            cl = c;
        }
        int n2 = n = k < 0 || j < 0 ? 0 : k - j + 1;
        if (p >= 0) {
            this.format = fn;
            this.indx0 = 0;
            this.indx = 0;
        } else if (this.nsf == 0 && n > 0) {
            boolean lz = n > 1 && fn.charAt(j) == '0';
            String form = lz ? "%0" + n + "d" : "%d";
            this.format = fn.substring(0, j) + form + fn.substring(k + 1);
            this.indx = this.indx0 = Convert.s2l((String)fn.substring(j, k + 1));
        } else {
            this.format = fn + "_%d";
            this.indx0 = 1;
            this.indx = 1;
            this.toc = new Archiver.ToC(this.ref, fn + "_toc", this.nsf, -1.0, 65);
            if (this.toc.isOpen()) {
                this.nsf = this.toc.size();
                this.tlen = this.toc.getLength();
                this.clen = 0.0;
                this.indx = 0;
                this.nextIndex();
                if (this.toc.tocr.getRate() > 0.0) {
                    this.rate = this.toc.tocr.getRate();
                }
                System.out.println("Using TOC file=" + this.toc.df.getURL() + " entries=" + this.nsf + " time=" + this.tlen);
            } else {
                this.toc = null;
            }
        }
        this.indxt = this.indx0;
        this.legit = true;
        return this.legit;
    }

    public int nextIndex() {
        double d;
        double t;
        do {
            ++this.indx;
            if (this.nsf > 0 && this.indx - this.indx0 >= this.nsf) {
                this.indx = this.indx0;
            }
            if (this.toc == null) break;
            long cleft = (long)((this.dur - this.clen) * this.rate);
            if (this.dur > 0.0 && cleft < (long)this.xfer) {
                this.indx = this.indxt;
            }
            if (this.indx == this.indxt) {
                this.clen = 0.0;
            }
            this.toc.read(this.indx - 1);
            t = this.toc.tocr.getTime();
            d = this.toc.tocr.getLength();
        } while (this.dur > 0.0 && (t + d < this.top || t > this.top + this.dur));
        return this.indx;
    }

    public String nextSFN() {
        this.indx = this.nextIndex();
        return this.getSFN();
    }

    public String getSFN() {
        return this.getSFN(this.indx);
    }

    public String getSFN(int index) {
        String fn;
        String string = fn = this.legit ? String.format(this.format, index) : this.format;
        if (fn.startsWith("http:")) {
            fn = fn + ".tmp";
        }
        if (this.toc != null) {
            int a = 0;
            int b = 0;
            double t = this.toc.tocr.getTime();
            this.flen = this.toc.tocr.getLength();
            if (index == this.indxt) {
                this.flen -= this.toff;
            }
            this.clen += this.flen;
            if (this.toc.tocr.getRate() > 0.0) {
                this.rate = this.toc.tocr.getRate();
            }
            if (index == this.indxt && this.toff > 0.0) {
                a = this.xfer * (int)(this.toff * this.rate / (double)this.xfer);
            }
            if (this.dur > 0.0 && this.clen > this.dur) {
                b = this.xfer * (int)((this.clen - this.dur) * this.rate / (double)this.xfer);
            }
            if (a != 0 || b != 0) {
                fn = fn + "(" + a + ":-" + b + ")";
            }
        }
        if (this.quals != null) {
            fn = fn + this.quals;
        }
        return fn;
    }

    public void setTL(int xfer) {
        this.xfer = xfer;
    }

    public void setTop(double top) {
        this.top = top;
        if (top < 0.0) {
            return;
        }
        int i = 0;
        double t = 0.0;
        double d = 1.0;
        if (this.toc != null) {
            for (i = 0; i < this.nsf; ++i) {
                this.toc.read(i);
                t = this.toc.tocr.getTime();
                d = this.toc.tocr.getLength();
                if (t <= top && top < t + d) break;
            }
            if (i == this.nsf) {
                System.out.println("ArchSFN top time=" + t + " not found. Starting at 1st record.");
                i = 0;
                this.toc.read(i);
            }
            this.indx = this.indxt = i + 1;
            this.clen = 0.0;
            this.toff = top - t;
        }
    }

    public void setDur(double dur) {
        this.dur = dur;
    }

    public int getIndex() {
        return this.indx;
    }

    public void setIndex(int index) {
        this.indx = index;
    }

    public int getSize() {
        return this.nsf;
    }

    public void setLast(int index) {
        this.nsf = index - this.indx0 + 1;
    }

    public int getLast() {
        return this.nsf + this.indx0 - 1;
    }

    public void setSize(int size) {
        this.nsf = size;
    }

    public int getIndex0() {
        return this.indx0;
    }

    public void setIndex0(int index) {
        this.indx0 = index;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String form) {
        if (form != null) {
            this.format = form;
        }
    }

    public boolean isLegit() {
        return this.legit;
    }

    public int resetIndex() {
        this.indx = this.indx0;
        return this.indx;
    }

    public boolean isFirst() {
        return this.indx == this.indx0;
    }

    public boolean isTop() {
        return this.indx == this.indxt;
    }

    public int getOffset() {
        return this.indx - this.indx0;
    }

    public double getLength() {
        return this.dur > 0.0 ? this.dur : this.tlen;
    }

    public double getLengthTo(double offset) {
        return this.clen - this.flen + offset / this.rate;
    }

    public double getTimeTop() {
        return this.top;
    }

    public double getTimeDur() {
        return this.dur > 0.0 ? this.dur : this.tlen;
    }

    private boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isDelimit(char c) {
        return c == '.' || c == '-' || c == '_' || c == '/';
    }
}

