/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.dsp.prim.firkais;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class WBR
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int ONP = 1;
    public static final int NP = 2;
    public static final int BW = 64;
    public static final int IKR = 8;
    public static final int OTAP = 6;
    public static final int RTAP = 64;
    public static final int OFILT = 5;
    public static final int FILT = 32;

    public static class CORE
    extends Core {
        float fwf;
        double p;
        double dp;
        double dpinc;
        int ntap;
        int nrpt;
        float fscl;
        float lfp;
        float mfp;
        float dpi;
        float[] dpia;
        boolean updn;
        boolean bypass;
        int gain;
        CoreComponent.CxTapBuf vd;
        CoreComponent.RomF2Di rft;
        CoreCommon.CxFloat[] vi;
        CoreCommon.CxFloat[] vs;
        CoreCommon.CxFloat[] vo;

        public void setRatio(double ratio) {
            this.dp = 1.0 / ratio;
            this.ntap = 64 - 2 * CORE.d2i(CORE.ceil(2.0 * this.dp));
            this.updn = ratio > 1.0;
            this.bypass = this.dp == 1.0;
            this.dpinc = this.updn ? this.dp : ratio;
            this.putVars("dpinc");
        }

        public void setGain(double dgain) {
            double scale = CORE.pow(2.0, dgain / 6.0);
            this.fscl = CORE.d2f(scale);
            if ((double)this.gain == dgain) {
                return;
            }
            this.gain = (byte)dgain;
            this.putVars("gain,fscl");
        }

        public void genFilt() {
            int nt = this.nrpt * this.ntap;
            int joff = 64 - this.ntap;
            double fw = this.updn ? (double)this.fwf : (double)this.fwf / this.dp;
            float[] ctap = new float[nt * 2];
            firkais.generate((int)1, (double)(fw / (double)this.nrpt), (double)0.0, (double)(0.05 / (double)this.nrpt), (double)90.0, (float[])ctap, (int)nt, (boolean)false);
            int i = 0;
            for (int j = 0; j < this.ntap; ++j) {
                int k = 0;
                while (k < this.nrpt) {
                    this.rft.set(k, j + joff, ctap[i] * (float)this.nrpt);
                    ++k;
                    i += 2;
                }
            }
        }

        @Override
        public int init() {
            this.fwf = 0.9f;
            this.dp = 1.0;
            this.fscl = 1.0f;
            this.ntap = 64;
            this.nrpt = 32;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "D:RATIO")) {
                this.setRatio(value.toD());
            } else if (this.isMatch(key, "L:NTAP")) {
                this.ntap = value.toL();
            } else if (this.isMatch(key, "F:FWF")) {
                this.fwf = value.toF();
            } else if (this.isMatch(key, "D:GAIN")) {
                this.setGain(value.toD());
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:GAIN")) {
                value.fromL(this.gain);
            } else if (this.isMatch(key, "L:NTAP")) {
                value.fromL(this.ntap);
            } else if (this.isMatch(key, "D:RATIO")) {
                value.fromD(1.0 / this.dp);
            } else if (this.isMatch(key, "D:XDIO")) {
                value.fromD(this.dp);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            int i;
            this.rft = new CoreComponent.RomF2Di(5, 6, 64);
            this.vd = new CoreComponent.CxTapBuf(6, 1, 64, -1);
            this.vi = new CoreCommon.CxFloat[2];
            for (i = 0; i < 2; ++i) {
                this.vi[i] = new CoreCommon.CxFloat();
            }
            this.vo = new CoreCommon.CxFloat[2];
            for (i = 0; i < 2; ++i) {
                this.vo[i] = new CoreCommon.CxFloat();
            }
            this.vs = new CoreCommon.CxFloat[2];
            for (i = 0; i < 2; ++i) {
                this.vs[i] = new CoreCommon.CxFloat();
            }
            if (this.ntap > 64) {
                System.out.printf("Number taps=%d limited to max taps=%d for this buid\n", this.ntap, 64);
                this.ntap = 64;
            }
            this.genFilt();
            this.dpi = CORE.d2f(this.dp);
            this.p = 0.0;
            this.lfp = 0.0f;
            this.mfp = 1.0f - this.lfp;
            this.dpia = new float[2];
            for (i = 0; i < 2; ++i) {
                this.dpia[i] = this.dpi * (float)i;
            }
            this.dpi = CORE.d2f(this.dp * 0.999);
            System.out.printf("WBR dp=%f ntap=%d nrpt=%d spc=%d byp=%d\n", this.dp, this.ntap, this.nrpt, 2, this.bypass ? 1 : 0);
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            CoreCommon.CxFloat fi = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat tf = CoreCommon.CxFloat.stk();
            while (si.rok && so.wok) {
                float pp;
                boolean doout;
                boolean doin;
                float nfp = CORE.d2f(this.p);
                if (this.updn) {
                    doin = nfp < this.lfp;
                    doout = true;
                    pp = nfp;
                } else {
                    doin = true;
                    doout = nfp <= this.lfp;
                    pp = this.mfp * this.dpi;
                }
                this.lfp = nfp;
                this.mfp = 1.0f - nfp;
                this.p = CORE.frac(this.p + this.dpinc);
                if (doin) {
                    si.rdCIFA(this.vi, 2);
                    for (int k = 0; k < 2; ++k) {
                        CORE.mulfc(this.fscl, this.vi[k], this.vs[k]);
                    }
                    this.vd.loadA(this.vs, 2);
                }
                if (!doout) continue;
                for (int j = 0; j < 2; ++j) {
                    float rp = CORE.mulfp2(pp, 1) + this.dpia[j];
                    CoreCommon.CxFloat fr = CoreCommon.CxFloat.stk();
                    fr.x = 0.0f;
                    fr.y = 0.0f;
                    for (int i = 0; i < 64; ++i) {
                        float ftx;
                        CoreCommon.CxFloat fdi = CoreCommon.CxFloat.stk();
                        CoreCommon.CxFloat fdix = CoreCommon.CxFloat.stk();
                        CoreCommon.CxFloat fdiy = CoreCommon.CxFloat.stk();
                        float ft = ftx = this.rft.getrN(rp, i);
                        this.vd.get(i, fdix);
                        fdi = fdix;
                        fr.x += ft * fdi.x;
                        fr.y += ft * fdi.y;
                    }
                    this.vo[j] = fr;
                }
                so.wrCFIA(this.vo, 2);
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

