/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class UDAT
extends CoreFactory {
    public static final String pktList = "Auto,None,Noop,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
    public static final int PT_AUTO = -1;
    public static final int PT_NONE = 0;
    public static final int PT_NOOP = 1;
    public static final int PT_ICE = 2;
    public static final int PT_SDDS = 3;
    public static final int PT_VRT = 4;
    public static final int PT_VRTL = 5;
    public static final int PT_VRTW = 6;
    public static final int PT_VRTX = 7;
    public static final int PT_VRTD = 8;
    public static final String flgList = "Fill,Time,OUID,SOS,FB3,AnySID,Bypass,CTXF,xSR,xIF,xRF,xGAIN";
    public static final int PF_FILL = 0;
    public static final int PF_TIME = 1;
    public static final int PF_OUID = 2;
    public static final int PF_SOS = 3;
    public static final int PF_FB3 = 4;
    public static final int PF_ANYSID = 5;
    public static final int PF_BYPASS = 6;
    public static final int PF_CTXF = 7;
    public static final int PF_XSR = 8;
    public static final int PF_XIF = 9;
    public static final int PF_XRF = 10;
    public static final int PF_XGAIN = 11;

    public static class CORE
    extends Core {
        public static final int FLOW = 3;
        public static final int SELFPACE = 1;
        public static final int IKR = 16;
        public static final int OKR = 4;
        public static final int OFMT = 5;
        public static final int BW = 32;
        public static final int XFER = 256;
        public static final int OUID = 1068407;
        public static final int DIFI = 6971934;
        public double ctime;
        public double srate;
        public int bits;
        public int ptype;
        public int bpa;
        int pkty;
        int flags;
        int osel;
        int sid;
        int pinc;
        int cwsec;
        int nwsec;
        long cpsec;
        long npsec;
        long mpsec;
        int counts;
        int nseq;
        int swaps;
        int length;
        int ifix;
        int mfix;
        int nfix;
        int pad;
        int pstate;
        int npinc;
        int ouid;
        int pass;
        int vctx;

        public void setTime(double time) {
            time = this.ctime > 60.0 ? this.ctime : (time += this.ctime);
            this.cwsec = CORE.d2i(CORE.floor(time));
            this.cpsec = CORE.d2l(CORE.frac(time) * 1.0E12);
            this.nwsec = 0;
            this.npsec = 0L;
            this.putVars("cwsec,cpsec,nwsec,npsec");
        }

        public void startup(double time) {
            this.setTime(time);
            this.poll();
            this.pkty = this.ptype;
            this.putVars("pkty");
        }

        public void setPhaseInc(double rate) {
            this.npinc = CORE.d2i(CORE.round(1.0E12 / rate / (double)this.bpa * 4.0));
        }

        public boolean isAsync() {
            return this.ptype != 1 && CORE.getBit(this.flags, 1);
        }

        public double getRate() {
            return this.srate;
        }

        public boolean getCTXF() {
            return CORE.getBit(this.flags, 7);
        }

        @Override
        public int init() {
            this.pkty = 0;
            this.ptype = 1;
            this.flags = 0;
            this.sid = -1;
            this.ctime = 0.0;
            this.srate = 1.0E7;
            this.bits = -16;
            this.pad = 0;
            this.ouid = 0;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "S:PT")) {
                this.ptype = value.toItem(UDAT.pktList);
            } else if (this.isMatch(key, "L:PKTY")) {
                this.ptype = value.toL();
            } else if (this.isMatch(key, "L:SID")) {
                this.sid = value.toL();
            } else if (this.isMatch(key, "L:OSEL")) {
                this.osel = value.toL();
            } else if (this.isMatch(key, "L:OUID")) {
                this.ouid = value.toL();
            } else if (this.isMatch(key, "L:BITS")) {
                this.bits = value.toL();
            } else if (this.isMatch(key, "L:PAD")) {
                this.pad = value.toL();
            } else if (this.isMatch(key, "D:CTIME")) {
                this.ctime = value.toD();
            } else if (this.isMatch(key, "D:SRATE")) {
                this.srate = value.toD();
            } else if (this.isMatch(key, "L:VCTX")) {
                this.vctx = value.toL();
            } else if (this.isMatch(key, "L:FLAGS")) {
                this.flags = value.toL();
            } else if (this.isMatch(key, "S:FLAGS")) {
                this.flags = value.toMask(UDAT.flgList);
            } else if (this.isMatch(key, "D:NEXTSRATE")) {
                this.setPhaseInc(value.toD());
                this.putVars("npinc");
            } else if (this.isMatch(key, "D:STARTUP")) {
                this.startup(value.toD());
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:PKTY")) {
                value.fromL(this.ptype);
            } else if (this.isMatch(key, "L:SID")) {
                value.fromL(this.sid);
            } else if (this.isMatch(key, "L:FLAGS")) {
                value.fromL(this.flags);
            } else if (this.isMatch(key, "D:STARTUP")) {
                value.fromD(this.ctime);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.sid &= 0xFFFF;
            this.bpa = this.bits < 0 ? -this.bits * 2 / 8 : this.bits / 8;
            this.nseq = 0;
            this.counts = 0;
            this.length = 0;
            this.swaps = 0;
            this.nwsec = 0;
            this.npsec = 0L;
            this.mpsec = CORE.d2l(1.0E12);
            this.pstate = 0;
            if (this.ptype == 1) {
                this.bpa = 4;
                this.pkty = this.ptype;
            }
            if (this.ptype == 8) {
                this.ouid = 6971934;
            }
            this.setTime(CORE.cpuTime());
            if (this.srate < 1000000.0) {
                System.out.printf("Sample Rate=%f too low for UDAT counters\n", this.srate);
            }
            this.setPhaseInc(this.srate);
            this.pinc = this.npinc;
            if (this.srate == 3.0E8 && this.bpa == 3) {
                this.mfix = 8;
                this.nfix = 4;
            }
            if (this.nfix != 0) {
                System.out.printf("Fixup for UDAT fractional pinc=%d nfix=%d mfix=%d\n", this.pinc, this.nfix, this.mfix);
            }
            this.flags = CORE.setBit(this.flags, 4, this.bpa == 3);
            this.flags = CORE.setBit(this.flags, 5, this.sid == 65535);
            this.flags = CORE.setBit(this.flags, 8, CORE.getBit(this.flags, 8) || CORE.getBit(this.vctx, 24));
            this.flags = CORE.setBit(this.flags, 9, CORE.getBit(this.flags, 9) || CORE.getBit(this.vctx, 25));
            this.flags = CORE.setBit(this.flags, 10, CORE.getBit(this.flags, 10) || CORE.getBit(this.vctx, 26));
            this.flags = CORE.setBit(this.flags, 11, CORE.getBit(this.flags, 11) || CORE.getBit(this.vctx, 27));
            this.flags = CORE.setBit(this.flags, 7, CORE.getBit(this.flags, 7) || CORE.getBit(this.flags, 8) || CORE.getBit(this.flags, 9) || CORE.getBit(this.flags, 10) || CORE.getBit(this.flags, 11));
            this.flags = CORE.setBit(this.flags, 2, CORE.getBit(this.flags, 2) && this.ouid >= 0);
            if (this.ouid <= 0) {
                this.ouid = 1068407;
            }
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("UDAT pkty=%d:%d srate=%f bits=%d flags=%04x\n", this.ptype, this.pkty, this.srate, this.bits, this.flags);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Buffer bi, CoreComponent.Stream so) {
            boolean doWrap;
            boolean doStop;
            boolean doTrim;
            boolean usePad = CORE.getBit(this.flags, 0);
            boolean useTC = CORE.getBit(this.flags, 1);
            boolean anyID = CORE.getBit(this.flags, 5);
            boolean fb3 = CORE.getBit(this.flags, 4);
            boolean ctxf = CORE.getBit(this.flags, 7);
            boolean byp = CORE.getBit(this.flags, 6);
            boolean useOUID = CORE.getBit(this.flags, 2);
            boolean xSR = CORE.getBit(this.flags, 8);
            boolean xIF = CORE.getBit(this.flags, 9);
            boolean xRF = CORE.getBit(this.flags, 10);
            boolean xGain = CORE.getBit(this.flags, 11);
            boolean isNone = this.pkty == 0;
            boolean isNoop = this.pkty == 1;
            boolean okICE = this.pkty == -1 || this.pkty == 2;
            boolean okSDDS = this.pkty == 3;
            boolean okVRT = this.pkty == -1 || this.pkty >= 4;
            boolean okIn = bi.rok;
            int phinc = this.pinc;
            boolean okLen = this.length > 0;
            boolean bl = doTrim = this.length < 256;
            int xfer = !okIn ? 0 : (doTrim ? this.length : 256);
            boolean oknSec = this.nwsec > 0;
            int difws = this.cwsec - this.nwsec;
            long difps = this.cpsec - this.npsec;
            boolean cwgtnw = difws > 0;
            boolean cwltnw = difws < 0;
            boolean cweqnw = !cwgtnw && !cwltnw;
            boolean cpgtnp = difps > (long)(phinc << 2);
            boolean cpltnp = difps < (long)(-phinc);
            boolean cpeqnp = !cpgtnp && !cpltnp;
            boolean ceqn = cweqnw && cpeqnp;
            boolean cgtn = cwgtnw || cweqnw && cpgtnp;
            boolean cltn = cwltnw || cweqnw && cpltnp;
            boolean needPad = usePad && !okIn;
            boolean needFill = useTC && oknSec && cltn;
            boolean needDrop = this.pstate == 4 && useTC && cgtn;
            long lpsec = this.cpsec + (long)(this.pinc << 8);
            boolean lpgtnp = lpsec > this.npsec;
            boolean doClip = lpsec > this.mpsec;
            boolean doFill = (needPad || needFill || needDrop) && !isNoop && !isNone;
            boolean bl2 = doStop = oknSec && cweqnw && lpgtnp && !needPad;
            int fpsec = doClip ? CORE.l2i(this.mpsec - this.cpsec) : (doStop ? CORE.l2i(this.npsec - this.cpsec) : this.pinc << 8);
            this.sid = 0;
            int ooff = 0;
            int seq = 0;
            int ifb = 0;
            int pfix = 0;
            if ((this.halo.vbpr & 2) != 0) {
                System.out.printf("Top  Cur w=%08x p=%012x  Nxt w=%08x p=%012x  Counts=%x Pad=%x Fill=%x Drop=%x rOk=%x wOk=%x cnt=%d\n", this.cwsec, this.cpsec, this.nwsec, this.npsec, this.counts, needPad ? 1 : 0, needFill ? 1 : 0, needDrop ? 1 : 0, bi.rok ? 1 : 0, so.wok ? 1 : 0, 0);
            }
            if (doFill) {
                this.pstate = 1;
                int bz = this.pad;
                for (int dpsec = fpsec; so.wok && dpsec > 0 || ifb != 0; dpsec -= this.pinc) {
                    this.cpsec += (long)this.pinc;
                    int n = !fb3 ? 0 : (ifb = ifb == 2 ? 0 : ifb + 1);
                    if (this.ifix == this.mfix) {
                        pfix += this.nfix;
                    }
                    this.ifix = this.ifix == this.mfix ? 0 : this.ifix + 1;
                    so.wrLS(bz, this.swaps);
                }
                this.counts = CORE.setBits(this.counts, 15, 12, CORE.getBits(this.counts, 15, 12) + 1);
                bz = 0;
            } else if (okLen) {
                this.pstate = 2;
                int i = 0;
                while (so.wok && i < xfer) {
                    this.cpsec += (long)this.pinc;
                    if (this.ifix == this.mfix) {
                        pfix += this.nfix;
                    }
                    this.ifix = this.ifix == this.mfix ? 0 : this.ifix + 1;
                    int bz = bi.getL(i << 2);
                    so.wrLS(bz, this.swaps);
                    ++i;
                    --this.length;
                }
                bi.rnxt(i << 2);
            } else if (okIn && isNoop) {
                this.pstate = 3;
                this.length = 256;
            } else if (okIn && !isNone) {
                int ioff;
                boolean isVCTX;
                this.pstate = 4;
                int ulen = 0;
                int bx = bi.getL(0);
                int by = bi.getL(4);
                int bz = bi.getL(8);
                boolean anyOUID = !useOUID || !CORE.getBit(bx, 3);
                boolean hasOUID = CORE.getBit(bx, 3);
                boolean hasSID = CORE.getBits(bx, 6, 5) > 1 ? true : CORE.getBit(bx, 4);
                boolean isSID = CORE.bswap2(hasSID ? CORE.getBits(by, 31, 16) : CORE.getBits(bz, 15, 0)) == this.sid;
                boolean isVRTi = CORE.getBits(bx, 7, 0) == 28 && (CORE.bswap4(bz) == this.ouid || anyOUID);
                boolean isVRTj = CORE.getBits(bx, 7, 0) == 8 && (CORE.bswap4(by) == this.ouid || anyOUID);
                boolean isVRTd = CORE.getBits(bx, 7, 0) == 24 && (CORE.bswap4(bz) == 6971934 || anyOUID);
                boolean isVRTc = CORE.getBits(bx, 7, 0) == 73 && (CORE.bswap4(bz) == this.ouid || anyOUID);
                boolean isICE = okICE && bx == 0x676665;
                boolean isVRT = !(!okVRT || !isVRTi && !isVRTj && !isVRTd || !isSID && !anyID);
                boolean bl3 = isVCTX = okVRT && isVRTc && (isSID || anyID);
                if (isICE) {
                    ioff = 64;
                    seq = CORE.getBits(by, 7, 0);
                    int bfer = CORE.getBits(bz, 13, 0);
                    ulen = CORE.getBits(bz, 13, 0);
                    bx = bi.getL(12);
                    this.sid = CORE.getBits(bx, 31, 16);
                    bx = bi.getL(16);
                    int bpa = CORE.getBits(bx, 27, 24);
                    for (int j = 1; j < bpa; ++j) {
                        ulen += bfer;
                    }
                } else if (isVRT) {
                    int bps;
                    boolean isBE;
                    int n = ooff = CORE.getBit(bx, 2) ? 4 : 0;
                    ioff = !hasOUID ? 20 : (!hasSID ? 24 : 28);
                    seq = CORE.getBits(bx, 11, 8);
                    this.nseq &= 0xF;
                    ulen = (CORE.bswap2(CORE.getBits(bx, 31, 16)) << 2) - ioff - ooff;
                    bx = bi.getL(12);
                    boolean bl4 = isVRTi ? CORE.getBit(bx, 22) : (isBE = isVRTj ? CORE.getBit(bz, 22) : true);
                    int n2 = isVRTi ? CORE.getBits(bx, 27, 24) : (bps = isVRTj ? CORE.getBits(bz, 27, 24) : 15);
                    if (useTC) {
                        by = bi.getL(ioff - 12);
                        this.nwsec = CORE.bswap4(by);
                        by = bi.getL(ioff - 8);
                        this.npsec = CORE.setBits(this.npsec, 39, 32, (long)CORE.bswap4(by));
                        by = bi.getL(ioff - 4);
                        this.npsec = CORE.setBits(this.npsec, 31, 0, (long)CORE.bswap4(by));
                    }
                    this.swaps = CORE.setBit(this.swaps, 0, bps == 15 && isBE);
                    this.swaps = CORE.setBit(this.swaps, 1, bps > 15 && isBE);
                    this.swaps = CORE.setBit(this.swaps, 2, bps == 11 && isBE);
                    if ((this.halo.vbpr & 2) != 0) {
                        System.out.printf("New Cur w=%08x p=%012x  Nxt w=%08x p=%012x\n", this.cwsec, this.cpsec, this.nwsec, this.npsec);
                    }
                } else if (isVCTX) {
                    int coff;
                    this.pstate = 5;
                    ioff = CORE.getBits(bx, 31, 24) << 2;
                    int n = coff = hasOUID ? 28 : 20;
                    if (ctxf) {
                        int bc;
                        bx = bi.getL(coff);
                        bx = CORE.brev4(CORE.bswap4(bx));
                        if ((this.halo.vbpr & 1) != 0) {
                            System.out.printf("UDAT Ctx bx=%08x coff=%d len=%d\n", bx, coff, ioff);
                        }
                        for (int k = 0; k < 8; ++k) {
                            so.wrLC(0, 1);
                        }
                        so.wrLC(bx, 2);
                        coff += 4 + (CORE.getBits(bx, 2, 2) << 3) + (CORE.getBits(bx, 1, 1) << 2);
                        if (CORE.getBit(bx, 3) && xIF) {
                            by = bi.getL(coff);
                            bz = bi.getL(coff + 4);
                            bc = CORE.l2i(CORE.ii2l(CORE.bswap4(by), CORE.bswap4(bz)) >> 20);
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx IF bc=%d\n", bc);
                            }
                            so.wrLC(bc, 4);
                        }
                        coff += CORE.getBits(bx, 3, 3) << 3;
                        if (CORE.getBit(bx, 4) && xRF) {
                            by = bi.getL(coff);
                            bz = bi.getL(coff + 4);
                            bc = CORE.l2i(CORE.ii2l(CORE.bswap4(by), CORE.bswap4(bz)) >> 20);
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx RF bc=%d\n", bc);
                            }
                            so.wrLC(bc, 4);
                        }
                        coff += (CORE.getBits(bx, 4, 4) + CORE.getBits(bx, 5, 5) + CORE.getBits(bx, 6, 6) << 3) + (CORE.getBits(bx, 7, 7) << 2);
                        if (CORE.getBit(bx, 8) && xGain) {
                            by = bi.getL(coff);
                            bc = CORE.bswap4(by) >> 7;
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx GAIN bc=%d\n", bc);
                            }
                            so.wrLC(bc, 8);
                        }
                        coff += CORE.getBits(bx, 8, 8) + CORE.getBits(bx, 9, 9) << 2;
                        if (CORE.getBit(bx, 10) && xSR) {
                            by = bi.getL(coff);
                            bz = bi.getL(coff + 4);
                            bc = CORE.l2i(CORE.ii2l(CORE.bswap4(by), CORE.bswap4(bz)) >> 20);
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx SR bc=%d\n", bc);
                            }
                            so.wrLC(bc, 10);
                        }
                        so.wrLC(bx, 2);
                        so.setC(0);
                    }
                    this.counts = CORE.setBits(this.counts, 23, 20, CORE.getBits(this.counts, 23, 20) + 1);
                } else {
                    ioff = 4;
                    this.counts = CORE.setBits(this.counts, 30, 24, CORE.getBits(this.counts, 30, 24) + 1);
                }
                bi.rnxt(ioff);
                if (ulen > 0) {
                    this.length = ulen >> 2;
                    so.setC(this.osel);
                    this.counts = CORE.setBits(this.counts, 3, 0, CORE.getBits(this.counts, 3, 0) + 1);
                    if (seq != this.nseq) {
                        this.counts = CORE.setBits(this.counts, 7, 4, CORE.getBits(this.counts, 7, 4) + 1);
                    }
                    this.nseq = seq + 1;
                }
            }
            if (needDrop) {
                this.counts = CORE.setBits(this.counts, 11, 8, CORE.getBits(this.counts, 11, 8) + 1);
                bi.rnxt(xfer << 2);
                this.length -= xfer;
                if (this.length > 0) {
                    this.pstate = 4;
                }
            }
            this.counts = CORE.setBits(this.counts, 19, 16, this.length > 15 ? 15 : CORE.getBits(this.length, 3, 0));
            this.counts = CORE.setBit(this.counts, 31, okIn);
            this.cpsec += (long)pfix;
            boolean bl5 = doWrap = this.cpsec >= this.mpsec;
            if (doWrap) {
                this.cpsec -= this.mpsec;
                ++this.cwsec;
            }
            if (this.pass == 0) {
                this.counts = this.counts;
                this.cwsec = this.cwsec;
                this.cpsec = this.cpsec;
                this.nwsec = this.nwsec;
                this.npsec = this.npsec;
            }
            int n = this.pass = this.pass >= 14 ? 0 : this.pass + 1;
            if ((this.halo.vbpr & 2) != 0) {
                System.out.printf("Bot  Cur w=%08x p=%012x  Nxt w=%08x p=%012x  Counts=%x pstate=%d cnt=%d pass=%d\n", this.cwsec, this.cpsec, this.nwsec, this.npsec, this.counts, this.pstate, 0, this.pass);
            }
            bi.rokLen(1024);
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }

        @Override
        public int poll() {
            double time = CORE.cpuTime();
            int twsec = CORE.d2i(CORE.floor(time));
            long tpsec = CORE.d2l(CORE.frac(time) * 1.0E12);
            if (this.ptype <= 1) {
                return 0;
            }
            this.getVars("cwsec,cpsec,nwsec,npsec,counts");
            System.out.printf("Poll EECLFDSU=%08x  Cpu=%08x:%012x  Nxt=%08x:%012x  Cur=%08x:%012x\n", this.counts, twsec, tpsec, this.nwsec, this.npsec, this.cwsec, this.cpsec);
            return 5;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(3);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(3);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(3);
        }
    }
}

