/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class TFDD
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int NP = 1;
    public static final int SIBW = 32;
    public static final int SOBW = 32;
    public static final int OCIC = 5;
    public static final int ODEC = 10;
    public static final int OTAP = 8;
    public static final int RTAP = 256;
    public static final int PTAP = 8;
    public static final int OAGC = 12;
    public static final int FPS = 31;
    public static final int MAXCR = 300000000;

    public static class CORE
    extends Core {
        public int irate;
        public int orate;
        public double fcny;
        public double ratio;
        public int dec;
        public int gain;
        public int flags;

        @Override
        public int init() {
            this.irate = 1000000;
            this.orate = -1;
            this.fcny = 0.0;
            this.gain = 0;
            this.dec = 1;
            this.ratio = 1.0;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:RATE")) {
                this.irate = value.toL();
            } else if (this.isMatch(key, "L:ORATE")) {
                this.orate = value.toL();
            } else if (this.isMatch(key, "D:FREQ")) {
                this.fcny = value.toD() * 2.0 / (double)this.irate;
            } else if (this.isMatch(key, "D:FCNY")) {
                this.fcny = value.toD();
            } else if (this.isMatch(key, "L:DEC")) {
                this.dec = value.toL();
            } else if (this.isMatch(key, "D:RATIO")) {
                this.ratio = value.toD();
            } else if (this.isMatch(key, "L:GAIN")) {
                this.gain = value.toL();
            } else if (this.isMatch(key, "L:FLAGS")) {
                this.flags = value.toL();
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:RATE")) {
                value.fromL(this.irate);
            } else if (this.isMatch(key, "D:FREQ")) {
                value.fromD(this.fcny);
            } else if (this.isMatch(key, "D:RATIO")) {
                value.fromD(this.ratio);
            } else if (this.isMatch(key, "D:XDIO")) {
                value.fromD((double)(this.dec * 2) / this.ratio);
            } else if (this.isMatch(key, "L:GAIN")) {
                value.fromL(this.gain);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            if (this.orate < 0) {
                this.orate = this.irate / this.dec / 2;
            }
            System.out.printf("TFDD Fs=%d Fc=%f Fo=%d dec=%d gain=%d ratio=%f\n", this.irate, this.fcny, this.orate, this.dec, this.gain, this.ratio);
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

