/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Modefs;
import nxm.ice.core.Modems;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class REC
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int IFMT = 2;
    public static final int OFMT = 2;
    public static final int SELFPACE = 1;
    public static final int BW = 32;
    public static final int OFEC = 9;

    public static class CORE
    extends Core
    implements Modefs {
        public int alg;
        public int upp;
        int terrs;
        int tbits;
        int vflg;
        int bpw;
        Modems.IFEC ifec;

        @Override
        public int init() {
            this.alg = 0;
            this.upp = 0;
            this.bpw = 2;
            this.vflg = 128;
            this.terrs = 0;
            this.tbits = 0;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "S:ALG")) {
                this.alg = value.toItem("NONE,REP1,REP2,REP3,HAM74,HAM84,HAM128,GLY2412,SD2216,SD3932,SD7264,V27,V27P12,V27P23,V27P34,V27P45,V27P56,V27P67,V27P78,V29,V29P12,V29P23,V29P34,V29P45,V29P56,V29P67,V29P78,V39,V615,TCM,TCM23,DTCM23");
            } else if (this.isMatch(key, "S:FEC")) {
                this.alg = value.toItem("NONE,REP1,REP2,REP3,HAM74,HAM84,HAM128,GLY2412,SD2216,SD3932,SD7264,V27,V27P12,V27P23,V27P34,V27P45,V27P56,V27P67,V27P78,V29,V29P12,V29P23,V29P34,V29P45,V29P56,V29P67,V29P78,V39,V615,TCM,TCM23,DTCM23");
            } else if (this.isMatch(key, "L:BPW")) {
                this.bpw = value.toL();
            } else if (this.isMatch(key, "L:UPP")) {
                this.upp = value.toL();
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:ALG")) {
                value.fromL(this.alg);
            } else if (this.isMatch(key, "L:BPW")) {
                value.fromL(this.bpw);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            if (this.alg == 30) {
                this.bpw = 3;
                this.vflg |= 4;
            }
            this.ifec = new Modems.IFEC(9);
            this.ifec.open(this.alg, this.upp, this.vflg);
            System.out.printf("REC alg=%d bpw=%d vflg=%x\n", this.alg, this.bpw, this.vflg);
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            while (si.rok && so.wok) {
                int bi = si.rdBits(this.bpw);
                int ofec = this.ifec.process(bi, this.bpw);
                int bits = CORE.getBits(ofec, 19, 16);
                int errs = CORE.getBits(ofec, 27, 24);
                so.wrBits(bits, ofec);
                this.tbits += bits;
                this.terrs += errs;
            }
            return 0;
        }

        @Override
        public int close() {
            this.getVars("terrs,tbits");
            System.out.printf("iFEC alg=%d errs=%d of bits=%d \n", this.alg, this.terrs, this.tbits);
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

