/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class PKT2DAT
extends CoreFactory {

    public static class CORE
    extends Core {
        public static final int FLOW = 4;
        public static final int SELFPACE = 1;
        public static final int PIPE = 0;
        public static final String pktList = "Auto,None,Eth,UDP,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
        public static final int PT_AUTO = -1;
        public static final int PT_NONE = 0;
        public static final int PT_ETH = 1;
        public static final int PT_UDP = 2;
        public static final int PT_ICE = 3;
        public static final int PT_SDDS = 4;
        public static final int PT_VRT = 5;
        public static final int PT_VRTL = 6;
        public static final int PT_VRTW = 7;
        public static final int PT_VRTX = 8;
        public static final int PT_VRTD = 9;
        public static final int BW = 32;
        public static final int PIBW = 32;
        public static final int POBW = 32;
        public static final int RW = 15;
        public static final int CW = 2;
        public static final int NC = 4;
        public static final int IP = 8;
        public static final int ARP = 1544;
        public static final int ICMP = 1;
        public static final int IGMP = 2;
        public static final int TCP = 6;
        public static final int UDP = 17;
        public static final int SOP = 0x55555555;
        public static final int OUID = 1068407;
        public static final int DIFI = 6971934;
        public static final int IGMP_BA = -536870911;
        public static final int RES_IPKT = 1;
        public static final int RES_OPKT = 2;
        public static final int RES_ARP = 3;
        public static final int RES_ICMP = 4;
        public static final int RES_IGMP = 5;
        public static final int RES_OTHER = 6;
        int pkty;
        int myip;
        int mcip;
        int mcid;
        int flags;
        int osel;
        int ipkt;
        int opkt;
        int ic;
        int nc;
        int[] mcips;
        int[] mcids;
        int[] osels;
        int counts;
        int nseq;
        int ouid;
        int debug;
        CoreComponent.Dma dma;

        @Override
        public int init() {
            this.ic = 0;
            this.nc = 0;
            this.pkty = -1;
            this.ouid = 0;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "S:PT")) {
                this.pkty = value.toItem(pktList);
            } else if (this.isMatch(key, "L:PKTY")) {
                this.pkty = value.toL();
            } else if (this.isMatch(key, "L:MYIP")) {
                this.myip = value.toL();
            } else if (this.isMatch(key, "L:CHAN")) {
                this.ic = value.toL();
            } else if (this.isMatch(key, "L:MCIP")) {
                this.mcip = value.toL();
            } else if (this.isMatch(key, "L:MCID")) {
                this.mcid = value.toL() & 0xFFFF;
            } else if (this.isMatch(key, "L:OSEL")) {
                this.osel = value.toL();
            } else if (this.isMatch(key, "L:OUID")) {
                this.ouid = value.toL();
            } else if (this.isMatch(key, "L:FLAGS")) {
                this.flags = value.toL();
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:PKTY")) {
                value.fromL(this.pkty);
            } else if (this.isMatch(key, "L:MYIP")) {
                value.fromL(this.myip);
            } else if (this.isMatch(key, "L:MCIP")) {
                value.fromL(this.mcip);
            } else if (this.isMatch(key, "L:MCID")) {
                value.fromL(this.mcid);
            } else if (this.isMatch(key, "L:FLAGS")) {
                value.fromL(this.flags);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.dma = new CoreComponent.Dma(15, 32);
            this.mcips = new int[4];
            this.mcids = new int[4];
            this.osels = new int[4];
            for (int i = 0; i < 4; ++i) {
                this.mcips[i] = -1;
                this.mcids[i] = 65535;
                this.osels[i] = 0;
            }
            this.mcips[this.ic] = this.mcip;
            this.mcids[this.ic] = this.mcid;
            this.osels[this.ic] = this.osel;
            if (this.pkty == 2) {
                this.flags |= 1;
            }
            if (this.pkty == 1) {
                this.flags |= 2;
            }
            if (this.mcip == -1) {
                this.flags |= 0x10;
            }
            if (this.mcid == 65535) {
                this.flags |= 0x20;
            }
            if (this.ouid < 0) {
                this.flags |= 0x400;
            }
            if (this.ouid <= 0) {
                this.ouid = this.pkty == 9 ? 6971934 : 1068407;
            }
            this.ipkt = 0;
            this.opkt = 0;
            this.nseq = 0;
            this.counts = 0;
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Buffer bi, CoreComponent.Stream sip, CoreComponent.Stream so, CoreComponent.Stream sop) {
            boolean okVRT;
            boolean asis = CORE.getBit(this.flags, 0);
            boolean doclip = CORE.getBit(this.flags, 2);
            boolean anyMC = CORE.getBit(this.flags, 4);
            boolean anySID = CORE.getBit(this.flags, 5);
            boolean anyIP = CORE.getBit(this.flags, 6);
            boolean othpkt = CORE.getBit(this.flags, 7);
            boolean pack = CORE.getBit(this.flags, 8);
            boolean tena = CORE.getBit(this.flags, 9);
            int tlen = CORE.getBits(this.flags, 15, 12);
            boolean xrst = false;
            boolean noOut = this.pkty == 0;
            boolean alleth = this.pkty == 1;
            boolean alludp = this.pkty == 2;
            boolean okICE = this.pkty == -1 || this.pkty == 3;
            boolean okSDDS = this.pkty == -1 || this.pkty == 4;
            boolean bl = okVRT = this.pkty == -1 || this.pkty >= 5;
            while (sip.rok) {
                boolean isBA;
                int dmaflg = 0;
                int pktlen = 0;
                int reslen = 0;
                int restyp = 0;
                int ihdr = 0;
                int ioff = 0;
                int length = 0;
                int seq = this.nseq;
                ++this.ipkt;
                this.counts = CORE.setBits(this.counts, 11, 0, this.ipkt);
                int bs = sip.rdL();
                int by = bi.getL(0);
                int bx = bi.getL(16);
                boolean isARP = CORE.getBits(bx, 31, 16) == 1544;
                boolean isIP = CORE.getBits(bx, 31, 16) == 8;
                bx = bi.getL(28);
                boolean isUDP = isIP && CORE.getBits(bx, 15, 8) == 17;
                boolean isICMP = isIP && CORE.getBits(bx, 15, 8) == 1;
                boolean isIGMP = isIP && CORE.getBits(bx, 15, 8) == 2;
                boolean isVCTX = false;
                bx = bi.getL(36);
                int dest = CORE.bswap4(bx);
                boolean isMe = dest == this.myip;
                boolean isMC = dest == this.mcip;
                boolean bl2 = isBA = dest == -536870911;
                if (CORE.getBits(bs, 17, 16) != 1 || by != 0x55555555) {
                    xrst = true;
                    this.counts = CORE.setBit(this.counts, 31, true);
                    this.counts = CORE.setBits(this.counts, 30, 28, CORE.getBits(this.counts, 30, 28) + 1);
                    return 1;
                }
                if (!alleth) {
                    if (isUDP && (anyMC || isMC)) {
                        bx = bi.getL(44);
                        short udplen = CORE.bswap2(CORE.getBits(bx, 15, 0));
                        int ooff = 8;
                        ihdr = 48;
                        boolean isKeep = true;
                        bx = bi.getL(ihdr);
                        by = bi.getL(ihdr + 4);
                        int bz = bi.getL(ihdr + 8);
                        int bq = bi.getL(ihdr + 12);
                        boolean anyOUID = CORE.getBit(this.flags, 10) || !CORE.getBit(bx, 3);
                        boolean hasOUID = CORE.getBit(bx, 3);
                        boolean hasSID = CORE.getBits(bx, 6, 5) > 1 ? true : CORE.getBit(bx, 4);
                        int sid = CORE.bswap2(hasSID ? CORE.getBits(by, 31, 16) : CORE.getBits(bz, 15, 0));
                        boolean isSID = sid == this.mcid;
                        boolean isOUID = this.ouid == CORE.bswap4(hasSID ? bz : by);
                        boolean isVRTi = CORE.getBits(bx, 7, 0) == 28;
                        boolean isVRTj = CORE.getBits(bx, 7, 0) == 8;
                        boolean isVRTx = CORE.getBits(bx, 7, 0) == 20 && this.pkty == 8;
                        boolean isVRTd = CORE.getBits(bx, 7, 0) == 24;
                        boolean isVRTc = CORE.getBits(bx, 7, 0) == 73 || CORE.getBits(bx, 7, 0) == 65;
                        boolean isICE = okICE && bx == 0x676665;
                        boolean isSDDS = okSDDS && udplen == 1088;
                        boolean isVRT = !(!okVRT || !isVRTi && !isVRTj && !isVRTx && !isVRTd || !isSID && !anySID || !isOUID && !anyOUID);
                        boolean bl3 = isVCTX = !(!okVRT || !isVRTc || !isSID && !anySID || !isOUID && !anyOUID);
                        if (alludp) {
                            ioff = 0;
                        } else if (isICE) {
                            ioff = 64;
                            seq = CORE.getBits(by, 7, 0);
                            sid = CORE.getBits(bq, 31, 16);
                        } else if (isSDDS) {
                            ioff = 56;
                            seq = CORE.getBits(bx, 31, 24);
                            boolean isNB = CORE.getBits(bx, 13, 8) > 8;
                            bq = bi.getL(ihdr + 52);
                            sid = CORE.getBits(bq, 31, 16);
                            dmaflg = CORE.setBit(dmaflg, 0, isNB);
                        } else if (isVRT) {
                            boolean isBE;
                            if (CORE.getBit(bx, 2) && !asis) {
                                ooff = 12;
                            }
                            seq = CORE.getBits(bx, 11, 8);
                            this.nseq &= 0xF;
                            int n = !hasOUID ? 20 : (ioff = !hasSID ? 24 : 28);
                            boolean bl4 = isVRTi ? CORE.getBit(bq, 22) : (isBE = isVRTj ? CORE.getBit(bz, 22) : true);
                            int bps = isVRTi ? CORE.getBits(bq, 27, 24) : (isVRTj ? CORE.getBits(bz, 27, 24) : 15);
                            dmaflg = CORE.setBit(dmaflg, 0, bps == 15 && isBE);
                            dmaflg = CORE.setBit(dmaflg, 1, bps > 7 && isBE);
                            dmaflg = CORE.setBit(dmaflg, 2, bps == 11 && isBE);
                            if (tena) {
                                bx = bi.getL(ihdr + 16);
                                isKeep = CORE.getBits(bx, 31, 28) < tlen;
                            }
                        } else {
                            boolean bl5 = isKeep = isVCTX ? asis : false;
                        }
                        if (asis) {
                            ioff = 0;
                            dmaflg = 0;
                        }
                        int ulen = udplen - ioff - ooff;
                        boolean bl6 = isSID = sid == this.mcid;
                        if (isKeep && (isSID || anySID)) {
                            length = ulen;
                        }
                    } else if (isICMP && isMe | anyIP) {
                        restyp = 4;
                        this.counts = CORE.setBits(this.counts, 19, 16, CORE.getBits(this.counts, 19, 16) + 1);
                    } else if (isIGMP && isMe | anyIP | isMC | isBA) {
                        restyp = 5;
                        this.counts = CORE.setBits(this.counts, 23, 20, CORE.getBits(this.counts, 23, 20) + 1);
                    } else if (isARP) {
                        restyp = 3;
                        this.counts = CORE.setBits(this.counts, 27, 24, CORE.getBits(this.counts, 27, 24) + 1);
                    } else if (othpkt && !isUDP) {
                        restyp = 6;
                        this.counts = CORE.setBits(this.counts, 30, 28, CORE.getBits(this.counts, 30, 28) + 1);
                    }
                }
                if (alleth) {
                    while (!sip.rok) {
                    }
                    pktlen = sip.rdL();
                    int dlen = 64 << CORE.getBits(this.flags, 10, 8);
                    int n = length = doclip ? dlen : pktlen;
                }
                if (length > 0 && !noOut) {
                    if (this.nc > 0) {
                        this.osel = this.osels[this.ic];
                    }
                    so.setC(this.osel);
                    this.dma.setFlags(dmaflg);
                    this.dma.b2s(bi, ihdr + ioff, so, 0, length);
                    ++this.opkt;
                    if (isUDP && !isVCTX) {
                        if (seq != this.nseq) {
                            this.counts = CORE.setBits(this.counts, 15, 12, CORE.getBits(this.counts, 15, 12) + 1);
                        }
                        this.nseq = seq + 1;
                    }
                    CORE cORE = this;
                    cORE.dma.sync();
                }
                if (!alleth) {
                    while (!sip.rok) {
                    }
                    pktlen = sip.rdL();
                }
                if (restyp > 0 && sop.wok) {
                    this.dma.setFlags(0);
                    reslen = pktlen;
                    bs = CORE.setBits(bs, 31, 20, 462);
                    bs = CORE.setBits(bs, 19, 16, restyp);
                    bs = CORE.setBits(bs, 15, 0, reslen);
                    sop.wrL(bs);
                    bs = CORE.bswap4(this.myip);
                    sop.wrL(bs);
                    this.dma.b2s(bi, 0, sop, 0, reslen);
                    System.out.printf("Got restyp=%d reslen=%d\n", restyp, reslen);
                    CORE cORE = this;
                    cORE.dma.sync();
                }
                bi.rnxt(pktlen);
            }
            this.opkt = this.opkt;
            this.counts = this.counts;
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(4);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(4);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(4);
        }
    }
}

