/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class Noop
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int BW = 32;

    public static class CORE
    extends Core {
        int dec;
        int throttle;
        int mdec;
        int idec;
        CoreComponent.Value vx;

        @Override
        public int init() {
            this.dec = 1;
            this.throttle = 0;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:DEC")) {
                this.dec = value.toL();
            } else if (this.isMatch(key, "L:THROTTLE")) {
                this.throttle = value.toL();
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:DEC")) {
                value.fromL(this.dec);
            } else if (this.isMatch(key, "L:THROTTLE")) {
                value.fromL(this.throttle);
            } else if (this.isMatch(key, "D:XDIO")) {
                value.fromD(CORE.i2d(this.dec));
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.mdec = this.dec - 1;
            this.idec = 0;
            this.vx = new CoreComponent.Value("CI", 1);
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            while (si.rok && so.wok) {
                si.rd(this.vx);
                if (this.idec == 0) {
                    so.wr(this.vx);
                }
                this.idec = this.idec == this.mdec ? 0 : this.idec + 1;
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

