/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Modefs;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreLibrary;

public class Modems
extends CoreLibrary
implements Modefs {
    public static final byte[] mapTCM = new byte[]{0, 2, 3, 1, 4, 6, 7, 5};

    public static int getModID(String s) {
        int id = Modems.findListItem("NONE,CW,AM,FM,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,1P4DQPSK,8PSK,16PSK,16APSK,32APSK,64APSK,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM", s, -2);
        if (id < 0) {
            System.out.printf("Unknown MOD type=%s\n", s);
        }
        return id;
    }

    public static int getFecID(String s) {
        int id = Modems.findListItem("NONE,REP1,REP2,REP3,HAM74,HAM84,HAM128,GLY2412,SD2216,SD3932,SD7264,V27,V27P12,V27P23,V27P34,V27P45,V27P56,V27P67,V27P78,V29,V29P12,V29P23,V29P34,V29P45,V29P56,V29P67,V29P78,V39,V615,TCM,TCM23,DTCM23", s, -2);
        if (id < 0) {
            System.out.printf("Unknown FEC type=%s\n", s);
        }
        return id;
    }

    public static int getMapID(String s) {
        int id = Modems.findListItem("LINEAR,BRGC,BRGCIB,BRGCIX,BRGCIY,BRGCIXY,BRGCNT,BRGCBE", s, -2);
        if (id < 0) {
            System.out.printf("Unknown MAP type=%s\n", s);
        }
        return id;
    }

    public static int getGridSF(int mod) {
        int gsf;
        switch (mod) {
            case 24: {
                gsf = 16;
                break;
            }
            case 23: {
                gsf = 12;
                break;
            }
            case 22: {
                gsf = 8;
                break;
            }
            case 21: {
                gsf = 6;
                break;
            }
            case 16: 
            case 20: {
                gsf = 4;
                break;
            }
            case 15: 
            case 19: {
                gsf = 3;
                break;
            }
            case 14: 
            case 18: {
                gsf = 2;
                break;
            }
            case 17: {
                gsf = 2;
                break;
            }
            default: {
                gsf = 1;
            }
        }
        return gsf;
    }

    public static int getBitsPerSym(int mod) {
        int bps;
        switch (mod) {
            case 24: {
                bps = 10;
                break;
            }
            case 23: {
                bps = 9;
                break;
            }
            case 22: {
                bps = 8;
                break;
            }
            case 21: {
                bps = 7;
                break;
            }
            case 16: 
            case 20: {
                bps = 6;
                break;
            }
            case 15: 
            case 19: {
                bps = 5;
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                bps = 4;
                break;
            }
            case 12: {
                bps = 3;
                break;
            }
            case 17: {
                bps = 3;
                break;
            }
            case 4: 
            case 6: {
                bps = 1;
                break;
            }
            default: {
                bps = 2;
            }
        }
        return bps;
    }

    public static float getMinSNR(int mod) {
        float snr;
        switch (mod) {
            case 24: {
                snr = 40.0f;
                break;
            }
            case 23: {
                snr = 36.0f;
                break;
            }
            case 22: {
                snr = 30.0f;
                break;
            }
            case 21: {
                snr = 20.0f;
                break;
            }
            case 16: 
            case 20: {
                snr = 15.0f;
                break;
            }
            case 15: 
            case 19: {
                snr = 12.0f;
                break;
            }
            case 14: 
            case 18: {
                snr = 9.0f;
                break;
            }
            case 12: {
                snr = 9.0f;
                break;
            }
            case 17: {
                snr = 9.0f;
                break;
            }
            case 6: {
                snr = 6.0f;
                break;
            }
            default: {
                snr = 6.0f;
            }
        }
        return snr;
    }

    public static int bitRev(int ord, int im) {
        int om = 0;
        for (int i = 0; i < ord; ++i) {
            if ((im >> i & 1) == 0) continue;
            om |= 1 << ord - 1 - i;
        }
        return om;
    }

    public static int getMap(int map, int ord, int i) {
        int n = 1 << ord;
        int nh = n / 2;
        int o = i;
        if (map == 3 && i >= nh) {
            i = n - 1 - i + nh;
        }
        if (map >= 2) {
            o = i ^ i >> 1;
        }
        if (map == 7) {
            o = mapTCM[i];
        }
        if (map == 8) {
            o = Modems.bitRev(ord, o);
        }
        return o;
    }

    public static int getMapXY(int map, int ord, int i, int j, int k) {
        int hord = ord / 2;
        int n = 1 << hord;
        if (map == 4 || map == 6) {
            i = n - 1 - i;
        }
        if (map == 5 || map == 6) {
            j = n - 1 - j;
        }
        int im = map >= 2 ? i ^ i >> 1 : i;
        int jm = map >= 2 ? j ^ j >> 1 : j;
        int o = im << hord | jm;
        if ((ord & 1) != 0) {
            o = k;
        }
        if (map == 8) {
            o = Modems.bitRev(ord, o);
        }
        return o;
    }

    public static int getSymbolMap(int mod, int map, double amp, double midx, int nper, float[] x, float[] y) {
        float scl = (float)amp;
        int k = 0;
        int hlut = 0;
        int olut = 0;
        if (map < 0) {
            map = 2;
        }
        if (mod == 0) {
            olut = 0;
        } else if (mod == 1) {
            olut = 10;
            float r1 = scl * 0.707f;
            for (int i = 0; i < 1024; ++i) {
                double p = ((double)i + 0.5) / 1024.0;
                x[i] = r1 * Modems.coscf(p);
                y[i] = r1 * Modems.sincf(p);
            }
        } else if (mod == 4) {
            int j;
            double p;
            int i;
            olut = 1;
            float r1 = scl * 0.707f;
            for (i = 0; i < nper * 2; ++i) {
                p = 0.5 * midx * (double)i / (double)nper;
                j = 0 + (i << 4);
                x[j] = r1 * Modems.coscf(p);
                y[j] = r1 * Modems.sincf(p);
            }
            for (i = 0; i < nper * 2; ++i) {
                p = -0.5 * midx * (double)i / (double)nper;
                j = 1 + (i << 4);
                x[j] = r1 * Modems.coscf(p);
                y[j] = r1 * Modems.sincf(p);
            }
        } else if (mod == 5) {
            int j;
            double p;
            int i;
            olut = 2;
            float r1 = scl * 0.707f;
            for (i = 0; i < nper * 2; ++i) {
                p = 0.5 * midx * (double)i / (double)nper;
                j = 0 + (i << 4);
                x[j] = r1 * Modems.coscf(p);
                y[j] = r1 * Modems.sincf(p);
            }
            for (i = 0; i < nper * 2; ++i) {
                p = -0.5 * midx * (double)i / (double)nper;
                j = 1 + (i << 4);
                x[j] = r1 * Modems.coscf(p);
                y[j] = r1 * Modems.sincf(p);
            }
            for (i = 0; i < nper * 2; ++i) {
                p = 1.5 * midx * (double)i / (double)nper;
                j = 2 + (i << 4);
                x[j] = r1 * Modems.coscf(p);
                y[j] = r1 * Modems.sincf(p);
            }
            for (i = 0; i < nper * 2; ++i) {
                p = -1.5 * midx * (double)i / (double)nper;
                j = 3 + (i << 4);
                x[j] = r1 * Modems.coscf(p);
                y[j] = r1 * Modems.sincf(p);
            }
        } else if (mod == 6) {
            olut = 1;
            float r1 = scl * 0.707f;
            for (int i = 0; i < 2; ++i) {
                double p = ((double)i + 0.25) / 2.0;
                int im = Modems.getMap(map, olut, i);
                x[im] = r1 * Modems.coscf(p);
                y[im] = r1 * Modems.sincf(p);
            }
        } else if (mod >= 7 && mod <= 11) {
            olut = 2;
            float r1 = scl * 0.707f;
            for (int i = 0; i < 4; ++i) {
                double p = ((double)i + 0.5) / 4.0;
                int im = Modems.getMap(map, olut, i);
                x[im] = r1 * Modems.coscf(p);
                y[im] = r1 * Modems.sincf(p);
            }
        } else if (mod == 12) {
            olut = 3;
            float r1 = scl * 0.707f;
            for (int i = 0; i < 8; ++i) {
                double p = ((double)i + 0.5) / 8.0;
                int im = Modems.getMap(map, olut, i);
                x[im] = r1 * Modems.coscf(p);
                y[im] = r1 * Modems.sincf(p);
            }
        } else if (mod == 13) {
            olut = 4;
            float r1 = scl * 0.707f;
            for (int i = 0; i < 16; ++i) {
                double p = ((double)i + 0.5) / 16.0;
                int im = Modems.getMap(map, olut, i);
                x[im] = r1 * Modems.coscf(p);
                y[im] = r1 * Modems.sincf(p);
            }
        } else if (mod == 14) {
            int im;
            double p;
            int i;
            olut = 4;
            float r2 = scl * 0.75f;
            float r1 = r2 * 0.38910508f;
            for (i = 0; i < 4; ++i) {
                p = ((double)i + 0.5) / 4.0;
                im = Modems.getMap(map, olut, i);
                x[im] = r1 * Modems.coscf(p);
                y[im] = r1 * Modems.sincf(p);
            }
            for (i = 4; i < 16; ++i) {
                p = ((double)i - 3.5) / 12.0;
                im = Modems.getMap(map, olut, i);
                x[im] = r2 * Modems.coscf(p);
                y[im] = r2 * Modems.sincf(p);
            }
        } else if (mod == 15) {
            int im;
            double p;
            int i;
            olut = 5;
            float r3 = scl * 0.8333333f;
            float r2 = r3 * 0.58837205f;
            float r1 = r3 * 0.23255813f;
            for (i = 0; i < 4; ++i) {
                p = ((double)i + 0.5) / 4.0;
                im = Modems.getMap(map, olut, i);
                x[im] = r1 * Modems.coscf(p);
                y[im] = r1 * Modems.sincf(p);
            }
            for (i = 4; i < 16; ++i) {
                p = ((double)i - 3.5) / 12.0;
                im = Modems.getMap(map, olut, i);
                x[im] = r2 * Modems.coscf(p);
                y[im] = r2 * Modems.sincf(p);
            }
            for (i = 16; i < 32; ++i) {
                p = ((double)i - 15.0) / 16.0;
                im = Modems.getMap(map, olut, i);
                x[im] = r3 * Modems.coscf(p);
                y[im] = r3 * Modems.sincf(p);
            }
        } else if (mod == 16) {
            int im;
            double p;
            int i;
            olut = 6;
            float r4 = scl * 0.875f;
            float r3 = r4 * 0.75471693f;
            float r2 = r4 * 0.47735846f;
            float r1 = r4 * 0.18867923f;
            for (i = 0; i < 4; ++i) {
                p = ((double)i + 0.5) / 4.0;
                im = Modems.getMap(map, olut, i);
                x[im] = r1 * Modems.coscf(p);
                y[im] = r1 * Modems.sincf(p);
            }
            for (i = 4; i < 16; ++i) {
                p = ((double)i - 3.5) / 12.0;
                im = Modems.getMap(map, olut, i);
                x[im] = r2 * Modems.coscf(p);
                y[im] = r2 * Modems.sincf(p);
            }
            for (i = 16; i < 36; ++i) {
                p = ((double)i - 15.5) / 20.0;
                im = Modems.getMap(map, olut, i);
                x[im] = r3 * Modems.coscf(p);
                y[im] = r3 * Modems.sincf(p);
            }
            for (i = 36; i < 64; ++i) {
                p = ((double)i - 35.5) / 28.0;
                im = Modems.getMap(map, olut, i);
                x[im] = r4 * Modems.coscf(p);
                y[im] = r4 * Modems.sincf(p);
            }
        } else if (mod == 17) {
            int im;
            double p;
            int i;
            olut = 3;
            float r2 = scl * 0.7392f;
            float r1 = 0.3072f;
            for (i = 0; i < 4; ++i) {
                p = ((double)i + 0.5) / 4.0;
                im = Modems.getMap(map, olut, i);
                x[im] = r1 * Modems.coscf(p);
                y[im] = r1 * Modems.sincf(p);
            }
            for (i = 4; i < 8; ++i) {
                p = ((double)i - 3.5) / 4.0;
                im = Modems.getMap(map, olut, i);
                x[im] = r2 * Modems.coscf(p);
                y[im] = r2 * Modems.sincf(p);
            }
        } else {
            switch (mod) {
                case 18: {
                    olut = 4;
                    hlut = 4;
                    break;
                }
                case 19: {
                    olut = 5;
                    hlut = 6;
                    break;
                }
                case 20: {
                    olut = 6;
                    hlut = 8;
                    break;
                }
                case 21: {
                    olut = 7;
                    hlut = 12;
                    break;
                }
                case 22: {
                    olut = 8;
                    hlut = 16;
                    break;
                }
                case 23: {
                    olut = 9;
                    hlut = 24;
                    break;
                }
                case 24: {
                    olut = 10;
                    hlut = 32;
                }
            }
            float ampd = 2.0f * scl / (float)hlut;
            float amp0 = -scl + ampd / 2.0f;
            for (int i = 0; i < hlut; ++i) {
                for (int j = 0; j < hlut; ++j) {
                    if (!((mod != 19 || i >= 1 && i <= 4 || j >= 1 && j <= 4) && (mod != 21 || i >= 2 && i <= 9 || j >= 2 && j <= 9) && (mod != 23 || i >= 4 && i <= 19 || j >= 4 && j <= 19))) continue;
                    int im = Modems.getMapXY(map, olut, i, j, k);
                    x[im] = amp0 + (float)i * ampd;
                    y[im] = amp0 + (float)j * ampd;
                    ++k;
                }
            }
        }
        return olut;
    }

    public static int diff(int order, int e) {
        int i1 = 0;
        int d = 0;
        for (int i = 0; i < order; ++i) {
            int i0 = i1;
            i1 = e >> i & 1;
            int ix = i0 ^ i1;
            d |= ix << i;
        }
        return d;
    }

    public static int genLUT(int order, int poly0, int poly1, boolean denc, int iper, int oper, int plen, int ppat, int[] lut, int[] pflg) {
        int pp;
        int j;
        int MO = 9;
        boolean tcm = ppat == 7;
        int len = order == 0 ? 1 << iper : 1 << order;
        int mask = order == 1 ? 0 : len - 1;
        int mpunc = plen - 1;
        if (mpunc < 0) {
            mpunc = 0;
        }
        if (lut != null) {
            for (int i = 0; i < len; ++i) {
                int k = denc ? Modems.diff(order, i) : i;
                int k0 = Modems.ones(k & poly0, order) & 1;
                int k1 = Modems.ones(k & poly1, order) & 1;
                int p0 = i % 2 == 1 ? (1 << oper) - 1 : 0;
                int p1 = 0x100 | k0;
                int p2 = 0x100 | k1;
                int p3 = k1 << 1 | k0;
                int p4 = k0 << 1 | k1;
                if (tcm) {
                    for (j = 0; j < 8; ++j) {
                        k = k0 != 0 ? j & 5 : j & 3;
                        int par = Modems.ones(k, 3) & 1;
                        lut[j << MO | i] = par << 2 | k0 << 1 | k1;
                    }
                    continue;
                }
                for (j = 0; j < plen; ++j) {
                    pp = ppat >> 4 * j & 0xF;
                    lut[j << MO | i] = (short)(order == 0 ? i & mask : (pp == 0 ? p0 : (pp == 1 ? p1 : (pp == 2 ? p2 : (pp == 3 ? p3 : (pp == 4 ? p4 : p0))))));
                }
            }
        }
        if (pflg != null) {
            for (j = 0; j < plen; ++j) {
                pp = ppat >> 4 * j & 0xF;
                pflg[j] = pp == 2 ? 9 : (pp == 1 ? 10 : 0);
            }
        }
        return mpunc << 28 | mask << 16 | oper << 8 | iper;
    }

    public static int getFECLUT(int alg, int upp, int[] lut, int[] pflg) {
        int io = 0;
        boolean up = upp != 0;
        switch (alg) {
            case 0: {
                io = Modems.genLUT(0, 0, 0, false, 1, 1, 1, up ? upp : 0, lut, pflg);
                break;
            }
            case 1: {
                io = Modems.genLUT(1, 1, 0, false, 1, 1, 1, up ? upp : 0, lut, pflg);
                break;
            }
            case 2: {
                io = Modems.genLUT(1, 1, 0, false, 1, 2, 1, up ? upp : 0, lut, pflg);
                break;
            }
            case 3: {
                io = Modems.genLUT(1, 1, 0, false, 1, 3, 1, up ? upp : 0, lut, pflg);
                break;
            }
            case 11: 
            case 12: {
                io = Modems.genLUT(7, 109, 79, false, 1, 2, 1, up ? upp : 3, lut, pflg);
                break;
            }
            case 13: {
                io = Modems.genLUT(7, 109, 79, false, 1, 2, 2, up ? upp : 19, lut, pflg);
                break;
            }
            case 14: {
                io = Modems.genLUT(7, 109, 79, false, 1, 2, 3, up ? upp : 531, lut, pflg);
                break;
            }
            case 15: {
                io = Modems.genLUT(7, 109, 79, false, 1, 2, 4, up ? upp : 4371, lut, pflg);
                break;
            }
            case 16: {
                io = Modems.genLUT(7, 109, 79, false, 1, 2, 5, up ? upp : 135699, lut, pflg);
                break;
            }
            case 17: {
                io = Modems.genLUT(7, 109, 79, false, 1, 2, 6, up ? upp : 0x212113, lut, pflg);
                break;
            }
            case 18: {
                io = Modems.genLUT(7, 109, 79, false, 1, 2, 7, up ? upp : 0x2121113, lut, pflg);
                break;
            }
            case 19: 
            case 20: {
                io = Modems.genLUT(9, 431, 285, false, 1, 2, 1, up ? upp : 3, lut, pflg);
                break;
            }
            case 21: {
                io = Modems.genLUT(9, 431, 285, false, 1, 2, 2, up ? upp : 19, lut, pflg);
                break;
            }
            case 22: {
                io = Modems.genLUT(9, 431, 285, false, 1, 2, 3, up ? upp : 275, lut, pflg);
                break;
            }
            case 23: {
                io = Modems.genLUT(9, 431, 285, false, 1, 2, 4, up ? upp : 4627, lut, pflg);
                break;
            }
            case 24: {
                io = Modems.genLUT(9, 431, 285, false, 1, 2, 5, up ? upp : 135459, lut, pflg);
                break;
            }
            case 25: {
                io = Modems.genLUT(9, 431, 285, false, 1, 2, 6, up ? upp : 0x211213, lut, pflg);
                break;
            }
            case 26: {
                io = Modems.genLUT(9, 431, 285, false, 1, 2, 7, up ? upp : 0x1121213, lut, pflg);
                break;
            }
            case 29: 
            case 30: {
                io = Modems.genLUT(7, 109, 79, false, 2, 3, 1, up ? upp : 7, lut, pflg);
                break;
            }
            case 31: {
                io = Modems.genLUT(7, 109, 79, true, 2, 3, 1, up ? upp : 7, lut, pflg);
                break;
            }
            default: {
                io = Modems.genLUT(0, 0, 0, false, 1, 1, 1, up ? upp : 0, lut, pflg);
                System.out.printf("Unhandled FEC algorithm index=%d \n", alg);
            }
        }
        return io;
    }

    public static int getFrameSize(int modt, int fect, int word, int len) {
        int isb;
        int fsb;
        int fs;
        int bps = Modems.getBitsPerSym(modt);
        int iom = Modems.getFECLUT(fect, 0, null, null);
        int iper = iom >> 0 & 0xFF;
        int oper = iom >> 8 & 0xFF;
        int mask = iom >> 16 & 0xFFF;
        int punc = iom >> 28 & 0xF;
        int iperp = iper * ++punc;
        int operp = oper + (punc - 1) * (oper - 1);
        for (fs = len; fs > 30 && ((fsb = fs * bps) % operp != 0 || (isb = fsb / operp * iperp) % word != 0); --fs) {
        }
        if (fs != len) {
            System.out.printf("RFP Frame: ask=%d use=%d\n", len, fs);
        }
        if (fs < 32) {
            System.out.printf("Problem finding frame size for bps=%d word=%d feci=%d feco=%d punc=%d\n", bps, word, iper, oper, punc);
        }
        return oper << 28 | iper << 24 | punc << 20 | bps << 16 | fs;
    }

    public static int getFrameFor(String mod, String fec, int word, int len) {
        return Modems.getFrameSize(Modems.getModID(mod), Modems.getFecID(fec), word, len);
    }

    public static int getFrameAWG(int fsm) {
        int fs = fsm >> 0 & 0xFFFF;
        return fs;
    }

    public static double getFECratio(int fect) {
        int iom = Modems.getFECLUT(fect, 0, null, null);
        int iper = iom >> 0 & 0xFF;
        int oper = iom >> 8 & 0xFF;
        int mask = iom >> 16 & 0xFFF;
        int punc = iom >> 28 & 0xF;
        int iperp = iper * ++punc;
        int operp = oper + (punc - 1) * (oper - 1);
        return Modems.i2d(operp * iper) / (double)iperp;
    }

    public static int getFrameFEC(int fsm) {
        int fs = fsm >> 0 & 0xFFFF;
        int bps = fsm >> 16 & 0xF;
        int punc = fsm >> 20 & 0xF;
        int iper = fsm >> 24 & 0xF;
        int oper = fsm >> 28 & 0xF;
        int iperp = iper * punc;
        int operp = oper + (punc - 1) * (oper - 1);
        return fs * bps / operp * iperp / iper;
    }

    public static class IFEC
    extends CoreComponent {
        int MO;
        int MP;
        int OLUT;
        int NLUT;
        public int alg;
        public int upp;
        public double ratio;
        int ilen;
        int olen;
        int ibit;
        int slen;
        int obit;
        int serr;
        int ipunc;
        int jpunc;
        int mpunc;
        int mask;
        int shft;
        int rluts;
        int vluts;
        int[] rlut;
        int[] pflgs;
        int vflg;
        int sdb;
        long ivec;
        int ovec;
        boolean iby3;
        boolean oby2;
        boolean frm1;
        boolean frm2;
        int uv;
        CoreComponent.Viterbi vit;
        public static final String handleAuto = "sets,process=iix1,processReframe=x1,processRepunc=x0";
        public static final String handleMethod_process = "$process_ena=T,$hsym=%1,$hbits=%2,x=1,%0=$process_ret";
        public static final String handleMethod_processReframe = "$processReframe_ena=T,x=1";
        public static final String handleMethod_processRepunc = "$processRepunc_ena=T,x=0";
        public static final String handleArgs = "sets,i:process_ena,i:uint32:hsym,i:uint5:hbits,o:uint32:process_ret,i:processReframe_ena,i:processRepunc_ena";

        public IFEC(int OFEC) {
            this.MO = OFEC;
            this.MP = this.MO + 3;
            this.OLUT = this.MP + 2;
            this.NLUT = 1 << this.OLUT;
            this.pflgs = new int[8];
            this.rlut = new int[this.NLUT];
            this.vit = new CoreComponent.Viterbi();
        }

        public void formLUT() {
            int[] elut = new int[this.NLUT];
            int iom = Modems.getFECLUT(this.alg, this.upp, elut, this.pflgs);
            this.olen = iom >> 0 & 0xFF;
            this.ilen = iom >> 8 & 0xFF;
            this.mask = iom >> 16 & 0xFFF;
            this.mpunc = iom >> 28 & 0xF;
            if (!IFEC.getBit(this.vflg, 7) || IFEC.getBit(this.vflg, 6)) {
                this.rlut = new int[8];
                return;
            }
            int ni = this.ilen >= 3 ? 8 : (this.ilen == 2 ? 4 : 2);
            for (int shift = 0; shift < 1 << this.MO; ++shift) {
                for (int bi = 0; bi < ni; ++bi) {
                    int bo;
                    int score0 = (bi ^ elut[shift << 1 & this.mask | 0]) & 3;
                    int score1 = (bi ^ elut[shift << 1 & this.mask | 1]) & 3;
                    int ferrs = 0;
                    if (this.alg >= 29) {
                        int r;
                        int n = r = score1 < score0 ? 1 : 0;
                        if (score0 != 0 && score1 != 0) {
                            ++ferrs;
                        }
                        int q = (bi & 2) != 0 ? 1 : 0;
                        int p = (bi & 4) != 0 ? 1 : 0;
                        for (int iuv = 0; iuv < 4; ++iuv) {
                            int u = (iuv & 1) != 0 ? 1 : 0;
                            int v = (iuv & 2) != 0 ? 1 : 0;
                            bo = r << 1 | (q != 0 ? p ^ v : p ^ u);
                            this.rlut[iuv << this.MP | bi << this.MO | shift] = ferrs << 3 | q << 2 | bo;
                        }
                        continue;
                    }
                    int n = bo = score1 < score0 ? 1 : 0;
                    if (score0 != 0 && score1 != 0) {
                        ++ferrs;
                    }
                    if (score0 == 0) {
                        this.rlut[1 << this.MP | (bi >> 1 & 1) << this.MO | shift] = bo;
                    }
                    if (score1 == 0) {
                        this.rlut[1 << this.MP | (bi >> 1 & 1) << this.MO | shift] = bo;
                    }
                    if (score0 == 0) {
                        this.rlut[2 << this.MP | (bi >> 0 & 1) << this.MO | shift] = bo;
                    }
                    if (score1 == 0) {
                        this.rlut[2 << this.MP | (bi >> 0 & 1) << this.MO | shift] = bo;
                    }
                    this.rlut[0 << this.MP | bi << this.MO | shift] = ferrs << 3 | bo;
                }
            }
        }

        public void open(int palg, int pupp, int flags) {
            this.alg = palg;
            this.upp = pupp;
            this.vflg = flags;
            this.formLUT();
            this.iby3 = this.ilen == 3;
            this.oby2 = this.olen == 2;
            this.ibit = 0;
            this.obit = 0;
            this.serr = 0;
            this.sdb = IFEC.getBit(this.vflg, 1) ? 4 : (IFEC.getBit(this.vflg, 0) ? 3 : 1);
            this.slen = this.ilen * this.sdb;
        }

        public double getRatio() {
            return Modems.getFECratio(this.alg);
        }

        public void processReframe() {
            if (IFEC.getBit(this.vflg, 5)) {
                this.frm1 = this.ibit == this.sdb;
                boolean bl = this.frm2 = !this.frm1;
            }
            if (this.frm2) {
                this.shft = 0;
            }
        }

        public void processRepunc() {
            this.ipunc = this.ipunc >= this.mpunc ? 0 : this.ipunc + 1;
            int n = this.jpunc = this.jpunc >= this.mpunc ? 0 : this.jpunc + 1;
            if (this.jpunc == 0 && !IFEC.getBit(this.vflg, 2)) {
                ++this.ibit;
            }
        }

        public int process(int hsym, int hbits) {
            boolean s3 = IFEC.getBit(this.vflg, 0);
            boolean s4 = IFEC.getBit(this.vflg, 1);
            boolean tcm = IFEC.getBit(this.vflg, 2);
            boolean uv35 = IFEC.getBit(this.vflg, 3);
            boolean ufad = IFEC.getBit(this.vflg, 4);
            boolean ufrm = IFEC.getBit(this.vflg, 5);
            boolean uvit = IFEC.getBit(this.vflg, 6);
            boolean ufec = IFEC.getBit(this.vflg, 7);
            this.ivec = hsym << this.ibit | IFEC.getBits(this.ivec, 7, 0);
            this.ibit += hbits;
            this.obit = 0;
            boolean init = true;
            while (this.ibit >= this.slen) {
                int bihd;
                int ump;
                int pflg = this.pflgs[this.ipunc];
                int n = ump = tcm ? this.uv : IFEC.getBits(pflg, 1, 0);
                int iinc = this.iby3 ? (s4 ? 12 : (s3 ? 9 : 3)) : (IFEC.getBit(pflg, 3) ? (s4 ? 4 : (s3 ? 3 : 1)) : (s4 ? 8 : (s3 ? 6 : 2)));
                int n2 = this.ipunc = this.ipunc >= this.mpunc ? 0 : this.ipunc + 1;
                int n3 = this.iby3 ? IFEC.getBits(this.ivec, 2, 0) : (bihd = !IFEC.getBit(pflg, 3) ? IFEC.getBits(this.ivec, 1, 0) : IFEC.getBits(this.ivec, 0, 0));
                if (uvit) {
                    this.vluts = this.vit.process(IFEC.getBits(this.ivec, 11, 0), pflg, this.vflg);
                } else {
                    boolean restr;
                    boolean bl = restr = ufad && IFEC.getBit(this.rluts, 3);
                    int shift = restr ? 0 : (this.frm2 ? 0 : (tcm ? IFEC.getBits(this.rluts, 1, 1) : IFEC.getBits(this.rluts, 0, 0))) | this.shft << 1;
                    int ilut = ump << this.MP | bihd << this.MO | shift & this.mask;
                    this.rluts = this.rlut[ilut];
                    this.shft = this.frm1 ? 0 : shift;
                    this.uv = IFEC.getBit(this.rluts, 2) ? this.uv & 1 | IFEC.getBits(this.rluts, 0, 0) << 1 : this.uv & 2 | IFEC.getBits(this.rluts, 0, 0);
                }
                int xluts = uvit ? this.vluts : this.rluts;
                boolean valid = uvit ? IFEC.getBit(this.vluts, 2) : true;
                int fhd = valid ? IFEC.getBits(xluts, 1, 0) : 0;
                int ferr = valid ? IFEC.getBits(xluts, 3, 3) : 0;
                int flen = valid ? this.olen : 0;
                this.serr = init ? ferr : this.serr + ferr;
                this.ovec = init ? fhd : this.ovec | fhd << this.obit;
                this.obit = init ? flen : this.obit + flen;
                this.ivec >>= iinc;
                this.ibit -= iinc;
                init = false;
                this.frm2 = this.frm1;
                this.frm1 = false;
            }
            return this.serr << 24 | this.obit << 16 | this.ovec;
        }
    }
}

