/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.AWG;
import nxm.ice.core.Modefs;
import nxm.ice.core.RFP;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class MOD
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int SELFPACE = 1;
    public static final int BW = 32;
    public static final int MC = 1;
    public static final int SSZ = 256;

    public static class CORE
    extends Core
    implements Modefs {
        RFP.CORE rfp;
        AWG.CORE awg;
        CoreComponent.Stream sa;
        boolean gen;

        @Override
        public int init() {
            this.rfp = new RFP.CORE();
            this.rfp.initSub(1, this.halo);
            this.awg = new AWG.CORE();
            this.awg.initSub(2, this.halo);
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.rfp.set(key, value) < 0 && this.awg.set(key, value) < 0) {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.rfp.get(key, value) < 0 && this.awg.get(key, value) < 0) {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.rfp.open();
            this.awg.open();
            this.sa = new CoreComponent.Stream(256, 32, 32);
            this.gen = this.rfp.isGen();
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            while ((this.gen || si.rok) && so.wok) {
                this.rfp.process(si, this.sa);
                this.awg.process(this.sa, so);
            }
            return 0;
        }

        @Override
        public int close() {
            this.rfp.close();
            this.awg.close();
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

