/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class MFPP
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int BW = 32;
    public static final int OHIT = 8;
    public static final int MHIT = 256;
    public static final int OTOP = 8;
    public static final int MTOP = 256;
    public static final int OWIN = 6;
    public static final int MWIN = 64;
    public static final int OFFT = 14;
    public static final int MFFT = 16384;
    public static final int PIPE = 1;

    public static class CORE
    extends Core {
        public static final String flgList = "Bypass,Strip,Tag,Log,Peak,Sort,Diff,HiThresh";
        public static final int F_BYPASS = 0;
        public static final int F_STRIP = 1;
        public static final int F_TAG = 2;
        public static final int F_LOG = 3;
        public static final int F_PEAK = 4;
        public static final int F_SORT = 5;
        public static final int F_DIFF = 6;
        public static final int F_HITHRESH = 7;
        float thresh;
        int frame;
        float vthresh;
        int mframe;
        int nwin;
        int ntop;
        float tmin;
        int flags;
        int itop;
        int count;
        boolean cntovr;
        boolean isUp;
        int iup;
        float vtot;
        float vhit;
        float vnf;
        CoreComponent.StatBuf sbuf;
        int[] hiti;
        float[] hitv;
        int edgeL;
        int edgeR;

        public int addToSort(int itop, float vtot, int vind) {
            for (int ii = itop; ii >= 0; --ii) {
                boolean rep1;
                boolean rep0 = ii == itop || vtot > this.hitv[ii];
                boolean bl = rep1 = ii > 0 && vtot > this.hitv[ii - 1];
                if (rep1) {
                    this.hiti[ii] = this.hiti[ii - 1];
                    this.hitv[ii] = this.hitv[ii - 1];
                    continue;
                }
                if (!rep0) continue;
                this.hiti[ii] = vind;
                this.hitv[ii] = vtot;
            }
            if (itop < this.ntop) {
                ++itop;
            }
            return itop;
        }

        @Override
        public int init() {
            this.thresh = 2.0f;
            this.frame = 256;
            this.ntop = 64;
            this.tmin = 0.0f;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:FRAME")) {
                this.frame = value.toL();
            } else if (this.isMatch(key, "L:WIDTH")) {
                this.nwin = value.toL();
            } else if (this.isMatch(key, "L:NTOP")) {
                this.ntop = value.toL();
            } else if (this.isMatch(key, "F:THRESH")) {
                this.thresh = value.toF();
            } else if (this.isMatch(key, "F:TMIN")) {
                this.tmin = value.toF();
            } else if (this.isMatch(key, "S:FLAGS")) {
                this.flags = value.toMask(flgList);
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:FRAME")) {
                value.fromL(this.frame);
            } else if (this.isMatch(key, "L:WIDTH")) {
                value.fromL(this.nwin);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            if (this.nwin > 64) {
                System.out.printf("Sliding window width=%d limited to max=%d\n", this.nwin, 64);
                this.nwin = 64;
            }
            if (this.ntop > 256) {
                System.out.printf("Number peaks=%d limited to max=%d\n", this.ntop, 256);
                this.ntop = 256;
            }
            this.sbuf = new CoreComponent.StatBuf(6);
            this.sbuf.setLength(this.nwin);
            this.hiti = new int[256];
            this.hitv = new float[256];
            this.cntovr = false;
            if (this.ntop == 0) {
                this.flags |= 0;
            }
            this.vthresh = 1.0f / this.thresh;
            this.count = 0;
            this.mframe = this.frame - 1;
            this.itop = 0;
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("MFPP frame=%d ntop=%d flags=%x\n", this.frame, this.ntop, this.flags);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            boolean bypass = CORE.getBit(this.flags, 0);
            boolean strip = CORE.getBit(this.flags, 1);
            boolean tag = CORE.getBit(this.flags, 2);
            boolean log = CORE.getBit(this.flags, 3);
            boolean peak = CORE.getBit(this.flags, 4);
            boolean sort = CORE.getBit(this.flags, 5);
            boolean diff = CORE.getBit(this.flags, 6);
            boolean hsnr = CORE.getBit(this.flags, 7);
            while (si.rok && so.wok && !this.cntovr) {
                boolean hitm;
                boolean cntok = this.count >= this.nwin && this.edgeR == 0;
                this.cntovr = this.count >= this.mframe;
                int ibin = this.count - (this.nwin >> 1);
                this.count = bypass || this.count >= this.mframe ? 0 : this.count + 1;
                float vi = si.rdF();
                if (!strip) {
                    so.wrL(CORE.fp2i(vi));
                }
                this.sbuf.load(vi);
                float vmid = this.sbuf.getMid();
                float vmin = this.sbuf.getMinM(peak ? 0 : -1);
                float vmax = this.sbuf.getMaxM(1);
                float v = diff ? vmid - vmin : vmid - this.vnf;
                float vthr = CORE.mulff(vmid, this.vthresh);
                float vchk = log ? vmid - this.thresh : vthr;
                boolean hitu = cntok && vchk > vmin;
                boolean hitd = this.cntovr || vmid < this.vhit;
                boolean bl = hitm = hsnr && vmax - vmid > this.thresh;
                if (this.isUp && hitd) {
                    this.edgeR = this.sbuf.getMinI(1);
                    int edgeM = CORE.imin(this.edgeL, this.edgeR);
                    int ve = ibin + edgeM << 16 | this.iup - edgeM;
                    if (!(this.vtot < this.tmin)) {
                        if (sort) {
                            this.itop = this.addToSort(this.itop, this.vtot, ve);
                        } else if (this.itop < this.ntop) {
                            this.hiti[this.itop] = ve;
                            this.hitv[this.itop] = this.vtot;
                            ++this.itop;
                        }
                    }
                    this.isUp = false;
                    this.vtot = 0.0f;
                    continue;
                }
                if (this.isUp ? hitm : hitu) {
                    this.iup = ibin;
                    this.vtot = v;
                    this.vhit = vmid;
                    if (!this.isUp) {
                        this.vnf = vmin;
                    }
                    this.edgeL = this.sbuf.getMinI(-1);
                    this.isUp = true;
                    continue;
                }
                if (this.isUp) {
                    if (!peak) {
                        this.vtot += v;
                        continue;
                    }
                    if (!(v > this.vtot)) continue;
                    this.vtot = v;
                    continue;
                }
                if (this.edgeR <= 0) continue;
                --this.edgeR;
            }
            while (so.wok && this.cntovr) {
                this.cntovr = this.count < this.ntop;
                boolean topl = this.count < this.itop;
                boolean topn = this.count == this.ntop;
                int vc = this.hiti[this.count];
                float vd = this.hitv[this.count];
                int n = this.count = this.count >= this.ntop ? 0 : this.count + 1;
                if (!topn || tag) {
                    int vcx;
                    int n2 = topn ? this.itop : (vcx = topl ? vc : 0);
                    float vdx = topn ? this.vtot : (topl ? vd : 0.0f);
                    so.wrL(vcx);
                    so.wrL(CORE.fp2i(vdx));
                    this.vtot += vd;
                }
                if (!topn) continue;
                this.itop = 0;
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

