/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class LRS
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int NP = 1;
    public static final int BW = 32;

    public static class CORE
    extends Core {
        int gain;
        float fscl;
        int lrsx;
        int lrsy;
        CoreCommon.CxFloat[] vi;
        CoreCommon.CxFloat[] vo;
        boolean neg;

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (!this.isMatch(key, "L:GAIN")) {
                return super.set(key, value);
            }
            this.gain = value.toL();
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (!this.isMatch(key, "L:GAIN")) {
                return super.get(key, value);
            }
            value.fromL(this.gain);
            return 0;
        }

        public int fLRS(int lrs) {
            return lrs << 1 | CORE.getBits(lrs, 0, 0) ^ CORE.getBits(lrs, 1, 1) ^ CORE.getBits(lrs, 5, 5) ^ CORE.getBits(lrs, 25, 25);
        }

        @Override
        public int init() {
            this.gain = -70;
            this.lrsx = -123457;
            this.lrsy = -654322;
            this.neg = false;
            return 0;
        }

        @Override
        public int open() {
            int i;
            this.fscl = CORE.d2f(CORE.pow(2.0, (double)this.gain / 6.0));
            this.vi = new CoreCommon.CxFloat[1];
            for (i = 0; i < 1; ++i) {
                this.vi[i] = new CoreCommon.CxFloat();
            }
            this.vo = new CoreCommon.CxFloat[1];
            for (i = 0; i < 1; ++i) {
                this.vo[i] = new CoreCommon.CxFloat();
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            while (si.rok && so.wok) {
                si.rdCIFA(this.vi, 1);
                int lrsx2 = CORE.iLRS(this.lrsx);
                int lrsy2 = CORE.iLRS(this.lrsy);
                for (int i = 0; i < 1; ++i) {
                    CoreCommon.CxFloat cn = CoreCommon.CxFloat.stk();
                    CoreCommon.CxFloat cm = CoreCommon.CxFloat.stk();
                    cn.x = CORE.L2F(i > 0 ? ~lrsx2 : (this.neg ? ~this.lrsx : this.lrsx));
                    cn.y = CORE.L2F(i > 0 ? ~lrsy2 : (this.neg ? ~this.lrsy : this.lrsy));
                    cm.x = cn.x * this.fscl;
                    cm.y = cn.y * this.fscl;
                    CORE.addcc(this.vi[i], cm, this.vo[i]);
                }
                this.lrsx = lrsx2;
                this.lrsy = lrsy2;
                this.neg = !this.neg;
                so.wrCFIA(this.vo, 1);
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

