/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreLibrary;

public class Filters
extends CoreLibrary {
    public static final int FIRKAIS_LOW = 1;
    public static final int FIRKAIS_HIGH = 2;
    public static final int FIRKAIS_BAND = 3;

    public static double sinx(double arg) {
        double num = Filters.sin(arg);
        if (Filters.fabs(arg) < 1.0E-20 && Filters.fabs(num) < 1.0E-20) {
            return 1.0;
        }
        return num / arg;
    }

    public static double besselIO(double x) {
        double ds = 1.0;
        double d = 0.0;
        double s = 1.0;
        while (!((ds = ds * x * x / ((d += 2.0) * d)) - (s += ds) * 2.0E-9 < 0.0)) {
        }
        return s;
    }

    public static int genFirKais(int type, double f1, double f2, double f3, double attn, float[] filt, int ntap) {
        double fcntr = f1;
        double fpass = type == 3 ? f2 * 0.5 : f1;
        double ftnbw = f3;
        double fsamp = 2.0;
        double mtap = (attn - 8.0) / (14.357078426905355 * ftnbw / fsamp);
        if (ntap <= 0) {
            ntap = (int)(mtap + 1.5);
        }
        if (ntap <= 0) {
            return 0;
        }
        double beta = attn > 50.0 ? 0.1102 * (attn - 8.7) : (attn >= 21.0 ? 0.5842 * Filters.pow(attn - 21.0, 0.4) + 0.07886 * (attn - 21.0) : 0.0);
        double alpha = 0.5 * (double)(ntap - 1);
        double fcut = type == 2 ? fpass - 0.5 * ftnbw : fpass + 0.5 * ftnbw;
        double wcut = Math.PI * 2 * (fcut /= fsamp);
        double den = Filters.besselIO(beta);
        if (type != 3) {
            fcntr = 0.0;
        }
        double strt = -0.5 * (double)(ntap - 1);
        double lo = Math.PI * 2 * fcntr / fsamp;
        for (int i = 0; i < ntap; ++i) {
            double pcos = Filters.cos((strt + (double)i) * lo);
            double psin = Filters.sin((strt + (double)i) * lo);
            double resp = 2.0 * fcut * Filters.sinx(wcut * ((double)i - alpha));
            if (type == 2) {
                resp = Filters.sinx(Math.PI * ((double)i - alpha)) - resp;
            }
            double factor = Filters.sqrt(1.0 - Filters.pow((1.0 * (double)i - alpha) / alpha, 2.0));
            double wind = Filters.besselIO(beta * factor) / den;
            filt[i + i + 0] = (float)(wind * resp * pcos);
            filt[i + i + 1] = (float)(wind * resp * psin);
        }
        return ntap;
    }

    public static double sincfunc(double x) {
        double num = Filters.sin(x);
        double sinc = 1.0;
        if (Filters.fabs(num) > 1.0E-20 && Filters.fabs(x) > 1.0E-20) {
            sinc = num / x;
        }
        return sinc;
    }

    public static float[] genWindowFilter(int len, int wtype, int ftype, double freq1, double freq2, double fs) {
        float[] filt = new float[len];
        freq1 /= fs;
        freq2 /= fs;
        double alpha = 0.5 * (double)(len - 1);
        for (int i = 0; i < len; ++i) {
            double win = 1.0;
            if (wtype == 1) {
                win = 0.5 - 0.5 * Filters.cos((double)i * Math.PI / alpha);
            }
            if (wtype == 2) {
                win = 0.54 - 0.46 * Filters.cos((double)i * Math.PI / alpha);
            }
            double ideal = 2.0 * freq1 * Filters.sincfunc(Math.PI * 2 * freq1 * ((double)i - alpha));
            if (ftype == 2) {
                ideal = Filters.sincfunc(Math.PI * ((double)i - alpha)) - ideal;
            }
            filt[i] = (float)(win * ideal);
        }
        return filt;
    }

    public static int applyCompensation(float alpha, float[] filt, int n) {
        float f2;
        float c0 = -alpha / 2.0f;
        float c1 = 1.0f + alpha;
        float c2 = -alpha / 2.0f;
        float f1 = filt[n - 1];
        float fx = f2 = filt[0];
        for (int i = 0; i < n; ++i) {
            float f0 = f1;
            f1 = f2;
            f2 = i == n - 1 ? fx : filt[i + 1];
            filt[i] = f0 * c0 + f1 * c1 + f2 * c2;
        }
        return n;
    }

    public static int genLinearSlope(double attn, float[] filt, int ntap) {
        int n = ntap;
        return n;
    }

    public static class CxPhasePLL
    extends CoreComponent {
        int BNSHF = 20;
        float B0;
        float B1;
        float adl;
        double nco;
        double uF;
        public static final String handleAuto = "sets,process=ix4";
        public static final String handleMethod_process = "$process_ena=T,$fi=%1,x=4,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:fptx:process_ret";

        public void setup(double K, double bw, double Zeta, double Fs) {
            double wn = bw * Math.PI / Zeta;
            double Tau1 = K / (wn * wn);
            double Tau2 = 2.0 * Zeta / wn;
            this.B0 = CxPhasePLL.mulfp2((float)(1.0 / (2.0 * Tau1 * Fs * Fs) * (1.0 + 1.0 / CxPhasePLL.tan(1.0 / (2.0 * Tau2 * Fs)))), this.BNSHF);
            this.B1 = CxPhasePLL.mulfp2((float)(1.0 / (2.0 * Tau1 * Fs * Fs) * (1.0 - 1.0 / CxPhasePLL.tan(1.0 / (2.0 * Tau2 * Fs)))), this.BNSHF);
            this.adl = 0.0f;
            this.uF = 0.0;
        }

        public float process(CoreCommon.CxFloat fi) {
            float ap = CxPhasePLL.atan2cf(fi.y, fi.x);
            float ad = CxPhasePLL.wrapf(ap - CxPhasePLL.d2f(this.nco));
            this.nco = CxPhasePLL.frac(this.nco + CxPhasePLL.divp2(this.uF, this.BNSHF));
            this.uF += CxPhasePLL.f2d(this.B0 * ad + this.B1 * this.adl);
            this.adl = ad;
            return CxPhasePLL.d2f(this.nco);
        }
    }

    public static class CxIIR
    extends CoreComponent {
        int ORD;
        int STR;
        int LEN;
        int LENM1;
        CxIIRStageO1 s1;
        CxIIRStageO1 s2;
        CxIIRStageO1 s3;
        CoreCommon.CxFloat c1;
        CoreCommon.CxFloat c2;
        int iN;
        int iM;
        int i2M;
        float[] ax1;
        float[] ax2;
        float[] ax3;
        float[] ax4;
        float[] ay1;
        float[] ay2;
        float[] ay3;
        float[] ay4;
        public static final String handleAuto = "sets,process=iox10";
        public static final String handleMethod_process = "$process_ena=T,$ci=%1,x=10,%2=$co,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:ci,o:CxFptx:co,o:process_ret";

        public CxIIR(int ORDER, int STRIDE) {
            this.ORD = ORDER;
            this.STR = STRIDE;
            this.LEN = this.STR * 2;
            this.LENM1 = this.LEN - 1;
            this.s1 = new CxIIRStageO1();
            this.s2 = new CxIIRStageO1();
            this.s3 = new CxIIRStageO1();
            this.c1 = new CoreCommon.CxFloat();
            this.c2 = new CoreCommon.CxFloat();
            this.ax1 = new float[this.LEN];
            this.ay1 = new float[this.LEN];
            this.ax2 = new float[this.LEN];
            this.ay2 = new float[this.LEN];
            this.ax3 = new float[this.LEN];
            this.ay3 = new float[this.LEN];
            this.ax4 = new float[this.LEN];
            this.ay4 = new float[this.LEN];
        }

        public void open(int order, float gain, float[] poles, float[] zeros) {
            int stages = 3;
            float gfact = CxIIR.powf(gain * 8.0f, 1.0f / (float)stages);
            if (order == 3) {
                this.s3.open(1, gfact, poles[4], zeros[4], 0.0f, 0.0f);
                this.s2.open(1, gfact, poles[2], zeros[2], poles[3], zeros[3]);
                this.s1.open(1, gfact, poles[0], zeros[0], poles[1], zeros[1]);
            } else if (order == 5) {
                this.s3.open(1, gfact, poles[8], zeros[8], 0.0f, 0.0f);
                this.s2.open(2, gfact, poles[4], zeros[4], poles[5], zeros[5]);
                this.s1.open(2, gfact, poles[0], zeros[0], poles[1], zeros[1]);
            } else {
                System.out.printf("Unsupported IIR filter order=%d\n", order);
            }
            this.iN = 0;
            this.iM = this.LEN - this.STR;
            this.i2M = 0;
        }

        public int process(CoreCommon.CxFloat ci, CoreCommon.CxFloat co) {
            this.ax1[this.iN] = ci.x;
            this.ay1[this.iN] = ci.y;
            this.s1.process(ci, this.c1, this.ax1[this.iM], this.ay1[this.iM], this.ax2[this.iM], this.ay2[this.iM]);
            this.ax2[this.iN] = this.c1.x;
            this.ay2[this.iN] = this.c1.y;
            this.s2.process(this.c1, this.c2, this.ax2[this.iM], this.ay2[this.iM], this.ax3[this.iM], this.ay3[this.iM]);
            this.ax3[this.iN] = this.c2.x;
            this.ay3[this.iN] = this.c2.y;
            this.s3.process(this.c2, co, this.ax3[this.iM], this.ay3[this.iM], this.ax4[this.iM], this.ay4[this.iM]);
            this.ax4[this.iN] = co.x;
            this.ay4[this.iN] = co.y;
            this.iN = this.iN == this.LENM1 ? 0 : this.iN + 1;
            this.iM = this.iM == this.LENM1 ? 0 : this.iM + 1;
            this.i2M = this.i2M == this.LENM1 ? 0 : this.i2M + 1;
            return 1;
        }
    }

    public static class CxIIRStageO2
    extends CoreComponent {
        float b0;
        float b1;
        float b2;
        float a1;
        float a2;
        public static final String handleAuto = "sets,process=iOiiiiiiiix3";
        public static final String handleMethod_process = "$process_ena=T,$fi=%1,$axM=%3,$ayM=%4,$naxM=%5,$nayM=%6,$ax2M=%7,$ay2M=%8,$nax2M=%9,$nay2M=%10,x=3,%2==$fo,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,i:fptx:axM,i:fptx:ayM,i:fptx:naxM,i:fptx:nayM,i:fptx:ax2M,i:fptx:ay2M,i:fptx:nax2M,i:fptx:nay2M,o:process_ret";

        public void open(int order, float gfact, float p1, float z1, float p2, float z2) {
            int ord = order;
            this.b0 = gfact;
            this.b1 = (float)(-ord) * z1;
            this.b2 = z1 * z1 + z2 * z2;
            this.a1 = (float)(-ord) * p1;
            this.a2 = p1 * p1 + p2 * p2;
        }

        public int process(CoreCommon.CxFloat fi, CoreCommon.CxFloat fo, float axM, float ayM, float naxM, float nayM, float ax2M, float ay2M, float nax2M, float nay2M) {
            float tax = naxM * this.a1 + nax2M * this.a2;
            float tay = nayM * this.a1 + nay2M * this.a2;
            float tbx = axM * this.b1 + ax2M * this.b2 + fi.x;
            float tby = ayM * this.b1 + ay2M * this.b2 + fi.y;
            fo.x = tbx * this.b0 - tax;
            fo.y = tby * this.b0 - tay;
            return 1;
        }
    }

    public static class CxIIRStageO1
    extends CoreComponent {
        float b0;
        float b1;
        float b2;
        float a1;
        float a2;
        public static final String handleAuto = "sets,process=iOiiiix2";
        public static final String handleMethod_process = "$process_ena=T,$fi=%1,$axM=%3,$ayM=%4,$naxM=%5,$nayM=%6,x=2,%2==$fo,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,i:fptx:axM,i:fptx:ayM,i:fptx:naxM,i:fptx:nayM,o:process_ret";

        public void open(int order, float gfact, float p1, float z1, float p2, float z2) {
            int ord = order;
            this.b0 = gfact;
            this.b1 = (float)(-ord) * z1;
            this.b2 = (float)(-ord) * z2;
            this.a1 = (float)(-ord) * p1;
            this.a2 = (float)(-ord) * p2;
        }

        public int process(CoreCommon.CxFloat fi, CoreCommon.CxFloat fo, float axM, float ayM, float naxM, float nayM) {
            float tax = naxM * this.a1 - nayM * this.a2;
            float tay = nayM * this.a1 + naxM * this.a2;
            float tbx = axM * this.b1 - ayM * this.b2 + fi.x;
            float tby = ayM * this.b1 + axM * this.b2 + fi.y;
            fo.x = tbx * this.b0 - tax;
            fo.y = tby * this.b0 - tay;
            return 1;
        }
    }

    public static class CxComb
    extends CoreComponent {
        int off;
        int lenm1;
        float fx;
        float fy;
        float scale;
        float[] ax;
        float[] ay;
        boolean full;
        public static final String handleAuto = "sets,process=iox4";
        public static final String handleMethod_process = "$process_ena=T,$fi=%1,x=4,%2=$fo,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,o:process_ret";

        public void setLength(int length) {
            this.lenm1 = length - 1;
            this.scale = 1.0f / (float)length;
        }

        public CxComb(int ORDER) {
            int len = 1 << ORDER;
            this.ax = new float[1 << ORDER];
            this.ay = new float[1 << ORDER];
            this.full = false;
            this.lenm1 = len - 1;
            this.scale = 1.0f / (float)len;
            this.off = 0;
        }

        public boolean process(CoreCommon.CxFloat fi, CoreCommon.CxFloat fo) {
            float axi = !this.full ? 0.0f : this.ax[this.off];
            float ayi = !this.full ? 0.0f : this.ay[this.off];
            float bxi = fi.x;
            float byi = fi.y;
            this.ax[this.off] = fi.x;
            this.ay[this.off] = fi.y;
            this.fx = this.fx + bxi - axi;
            this.fy = this.fy + byi - ayi;
            fo.x = this.fx * this.scale;
            fo.y = this.fy * this.scale;
            this.full = this.full || this.off == this.lenm1;
            this.off = this.off < this.lenm1 ? this.off + 1 : 0;
            return this.full;
        }
    }

    public static class CxCIC
    extends CoreComponent {
        int O_CIC;
        int O_DEC;
        int count;
        int decm;
        int coarse;
        int fine;
        long[] pix;
        long[] piy;
        int[] pox;
        int[] poy;
        int[] pdx;
        int[] pdy;
        public static final String handleAuto = "sets,process=iox4";
        public static final String handleMethod_process = "$process_ena=T,$fi=%1,x=4,%2=$fo,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,o:process_ret";

        public void setGain(int gain) {
            int dec = this.decm + 1;
            int shift = (int)(5.0 * CxCIC.log2((double)dec / 4.0) + 9.0) - CxCIC.d2i((double)gain / 6.0);
            if (shift < 0) {
                shift = 0;
            }
            if (shift >= 32) {
                this.coarse = 31;
                this.fine = shift - 31;
            } else {
                this.coarse = shift;
                this.fine = 0;
            }
        }

        public void setDecimation(int dec) {
            this.count = this.decm = dec - 1;
            this.setGain(0);
        }

        public CxCIC(int ocic, int odec) {
            this.O_CIC = ocic;
            this.O_DEC = odec;
            this.pix = new long[this.O_CIC + 1];
            this.piy = new long[this.O_CIC + 1];
            this.pox = new int[this.O_CIC + 1];
            this.poy = new int[this.O_CIC + 1];
            this.pdx = new int[this.O_CIC + 1];
            this.pdy = new int[this.O_CIC + 1];
            this.setDecimation(1 << odec);
        }

        public boolean process(CoreCommon.CxFloat fi, CoreCommon.CxFloat fo) {
            for (int ia = this.O_CIC; ia >= 0; --ia) {
                this.pix[ia] = ia == 0 ? CxCIC.s2l(CxCIC.F2I(fi.x)) : this.pix[ia] + this.pix[ia - 1];
                this.piy[ia] = ia == 0 ? CxCIC.s2l(CxCIC.F2I(fi.y)) : this.piy[ia] + this.piy[ia - 1];
            }
            boolean out = this.count == 0;
            int n = this.count = this.count == 0 ? this.decm : this.count - 1;
            if (out) {
                long pox0 = this.pix[this.O_CIC] >> this.coarse;
                long poy0 = this.piy[this.O_CIC] >> this.coarse;
                for (int ib = this.O_CIC; ib >= 0; --ib) {
                    this.pdx[ib] = this.pox[ib];
                    this.pox[ib] = ib == 0 ? CxCIC.l2i(pox0) : this.pox[ib - 1] - this.pdx[ib - 1];
                    this.pdy[ib] = this.poy[ib];
                    this.poy[ib] = ib == 0 ? CxCIC.l2i(poy0) : this.poy[ib - 1] - this.pdy[ib - 1];
                }
                fo.x = CxCIC.K2F(this.pox[this.O_CIC] >> this.fine);
                fo.y = CxCIC.K2F(this.poy[this.O_CIC] >> this.fine);
            }
            return out;
        }
    }

    public static class SmoothP2X
    extends CoreComponent {
        int shift;
        int mshft;
        float val = 0.0f;
        float scale;
        public static final String handleAuto = "sets,process=iix1";
        public static final String handleMethod_process = "$process_ena=T,$fin=%1,$valid=%2,x=1,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:fptx:fin,i:valid,o:fptx:process_ret";

        public SmoothP2X(int ORDER) {
            this.shift = ORDER;
            this.scale = 1.0f - 1.0f / (float)(1 << this.shift);
        }

        public void reset() {
            this.val = 0.0f;
        }

        public float process(float fin, boolean valid) {
            if (valid) {
                this.val = this.val * this.scale + SmoothP2X.divfp2(SmoothP2X.mulfp2(fin, 8), this.shift);
            }
            return SmoothP2X.divfp2(this.val, 8);
        }
    }

    public static class SmoothP2
    extends CoreComponent {
        int mlen;
        int mask;
        int offa;
        int offb;
        int olen;
        int lx;
        int[] ax;
        boolean full;
        public static final String handleAuto = "sets,process=iix3";
        public static final String handleMethod_process = "$process_ena=T,$fin=%1,$valid=%2,x=3,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:fptx:fin,i:valid,o:fptx:process_ret";

        public void reset() {
            int len = 1 << this.olen;
            this.offa = 0;
            this.offb = this.offa - len + 1 & this.mask;
            this.full = false;
            this.lx = 0;
        }

        public void setLength(int length) {
            int len;
            this.olen = 0;
            for (len = 1; len < length; len *= 2) {
                ++this.olen;
            }
            if (len != length) {
                System.out.printf("Smoother length modified from desired len=%d to power2 len=%d\n", length, len);
            }
            this.reset();
        }

        public SmoothP2(int ORDER) {
            this.mlen = 1 << ORDER;
            this.mask = this.mlen - 1;
            this.ax = new int[this.mlen];
            this.olen = ORDER;
            this.reset();
        }

        public float process(float fin, boolean valid) {
            int lin;
            int fa = lin = SmoothP2.F2K(fin);
            this.ax[this.offa] = lin;
            int fb = this.full ? this.ax[this.offb] : 0;
            boolean bl = this.full = this.full || this.offb == this.mask;
            if (valid) {
                this.offa = this.offa + 1 & this.mask;
                this.offb = this.offb + 1 & this.mask;
                this.lx += fa - fb;
            }
            return SmoothP2.K2F(this.lx >> this.olen);
        }
    }

    public static class Smooth
    extends CoreComponent {
        int mlen;
        int mask;
        int offa;
        int offb;
        float scale;
        double fx;
        float[] ax;
        boolean full;
        float ival;
        public static final String handleAuto = "sets,process=iix3";
        public static final String handleMethod_process = "$process_ena=T,$fin=%1,$valid=%2,x=3,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:fptx:fin,i:valid,o:fptx:process_ret";

        public void setLength(int length) {
            int len = length;
            if (len > this.mask) {
                System.out.printf("Smoother length reduced from desired len=%d to max len=%d\n", len, this.mask);
                len = this.mask;
            }
            this.scale = 1.0f / (float)len;
            this.offa = 0;
            this.offb = this.offa - len & this.mask;
            this.full = false;
            this.fx = 0.0;
            this.ival = 0.0f;
        }

        public void setInitial(float val) {
            this.ival = val;
            this.fx = this.ival / this.scale;
        }

        public Smooth(int ORDER) {
            this.mlen = 1 << ORDER;
            this.mask = this.mlen - 1;
            this.ax = new float[this.mlen];
            this.setLength(this.mlen - 1);
            this.setInitial(0.0f);
        }

        public float process(float fin, boolean valid) {
            float fa = fin;
            this.ax[this.offa] = fin;
            float fb = this.full ? this.ax[this.offb] : this.ival;
            boolean bl = this.full = this.full || this.offb == this.mask;
            if (valid) {
                this.offa = this.offa + 1 & this.mask;
                this.offb = this.offb + 1 & this.mask;
                this.fx += Smooth.f2d(fa - fb);
            }
            return Smooth.d2f(this.fx * (double)this.scale);
        }
    }
}

