/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class FSVI
extends CoreFactory {
    public static final int FLOW = 2;
    public static final int BW = 32;
    public static final int MFFT = 16384;
    public static final String flgList = "Mag,Log,Exp,Fix,MaxM,PSD";
    public static final int PF_MAG = 0;
    public static final int PF_LOG = 1;
    public static final int PF_EXP = 2;
    public static final int PF_FIX = 3;
    public static final int PF_MAXM = 4;
    public static final int PF_PSD = 5;

    public static class CORE
    extends Core {
        int nexp;
        int navg;
        float scale;
        int flags;
        int frame;
        int npkp;
        int mavg;
        int iavg;
        int bxfer;
        float p0;
        float p1;
        float lscl;
        float vadd;
        float vmin;
        float[] exbuf;
        float[] avbuf;
        boolean doReset;

        public void setPz() {
            int n;
            int n2 = n = this.nexp <= 0 ? 1 : this.nexp;
            if (this.npkp > 0) {
                n = this.npkp * this.navg;
            }
            this.p0 = 1.0f / (float)n;
            this.p1 = 1.0f - this.p0;
            this.mavg = this.navg - 1;
            this.doReset = true;
            this.putVars("p0,p1,mavg,npkp");
        }

        @Override
        public int init() {
            this.frame = 256;
            this.flags = 0;
            this.scale = 1.0f;
            this.vadd = 0.0f;
            this.vmin = 1.0f;
            this.nexp = 1;
            this.navg = 1;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:FRAME")) {
                this.frame = value.toL();
            } else if (this.isMatch(key, "L:NEXP")) {
                this.nexp = value.toL();
                this.setPz();
            } else if (this.isMatch(key, "L:NAVG")) {
                this.navg = value.toL();
                this.setPz();
            } else if (this.isMatch(key, "L:NPKP")) {
                this.npkp = value.toL();
                this.setPz();
            } else if (this.isMatch(key, "F:SCALE")) {
                this.scale = value.toF();
                this.setPz();
            } else if (this.isMatch(key, "F:VADD")) {
                this.vadd = value.toF();
            } else if (this.isMatch(key, "F:VMIN")) {
                this.vmin = value.toF();
            } else if (this.isMatch(key, "L:FLAGS")) {
                this.flags = value.toL();
            } else if (this.isMatch(key, "S:FLAGS")) {
                this.flags = value.toMask(FSVI.flgList);
            } else if (this.isMatch(key, "L:RESET")) {
                this.doReset = true;
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:FRAME")) {
                value.fromL(this.frame);
            } else if (this.isMatch(key, "L:NEXP")) {
                value.fromL(this.nexp);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.exbuf = new float[16384];
            this.avbuf = new float[16384];
            this.bxfer = this.frame * 4;
            this.setPz();
            this.lscl = 20.0f;
            this.iavg = 0;
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Buffer bi, CoreComponent.Buffer bo) {
            boolean doRes = this.doReset;
            boolean doLog = CORE.getBit(this.flags, 1);
            boolean doMax = CORE.getBit(this.flags, 4);
            boolean doMin = doRes || CORE.getBit(this.flags, 4) && this.npkp == 0;
            bi.rokLen(this.bxfer);
            bo.wokLen(this.bxfer);
            if (!bi.rok || !bo.wok) {
                return 0;
            }
            for (int i = 0; i < this.frame; ++i) {
                float a = (float)bi.getL(i << 2) * this.scale;
                float b = this.exbuf[i];
                float c = b * this.p1 + a * this.p0;
                this.exbuf[i] = doMin ? this.vmin : (doMax && a > b ? a : (this.npkp < 0 ? b : c));
                float d = c < this.vmin ? this.vmin : this.exbuf[i];
                float e = CORE.log10f(d);
                float f = doLog ? this.lscl * e : d;
                bo.setF(i << 2, f + this.vadd);
            }
            bi.rnxt(this.bxfer);
            if (this.iavg == 0) {
                bo.wnxt(this.bxfer);
            }
            int n = this.iavg = this.iavg >= this.mavg ? 0 : this.iavg + 1;
            if (doRes) {
                this.doReset = false;
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(2);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(2);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(2);
        }
    }
}

