/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Modefs;
import nxm.ice.core.Modems;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class FMC
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int SELFPACE = 1;
    public static final int IFMT = 2;
    public static final int BW = 32;
    public static final int OSEQ = 11;
    public static final int NSEQ = 2048;
    public static final int OLUT = 10;
    public static final int NLUT = 1024;

    public static class CORE
    extends Core
    implements Modefs {
        public int rfp;
        public int mod;
        public int map;
        public int fec;
        public int scr;
        public double midx;
        public double fS;
        public double fSym;
        public double tOff;
        public int frame;
        double ps;
        int bpw;
        int iper;
        int nper;
        int mper;
        int flgs;
        int pr;
        int princ;
        int mlut;
        float[] xlut;
        float[] ylut;
        int din;
        int dinc;
        int scrvec;
        int[] seq;
        int iseq;
        int mseq;
        int di;
        int db;

        public void setFrame(int len) {
            this.frame = len;
        }

        @Override
        public int init() {
            this.mod = 0;
            this.midx = 1.0;
            this.fS = -1.0;
            this.tOff = 0.0;
            this.bpw = -1;
            this.nper = 1;
            this.mper = 0;
            this.iseq = 0;
            this.scr = -1;
            this.map = 2;
            this.frame = 1920;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "S:SHAPE")) {
                this.mod = value.toItem("NONE,CW,AM,FM,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,1P4DQPSK,8PSK,16PSK,16APSK,32APSK,64APSK,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM");
            } else if (this.isMatch(key, "D:MIDX")) {
                this.midx = value.toD();
            } else if (this.isMatch(key, "S:RFP")) {
                this.rfp = value.toItem("NONE,ICE,ETH,DVBS,DVBX,GSM");
            } else if (this.isMatch(key, "S:MOD")) {
                this.mod = value.toItem("NONE,CW,AM,FM,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,1P4DQPSK,8PSK,16PSK,16APSK,32APSK,64APSK,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM");
            } else if (this.isMatch(key, "S:MAP")) {
                this.map = value.toItem("LINEAR,BRGC,BRGCIB,BRGCIX,BRGCIY,BRGCIXY,BRGCNT,BRGCBE");
            } else if (this.isMatch(key, "S:FEC")) {
                this.fec = value.toItem("NONE,REP1,REP2,REP3,HAM74,HAM84,HAM128,GLY2412,SD2216,SD3932,SD7264,V27,V27P12,V27P23,V27P34,V27P45,V27P56,V27P67,V27P78,V29,V29P12,V29P23,V29P34,V29P45,V29P56,V29P67,V29P78,V39,V615,TCM,TCM23,DTCM23");
            } else if (this.isMatch(key, "S:SCR")) {
                this.scr = value.toItem("NONE,LRS,V35,IES");
            } else if (this.isMatch(key, "L:FRAME")) {
                this.frame = value.toL();
            } else if (this.isMatch(key, "L:BPW")) {
                this.bpw = value.toL();
            } else if (this.isMatch(key, "D:FS")) {
                this.fS = value.toD();
            } else if (this.isMatch(key, "D:FSYM")) {
                this.fSym = value.toD();
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "D:FS")) {
                value.fromD(this.fS);
            } else if (this.isMatch(key, "D:FSYM")) {
                value.fromD(this.fSym);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        public void genSeq(int olut) {
            int j;
            int i = 0;
            int seed = 123456;
            int lrs = ~seed;
            int mask = (1 << olut) - 1;
            this.mseq = 2045;
            if (this.rfp == 1) {
                for (j = 0; j <= 32 - olut; j += olut) {
                    int bits = 1368206978 >> j & mask;
                    this.seq[i++] = 0x8000 | bits;
                }
                int n = i - 1;
                this.seq[n] = this.seq[n] | 0x4000;
                this.mseq = this.frame + i;
                if (this.mseq > 2048) {
                    System.out.printf("Total RFP frame data=%d + sync=%d > max seq=%d\n", this.frame, i, 2048);
                }
            }
            if (this.mod == 1) {
                this.scr = 0;
                if (this.midx > 0.0) {
                    this.mseq = CORE.d2i((double)this.nper * this.fSym / this.midx / 65536.0);
                    if (this.mseq <= 0) {
                        System.out.printf("Unable to perform CW sweep parameters\n", this.mseq);
                        this.mseq = 1;
                    }
                    if (this.mseq > 2048) {
                        System.out.printf("Unable to perform CW sweep parameters\n", this.mseq);
                        this.mseq = 2048;
                    }
                    this.seq[i++] = 16384;
                } else {
                    this.mseq = 16;
                    this.seq[i++] = 0;
                }
            }
            while (i < this.mseq) {
                if (this.scr != 1) {
                    lrs = 0;
                } else {
                    for (j = 0; j < 8; ++j) {
                        lrs = lrs << 1 | 1 ^ CORE.getBits(lrs, 0, 0) ^ CORE.getBits(lrs, 1, 1) ^ CORE.getBits(lrs, 5, 5) ^ CORE.getBits(lrs, 25, 25);
                    }
                }
                this.seq[i] = lrs & 0x3FF;
                ++i;
            }
            --this.mseq;
        }

        public void genRotates(int nn) {
            int ii = 16;
            for (int i = 0; i < ii; ++i) {
                float p = CORE.i2f(i) / (float)ii;
                float bx = CORE.coscf(p);
                float by = CORE.sincf(p);
                for (int n = 0; n < nn; ++n) {
                    float ax = this.xlut[n];
                    float ay = this.ylut[n];
                    this.xlut[(i << 4) + n] = ax * bx - ay * by;
                    this.ylut[(i << 4) + n] = ax * by + ay * bx;
                }
            }
        }

        public double getFilterWidth() {
            double fw = 1.0;
            if (this.mod == 4) {
                fw = 2.0 * this.midx / (double)this.nper;
            }
            if (this.mod == 5) {
                fw = 4.0 * this.midx / (double)this.nper;
            }
            if (this.mod == 8) {
                fw /= 2.0;
            }
            return fw;
        }

        public double getFeedRate() {
            return this.fSym * (double)this.nper;
        }

        public int getDefaultTaps() {
            boolean fsk;
            boolean oqpsk = this.mod == 8;
            boolean bl = fsk = this.mod == 4 || this.mod == 5;
            return oqpsk ? 7 : (fsk ? 21 : (this.mod >= 23 ? 11 : 7));
        }

        public boolean isGenerator() {
            return this.bpw == 0;
        }

        @Override
        public int open() {
            boolean fsk;
            boolean oqpsk = this.mod == 8;
            boolean bl = fsk = this.mod == 4 || this.mod == 5;
            if (this.mod == 4) {
                this.nper = (int)(this.midx * 2.0);
                this.mper = 2 * this.nper - 1;
            }
            if (this.mod == 5) {
                this.nper = (int)(this.midx * 6.0);
                this.mper = 2 * this.nper - 1;
            }
            if (oqpsk) {
                this.nper = 2;
                this.mper = 1;
            }
            this.xlut = new float[1024];
            this.ylut = new float[1024];
            int olut = Modems.getSymbolMap(this.mod, this.map, 1.0, this.midx, this.nper, this.xlut, this.ylut);
            int nlut = 1 << olut;
            this.mlut = nlut - 1;
            if (this.bpw < 0) {
                this.bpw = olut;
            }
            if (this.scr < 0) {
                this.scr = this.fec == 0 ? 1 : 0;
            }
            this.seq = new int[2048];
            this.genSeq(olut);
            this.scrvec = 0;
            this.pr = 0;
            this.ps = 0.0;
            this.di = 0;
            this.iper = 0;
            this.flgs = 0;
            this.flgs = CORE.setBit(this.flgs, 0, this.bpw == 0);
            this.flgs = CORE.setBit(this.flgs, 1, this.bpw == 32);
            this.flgs = CORE.setBit(this.flgs, 2, fsk);
            this.flgs = CORE.setBit(this.flgs, 3, oqpsk);
            int n = this.dinc = CORE.getBit(this.flgs, 0) ? 21845 : 0;
            int n2 = this.mod == 9 ? 2 : (this.princ = this.mod == 10 ? 6 : 0);
            if (this.princ != 0) {
                this.genRotates(nlut);
            }
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("FCM mod=%d scr=%d fec=%d flgs=%x \n", this.mod, this.scr, this.fec, this.flgs);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            CoreCommon.CxFloat cm = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cb = CoreCommon.CxFloat.stk();
            boolean gen = CORE.getBit(this.flgs, 0);
            boolean byp = CORE.getBit(this.flgs, 1);
            boolean fsk = CORE.getBit(this.flgs, 2);
            boolean oqp = CORE.getBit(this.flgs, 3);
            while ((gen || si.rok) && so.wok) {
                boolean sos = this.iper == 0 || this.iper == this.nper;
                int lper = this.iper;
                int n = this.iper = this.iper == this.mper ? 0 : this.iper + 1;
                if (sos) {
                    this.scrvec = this.seq[this.iseq];
                    int n2 = this.iseq = this.iseq == this.mseq ? 0 : this.iseq + 1;
                    this.di = CORE.getBit(this.scrvec, 15) ? 0 : (gen ? this.din : si.rdBits(this.bpw));
                    this.din += this.dinc >> 6;
                    if (CORE.getBit(this.scrvec, 14)) {
                        ++this.dinc;
                    }
                }
                int dix = (this.di ^ this.scrvec) & this.mlut;
                int diy = sos ? this.db & 2 | dix & 1 : dix & 2 | this.db & 1;
                this.db = oqp ? diy : dix | lper << 4 | this.pr << 4;
                this.pr = this.pr + this.princ & 0xF;
                cm.x = this.xlut[this.db];
                cm.y = this.ylut[this.db];
                cb.x = CORE.CI2Fx(this.di);
                cb.y = CORE.CI2Fy(this.di);
                so.wrCFI(byp ? cb : cm);
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

