/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Modefs;
import nxm.ice.core.Modems;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class FEC
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int IFMT = 2;
    public static final int OFMT = 2;
    public static final int SELFPACE = 1;
    public static final int BW = 32;
    public static final int MO = 9;
    public static final int OLUT = 12;
    public static final int NLUT = 4096;
    public static final int LRSPM = 0x2000023;

    public static class CORE
    extends Core
    implements Modefs {
        public int alg;
        public int len;
        public int scr;
        public int bpw;
        public int upp;
        int polyA;
        int polyB;
        int shft;
        int mask;
        int mfr;
        int ifr;
        int punc;
        int ipunc;
        int mpunc;
        int errs;
        int[] elut;
        int ilen;
        int olen;
        int flgs;
        int scrc;
        int scrv;
        int gmask;
        int lrsc;
        int lrsp;
        int uv;

        public void setLength(int length) {
            this.len = length;
        }

        public void optimize() {
            if (CORE.getBit(this.flgs, 0)) {
                this.elut = new int[8];
            }
        }

        @Override
        public int init() {
            this.len = 0;
            this.mfr = 0;
            this.alg = 0;
            this.upp = 0;
            this.scr = -1;
            this.bpw = -1;
            this.lrsp = 0;
            this.lrsc = 0;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "S:ALG")) {
                this.alg = value.toItem("NONE,REP1,REP2,REP3,HAM74,HAM84,HAM128,GLY2412,SD2216,SD3932,SD7264,V27,V27P12,V27P23,V27P34,V27P45,V27P56,V27P67,V27P78,V29,V29P12,V29P23,V29P34,V29P45,V29P56,V29P67,V29P78,V39,V615,TCM,TCM23,DTCM23");
            } else if (this.isMatch(key, "S:FEC")) {
                this.alg = value.toItem("NONE,REP1,REP2,REP3,HAM74,HAM84,HAM128,GLY2412,SD2216,SD3932,SD7264,V27,V27P12,V27P23,V27P34,V27P45,V27P56,V27P67,V27P78,V29,V29P12,V29P23,V29P34,V29P45,V29P56,V29P67,V29P78,V39,V615,TCM,TCM23,DTCM23");
            } else if (this.isMatch(key, "S:SCR")) {
                this.scr = value.toItem("NONE,LRS,V35,IES");
            } else if (this.isMatch(key, "L:LEN")) {
                this.len = value.toL();
            } else if (this.isMatch(key, "L:BPW")) {
                this.bpw = value.toL();
            } else if (this.isMatch(key, "L:LRSP")) {
                this.lrsp = value.toL();
            } else if (this.isMatch(key, "L:LRSI")) {
                this.lrsc = value.toL();
            } else if (!this.isMatch(key, "L:VFLG")) {
                if (this.isMatch(key, "L:ERRS")) {
                    this.errs = value.toL();
                } else if (this.isMatch(key, "L:UPP")) {
                    this.upp = value.toL();
                } else {
                    return super.set(key, value);
                }
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:ALG")) {
                value.fromL(this.alg);
            } else if (this.isMatch(key, "L:LEN")) {
                value.fromL(this.len);
            } else if (this.isMatch(key, "L:SCR")) {
                value.fromL(this.scr);
            } else if (this.isMatch(key, "L:ERRS")) {
                value.fromL(this.errs);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.elut = new int[4096];
            int iom = Modems.getFECLUT(this.alg, this.upp, this.elut, null);
            this.ilen = iom >> 0 & 0xFF;
            this.olen = iom >> 8 & 0xFF;
            this.mask = iom >> 16 & 0xFFF;
            this.mpunc = iom >> 28 & 0xF;
            this.gmask = (1 << this.ilen) - 1;
            this.ifr = 0;
            this.shft = 0;
            this.ipunc = this.mpunc;
            this.scrv = 0;
            this.flgs = 0;
            if (this.scr < 0) {
                int n = this.scr = this.alg == 0 ? 1 : 0;
            }
            if (this.scr > 1) {
                this.flgs |= 4;
                if (this.alg == 0) {
                    this.olen = 1;
                    this.ilen = 1;
                }
            }
            if (this.alg == 0 && this.scr <= 1) {
                this.flgs |= 1;
                this.olen = 32;
                this.ilen = 32;
            }
            if (this.len > 0) {
                this.flgs |= 2;
                this.mfr = this.len - 1;
            }
            if (this.bpw == 0) {
                this.flgs |= 8;
            }
            if (this.alg >= 29) {
                this.flgs |= 0x10;
            }
            if (this.lrsp == 0 || this.lrsp == -1) {
                this.lrsp = 0x2000023;
            }
            this.optimize();
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("FEC alg=%d scr=%x len=%d ilen=%d olen=%d flgs=%x punc=%d\n", this.alg, this.scr, this.len, this.ilen, this.olen, this.flgs, this.mpunc + 1);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            boolean bypass = CORE.getBit(this.flgs, 0);
            boolean framed = CORE.getBit(this.flgs, 1);
            boolean scramb = CORE.getBit(this.flgs, 2);
            boolean gen = CORE.getBit(this.flgs, 3);
            boolean tcm = CORE.getBit(this.flgs, 4);
            while ((gen || si.rok) && so.wok) {
                int bi;
                if (!gen) {
                    bi = si.rdBits(this.ilen);
                } else {
                    bi = this.lrsc & this.gmask;
                    this.lrsc = CORE.iLRSP(this.lrsc, this.lrsp);
                }
                if (bypass) {
                    so.wrBits(this.olen, bi);
                    continue;
                }
                boolean reframe = framed && this.ifr == 0;
                this.ifr = this.ifr == this.mfr ? 0 : this.ifr + 1;
                int imask = reframe ? 0 : this.mask;
                int scrv0 = CORE.getBits(bi, 0, 0) ^ (reframe ? 0 : CORE.getBits(this.scrv, 3, 3) ^ CORE.getBits(this.scrv, 20, 20) ^ (this.scrc == 31 ? 1 : 0));
                this.scrc = reframe ? 0 : (CORE.getBit(this.scrv, 1) != CORE.getBit(this.scrv, 9) ? 0 : this.scrc + 1);
                this.scrv = scrv0 << 1 | (reframe ? 0 : this.scrv << 1);
                int bix = tcm ? bi >> 1 : (scramb ? scrv0 : bi);
                int biy = bi & 1;
                this.shft = this.shft << 1 & imask | bix;
                this.ipunc = this.ipunc >= this.mpunc ? 0 : this.ipunc + 1;
                int ilut = this.ipunc << 9 | this.shft;
                int olut = this.elut[ilut];
                if (tcm) {
                    this.uv ^= biy << CORE.getBits(olut, 1, 1);
                    int otcm2 = CORE.getBits(olut, 1, 0);
                    int qtcm = CORE.getBits(olut, 1, 1);
                    int otcm3 = otcm2 | (CORE.getBit(this.uv, qtcm) ? 4 : 0);
                    so.wrBits(3, otcm3);
                    continue;
                }
                so.wrBits(this.olen - CORE.getBits(olut, 8, 8), CORE.getBits(olut, 7, 0));
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

