/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Filters;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class DUC2
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int ONP = 1;
    public static final int NP = 2;
    public static final int SIBW = 32;
    public static final int SOBW = 64;
    public static final int OTAP = 4;
    public static final int NTAP = 16;
    public static final int SHF = 8;

    public static class CORE
    extends Core {
        public double fbwf;
        public double fbwn;
        int ntap;
        int nrpt;
        int quad;
        int dquad;
        float[] fta;
        float[] ftb;
        float[] ftc;
        CoreComponent.CxTapBuf vd;
        CoreComponent.Value vo;

        @Override
        public int init() {
            this.fbwf = 1.0;
            this.fbwn = 1.0;
            this.ntap = -1;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:NTAP")) {
                this.ntap = value.toL();
            } else if (this.isMatch(key, "L:FCNY")) {
                this.dquad = value.toL() % 4;
            } else if (this.isMatch(key, "D:FBWF")) {
                this.fbwf = value.toD();
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (!this.isMatch(key, "D:XDIO")) {
                return super.get(key, value);
            }
            value.fromD(0.5);
            return 0;
        }

        public void genFilt() {
            int nt = this.nrpt * this.ntap;
            double fw = this.fbwn * this.fbwf;
            float scl = (float)this.nrpt * CORE.mulfp2(1.0f, 8);
            float[] ctap = new float[nt * 2];
            Filters.genFirKais(1, fw / (double)this.nrpt, 0.0, 0.05 / (double)this.nrpt, 90.0, ctap, nt);
            int j = 0;
            int i = 0;
            while (j < this.ntap) {
                this.fta[j] = ctap[i + 0] * scl;
                this.ftb[j] = ctap[i + 2] * scl;
                ++j;
                i += 4;
            }
            for (i = 0; i < nt; ++i) {
                this.ftc[i] = ctap[i + i] * scl;
            }
        }

        @Override
        public int open() {
            if (this.ntap <= 0) {
                this.ntap = 16;
            }
            if (this.ntap > 16) {
                System.out.printf("Warn ntap=%d limited to ntap=%d for this compile\n", this.ntap, 16);
                this.ntap = 16;
            }
            this.vd = new CoreComponent.CxTapBuf(4, 1, 16, -1);
            this.vd.setLength(this.ntap);
            this.fta = new float[16];
            this.ftb = new float[16];
            this.ftc = new float[32];
            this.vo = new CoreComponent.Value("CI", 2);
            this.nrpt = 2;
            this.genFilt();
            this.quad = 0;
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("DUC2 fbwn=%f fbwf=%f ntap=%d NP=%d\n", this.fbwn, this.fbwf, this.ntap, 2);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            CoreCommon.CxFloat cm = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat foa = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat fob = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat foaq = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat fobq = CoreCommon.CxFloat.stk();
            while (si.rok && so.wok) {
                si.rdCIF(cm);
                this.vd.load(cm);
                foa.x = 0.0f;
                foa.y = 0.0f;
                fob.x = 0.0f;
                fob.y = 0.0f;
                for (int j = 0; j < this.ntap; ++j) {
                    CoreCommon.CxFloat fdx = CoreCommon.CxFloat.stk();
                    CoreCommon.CxFloat fdxa = CoreCommon.CxFloat.stk();
                    CoreCommon.CxFloat fdxb = CoreCommon.CxFloat.stk();
                    this.vd.get(j, fdx);
                    fdxa = fdx;
                    fdxb = fdx;
                    float ftxa = this.fta[j];
                    float ftxb = this.ftb[j];
                    foa.x += ftxa * fdxa.x;
                    fob.x += ftxb * fdxb.x;
                    foa.y += ftxa * fdxa.y;
                    fob.y += ftxb * fdxb.y;
                }
                CORE.qrotcc(foa, this.quad, foaq);
                CORE.qrotcc(fob, this.quad + this.dquad, fobq);
                this.quad = this.quad + this.dquad + this.dquad & 3;
                this.vo.setCFIS2(-8, foaq, fobq);
                so.wr(this.vo);
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

