/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Filters;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class DUC
extends CoreFactory {
    public static final int NP = 1;
    public static final int BW = 32;
    public static final int FLOW = 1;
    public static final int OTAP = 5;
    public static final int RTAP = 32;
    public static final int PTAP = 16;
    public static final int OFILT = 7;
    public static final int NFILT = 128;
    public static final int FPS = 15;
    public static final int MAXMON = 1048575;
    public static final int MAXCR = 250000000;
    public static final int IKR = 8;
    public static final int OKR = 4;
    public static final String flgList = "Bypass,CTXF,Debug";
    public static final int PF_BYPASS = 0;
    public static final int PF_CTXF = 1;
    public static final int PF_DEBUG = 2;

    public static class CORE
    extends Core {
        public double fS;
        public double fSi;
        public double tOff;
        public double fbwf;
        public double fbwn;
        public double fC;
        public int ups;
        public int bups;
        public boolean mute;
        public boolean isFPGA;
        double ps;
        double dps;
        double p;
        double dp;
        float fscl;
        float lfps;
        int ntap;
        int nrpt;
        int mrpt;
        CoreComponent.CxTapBuf vd;
        CoreComponent.RomF2Di rft;
        int imon;
        int mmon;
        int ovsr;
        int cper;
        int cups;
        int ifS;
        int flags;
        int upds;

        public int findMoN(double dphase) {
            if (dphase < 1.0E-4) {
                return 0;
            }
            for (int i = 2; i < 524288; ++i) {
                double phase = dphase * (double)i;
                double err = CORE.fabs(phase - CORE.round(phase));
                if (!(err < 1.0E-12)) continue;
                return i;
            }
            return 0;
        }

        public void setDPS() {
            double odps = this.dps;
            double freq = this.dps * this.fS / (double)this.ovsr;
            if ((this.halo.vbpr & 2) != 0) {
                System.out.printf("DUC fs=%f mon=%d\n", this.fS, this.findMoN(odps));
            }
            this.mmon = 0;
            this.dps = CORE.dptx2d(CORE.d2dptx(this.dps));
            this.fSi = this.dps * this.fS / (double)this.ovsr;
            if (this.fSi != freq) {
                this.mmon = this.findMoN(odps);
                if (this.mmon > 1) {
                    double err = CORE.frac(this.dps * (double)this.mmon);
                    if (err > 0.5) {
                        this.dps = CORE.dptx2d(CORE.d2dptx(this.dps) + 4L);
                        err = CORE.frac(this.dps * (double)this.mmon);
                        this.fSi = this.dps * this.fS / (double)this.ovsr;
                    }
                    if (err > 0.001 && this.fSi != freq) {
                        System.out.printf("DUC fS=%18.9f fSi=%18.9f fActual=%18.9f MoN=%d perr=%8.6f\n", this.fS, freq, this.fSi, this.mmon, err);
                    }
                    this.fSi = odps * this.fS / (double)this.ovsr;
                } else {
                    System.out.printf("DUC fS=%18.9f fSi=%18.9f fActual=%18.9f\n", this.fS, freq, this.fSi);
                }
            }
            this.mmon = this.mmon == 0 ? 0 : this.mmon - 1;
            this.putVars("dps,mmon");
        }

        public void setRate(double sr) {
            if (sr > 5.0E8) {
                System.out.printf("Desired sample rate = %f limited to max supported rate of %d\n", sr, 500000000);
                sr = 5.0E8;
            }
            this.ups = sr > 2.5E8 ? 2 : 1;
            this.fS = sr / (double)this.ups;
        }

        public void setRateIn(double sr) {
            this.fSi = sr;
        }

        public void setCUPS(int c) {
            this.cups = c >= 0 ? c : (this.mute ? 0 : this.bups + 2);
            this.putVars("cups");
        }

        public void setMute(int m) {
            this.mute = m != 0;
            this.setCUPS(-1);
        }

        public void setFcny(double f) {
            this.bups = 0;
            this.dp = f;
            if (this.ups == 2) {
                if (f < -0.125) {
                    this.bups = -1;
                    this.dp = (f + 0.25) * (double)this.ups;
                } else if (f < 0.125) {
                    this.bups = 0;
                    this.dp = (f - 0.0) * (double)this.ups;
                } else {
                    this.bups = 1;
                    this.dp = (f - 0.25) * (double)this.ups;
                }
            }
            if (f < -0.5 || f > 0.5) {
                this.bups = 0;
            }
            if (this.isFPGA) {
                this.dp = CORE.dptx2d(CORE.d2dptx(this.dp));
            }
            this.cups = this.mute ? 0 : this.bups + 2;
            this.fC = (this.dp / (double)this.ups + (double)this.bups * 0.25) * this.fS * (double)this.ups;
            this.putVars("dp,cups");
        }

        public void setFreq(double f) {
            this.setFcny(f / (this.fS * (double)this.ups));
        }

        public void setGain(double gain) {
            this.fscl = CORE.d2f(CORE.pow(2.0, gain / 6.0) * this.fbwf / 15.0);
            this.putVars("fscl");
        }

        public void setCTXF(boolean x) {
            this.flags = CORE.setBit(this.flags, 1, x);
        }

        public void setFilterWidth(double f) {
            this.fbwn = f;
        }

        public void setFeedRate(double f) {
            this.fSi = f;
        }

        public void genFilt() {
            int nt = this.nrpt * this.ntap;
            double fw = this.fbwn * this.fbwf;
            float scl = CORE.d2f((double)(this.nrpt * 15) / fw);
            float[] ctap = new float[nt * 2];
            Filters.genFirKais(1, fw / (double)this.nrpt, 0.0, 0.05 / (double)this.nrpt, 90.0, ctap, nt);
            int i = 0;
            for (int j = 0; j < this.ntap; ++j) {
                int k = 0;
                while (k < this.nrpt) {
                    this.rft.set(k, j, ctap[i] * scl);
                    ++k;
                    i += 2;
                }
            }
        }

        @Override
        public int init() {
            this.ups = 1;
            this.fbwf = 1.0;
            this.fbwn = 1.0;
            this.fS = -1.0;
            this.dp = 0.0;
            this.dps = 0.25;
            this.tOff = 0.0;
            this.fscl = -1.0f;
            this.ntap = -1;
            this.ovsr = 1;
            this.fSi = -1.0;
            this.isFPGA = this.halo.impl >= 5;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "D:FS")) {
                this.setRate(value.toD());
            } else if (this.isMatch(key, "D:FSO")) {
                this.setRate(value.toD());
            } else if (this.isMatch(key, "D:FREQ")) {
                this.setFreq(value.toD());
            } else if (this.isMatch(key, "D:COFF")) {
                this.setFreq(value.toD());
            } else if (this.isMatch(key, "D:FCNY")) {
                this.setFcny(value.toD());
            } else if (this.isMatch(key, "D:FSI")) {
                this.setRateIn(value.toD());
            } else if (this.isMatch(key, "D:FSYM")) {
                this.setRateIn(value.toD());
            } else if (this.isMatch(key, "D:BAUD")) {
                this.setRateIn(value.toD());
            } else if (this.isMatch(key, "D:FBWF")) {
                this.fbwf = value.toD();
            } else if (this.isMatch(key, "D:TOFF")) {
                this.tOff = value.toD();
            } else if (this.isMatch(key, "L:NTAP")) {
                this.ntap = value.toL();
            } else if (this.isMatch(key, "D:GAIN")) {
                this.setGain(value.toD());
            } else if (this.isMatch(key, "L:GAIN")) {
                this.setGain(value.toD());
            } else if (this.isMatch(key, "L:CUPS")) {
                this.setCUPS(value.toL());
            } else if (this.isMatch(key, "L:MUTE")) {
                this.setMute(value.toL());
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "D:FS")) {
                value.fromD(this.fS);
            } else if (this.isMatch(key, "D:FSO")) {
                value.fromD(this.fS);
            } else if (this.isMatch(key, "D:FSI")) {
                value.fromD(this.fSi);
            } else if (this.isMatch(key, "D:FSYM")) {
                value.fromD(this.fSi);
            } else if (this.isMatch(key, "D:FREQ")) {
                value.fromD(this.dp * this.fS);
            } else if (this.isMatch(key, "D:XDO")) {
                value.fromD(1.0 / this.fS);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            if (this.fSi < 0.0) {
                this.fSi = 1000000.0;
            }
            if (this.fS < 0.0) {
                this.fS = this.fSi;
            }
            this.dps = this.fSi * (double)this.ovsr / this.fS;
            this.setDPS();
            this.cper = CORE.imax(1, CORE.imin(2, CORE.d2i(2.5E8 / this.fS)));
            if (this.ntap <= 0) {
                this.ntap = CORE.imin(32, 16 * this.cper);
            }
            if (this.ntap > 32) {
                System.out.printf("Warn ntap=%d limited to ntap=%d for this compile\n", this.ntap, 32);
                this.ntap = 32;
            }
            this.cper = (this.ntap + 16 - 1) / 16;
            if (this.fS > (double)(250000000 / this.cper)) {
                System.out.printf("Number taps=%d at fS=%f too large for FPGA load NP=%d PTAP=%d RTAP=%d\n", this.ntap, this.fS, 1, 16, 32);
            }
            int mtap = 16 * this.cper;
            if (this.fscl < 0.0f) {
                this.setGain(-3.0);
            }
            this.nrpt = 128;
            this.mrpt = this.nrpt - 1;
            this.vd = new CoreComponent.CxTapBuf(5, 1, 16, 0);
            this.vd.setLength(this.ntap);
            this.rft = new CoreComponent.RomF2Di(7, 5, 16);
            this.genFilt();
            this.lfps = 1.0f;
            this.ps = 0.0;
            this.p = 0.0;
            this.imon = 1;
            this.ifS = CORE.d2i(this.fS);
            this.flags = CORE.setBit(this.flags, 0, this.dps == 1.0);
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("DUC fSi=%f fS=%f fbwn=%f fbwf=%f fscl=%f mmon=%d ntap=%d cper=%d ups=%d flags=%x NP=%d\n", this.fSi, this.fS, this.fbwn, this.fbwf, Float.valueOf(this.fscl), this.mmon, this.ntap, this.cper, this.ups, this.flags, 1);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            int idat;
            CoreCommon.CxFloat sc = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat fo = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cm = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cn = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cmr = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cmrs = CoreCommon.CxFloat.stk();
            int chn = si.getC();
            boolean byp = CORE.getBit(this.flags, 0) && !CORE.getBit(this.flags, 1);
            boolean ctxf = CORE.getBit(this.flags, 1);
            boolean chx = ctxf && chn > 0;
            boolean cmon = this.mmon == 1048575;
            boolean mon = this.mmon > 0;
            so.setC(this.cups);
            while (si.rok && so.wok && byp) {
                idat = si.rdL();
                so.wrL(idat);
            }
            while (si.rok && so.wok && !chx && !byp) {
                float fps = CORE.fracf(CORE.d2f(this.ps));
                this.ps = mon && this.imon == 0 ? 0.0 : CORE.frac(this.ps + this.dps);
                int n = this.imon = this.imon >= this.mmon ? 0 : this.imon + 1;
                this.mmon = this.mmon != 1048575 ? this.mmon : (this.imon >= 1048575 ? 0 : (this.imon > 2 && CORE.d2dptx(this.ps) < 8L ? this.imon - 2 : this.mmon));
                boolean load = fps <= this.lfps;
                this.lfps = fps;
                if (load) {
                    chn = si.getC();
                    chx = ctxf && chn > 0;
                    si.rdCIF(cm);
                    this.vd.load(cm);
                }
                float ifps = this.lfps;
                fo.x = 0.0f;
                fo.y = 0.0f;
                for (int ia = 0; ia < this.ntap; ++ia) {
                    float ftx;
                    CoreCommon.CxFloat fdi = CoreCommon.CxFloat.stk();
                    CoreCommon.CxFloat fdix = CoreCommon.CxFloat.stk();
                    float ft = ftx = this.rft.getrN(ifps, ia);
                    this.vd.get(ia, fdix);
                    fdi = fdix;
                    fo.x += ft * fdi.x;
                    fo.y += ft * fdi.y;
                }
                cn = fo;
                float fp = CORE.d2f(this.p);
                this.p = CORE.frac(this.p + this.dp);
                CORE.sincoscf(fp, sc);
                CORE.mulcc(cn, sc, cmr);
                CORE.mulcf(cmr, this.fscl, cmrs);
                so.wrCFI(cmrs);
            }
            while (si.rok && chx) {
                chn = si.getC();
                idat = si.rdL();
                boolean bl = chx = chn > 0;
                if ((this.halo.vbpr & 2) != 0) {
                    System.out.printf("Got chn=%d dat=%d at %d\n", chn, idat, 0);
                }
                if (chn == 3 || chn == 4 || chn == 10) {
                    double dtmp = CORE.divii(idat, this.ifS);
                    if (chn == 3) {
                        this.dp = dtmp;
                        if ((this.halo.vbpr & 1) != 0) {
                            System.out.printf("DUC  Ctx chn=%d IF=%d dp=%x\n", chn, idat, CORE.d2x(dtmp));
                        }
                    }
                    if (chn == 4) {
                        this.dp = dtmp;
                        if ((this.halo.vbpr & 1) != 0) {
                            System.out.printf("DUC  Ctx chn=%d RF=%d dp=%x\n", chn, idat, CORE.d2x(dtmp));
                        }
                    }
                    if (chn == 10) {
                        this.dps = CORE.dptx2d(CORE.d2dptx(dtmp) + 1L);
                        this.mmon = 1048575;
                        this.imon = 0;
                        if ((this.halo.vbpr & 1) != 0) {
                            System.out.printf("DUC  Ctx chn=%d SR=%d dp=%x\n", chn, idat, CORE.d2x(dtmp));
                        }
                    }
                }
                if (chn == 8 && (this.halo.vbpr & 1) != 0) {
                    System.out.printf("DUC  Ctx chn=%d GAIN=%d fscl=%x\n", chn, idat, CORE.f2x(this.fscl));
                }
                this.upds = CORE.setBits(this.upds, 15, 0, CORE.getBits(this.upds, 15, 0) + 1);
                if (chn > 2) {
                    this.upds = CORE.setBits(this.upds, 31, 16, chn);
                }
                this.upds = this.upds;
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }

        @Override
        public int poll() {
            this.getVars("upds");
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("DUC upds=%08x\n", this.upds);
            }
            return 1;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

