/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Filters;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class DDC
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int NP = 1;
    public static final int SIBW = 32;
    public static final int SOBW = 32;
    public static final int OCIC = 5;
    public static final int ODEC = 10;
    public static final int OTAP = 8;
    public static final int RTAP = 256;
    public static final int PTAP = 8;
    public static final int OAGC = 12;
    public static final int FPS = 31;
    public static final int MAXCR = 250000000;

    public static class CORE
    extends Core {
        public double fs;
        public double fbwf;
        public double dbwf;
        public float alpha;
        public int gain;
        double p;
        double dp;
        float fscl;
        int ntap;
        int cdec;
        int ndec;
        int ups;
        int mdec;
        int idec;
        int oagc;
        int pass;
        int maxpass;
        int count;
        int maxcount;
        float blkSum;
        float AMDes;
        boolean cntovr;
        Filters.CxCIC cic;
        CoreComponent.CxTapBuf vd;
        CoreComponent.RomF rft;

        public void setFreq(double freq) {
            this.dp = -freq / this.fs;
            this.putVars("dp");
        }

        public void setFcny(double fcny) {
            this.dp = -fcny;
            this.putVars("dp");
        }

        public void setBW(double bw) {
            this.ups = 1;
            this.cdec = 1;
            this.ndec = CORE.d2i(this.fs / (bw * this.dbwf));
            if (this.ndec < 1) {
                this.ups = 2;
                this.ndec = 1;
            }
            if (this.ndec > 3) {
                this.cdec = this.ndec >> 1;
                this.ndec = 2;
            }
            this.fbwf = bw / ((double)this.ups * this.fs / (double)this.cdec);
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("DDC.setBW fs=%f bw=%f bwf=%f ups=%d cdec=%d ndec=%d\n", this.fs, bw, this.dbwf, this.ups, this.cdec, this.ndec);
            }
        }

        public double getRatio() {
            return 1.0 * (double)this.ups / (double)(this.cdec * this.ndec);
        }

        public double getDelay() {
            double delay = this.oagc * this.maxcount * this.cdec * this.ndec;
            delay = this.cdec == 1 ? (delay -= 2.5 * (double)this.cdec * (double)this.ndec) : (delay -= 3.5 + 2.5 * (double)this.cdec * (double)this.ndec);
            return (delay -= (double)(this.ntap / 2 * this.cdec)) / this.fs;
        }

        public void setDec(int dec) {
            this.ups = 1;
            this.cdec = 1;
            this.ndec = dec;
            if (this.ndec > 3) {
                this.cdec = this.ndec >> 1;
                this.ndec = 2;
            }
            this.fbwf = 0.8;
        }

        public void setGain(double gain) {
            int cicgain = CORE.d2i(gain / 6.0) * 6;
            this.cic.setGain(cicgain);
            this.fscl = CORE.d2f(CORE.pow(2.0, (gain -= (double)cicgain) / 6.0)) / CORE.i2f(31);
            this.putVars("fscl");
        }

        public void genFilt() {
            int i;
            int nt = this.ntap;
            double fw = this.fbwf;
            float scl = CORE.i2f(31);
            float falpha = this.alpha > 0.0f ? this.alpha : (this.cdec == 2 ? 0.2f : (this.cdec == 3 ? 0.3f : 0.4f));
            float[] ctap = new float[nt * 2];
            Filters.genFirKais(1, fw, 0.0, 0.01, 70.0, ctap, nt);
            for (i = 0; i < nt; ++i) {
                ctap[i] = ctap[i + i];
            }
            if (this.cdec > 1) {
                Filters.applyCompensation(falpha, ctap, nt);
            }
            for (i = 0; i < nt; ++i) {
                this.rft.set(i, ctap[i] * scl);
            }
        }

        @Override
        public int init() {
            this.fs = -1.0;
            this.dbwf = 1.5;
            this.dp = 0.0;
            this.ntap = 128;
            this.gain = 0;
            this.alpha = -1.0f;
            this.AMDes = 0.7071f;
            this.setDec(1);
            this.maxcount = 4096;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "D:FS")) {
                this.fs = value.toD();
            } else if (this.isMatch(key, "D:FREQ")) {
                this.setFreq(value.toD());
            } else if (this.isMatch(key, "D:FCNY")) {
                this.setFcny(value.toD());
            } else if (this.isMatch(key, "D:BW")) {
                this.setBW(value.toD());
            } else if (this.isMatch(key, "L:DEC")) {
                this.setDec(value.toL());
            } else if (this.isMatch(key, "D:FBWF")) {
                this.fbwf = value.toD();
            } else if (this.isMatch(key, "D:DBWF")) {
                this.dbwf = value.toD();
            } else if (this.isMatch(key, "L:NTAP")) {
                this.ntap = value.toL();
            } else if (this.isMatch(key, "L:GAIN")) {
                this.gain = value.toL();
            } else if (this.isMatch(key, "L:AGC")) {
                this.oagc = value.toL();
            } else if (this.isMatch(key, "F:AMDES")) {
                this.AMDes = value.toF();
            } else if (this.isMatch(key, "F:ALPHA")) {
                this.alpha = value.toF();
            } else if (this.isMatch(key, "L:MAXPASS")) {
                this.maxpass = value.toL();
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "D:FS")) {
                value.fromD(this.fs);
            } else if (this.isMatch(key, "D:FREQ")) {
                value.fromD(this.dp * this.fs);
            } else if (this.isMatch(key, "D:RATIO")) {
                value.fromD(this.getRatio());
            } else if (this.isMatch(key, "D:XDIO")) {
                value.fromD(1.0 / this.getRatio());
            } else if (this.isMatch(key, "D:XSIO")) {
                value.fromD(this.getDelay());
            } else if (this.isMatch(key, "L:NTAP")) {
                value.fromL(this.ntap);
            } else if (this.isMatch(key, "L:GAIN")) {
                value.fromL(this.gain);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.cic = new Filters.CxCIC(5, 10);
            this.cic.setDecimation(this.cdec);
            this.vd = new CoreComponent.CxTapBuf(8, 1, 8, 0);
            this.vd.setLength(this.ntap);
            this.rft = new CoreComponent.RomF(8, 8);
            this.genFilt();
            this.setGain(this.gain);
            if (this.oagc > 0) {
                this.AMDes *= CORE.d2f(CORE.pow(2.0, this.gain / 6));
            }
            this.p = 0.0;
            this.idec = this.mdec = this.ndec - 1;
            System.out.printf("DDC Fs=%f Fc=%f cdec=%d ndec=%d fbwf=%f ntap=%d mc=%d NP=%d\n", this.fs, -this.fs * this.dp, this.cdec, this.ndec, this.fbwf, this.ntap, this.maxcount, 1);
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            boolean okOut;
            CoreCommon.CxFloat sc = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cn = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cm = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cc = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat fo = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat fos = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat fc = CoreCommon.CxFloat.stk();
            if (this.cntovr) {
                int n = this.pass = this.pass >= 4096 ? 4096 : this.pass + 1;
                if (this.pass <= this.oagc) {
                    float blkAvg = CORE.divfp2(this.blkSum, 12);
                    float blkAvgInv = CORE.invf(blkAvg);
                    this.fscl = this.fscl * this.AMDes * blkAvgInv;
                    this.blkSum = 0.0f;
                }
                this.count = 0;
                this.cntovr = false;
            }
            boolean bl = okOut = this.pass >= this.oagc;
            while (si.rok && so.wok && !this.cntovr) {
                if (this.ups == 2 && CORE.getBit(this.count, 0)) {
                    cn.x = 0.0f;
                    cn.y = 0.0f;
                } else {
                    si.rdCIF(cn);
                }
                float fp = CORE.d2f(this.p);
                this.p = CORE.frac(this.p + this.dp);
                CORE.sincoscf(fp, sc);
                CORE.mulcc(cn, sc, cm);
                boolean cgo = this.cic.process(cm, cc);
                if (!cgo) continue;
                this.vd.load(cc);
                boolean fout = this.idec == 0;
                int n = this.idec = this.idec == 0 ? this.mdec : this.idec - 1;
                if (!fout) continue;
                fo.x = 0.0f;
                fo.y = 0.0f;
                for (int ia = 0; ia < this.ntap; ++ia) {
                    CoreCommon.CxFloat fdi = CoreCommon.CxFloat.stk();
                    float ft = this.rft.get(ia);
                    this.vd.get(ia, fdi);
                    fo.x += ft * fdi.x;
                    fo.y += ft * fdi.y;
                }
                CORE.mulcf(fo, this.fscl, fos);
                if (okOut) {
                    so.wrCFI(fos);
                }
                if (this.pass < this.oagc) {
                    fc.x = fos.x * fos.x;
                    fc.y = fos.y * fos.y;
                    float msq = fc.x + fc.y;
                    float mag = CORE.sqrtf(msq);
                    this.blkSum += mag;
                }
                ++this.count;
                this.cntovr = this.count >= this.maxcount;
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

