/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Filters;
import nxm.ice.core.Modefs;
import nxm.ice.core.Modems;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class AWG
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int SELFPACE = 1;
    public static final int IFMT = 2;
    public static final int BW = 32;
    public static final int OSEQ = 11;
    public static final int NSEQ = 2048;
    public static final int OLUT = 10;
    public static final int NLUT = 1024;
    public static final int OFILT = 7;
    public static final int NFILT = 128;
    public static final int OTAP = 5;
    public static final int RTAP = 32;
    public static final int PTAP = 16;
    public static final int HTAP = 8;
    public static final int FPS = 15;
    public static final int MAXCR = 250000000;
    public static final int OMSEQ = 24;

    public static class CORE
    extends Core
    implements Modefs {
        public int mod;
        public int map;
        public int scr;
        public int ups;
        public double gain;
        public boolean isFPGA;
        double ps;
        double dps;
        double p;
        double dp;
        float fscl;
        float lfps;
        int bpw;
        int iper;
        int nper;
        int mper;
        int flgs;
        int pr;
        int princ;
        int mlut;
        float[] xlut;
        float[] ylut;
        int din;
        int dinc;
        int ntap;
        int nrpt;
        int ntot;
        CoreComponent.CxTapBuf vd;
        CoreComponent.RomF2Di rft;
        int scrvec;
        int[] seq;
        int iseq;
        int mseq;
        int di;
        int db;
        int imon;
        int mmon;
        int cups;
        int cper;
        int ifbd;
        int mfbd;
        public double midx;
        public double fS;
        public double fSym;
        public double tOff;
        public double fC;
        public double fbwf;
        public int obpw;
        public int lmod;
        public int bups;
        public int fbd;
        public boolean mute;

        public void dump(String cc) {
            System.out.printf("set=%s fsym=%f dps=%f nper=%d imon=%d mmon=%d cper=%d cups=%d mseq=%d bpw=%d flgs=%d\n", cc, this.fSym, this.dps, this.nper, this.imon, this.mmon, this.cper, this.cups, this.mseq, this.bpw, this.flgs);
        }

        public int findMoN(double dphase) {
            if (dphase < 1.0E-4) {
                return 0;
            }
            for (int i = 2; i < 0x100000; ++i) {
                double phase = dphase * (double)i;
                double err = CORE.fabs(phase - CORE.round(phase));
                if (!(err < 1.0E-12)) continue;
                return i;
            }
            return 0;
        }

        public void genFilt() {
            int k;
            int j;
            int nt = this.nrpt * this.ntap;
            int nhlf = this.nrpt / 2;
            float scl = CORE.d2f((double)(this.nrpt * 15) / this.fbwf);
            double fw = this.fbwf;
            if (this.mod == 4) {
                fw = 2.0 * this.midx / (double)this.nper;
            }
            if (this.mod == 5) {
                fw = 4.0 * this.midx / (double)this.nper;
            }
            float[] ctap = new float[nt * 2];
            Filters.genFirKais(1, fw / (double)this.nrpt, 0.0, 0.05 / (double)this.nrpt, 90.0, ctap, nt);
            this.rft.clear();
            int i = 0;
            for (j = 0; j < this.ntap; ++j) {
                k = 0;
                while (k < this.nrpt) {
                    this.rft.set(k, j, ctap[i] * scl);
                    ++k;
                    i += 2;
                }
            }
            if (this.mod == 8) {
                i = 0;
                for (j = 0; j < this.ntap; ++j) {
                    k = 0;
                    while (k < this.nrpt) {
                        this.rft.set(k + nhlf, j + 8, ctap[i] * scl);
                        ++k;
                        i += 2;
                    }
                }
            }
        }

        public void genRotates() {
            int ii = 16;
            boolean alt = false;
            boolean rot = this.mod == 11;
            int nn = this.mlut + 1;
            int n = this.mod == 11 ? 2 : (this.mod == 9 ? 2 : (this.princ = this.mod == 10 ? 6 : 0));
            if (this.princ == 0) {
                return;
            }
            for (int i = 0; i < ii; ++i) {
                float p = rot ? (float)i / 8.0f : (alt ? (float)this.princ / 16.0f : 0.0f);
                float bx = CORE.coscf(p);
                float by = CORE.sincf(p);
                for (int n2 = 0; n2 < nn; ++n2) {
                    float ax = this.xlut[n2];
                    float ay = this.ylut[n2];
                    this.xlut[(i << 4) + n2] = ax * bx - ay * by;
                    this.ylut[(i << 4) + n2] = ax * by + ay * bx;
                }
                alt = !alt;
            }
            this.princ = 1;
        }

        public void setDPS() {
            double odps = this.dps;
            double freq = this.dps * this.fS;
            this.dps = CORE.dptx2d(CORE.d2dptx(this.dps));
            this.fSym = this.dps * this.fS * (double)this.nper;
            this.mmon = 0;
            if (this.fSym != freq) {
                this.mmon = this.findMoN(odps);
                if (this.mmon > 1) {
                    double err = CORE.frac(this.dps * (double)this.mmon);
                    if (err > 0.5) {
                        this.dps = CORE.dptx2d(CORE.d2dptx(this.dps) + 4L);
                        err = CORE.frac(this.dps * (double)this.mmon);
                        this.fSym = this.dps * this.fS;
                    }
                    if (err > 0.001 && this.fSym != freq) {
                        System.out.printf("AWG fS=%18.9f fSym=%18.9f fActual=%18.9f MoN=%d perr=%8.6f\n", this.fS, freq, this.fSym, this.mmon, err);
                    }
                    this.fSym = odps * this.fS;
                } else {
                    System.out.printf("AWG fS=%18.9f fSym=%18.9f fActual=%18.9f\n", this.fS, freq, this.fSym);
                }
            }
            this.mmon = this.mmon == 0 ? 0 : this.mmon - 1;
            this.flgs = CORE.setBit(this.flgs, 4, this.mmon > 0);
            this.putVars("dps,mmon,flgs");
        }

        public void setRate(double sr) {
            if (sr > 5.0E8) {
                System.out.printf("Desired sample rate = %f limited to max supported rate of %d\n", sr, 500000000);
                sr = 5.0E8;
            }
            this.ups = sr > 2.5E8 ? 2 : 1;
            this.fS = sr / (double)this.ups;
        }

        public void setCUPS(int c) {
            this.cups = c >= 0 ? c : (this.mute ? 0 : this.bups + 2);
            this.putVars("cups");
        }

        public void setMute(int m) {
            this.mute = m != 0;
            this.setCUPS(-1);
        }

        public void setFcny(double f) {
            this.bups = 0;
            this.dp = f;
            if (this.ups == 2) {
                if (f < -0.125) {
                    this.bups = -1;
                    this.dp = (f + 0.25) * (double)this.ups;
                } else if (f < 0.125) {
                    this.bups = 0;
                    this.dp = (f - 0.0) * (double)this.ups;
                } else {
                    this.bups = 1;
                    this.dp = (f - 0.25) * (double)this.ups;
                }
            }
            if (f < -0.5 || f > 0.5) {
                this.bups = 0;
            }
            if (this.isFPGA) {
                this.dp = CORE.dptx2d(CORE.d2dptx(this.dp));
            }
            this.cups = this.mute ? 0 : this.bups + 2;
            this.fC = (this.dp / (double)this.ups + (double)this.bups * 0.25) * this.fS * (double)this.ups;
            this.putVars("dp,cups");
        }

        public void setFreq(double f) {
            this.setFcny(f / (this.fS * (double)this.ups));
        }

        public void setGain(double g) {
            this.gain = g;
            if (this.mod >= 4) {
                g -= 3.0;
            }
            if (this.mod > 8) {
                g -= 3.0;
            }
            this.fscl = CORE.d2f(CORE.pow(2.0, g / 6.0) * this.fbwf / 15.0);
            this.putVars("fscl");
        }

        public void setSpec(double v) {
            boolean sweep = false;
            int mxseq = 0x1000000;
            this.midx = v;
            if (this.mod == 1 && this.fS > 0.0) {
                this.mseq = 0;
                if (this.midx > 0.0) {
                    sweep = true;
                    this.mseq = CORE.d2i(this.fS * this.dps / this.midx / 65536.0);
                    if (this.mseq < 1) {
                        System.out.printf("Unable to perform CW sweep parameters min=%d\n", this.mseq);
                        this.mseq = 1;
                    }
                    if (this.mseq > mxseq) {
                        System.out.printf("Unable to perform CW sweep parameters max=%d\n", this.mseq);
                        this.mseq = mxseq;
                    }
                }
                this.flgs = CORE.setBit(this.flgs, 5, sweep);
                if (this.mseq > 0) {
                    --this.mseq;
                }
                this.putVars("flgs,mseq");
                if (!sweep) {
                    this.dinc = 0;
                }
                this.putVars("dinc");
            }
        }

        public void genSeq(int olut) {
            int seed = 123456;
            int lrs = ~seed;
            int mask = (1 << olut) - 1;
            int mxseq = 0x1000000;
            this.mseq = 2045;
            if (this.mod == 1) {
                this.scr = 0;
                this.mseq = 1;
                this.seq[0] = 0;
                this.setSpec(this.midx);
            } else {
                for (int i = 0; i < this.mseq; ++i) {
                    if (this.scr != 1) {
                        lrs = 0;
                    } else {
                        for (int j = 0; j < 8; ++j) {
                            lrs = lrs << 1 | 1 ^ CORE.getBits(lrs, 0, 0) ^ CORE.getBits(lrs, 1, 1) ^ CORE.getBits(lrs, 5, 5) ^ CORE.getBits(lrs, 25, 25);
                        }
                    }
                    this.seq[i] = lrs & 0x3FF;
                }
            }
            --this.mseq;
        }

        public void genMod() {
            switch (this.mod) {
                case 4: {
                    this.nper = (int)(this.midx * 2.0);
                    this.mper = 2 * this.nper - 1;
                    break;
                }
                case 5: {
                    this.nper = (int)(this.midx * 4.0);
                    this.mper = 2 * this.nper - 1;
                    break;
                }
                default: {
                    this.nper = 1;
                    this.mper = 0;
                }
            }
            int olut = Modems.getSymbolMap(this.mod, this.map, 1.0, this.midx, this.nper, this.xlut, this.ylut);
            int nlut = 1 << olut;
            this.mlut = nlut - 1;
            this.bpw = this.mod == 0 ? 32 : (this.obpw >= 0 ? this.obpw : olut);
            this.dinc = 0;
            this.genSeq(olut);
            this.putVars("seq,mseq,nper,mper,dinc");
            this.putVars("xlut,ylut,mlut,bpw");
            this.lmod = this.mod;
        }

        public void setFBWF(double f) {
            this.fbwf = f;
            if (this.halo.state == 1) {
                this.setGain(this.gain);
                this.genFilt();
                this.putVars("rft");
            }
        }

        public void setFsym(double f) {
            this.fSym = f;
            this.dps = (double)this.nper * this.fSym / this.fS;
            this.setDPS();
            if (this.halo.state == 1) {
                this.genFilt();
                this.putVars("rft");
            }
            this.mfbd = CORE.d2i(this.fS / (1.5 * this.fSym)) - 1;
        }

        @Override
        public int init() {
            this.mod = 0;
            this.midx = 1.0;
            this.fbwf = 1.0;
            this.fS = -1.0;
            this.dp = 0.0;
            this.dps = 0.25;
            this.tOff = 0.0;
            this.gain = -3.0;
            this.ntap = -1;
            this.obpw = -1;
            this.iseq = 0;
            this.scr = -1;
            this.map = -1;
            this.nper = 1;
            this.mper = 0;
            this.ups = 1;
            this.bups = 0;
            this.fbd = -1;
            this.mfbd = 0;
            this.flgs = 0;
            this.isFPGA = this.halo.impl >= 5;
            return 0;
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            int lmod = this.mod;
            double lmidx = this.midx;
            double lfSym = this.fSym;
            if (this.isMatch(key, "S:SHAPE")) {
                this.mod = value.toItem("NONE,CW,AM,FM,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,1P4DQPSK,8PSK,16PSK,16APSK,32APSK,64APSK,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM");
            } else if (this.isMatch(key, "D:MIDX")) {
                this.setSpec(value.toD());
            } else if (this.isMatch(key, "D:SPEC")) {
                this.setSpec(value.toD());
            } else if (this.isMatch(key, "S:MOD")) {
                this.mod = value.toItem("NONE,CW,AM,FM,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,1P4DQPSK,8PSK,16PSK,16APSK,32APSK,64APSK,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM");
            } else if (this.isMatch(key, "L:MOD")) {
                this.mod = value.toL();
            } else if (this.isMatch(key, "S:MAP")) {
                this.map = value.toItem("LINEAR,BRGC,BRGCIB,BRGCIX,BRGCIY,BRGCIXY,BRGCNT,BRGCBE");
            } else if (this.isMatch(key, "S:SCR")) {
                this.scr = value.toItem("NONE,LRS,V35,IES");
            } else if (this.isMatch(key, "D:FS")) {
                this.setRate(value.toD());
            } else if (this.isMatch(key, "D:FREQ")) {
                this.setFreq(value.toD());
            } else if (this.isMatch(key, "D:COFF")) {
                this.setFreq(value.toD());
            } else if (this.isMatch(key, "D:FCNY")) {
                this.setFcny(value.toD());
            } else if (this.isMatch(key, "D:FSYM")) {
                this.setFsym(value.toD());
            } else if (this.isMatch(key, "D:BAUD")) {
                this.setFsym(value.toD());
            } else if (this.isMatch(key, "D:FBWF")) {
                this.setFBWF(value.toD());
            } else if (this.isMatch(key, "D:TOFF")) {
                this.tOff = value.toD();
            } else if (this.isMatch(key, "L:NTAP")) {
                this.ntap = value.toL();
            } else if (this.isMatch(key, "L:BPW")) {
                this.obpw = value.toL();
            } else if (this.isMatch(key, "L:FBD")) {
                this.fbd = value.toL();
            } else if (this.isMatch(key, "D:GAIN")) {
                this.setGain(value.toD());
            } else if (this.isMatch(key, "L:GAIN")) {
                this.setGain(value.toD());
            } else if (this.isMatch(key, "L:CUPS")) {
                this.setCUPS(value.toL());
            } else if (this.isMatch(key, "L:MUTE")) {
                this.setMute(value.toL());
            } else {
                return super.set(key, value);
            }
            if (this.halo.state == 0) {
                return 0;
            }
            if (this.mod >= 4 && this.mod <= 5 && (this.midx != lmidx || this.fSym != lfSym)) {
                lmod = 0;
            }
            if (this.mod != lmod) {
                this.genMod();
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "D:FS")) {
                value.fromD(this.fS * (double)this.ups);
            } else if (this.isMatch(key, "D:XDO")) {
                value.fromD(1.0 / (this.fS * (double)this.ups));
            } else if (this.isMatch(key, "D:FSYM")) {
                value.fromD(this.fSym);
            } else if (this.isMatch(key, "D:FREQ")) {
                value.fromD(this.fC);
            } else if (this.isMatch(key, "L:CUPS")) {
                value.fromL(this.cups);
            } else if (this.isMatch(key, "L:MOD")) {
                value.fromL(this.mod);
            } else if (this.isMatch(key, "L:FBD")) {
                value.fromL((this.mfbd + 1) * this.ups);
            } else if (this.isMatch(key, "S:MODLIST")) {
                value.fromS("NONE,CW,AM,FM,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,1P4DQPSK,8PSK,16PSK,16APSK,32APSK,64APSK,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM");
            } else if (this.isMatch(key, "S:MAPLIST")) {
                value.fromS("LINEAR,BRGC,BRGCIB,BRGCIX,BRGCIY,BRGCIXY,BRGCNT,BRGCBE");
            } else if (this.isMatch(key, "S:SCRLIST")) {
                value.fromS("NONE,LRS,V35,IES");
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            int mtap;
            if (this.scr < 0) {
                this.scr = 0;
            }
            if (this.map < 0) {
                this.map = 2;
            }
            this.seq = new int[2048];
            this.xlut = new float[1024];
            this.ylut = new float[1024];
            this.genMod();
            this.setFsym(this.fSym);
            this.setGain(this.gain);
            int n = mtap = this.isFPGA ? 16 : 32;
            if (this.ntap <= 0) {
                int n2 = this.mod <= 0 ? mtap : (this.ntap = this.mod == 4 || this.mod == 5 ? 21 : 7);
            }
            if (this.ntap >= 8 && this.mod == 8) {
                System.out.printf("Warn ntap=%d limited to ntap=%d for OQPSK\n", this.ntap, 7);
                this.ntap = 7;
            }
            if (this.ntap > 32) {
                System.out.printf("Warn ntap=%d limited to ntap=%d for this compile\n", this.ntap, 32);
                this.ntap = 32;
            }
            this.cper = (this.ntap + 16 - 1) / 16;
            int n3 = mtap = this.isFPGA ? 16 * CORE.imax(1, CORE.d2i(2.5E8 / this.fS)) : 32;
            if (this.ntap > mtap) {
                System.out.printf("Number taps=%d at fS=%f too large max=%d for FPGA load PTAP=%d RTAP=%d\n", this.ntap, this.fS, mtap, 16, 32);
                this.ntap = mtap;
                this.cper = this.ntap / 16;
            }
            this.nrpt = 128;
            this.ntot = this.ntap;
            this.vd = new CoreComponent.CxTapBuf(5, 1, 16, 0);
            this.vd.setLength(this.ntap);
            this.rft = new CoreComponent.RomF2Di(7, 5, 16);
            this.genFilt();
            this.pr = 0;
            this.ps = 0.0;
            this.p = 0.0;
            this.di = 0;
            this.lfps = 1.0f;
            this.iper = 0;
            this.ifbd = 0;
            this.imon = 1;
            this.scrvec = 0;
            this.flgs = 0;
            this.flgs = CORE.setBit(this.flgs, 0, this.bpw == 0);
            this.flgs = CORE.setBit(this.flgs, 1, this.bpw == 32);
            this.flgs = CORE.setBit(this.flgs, 2, this.mod == 1);
            this.flgs = CORE.setBit(this.flgs, 3, this.mod == 8);
            this.flgs = CORE.setBit(this.flgs, 4, this.mmon > 0);
            this.flgs = CORE.setBit(this.flgs, 5, this.mod == 1 && this.midx > 0.0);
            if (this.fbd > 0) {
                this.mfbd = this.fbd / this.ups - 1;
            }
            this.genRotates();
            this.setCUPS(-1);
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("AWG fSym=%f fS=%f fbwf=%f mmon=%d ntap=%d bpw=%d cper=%d\n", this.fSym, this.fS, this.fbwf, this.mmon, this.ntap, this.bpw, this.cper);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream si, CoreComponent.Stream so) {
            CoreCommon.CxFloat cm = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cb = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat sc = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat fo = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cn = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cmr = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cmrs = CoreCommon.CxFloat.stk();
            boolean gen = CORE.getBit(this.flgs, 0);
            boolean byp = CORE.getBit(this.flgs, 1);
            boolean cw = CORE.getBit(this.flgs, 2);
            boolean oqp = CORE.getBit(this.flgs, 3);
            boolean mon = CORE.getBit(this.flgs, 4);
            boolean zbinc = CORE.getBit(this.flgs, 5);
            so.setC(this.cups);
            while ((gen || si.rok) && so.wok) {
                float fps = CORE.fracf(CORE.d2f(this.ps));
                this.ps = mon && this.imon == 0 ? 0.0 : CORE.frac(this.ps + this.dps);
                this.imon = this.imon >= this.mmon ? 0 : this.imon + 1;
                boolean load = fps < this.lfps;
                this.lfps = fps;
                if (load) {
                    boolean sos = this.iper == 0 || this.iper == this.nper;
                    int lper = this.iper;
                    int n = this.iper = this.iper == this.mper ? 0 : this.iper + 1;
                    if (sos) {
                        this.scrvec = this.seq[this.iseq & 0x7FF];
                        this.iseq = this.iseq >= this.mseq ? 0 : this.iseq + 1;
                        boolean zseq = this.iseq == 0;
                        this.di = gen | cw ? this.din & 0x3FF : si.rdBits(this.bpw);
                        this.din += this.dinc >> 6;
                        if (zbinc && zseq) {
                            ++this.dinc;
                        }
                    }
                    int dix = (this.di ^ this.scrvec) & this.mlut;
                    this.db = dix | lper << 4 | this.pr << 4;
                    this.pr = this.pr + this.princ & 0xF;
                    cm.x = this.xlut[this.db];
                    cm.y = this.ylut[this.db];
                    cb.x = CORE.CI2Fx(this.di);
                    cb.y = CORE.CI2Fy(this.di);
                    this.vd.load(byp ? cb : cm);
                }
                fo.x = 0.0f;
                fo.y = 0.0f;
                for (int ia = 0; ia < this.ntot; ++ia) {
                    CoreCommon.CxFloat ft = CoreCommon.CxFloat.stk();
                    CoreCommon.CxFloat fdi = CoreCommon.CxFloat.stk();
                    CoreCommon.CxFloat fdj = CoreCommon.CxFloat.stk();
                    this.rft.getrNc(this.lfps, ia, oqp, ft);
                    this.vd.get(ia, fdi);
                    fdj = fdi;
                    fo.x += ft.x * fdj.x;
                    fo.y += ft.y * fdj.y;
                }
                cn = fo;
                float fp = CORE.d2f(this.p + this.dp);
                this.p = CORE.frac(this.p + this.dp);
                CORE.sincoscf(fp, sc);
                CORE.mulcc(cn, sc, cmr);
                boolean zfbd = this.ifbd == this.mfbd;
                this.ifbd = this.ifbd == this.mfbd ? 0 : this.ifbd + 1;
                CORE.mulcf(cmr, this.fscl, cmrs);
                so.wrCFI(cmrs);
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

