/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class AU2C
extends CoreFactory {

    public static class CORE
    extends Core {
        public static final int FLOW = 2;
        public static final int BW = 64;
        public static final int RW = 12;
        public static final int CW = 6;
        public static final int NHDR = 64;
        public static final int NPKT = 2432;
        public static final int NPKTI = 2432;
        public static final int NCFG = 64;
        public static final int NOVR = 4000;
        public static final int NRAM = 4096;
        public static final int MRAM = 4095;
        public static final int NCRP = 270;
        public static final int NCRV = 260;
        public static final int NROW = 9;
        public static final int NVRC = 783;
        public static final int NOUT = 2340;
        public static final int NTOT = 2496;
        public static final int NTOTI = 2496;
        public static final int SFIL = 2400;
        public static final int SOVH = 2416;
        public static final int MAXDMAI = 272;
        public static final int MAXDMAO = 264;
        public int func;
        public int dec;
        public int chn;
        public int imd;
        public byte pkt;
        public byte tag;
        public byte ntag;
        public byte mtag;
        public int nfpp;
        public int itag;
        public int ncfg;
        public int itl;
        public int otl;
        public int ofs;
        public int dfs;
        public int ipkt;
        public int opkt;
        public int novh;
        static final int[] NCRPS = new int[]{270, 1080, 4320, 17280};
        static final int[] NCRVS = new int[]{260, 1040, 4160, 16640};
        static final int[] DMINS = new int[]{120, 120, 160, 640};
        ChannelState[] csa;
        CoreComponent.RamRWC ram;
        CoreComponent.RamRWC rov;
        CoreComponent.RamRWC rop;
        CoreComponent.Dma dmar;
        CoreComponent.Dma dmaw;

        @Override
        public int init() {
            this.itl = 2496;
            this.otl = 4992;
            this.ofs = 2496;
            this.dec = 1;
            return 0;
        }

        public void setFunction(CoreComponent.Value value) {
        }

        public void setConfigFile(CoreComponent.Value value) {
        }

        @Override
        public int set(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "S:FUNCTION")) {
                this.setFunction(value);
            } else if (this.isMatch(key, "L:CONFIG")) {
                this.setConfigFile(value);
            } else if (this.isMatch(key, "L:CHN")) {
                this.chn = value.toL();
            } else if (this.isMatch(key, "L:FLAGS")) {
                this.halo.flag = value.toL();
            } else {
                return super.set(key, value);
            }
            return 0;
        }

        @Override
        public int get(String key, CoreComponent.Value value) {
            if (this.isMatch(key, "L:NCFG")) {
                value.fromL(this.ncfg);
            } else if (this.isMatch(key, "L:ITL")) {
                value.fromL(this.itl);
            } else if (this.isMatch(key, "L:OTL")) {
                value.fromL(this.otl);
            } else if (this.isMatch(key, "L:OFS")) {
                value.fromL(this.ofs);
            } else if (this.isMatch(key, "L:DEC")) {
                value.fromL(this.dec);
            } else {
                return super.get(key, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.csa = new ChannelState[64];
            for (int i = 0; i < 64; ++i) {
                this.csa[i] = new ChannelState();
            }
            this.ram = new CoreComponent.RamRWC(12, 64, 64, 6);
            this.rov = new CoreComponent.RamRWC(4, 64, 8, 6);
            this.rop = new CoreComponent.RamRWC(12, 64, 64, 1);
            this.dmar = new CoreComponent.Dma(12, 64);
            this.dmaw = new CoreComponent.Dma(12, 64);
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Buffer bi, CoreComponent.Buffer bo) {
            boolean doovh;
            int nptr = 0;
            int i = 0;
            int flag = this.halo.flag;
            long bx = bi.getX(i);
            this.ipkt = CORE.getBits(bx, 63, 32);
            bx = CORE.setBits(bx, 63, 32, (long)this.opkt);
            bo.setX(i, bx);
            bx = bi.getX(i += 8);
            bo.setX(i, bx);
            long bx1 = bx;
            i += 8;
            int chx = CORE.getBits(bx, 39, 32);
            int chn = CORE.getBits(bx, 53, 48);
            int omd = CORE.getBits(bx, 59, 56);
            int typ = CORE.getBits(bx, 63, 60);
            int omc = omd - 1;
            boolean byp = typ == 0 || typ == 2 || CORE.getBits(flag, 4, 4) != 0;
            boolean bl = doovh = this.novh >= 2340;
            while (i < 64) {
                bx = bi.getX(i);
                bo.setX(i, bx);
                i += 8;
            }
            boolean doin = true;
            boolean doout = false;
            if (byp) {
                while (i < 2496) {
                    bx = bi.getX(i);
                    bo.setX(i, bx);
                    i += 8;
                }
                doout = true;
            } else if (doovh) {
                bx1 = CORE.setBits(bx1, 63, 32, -1879048192L);
                bo.setX(8, bx1);
                this.dmaw.r2b(this.rop, 0, bo, 64, 2432);
                this.novh = 0;
                doin = false;
                doout = true;
            } else if (typ != 1) {
                boolean ook;
                boolean iok;
                this.ram.setC(chn);
                this.rov.setC(chn);
                int nds = omc << 1;
                int ndx = 1 << nds;
                int ndy = ndx - 1;
                int seq = chx & ndy;
                int bpct = 3 << nds;
                ChannelState cs = this.csa[chn];
                int oram = cs.oram;
                int iram = cs.iram;
                int olen = cs.olen;
                int ilen = cs.ilen;
                int orow = cs.orow;
                int irow = cs.irow;
                int ptr = cs.ptr;
                int cnt = cs.cnt;
                int smd = cs.smd;
                CoreComponent.Dma.addReader(bi);
                CoreComponent.Dma.addReader(this.ram);
                int inpr = NCRPS[omc];
                int onpr = NCRVS[omc];
                int dmin = DMINS[omc] + 264;
                int dram = iram - oram;
                doout = dram > dmin && dram < 4096;
                int iper = 192;
                int iadr = 64;
                int iend = 2496;
                if (seq == 0) {
                    irow = 0;
                    ilen = 0;
                }
                if (seq == 57 && omc == 3) {
                    iadr += iper;
                }
                if (seq == ndy) {
                    iend -= 2 << nds;
                }
                int oadr = 64;
                int oend = 2404;
                bx = 0L;
                for (i = 2400; i < 2496; i += 8) {
                    bo.setX(i, bx);
                }
                do {
                    boolean bl2 = iok = iadr < iend;
                    if (ilen > 0 && iok) {
                        iper = iend - iadr;
                        if (ilen < iper) {
                            iper = ilen;
                        }
                        if (iper > 272) {
                            iper = 272;
                        }
                        if ((this.halo.vbpr & 1) != 0) {
                            System.out.printf("DMAi chn=%d row=%d adr=%x ram=%x xfer=%d smd=%d\n", chn, irow, iadr, iram, iper, smd);
                        }
                        if (smd > 1) {
                            CORE cORE = this;
                            cORE.dmar.sync();
                            this.dmar.b2r(bi, iadr, this.ram, iram, iper);
                            iram += iper;
                        }
                        iadr += iper;
                        ilen -= iper;
                    }
                    iok = iadr < iend;
                    int oper = oend - oadr;
                    if (olen > 0 && oper > 0 && doout) {
                        if (olen < oper) {
                            oper = olen;
                        }
                        if (oper > 264) {
                            oper = 264;
                        }
                        if ((this.halo.vbpr & 1) != 0) {
                            System.out.printf("DMAo chn=%d row=%d adr=%x ram=%x olen=%d xfer=%d\n", chn, orow, oadr, oram, olen, oper);
                        }
                        CORE cORE = this;
                        cORE.dmaw.sync();
                        this.dmaw.r2b(this.ram, oram, bo, oadr, oper);
                        oram += oper;
                        oadr += oper;
                        olen -= oper;
                    }
                    if (ilen == 0 && iok) {
                        int noc = 9;
                        if (irow == 3) {
                            boolean restart = false;
                            int jadr = iadr + bpct;
                            byte bb = bi.getB(iadr);
                            nptr = CORE.setBits(nptr, 9, 8, (int)bb);
                            int pmode = CORE.getBits(bb, 7, 4);
                            bb = bi.getB(jadr);
                            nptr = CORE.setBits(nptr, 7, 0, (int)bb);
                            int xptr = nptr ^ ptr;
                            int xpebc = CORE.getBits(xptr, 0, 0) + CORE.getBits(xptr, 2, 2) + CORE.getBits(xptr, 4, 4) + CORE.getBits(xptr, 6, 6) + CORE.getBits(xptr, 8, 8);
                            int xpobc = CORE.getBits(xptr, 1, 1) + CORE.getBits(xptr, 3, 3) + CORE.getBits(xptr, 5, 5) + CORE.getBits(xptr, 7, 7) + CORE.getBits(xptr, 9, 9);
                            if (xptr == 0) {
                                if (smd < 5) {
                                    ++smd;
                                }
                                restart = smd == 2;
                            } else if (pmode == 9) {
                                if (smd > 2) {
                                    smd = 2;
                                }
                                ptr = nptr;
                                restart = true;
                            } else if (smd < 2) {
                                ptr = nptr;
                            } else if (xpobc > 2) {
                                noc = 12;
                                if (++ptr == 783) {
                                    ptr = 0;
                                }
                            } else if (xpebc > 2) {
                                noc = 6;
                                ptr = ptr == 0 ? 782 : --ptr;
                            } else if (smd > 0) {
                                if (--smd == 2) {
                                    smd = 0;
                                }
                                if (smd == 0) {
                                    restart = true;
                                }
                            }
                            int tram = ptr * bpct;
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("pMode=%x nPtr=%x Ptr=%x chn=%d typ=%d smd=%d iadr=%x\n", pmode, nptr, ptr, chn, typ, smd, iadr);
                            }
                            if (restart) {
                                doout = false;
                                iram = 0;
                                oram = tram;
                                orow = 0;
                                cnt = 0;
                                olen = 0;
                            }
                        }
                        int ncol = 270 - noc;
                        iadr += noc << nds;
                        ++irow;
                        ilen = ncol << nds;
                    }
                    boolean bl3 = ook = oadr < oend && doout;
                    if (olen != 0 || !ook) continue;
                    byte br = this.ram.rdB(oram);
                    oram += ndx;
                    olen = onpr;
                    this.rov.wrB(++orow, br);
                } while (iok || ook);
                if (doout) {
                    CORE cORE = this;
                    cORE.dmaw.sync();
                    bx1 = CORE.setBits(bx1, 47, 32, (long)cnt);
                    bo.setX(8, bx1);
                    cnt = cnt + 1 & ndy;
                    if (cnt == 0) {
                        this.rov.wrB(0, chn);
                        this.dmaw.r2b(this.rov, 1, bo, 2416, 9);
                        CORE cORE2 = this;
                        cORE2.dmaw.sync();
                        this.dmaw.r2r(this.rov, 0, this.rop, this.novh, 10);
                        this.novh += 10;
                        orow = 0;
                    }
                }
                cs.oram = oram;
                cs.iram = iram;
                cs.olen = olen;
                cs.ilen = ilen;
                cs.orow = orow;
                cs.irow = irow;
                cs.ptr = ptr;
                cs.cnt = cnt;
                cs.smd = smd;
                this.csa[chn] = cs;
            }
            CORE cORE = this;
            cORE.dmar.sync();
            if (doin) {
                bi.rnxt(2496);
            }
            CORE cORE3 = this;
            cORE3.dmaw.sync();
            if (doout) {
                bo.wnxt(2496);
                ++this.opkt;
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ChannelState
    extends CoreFactory.TypeDef {
        int smd;
        int cnt;
        int ptr;
        int irow;
        int orow;
        int ilen;
        int olen;
        int iram;
        int oram;
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(2);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(2);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(2);
        }
    }
}

