/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.Feature;
import nxm.sys.prim.plot;

public class t5pathgenerator
extends Primitive {
    private DataFile outFile;
    private Data outData;
    private boolean rt;
    private String rframe;
    private double tdelta;
    private double tnext;
    private double size;
    private long offset;
    private double alt = 0.0;
    private double lat = 0.0;
    private double lon = 0.0;
    private double altStart = 0.0;
    private double latStart = 0.0;
    private double lonStart = 0.0;
    private double altDest = 0.0;
    private double latDest = 0.0;
    private double lonDest = 0.0;
    private double altShift = 0.0;
    private double latShift = 0.0;
    private double lonShift = 0.0;
    private double altDelta = 0.0;
    private double latDelta = 0.0;
    private double lonDelta = 0.0;
    private double origLatDelta = 0.0;
    private double origLonDelta = 0.0;
    private boolean landing = false;
    private int landingPt = 0;
    private double[] landingPattern;
    private static final int SNAKE = 1;
    private static final int FLIGHT = 2;
    private static final int TRAJECTORY = 3;
    private int pathType;
    private byte color;
    private String directColor;
    private String namePrefix;
    private boolean noFlags;
    private boolean timeField;
    private boolean noEllipse;
    private boolean ellipsoid;
    private boolean rotate;
    private boolean xyzData;
    private String noteModeType = "";
    private char noteMode = (char)48;
    private char noteType = (char)65;
    private static final String NOTE_A = "note_";
    private static final String NOTE_B = "info_";
    private String note = "";
    private String noteA = "";
    private String noteB = "";
    private double timeAdjustment = 0.0;
    private boolean outOfBounds;
    private static boolean running;
    private int pointRepeat = 0;
    private static final int NUM_POINT_REPEATS = 5;
    private static final int NUM_FLIGHT_INCREMENTS = 250;
    private static final int NUM_TRAJECTORY_INCREMENTS = 50;
    private double pathAddAlt;
    private double pathAddLat;
    private double pathAddLon;
    private static boolean varyNote;
    private int ellipsoidIdx = 0;

    @Override
    public int open() {
        this.size = this.MA.getD("ELEM", 32768.0);
        this.rframe = this.MA.getS("RF", "ECR");
        this.rt = this.MA.getState("/RT");
        this.tdelta = 1.0 / this.MA.getD("/RATE", 1.0);
        this.xfer = this.MA.getL("/TL", 1);
        this.tnext = 0.0;
        this.outFile = this.MA.getDataFile("OUT");
        this.color = this.MA.getB("/COLOR", Byte.valueOf("2"));
        this.namePrefix = this.MA.getS("/NAME", "POINT");
        if (this.namePrefix.length() > 7) {
            this.namePrefix = this.namePrefix.substring(0, 7);
        }
        this.directColor = this.MA.getS("/DIRECTCOLOR");
        this.noteModeType = this.MA.getS("/NOTEMODETYPE", "0A");
        this.noteMode = this.noteModeType.charAt(0);
        if (this.noteModeType.length() > 1 && this.noteModeType.charAt(1) == 'Z') {
            this.noteType = (char)90;
        }
        if (this.noteMode != '\uffffffff' && ("SCVQMTA".indexOf(this.noteMode) >= 0 || "123456789X".indexOf(this.noteMode) >= 0)) {
            this.createNoteA();
            this.createNoteB();
        }
        String timeString = this.MA.getS("/STARTTIME", "");
        Time startTime = Time.currentTime();
        if (!timeString.isEmpty()) {
            startTime = new Time(timeString);
            this.timeAdjustment = Time.currentTime().getSec() - startTime.getSec();
        }
        this.alt = this.altStart = this.MA.getD("/ALT_START", 0.0);
        this.lat = this.latStart = this.MA.getD("/LAT_START", t5pathgenerator.randomLat());
        this.lon = this.lonStart = this.MA.getD("/LON_START", t5pathgenerator.randomLon());
        this.altDest = this.MA.getD("/ALT_DEST", 0.0);
        this.latDest = this.MA.getD("/LAT_DEST", t5pathgenerator.randomLat());
        this.lonDest = this.MA.getD("/LON_DEST", t5pathgenerator.randomLon());
        this.altShift = this.MA.getD("/ALT_SHIFT", 0.0);
        this.latShift = this.MA.getD("/LAT_SHIFT", 0.0);
        this.lonShift = this.MA.getD("/LON_SHIFT", 0.0);
        if (this.MA.getState("/SNAKE")) {
            this.pathType = 1;
            this.pathAddLat = Math.random() > 0.5 ? 0.5 : -0.5;
            this.pathAddLon = Math.random() > 0.5 ? 0.5 : -0.5;
        } else if (this.MA.getState("/FLIGHT")) {
            this.pathType = 2;
            this.landingPattern = this.circlingToLanding(20, (int)(Math.random() * 10.0 + 1.0), 3.0, this.latDest, this.lonDest);
            this.origLatDelta = this.latDelta = this.landingPattern[0] - this.latStart;
            this.origLonDelta = this.lonDelta = this.landingPattern[1] - this.lonStart;
            this.setCurrentTrajectory(250);
        } else if (this.MA.getState("/TRAJECTORY")) {
            this.pathType = 3;
            this.xyzData = this.MA.getState("/XYZ");
            if (this.xyzData) {
                this.rframe = "NONE";
            }
            this.altDelta = this.altDest - this.altStart;
            this.latDelta = this.latDest - this.latStart;
            this.lonDelta = this.lonDest - this.lonStart;
            int increments = this.MA.getL("/INCR", 50);
            this.setCurrentTrajectory(increments);
        } else {
            this.pathType = 1;
            this.pathAddLat = Math.random() > 0.5 ? 0.5 : -0.5;
            this.pathAddLon = Math.random() > 0.5 ? 0.5 : -0.5;
        }
        this.noEllipse = this.MA.getState("/NOELLIPSE");
        this.ellipsoid = this.MA.getState("/ELLIPSOID");
        if (this.ellipsoid) {
            this.rotate = this.MA.getState("/ROTATE");
        }
        this.noFlags = this.MA.getState("/NOFLAGS");
        this.timeField = this.MA.getState("/TIME");
        this.outOfBounds = this.MA.getState("/OUTOFBOUNDS");
        String ellipseComponent = this.noEllipse ? "" : ",ELPS/VD/0/0";
        String ellipsoidComponent = !this.ellipsoid ? "" : ",ELLIPSOID/6D/0/0";
        String colorComponent = this.directColor == "" ? "" : ",COLOR/2A/0/0";
        String flagComponent = this.noFlags ? "" : ",FLAG/8B/0/0";
        String noteComponent = this.noteA.isEmpty() ? "" : ",NOTE/" + this.noteMode + "" + this.noteType + "/0/0";
        String timeComponent = !this.timeField ? "" : ",TIME/SD/0/0";
        this.outFile.setComponents("POS/VD/6/5" + ellipseComponent + ellipsoidComponent + ",NAME/2A/0/0" + colorComponent + flagComponent + noteComponent + timeComponent);
        this.outFile.setSize(this.size);
        this.outFile.open(2);
        this.outFile.setTime(startTime);
        this.outFile.setDelta(this.tdelta);
        this.outFile.setReferenceFrame(this.rframe);
        this.outData = this.outFile.getDataBuffer(1);
        return 0;
    }

    private void setCurrentTrajectory(int increments) {
        this.pathAddAlt = this.altDelta / (double)increments;
        this.pathAddLat = this.latDelta / (double)increments;
        this.pathAddLon = this.lonDelta / (double)increments;
    }

    @Override
    public int process() {
        int status = 0;
        double time = Time.current() - this.timeAdjustment;
        if (this.rt && time < this.tnext) {
            status = -1;
        } else {
            for (int i = 0; i < this.xfer && (double)this.offset < this.size; ++i) {
                boolean reachedLat;
                if (this.pathType == 1) {
                    this.pointRepeat = this.pointRepeat++ % 5;
                    if (this.pointRepeat == 0) {
                        this.lat += this.pathAddLat * Math.random();
                        this.lon += this.pathAddLon * Math.random();
                    }
                    if (this.lat > 90.0) {
                        this.lat = 90.0;
                        this.pathAddLat = -this.pathAddLat;
                    } else if (this.lat < -90.0) {
                        this.lat = -90.0;
                        this.pathAddLat = -this.pathAddLat;
                    }
                    if (this.lon > 180.0) {
                        this.lon = -180.0;
                    } else if (this.lon < -180.0) {
                        this.lon = 180.0;
                    }
                } else if (this.pathType == 2) {
                    this.pointRepeat = this.pointRepeat++ % 5;
                    if (this.pointRepeat == 0) {
                        boolean reachedLon;
                        this.lat += this.pathAddLat;
                        this.lon += this.pathAddLon;
                        boolean bl = this.pathAddLat > 0.0 ? this.lat >= this.landingPattern[0] : (reachedLat = this.lat <= this.landingPattern[0]);
                        boolean bl2 = this.pathAddLon > 0.0 ? this.lon >= this.landingPattern[1] : (reachedLon = this.lon <= this.landingPattern[1]);
                        if (this.landing) {
                            this.lat = this.landingPattern[this.landingPt * 2];
                            this.lon = this.landingPattern[this.landingPt * 2 + 1];
                            ++this.landingPt;
                            if (this.landingPt * 2 >= this.landingPattern.length) {
                                this.lat = this.latStart = this.incrementWithWrap(this.latStart, this.latShift, -90.0, 90.0);
                                this.lon = this.lonStart = this.incrementWithWrap(this.lonStart, this.lonShift, -180.0, 540.0);
                                this.latDest = this.latStart + this.origLatDelta;
                                this.lonDest = this.lonStart + this.origLonDelta;
                                this.landingPattern = this.circlingToLanding(20, (int)(Math.random() * 15.0 + 1.0), 3.0, this.latDest, this.lonDest);
                                this.latDelta = this.landingPattern[0] - this.latStart;
                                this.lonDelta = this.landingPattern[1] - this.lonStart;
                                this.setCurrentTrajectory(250);
                                this.landing = false;
                                this.landingPt = 0;
                            }
                        } else if (reachedLon || reachedLat) {
                            this.landing = true;
                            this.landingPt = 0;
                        }
                    }
                } else {
                    this.pointRepeat = this.pointRepeat++ % 5;
                    if (this.pointRepeat == 0) {
                        boolean reachedLon;
                        this.alt += this.pathAddAlt * Math.random();
                        this.lat += this.pathAddLat * Math.random();
                        this.lon += this.pathAddLon * Math.random();
                        boolean bl = this.pathAddLat > 0.0 ? this.lat > this.latDest : (reachedLat = this.lat < this.latDest);
                        boolean bl3 = this.pathAddLon > 0.0 ? this.lon > this.lonDest : (reachedLon = this.lon < this.lonDest);
                        if (reachedLon || reachedLat) {
                            if (!this.xyzData) {
                                this.alt = this.altStart += this.altShift;
                                this.lat = this.latStart = this.incrementWithWrap(this.latStart, this.latShift, -90.0, 90.0);
                                this.lon = this.lonStart = this.incrementWithWrap(this.lonStart, this.lonShift, -180.0, 540.0);
                            } else {
                                this.alt = this.altStart += this.altShift;
                                this.lat = this.latStart += this.latShift;
                                this.lon = this.lonStart += this.lonShift;
                            }
                            this.altDest = this.altStart + this.altDelta;
                            this.latDest = this.latStart + this.latDelta;
                            this.lonDest = this.lonStart + this.lonDelta;
                        }
                    }
                }
                this.outData.packD(0, this.alt);
                this.outData.packD(8, this.lat);
                this.outData.packD(16, this.lon);
                int byteOff = 24;
                if (!this.noEllipse) {
                    this.outData.packD(24, 30000.0);
                    this.outData.packD(32, 7000.0);
                    this.outData.packD(40, 45.0);
                    byteOff += 24;
                }
                if (this.ellipsoid) {
                    double rotX = 0.0;
                    double rotY = 0.0;
                    double rotZ = 0.0;
                    if (this.rotate) {
                        rotX = this.ellipsoidIdx == 0 ? 45.0 : 0.0;
                        rotY = this.ellipsoidIdx == 1 ? 25.0 : 0.0;
                        rotZ = this.ellipsoidIdx == 2 ? 60.0 : 0.0;
                        ++this.ellipsoidIdx;
                        this.ellipsoidIdx %= 4;
                    }
                    this.outData.packD(byteOff, 100000.0);
                    this.outData.packD(byteOff + 8, 500000.0);
                    this.outData.packD(byteOff + 16, 250000.0);
                    this.outData.packD(byteOff + 24, rotX);
                    this.outData.packD(byteOff + 32, rotY);
                    this.outData.packD(byteOff + 40, rotZ);
                    byteOff += 48;
                }
                this.outData.packS(byteOff, 16, this.namePrefix + "_" + this.offset);
                byteOff += 16;
                if (this.directColor != "") {
                    this.outData.packS(byteOff, 16, this.directColor);
                    byteOff += 16;
                }
                if (!this.noFlags) {
                    this.outData.packB(byteOff++, (byte)0);
                    this.outData.packB(byteOff++, (byte)0);
                    this.outData.packB(byteOff++, this.color);
                    this.outData.packB(byteOff++, (byte)2);
                    this.outData.packB(byteOff++, Byte.valueOf("-9"));
                    this.outData.packB(byteOff++, (byte)1);
                    this.outData.packB(byteOff++, (byte)4);
                    this.outData.packB(byteOff++, (byte)4);
                }
                if (!this.noteA.isEmpty()) {
                    int len = Data.getSPA(this.noteMode) * Data.getBPS(this.noteType);
                    this.note = varyNote && this.offset % 3L == 0L ? this.noteB : this.noteA;
                    this.outData.packS(byteOff, len, this.note);
                    byteOff += len;
                }
                if (this.timeField) {
                    this.outData.packD(byteOff, time);
                    byteOff += 8;
                }
                this.outFile.write(this.outData);
                ++this.offset;
            }
            this.tnext = this.tnext == 0.0 ? time + this.tdelta : (this.tnext += this.tdelta * (double)this.xfer);
        }
        return (double)this.offset < this.size ? status : 9;
    }

    private double incrementWithWrap(double initialValue, double increment, double minValue, double maxValue) {
        double result = initialValue + increment;
        if (result < minValue) {
            result += maxValue - minValue;
        }
        if (result > maxValue) {
            result -= maxValue - minValue;
        }
        return result;
    }

    @Override
    public int close() {
        if (this.outFile != null) {
            this.outFile.close();
        }
        running = false;
        return 0;
    }

    public static void resetPlot(final plot plot2, int sleep) {
        running = true;
        final int waitTime = sleep * 1000;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                int factorX = 1;
                int factorY = 1;
                while (running) {
                    if (System.currentTimeMillis() - start <= (long)waitTime) continue;
                    Table feat = new Table();
                    Table line = new Table();
                    line.put("Color", (Object)"RED");
                    feat.put("NAME", (Object)("FEAT" + start));
                    feat.put("TYPE", (Object)"Circle");
                    feat.put("LINE", (Object)line);
                    feat.put("X", Math.random() * 180.0 * (double)factorX);
                    feat.put("Y", Math.random() * 90.0 * (double)factorY);
                    feat.put("DX", Math.random() * 20.0);
                    plot2.MP.clearData();
                    if (start % 2L == 0L) {
                        factorY *= -1;
                    }
                    plot2.MP.addFeature(new Feature(feat));
                    factorX *= -1;
                    start = System.currentTimeMillis();
                }
            }
        });
        t.start();
    }

    private void createNoteA() {
        int atypeMultiplier = this.noteType == 'Z' ? 32 : 1;
        int repeats = Data.getSPA(this.noteMode) * atypeMultiplier;
        for (int i = 1; i <= repeats; ++i) {
            this.noteA = this.noteA + NOTE_A + i % 10 + "  ";
        }
        this.noteA = this.noteA.substring(0, Math.max(this.noteA.length() - 2, 0));
    }

    private void createNoteB() {
        int atypeMultiplier = this.noteType == 'Z' ? 32 : 1;
        int repeats = Data.getSPA(this.noteMode) * atypeMultiplier;
        for (int i = 1; i <= repeats; ++i) {
            this.noteB = this.noteB + NOTE_B + i % 10 + "  ";
        }
        this.noteB = this.noteB.substring(0, Math.max(this.noteB.length() - 2, 0));
    }

    public static void setVaryNote(boolean varyNote) {
        t5pathgenerator.varyNote = varyNote;
    }

    public static double randomLon() {
        return Math.random() * 355.0 - 177.5;
    }

    public static double randomLat() {
        return Math.random() * 175.0 - 87.5;
    }

    private double[] circlingToLanding(int num8thOfPass, int num8thOfPasses, double radius, double latCtr, double lonCtr) {
        int landingPoints = num8thOfPass;
        int totalCirclingPts = num8thOfPass * num8thOfPasses;
        int ptsPerCircle = num8thOfPass * 8;
        double[] latLonPts = new double[(totalCirclingPts + landingPoints) * 2];
        int p = 0;
        double lastLat = latCtr;
        double lastLon = lonCtr;
        for (int i = 0; i < totalCirclingPts; ++i) {
            double angle = Math.toRadians((double)i / (double)ptsPerCircle * 360.0);
            latLonPts[p++] = lastLat = latCtr + Math.cos(angle) * radius;
            latLonPts[p++] = lastLon = lonCtr + Math.sin(angle) * radius;
        }
        double latLandingInc = (latCtr - lastLat) / (double)landingPoints;
        double lonLandingInc = (lonCtr - lastLon) / (double)landingPoints;
        for (int i = 0; i < landingPoints; ++i) {
            latLonPts[p++] = lastLat += latLandingInc;
            latLonPts[p++] = lastLon += lonLandingInc;
        }
        return latLonPts;
    }

    static {
        varyNote = false;
    }
}

