/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.lib.TimeLine;

@InternalUseOnly(value="Since 3.7.2 creation")
public class TestTimelineCreator {
    private TestTimelineCreator() {
    }

    public static TimeLine timelineByElement(int alloc, double delta, int bpe, Time startTime, double adjustment, int numElements, int ... elemOffsets) {
        double tolerance = Math.abs(adjustment) / 2.0;
        Time currentTime = new Time(startTime);
        TimeLine timeline = new TimeLine(alloc, delta, tolerance);
        int[] offsets = new int[]{};
        if (elemOffsets.length == 1) {
            int entryInterval = elemOffsets[0];
            offsets = TestTimelineCreator.createSetOffsets(entryInterval, numElements);
        } else if (elemOffsets.length > 1) {
            offsets = elemOffsets;
        }
        TestTimelineCreator.addTimeLineEntries(timeline, currentTime, 0, offsets, delta, bpe, adjustment);
        return timeline;
    }

    public static TimeLine timelineFromTable(double delta, int bpe, Table elemTimeTable) {
        TimeLine timeline = new TimeLine(-1, delta, 0.0);
        for (String offset : elemTimeTable) {
            int off = Integer.parseInt(offset);
            Time timelineEntry = new Time(elemTimeTable.getString(offset));
            timeline.setTimeAt((double)off, (double)bpe, timelineEntry);
        }
        return timeline;
    }

    public static TimeLine timelineFromArrays(int alloc, double delta, int bpe, double[] offsets, Time[] times) {
        if (offsets.length != times.length) {
            throw new IllegalArgumentException("must have equal # of offsets & times");
        }
        TimeLine timeline = new TimeLine(alloc, delta, 0.0);
        for (int i = 0; i < offsets.length; ++i) {
            timeline.setTimeAt(offsets[i], (double)bpe, times[i]);
        }
        return timeline;
    }

    public static TimeLine timelineBadOffset(double delta, int bpe, Time startTime, int numElements, int entryInterval) {
        int nextLastOffset;
        TimeLine timeline = new TimeLine(-1, delta, 0.1);
        Time currentTime = new Time(startTime);
        int maxOffset = Math.min(numElements, 128 * entryInterval);
        int[] offsets = TestTimelineCreator.createSetOffsets(entryInterval, maxOffset);
        if (offsets.length < 2) {
            throw new MidasException("Not enough elements in file to create Bad Offset Timeline based on entry interval");
        }
        int lastIdx = offsets.length - 1;
        int lastOffset = offsets[lastIdx];
        offsets[lastIdx] = nextLastOffset = offsets[lastIdx - 1];
        offsets[lastIdx - 1] = lastOffset;
        double adjustment = 0.11000000000000001;
        TestTimelineCreator.addTimeLineEntries(timeline, currentTime, 0, offsets, delta, bpe, adjustment);
        return timeline;
    }

    public static TimeLine timelineBadTime(double delta, int bpe, Time startTime, int numElements, int entryInterval) {
        TimeLine timeline = new TimeLine(-1, delta, 0.1);
        Time currentTime = new Time(startTime);
        int maxOffset = Math.min(numElements, 128 * entryInterval);
        int[] offsets = TestTimelineCreator.createSetOffsets(entryInterval, maxOffset);
        if (offsets.length < 2) {
            throw new MidasException("Not enough elements in file to create Bad Time Timeline based on entry interval");
        }
        double adjustment = 0.11000000000000001;
        int[] subOffsets = new int[offsets.length - 2];
        System.arraycopy(offsets, 0, subOffsets, 0, offsets.length - 2);
        TestTimelineCreator.addTimeLineEntries(timeline, currentTime, 0, subOffsets, delta, bpe, adjustment);
        Time badTime = Time.add(currentTime, -adjustment);
        int idxLastOffset = offsets.length - 1;
        timeline.setTimeAt(offsets[idxLastOffset - 1], bpe, badTime, TimeLine.NotifyInvalidEntry.WARNING);
        double deltaSec = (double)(offsets[idxLastOffset] - offsets[idxLastOffset - 3]) * delta * (double)bpe;
        currentTime.addSec(deltaSec + adjustment);
        timeline.setTimeAt(offsets[idxLastOffset], bpe, currentTime, TimeLine.NotifyInvalidEntry.WARNING);
        return timeline;
    }

    public static TimeLine timelineSuspectTime(double delta, int bpe, Time startTime, int numElements, int entryInterval) {
        if (delta * (double)entryInterval <= 1.0E7) {
            Shell.warning("Cannot creat suspect timeline unless delta*entryInterval > 1e7");
        }
        TimeLine timeline = new TimeLine(-1, delta, 0.1);
        Time currentTime = new Time(startTime);
        int maxOffset = Math.min(numElements, 128 * entryInterval);
        int[] offsets = TestTimelineCreator.createSetOffsets(entryInterval, maxOffset);
        if (offsets.length < 2) {
            throw new MidasException("Not enough elements in file to create Bad Time Timeline based on entry interval");
        }
        double adjustment = 0.11000000000000001;
        int[] subOffsets = new int[offsets.length - 2];
        System.arraycopy(offsets, 0, subOffsets, 0, offsets.length - 2);
        TestTimelineCreator.addTimeLineEntries(timeline, currentTime, 0, subOffsets, delta, bpe, adjustment);
        int idxLastOffset = offsets.length - 1;
        timeline.setTimeAt(offsets[idxLastOffset - 1], bpe, currentTime, TimeLine.NotifyInvalidEntry.WARNING);
        double deltaSec = (double)(offsets[idxLastOffset] - offsets[idxLastOffset - 3]) * delta * (double)bpe;
        currentTime.addSec(deltaSec + adjustment);
        timeline.setTimeAt(offsets[idxLastOffset], bpe, currentTime, TimeLine.NotifyInvalidEntry.WARNING);
        return timeline;
    }

    public static TimeLine timelineFixedSize(double delta, int bpe, Time startTime, int numElements, int entryInterval, int size) {
        return TestTimelineCreator.timelineFixedSize(delta, bpe, startTime, numElements, entryInterval, size, 0.1);
    }

    public static TimeLine timelineFixedSize(double delta, int bpe, Time startTime, int numElements, int entryInterval, int size, double tolr) {
        TimeLine timeline = new TimeLine(-1, delta, tolr);
        Time currentTime = new Time(startTime);
        int maxOffset = size * entryInterval;
        if (maxOffset > numElements) {
            throw new MidasException("Note enough elements to have " + size + " entries at every other element");
        }
        int[] offsets = TestTimelineCreator.createSetOffsets(entryInterval, maxOffset);
        double adjustment = tolr * 1.1;
        TestTimelineCreator.addTimeLineEntries(timeline, currentTime, 0, offsets, delta, bpe, adjustment);
        return timeline;
    }

    public static int[] getIntArray(int size) {
        return new int[size];
    }

    static int[] createSetOffsets(int entryInterval, int maxOffset) {
        int numOffsets = (int)Math.ceil((double)maxOffset / (double)entryInterval);
        int[] offsets = new int[numOffsets];
        int idx = 0;
        int thisOffset = 0;
        while (thisOffset < maxOffset) {
            offsets[idx] = thisOffset;
            thisOffset += entryInterval;
            ++idx;
        }
        return offsets;
    }

    static void addTimeLineEntries(TimeLine timeline, Time lastOffsetTime, int lastOffset, int[] offsets, double delta, int bpe, double adjustment) {
        for (int offset : offsets) {
            double deltaSec = (double)(offset - lastOffset) * delta * (double)bpe;
            if (deltaSec > 0.0) {
                lastOffsetTime.addSec(deltaSec + adjustment);
            }
            timeline.setTimeAt(offset, bpe, lastOffsetTime, TimeLine.NotifyInvalidEntry.WARNING);
            lastOffset = offset;
        }
    }
}

