/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;

public class statistics
extends Primitive {
    protected DataFile hin;
    protected int base;
    protected int frameSize;
    protected Table table = new Table();
    protected double drsum;
    protected double disum;
    protected double dstdDev;
    protected double dmax;
    protected double dmin;
    protected double real_min;
    protected double real_max;
    protected double imag_min;
    protected double imag_max;
    protected double dmaxOff;
    protected double dminOff;
    protected double dnelem;
    protected boolean complex;
    protected boolean paged;
    protected int spa;
    protected Data data;
    protected int ngot;

    @Override
    public int open() {
        this.hin = this.MA.getDataFile("IN", "1000,2000", "S#,C#", 0);
        this.hin.open();
        this.frameSize = this.hin.getFrameSize();
        if (this.hin.typeClass == 2) {
            this.hin.setFS(0);
        }
        this.xfer = this.MA.getL("/TL", Math.max(1, (int)((double)this.bufSize / this.hin.dbpe)));
        this.complex = this.hin.getFormatMode() == 67;
        this.spa = this.hin.getSPA();
        this.data = this.hin.getDataBuffer(this.xfer);
        this.base = this.MA.getState("/ONEBASE") ? 1 : 0;
        this.verbose = this.MA.getState("/VERBOSE", false);
        this.paged = this.MA.getState("/PIECEWISE");
        this.resetAccumulators();
        return 0;
    }

    @Override
    public int process() {
        this.ngot = this.hin.read(this.data);
        if (this.ngot == 0) {
            return -1;
        }
        if (this.ngot < 0) {
            return 9;
        }
        double[] dbuf = this.data.castD(true);
        this.computeStatistics(dbuf, this.ngot, this.spa, this.complex);
        this.data.uncast(dbuf, false);
        if (this.paged) {
            this.outputResults();
            this.resetAccumulators();
        }
        return 0;
    }

    @Override
    public int close() {
        if (this.hin.isOpen && !this.paged) {
            this.outputResults();
        }
        this.hin.close();
        return 0;
    }

    protected void computeStatistics(double[] dbuf, int ngot, int spa, boolean complex) {
        if (complex) {
            int i = 0;
            while (i < ngot * spa) {
                double rval = dbuf[i++];
                double ival = dbuf[i++];
                this.drsum += rval;
                this.disum += ival;
                double dabs = rval * rval + ival * ival;
                this.dstdDev += dabs;
                if (dabs > this.dmax) {
                    this.dmax = dabs;
                    this.dmaxOff = this.dnelem;
                }
                if (dabs < this.dmin) {
                    this.dmin = dabs;
                    this.dminOff = this.dnelem;
                }
                if (rval < this.real_min) {
                    this.real_min = rval;
                }
                if (rval > this.real_max) {
                    this.real_max = rval;
                }
                if (ival < this.imag_min) {
                    this.imag_min = ival;
                }
                if (ival > this.imag_max) {
                    this.imag_max = ival;
                }
                this.dnelem += 1.0;
            }
        } else {
            int i = 0;
            while (i < ngot * spa) {
                double dval = dbuf[i++];
                this.drsum += dval;
                this.dstdDev += dval * dval;
                if (dval > this.dmax) {
                    this.dmax = dval;
                    this.dmaxOff = this.dnelem;
                }
                if (dval < this.dmin) {
                    this.dmin = dval;
                    this.dminOff = this.dnelem;
                }
                this.dnelem += 1.0;
            }
        }
    }

    protected void outputResults() {
        double drmean = this.drsum / this.dnelem;
        double dimean = this.disum / this.dnelem;
        this.dstdDev = this.dstdDev / this.dnelem - drmean * drmean - dimean * dimean;
        this.dstdDev = Math.sqrt(Math.max(0.0, this.dstdDev));
        if (this.complex) {
            this.dmin = Math.sqrt(this.dmin);
        }
        if (this.complex) {
            this.dmax = Math.sqrt(this.dmax);
        }
        double dminAbs = this.hin.getXStart();
        double dmaxAbs = this.hin.getXStart();
        if (this.frameSize > 1) {
            double colMinIndex = this.dminOff - Math.floor(this.dminOff / (double)this.frameSize) * (double)this.frameSize;
            double colMaxIndex = this.dmaxOff - Math.floor(this.dmaxOff / (double)this.frameSize) * (double)this.frameSize;
            dminAbs += colMinIndex * this.hin.getXDelta();
            dmaxAbs += colMaxIndex * this.hin.getXDelta();
        } else {
            dminAbs += this.dminOff * this.hin.getXDelta();
            dmaxAbs += this.dmaxOff * this.hin.getXDelta();
        }
        this.dminOff += (double)this.base;
        this.dmaxOff += (double)this.base;
        Data Dsum = new Data(this.complex ? "CD" : "SD", 1);
        Dsum.setD(0, this.drsum);
        if (this.complex) {
            Dsum.setD(1, this.disum);
        }
        Data Dmean = new Data(this.complex ? "CD" : "SD", 1);
        Dmean.setD(0, drmean);
        if (this.complex) {
            Dmean.setD(1, dimean);
        }
        this.table.put("MEAN", (Object)Dmean);
        this.table.put("SDEV", this.dstdDev);
        this.table.put("ELEM", this.dnelem);
        this.table.put("MIN", this.dmin);
        this.table.put("MAX", this.dmax);
        this.table.put("AMIN", dminAbs);
        this.table.put("AMAX", dmaxAbs);
        this.table.put("OMIN", this.dminOff);
        this.table.put("OMAX", this.dmaxOff);
        this.table.put("SUM", (Object)Dsum);
        if (this.complex) {
            this.table.put("REALMIN", this.real_min);
            this.table.put("REALMAX", this.real_max);
            this.table.put("IMAGMIN", this.imag_min);
            this.table.put("IMAGMAX", this.imag_max);
        }
        boolean hasOutputResult = this.outputToResTable();
        if (this.verbose || !hasOutputResult) {
            String s = "";
            s = s + "Number of elements   : " + this.dnelem + "\n";
            s = s + "Mean Value           : " + Dmean + "\n";
            if (this.dnelem <= 1024.0) {
                s = s + "Sum Value            : " + Dsum + "\n";
            }
            s = s + "Standard deviation   : " + this.dstdDev + "\n";
            s = s + "Max/Absc/Offset      : " + this.dmax + " / " + dmaxAbs + " / " + this.dmaxOff + "\n";
            s = s + "Min/Absc/Offset      : " + this.dmin + " / " + dminAbs + " / " + this.dminOff;
            this.M.println(s);
        }
    }

    protected boolean outputToResTable() {
        boolean hasOutputResult = false;
        for (int n = 2; n <= this.MA.numberOf(); ++n) {
            String key = this.fixKey(this.MA.getKey(n));
            String label = this.MA.getU(n);
            if ((key.equals("IMEAN") || key.equals("ISUM")) && label != null && label.length() > 0) {
                this.M.deprecate("Key " + key + " deprecated, use " + key.substring(1) + ".i instead.");
            }
            if (label.length() <= 0) continue;
            hasOutputResult = true;
            if (key.equals("TABLE")) {
                this.MR.put(label, (Object)this.table);
                continue;
            }
            if (!this.table.containsKey(key)) {
                this.M.warning("Key=" + key + " not supported");
                continue;
            }
            if (label.equals("TERMINAL")) {
                this.M.println("Key=" + key + " Value=" + this.table.get(key));
                continue;
            }
            this.MR.put(label, this.table.get(key));
        }
        return hasOutputResult;
    }

    protected void resetAccumulators() {
        this.drsum = 0.0;
        this.disum = 0.0;
        this.dstdDev = 0.0;
        this.dmax = -1.0E37;
        this.dmin = 1.0E37;
        this.dmaxOff = -1.0;
        this.dminOff = -1.0;
        this.dnelem = 0.0;
        if (this.complex) {
            this.real_min = 1.0E37;
            this.real_max = -1.0E37;
            this.imag_min = 1.0E37;
            this.imag_max = -1.0E37;
        }
    }

    public Table getTable() {
        return this.table;
    }

    public void howToExtend() {
    }

    private String fixKey(String key) {
        String fix;
        if (key.equals("MEAN")) {
            return key;
        }
        if (key.equals("STDV")) {
            fix = "SDEV";
        } else if (key.equals("MAXV")) {
            fix = "MAX";
        } else if (key.equals("MINV")) {
            fix = "MIN";
        } else if (key.equals("MAXI")) {
            fix = "OMAX";
        } else if (key.equals("MINI")) {
            fix = "OMIN";
        } else if (key.equals("MAXA")) {
            fix = "AMAX";
        } else if (key.equals("MINA")) {
            fix = "AMIN";
        } else {
            if (key.equals("ELEM")) {
                return key;
            }
            if (key.equals("IMEAN")) {
                return key;
            }
            if (key.equals("SUM")) {
                return key;
            }
            if (key.equals("ISUM")) {
                return key;
            }
            return key;
        }
        this.M.deprecate("Use of " + key + "= is for legacy X-Midas compatibility only, please use " + fix + "=");
        if (key.equals("MAXI") || key.equals("MINI")) {
            this.M.warning("The results for " + key + "= will be zero-based rather than one-based.");
        }
        return fix;
    }
}

