/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.SDDSPacket;

public class sourcesdds
extends Primitive {
    private DataFile hi;
    private DataFile ho;
    private Data data;
    private SDDSPacket pkho;
    private SDDSPacket pkh = new SDDSPacket();
    private boolean strip;
    private boolean swap;
    private boolean live;

    @Override
    public int open() {
        this.hi = this.MA.getDataFile("IN", "1000", "SN,SB,SI", 0);
        this.live = this.hi.getURL().startsWith("udp://");
        this.hi.open();
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        if (this.hi.getPacketHandler() == null) {
            this.M.error("Input is not an SDDS formatted file");
        }
        this.strip = this.MA.getState("/STRIP", true);
        if (this.strip) {
            this.ho.setPacketHandler(null);
        }
        this.ho.open();
        this.xfer = (int)(1024.0 / this.hi.dbpe);
        this.data = this.hi.getDataBuffer(this.xfer);
        this.swap = this.data.bps == 2 && !Convert.isBigEndian(this.data.rep);
        return 0;
    }

    @Override
    public int process() {
        int n = this.hi.read(this.data);
        if (n > 0) {
            if (this.swap) {
                Convert.swap2(this.data.buf, 0, n);
            }
        } else {
            if (n == 0) {
                return -1;
            }
            return 9;
        }
        this.ho.write(this.data);
        return 0;
    }

    @Override
    public int close() {
        this.hi.close();
        this.ho.close();
        return 0;
    }
}

