/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.util.Arrays;
import java.util.StringTokenizer;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Message;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.lib.XmlFile;
import nxm.sys.net.DatagramData;

@Deprecated
public class sourcedg
extends Primitive
implements DatagramData.IceTimeCallBack {
    private TextFile logfile;
    private DataFile pout;
    private DataFile convout;
    private Data outdata;
    private DatagramData dgd = null;
    private boolean abort = false;
    private boolean dgdclosed = true;
    private boolean linear = true;
    private boolean linearin = true;
    private boolean init = false;
    private short[] outbuf;
    private short[] decodeTable;
    private Table t3kstruct = null;
    private byte[] buf;
    private byte[] fbuf = new byte[1024];
    private static final int MAXPKTBUF = 32768;
    private static final String defaulthost = "127.0.0.1";
    private static final String defaultxmlmsgname = "XMLMSGS";
    private static final int defaultport = 18800;
    private static final int defaulttimeout = 50;
    private static final int defaultintl = 1000;
    private static final int defaulttll = 128;
    private static final double defaultxstart = 0.0;
    private static final double defaultxdelta = 1.0;
    private String host = "127.0.0.1";
    private String midasdatatype = "SB";
    private int port = 18800;
    private int timeOut = 50;
    private int intl = 1000;
    private int outtl = this.intl * 2;
    private int midasfiletype = 1000;
    private int tll = 128;
    private int offsetdata = 0;
    private String msgnameforxml = "XMLMSGS";
    private Object msgid = null;
    private int rtpfiltertype = -1;
    private String msgidname = null;
    private int curlen = 0;
    private int pktfrcount = 0;
    private int fullwrites;
    private int remain;
    private int chdr = -1;
    private int len;
    private int offset;
    private int fillnum;
    private int pktsinframe;
    private int seq;
    private int pcount;
    private int psize;
    private int i;
    private int j;
    private byte fillValue = 0;
    private int framesz = 0;
    private double ystartjtime = 0.0;
    long numrecs;
    private boolean verbose = false;
    private boolean packetDebug = false;
    private boolean rtp = true;
    private boolean sap = false;
    private boolean alladdr = false;
    private boolean xml3000out = true;
    private boolean icehdrinpipe = false;
    private boolean icehdrframe = false;
    private boolean fill = false;
    private boolean msgonly = false;
    private boolean doTimeCode = false;
    private boolean doXSXD = true;
    private double xStart = 0.0;
    private double xDelta = 1.0;
    private double dgdxs = 0.0;
    private double dgdxd = 0.0;
    private double dgjtime = 0.0;
    private int dgdsize = 0;
    private int dgdbytes = 0;
    private String dgdformat = null;
    private Time dgTime = new Time();

    @Override
    public boolean getVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean ptemp) {
        this.verbose = ptemp;
    }

    public void setDebug(boolean ptemp) {
        this.verbose = ptemp;
    }

    public boolean getSocketDebug() {
        if (this.dgd == null) {
            return false;
        }
        try {
            return this.dgd.getVerbose();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSocketDebug(boolean ptemp) {
        if (this.dgd == null) {
            return;
        }
        try {
            this.dgd.setVerbose(ptemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getPacketDebug() {
        return this.packetDebug;
    }

    public void setPacketDebug(boolean ptemp) {
        this.packetDebug = ptemp;
        if (this.dgd == null) {
            return;
        }
        try {
            this.dgd.setPacketDebug(ptemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getRTP() {
        return this.rtp;
    }

    public void setRTP(boolean ptemp) {
        this.rtp = ptemp;
        if (this.dgd == null) {
            return;
        }
        try {
            this.dgd.setRTP(ptemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getSAP() {
        return this.sap;
    }

    public void setSAP(boolean ptemp) {
        this.sap = ptemp;
        if (this.dgd == null) {
            return;
        }
        try {
            this.dgd.setSAP(ptemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getRTPFilter() {
        return this.rtpfiltertype;
    }

    public void setRTPFilter(int ptemp) {
        this.rtpfiltertype = ptemp;
        if (this.dgd == null || this.rtpfiltertype < 0) {
            return;
        }
        try {
            this.dgd.setRTPFilter(ptemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String ptemp) {
        this.host = ptemp;
        if (this.dgd == null) {
            return;
        }
        try {
            this.dgd.setHost(ptemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int ptemp) {
        this.port = ptemp;
        if (this.dgd == null) {
            return;
        }
        try {
            this.dgd.setPort(ptemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int ptemp) {
        this.timeOut = ptemp;
        if (this.dgd == null) {
            return;
        }
        try {
            this.dgd.setTimeOut(ptemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getAllHosts() {
        return this.alladdr;
    }

    public void setAllHosts(boolean ptemp) {
        this.alladdr = ptemp;
        if (this.dgd == null) {
            return;
        }
        try {
            this.dgd.setAllHosts(ptemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getOffset() {
        return this.offsetdata;
    }

    public void setOffset(int ptemp) {
        this.offsetdata = ptemp < 0 || ptemp > 32768 ? 0 : ptemp;
    }

    public boolean getXML3000() {
        return this.xml3000out;
    }

    public void setXML3000(boolean ptemp) {
        this.xml3000out = ptemp;
    }

    public int getTimeLineLength() {
        return this.tll;
    }

    public void setTimeLineLength(int ptemp) {
        this.tll = ptemp < 0 ? 128 : ptemp;
    }

    public boolean getIceHdrFrame() {
        return this.icehdrframe;
    }

    public void setIceHdrFrame(boolean ptemp) {
        this.icehdrframe = ptemp;
    }

    public boolean getIceHdrInPipe() {
        return this.icehdrinpipe;
    }

    public void setIceHdrInPipe(boolean ptemp) {
        this.icehdrinpipe = ptemp;
        if (this.dgd == null) {
            return;
        }
        try {
            this.dgd.setIceHdrInPipe(ptemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte getFillValue() {
        return this.fillValue;
    }

    public void setFillValue(byte filler) {
        this.fillValue = filler;
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean ptemp) {
        this.fill = ptemp;
        if (this.fill) {
            this.setRTP(true);
            this.dgd.setIceData(true);
            this.setIceHdrFrame(true);
            if (this.verbose) {
                this.M.info("Fill requires TC processing and NO XS-XD restarts");
            }
        }
        if (this.dgd != null) {
            try {
                this.dgd.setFill(ptemp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setFillBufValue(byte val) {
        Arrays.fill(this.fbuf, val);
    }

    public int setFillBuf(byte[] pfbuf) {
        try {
            if (pfbuf.length > 0) {
                this.fbuf = new byte[pfbuf.length];
                System.arraycopy(pfbuf, 0, this.fbuf, 0, this.fbuf.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.M.error("sourcedg: setFillBuff failed:" + e);
        }
        if (this.fbuf == null) {
            return 0;
        }
        return this.fbuf.length;
    }

    public String getMSGID() {
        return this.msgidname;
    }

    public void setMSGID(String ptemp) {
        this.msgidname = ptemp;
        this.msgid = null;
        if (this.msgidname != null && this.msgidname.length() > 0) {
            this.msgid = this.M.registry.getCommand(this.msgidname, 5);
        }
        if (this.msgonly && (this.msgid == null || !(this.msgid instanceof MessageHandler))) {
            this.M.warning("MSGONLY requires valid /MSGID - msgonly turned off");
            this.setMsgOnly(false);
        }
    }

    public boolean getMsgOnly() {
        return this.msgonly;
    }

    public void setMsgOnly(boolean ptemp) {
        this.msgonly = ptemp;
    }

    public boolean getTimeCode() {
        return this.doTimeCode;
    }

    public void setTimeCode(boolean ptemp) {
        this.doTimeCode = ptemp;
    }

    public boolean getXSXD() {
        return this.doXSXD;
    }

    public void setXSXD(boolean ptemp) {
        this.doXSXD = ptemp;
    }

    public String getMidaDataType() {
        return this.midasdatatype;
    }

    public void setMidasDataType(String ptemp) {
        this.midasdatatype = ptemp == null || ptemp.length() < 2 ? "SB" : ptemp;
    }

    public double getXStart() {
        return this.xStart;
    }

    public void setXStart(double ptemp) {
        this.xStart = ptemp;
    }

    public double getXDelta() {
        return this.xDelta;
    }

    public void setXDelta(double ptemp) {
        this.xDelta = ptemp;
    }

    public double getYStartTime() {
        return this.ystartjtime;
    }

    public void setYStartTime(double ptemp) {
        this.ystartjtime = ptemp;
    }

    public double getPacketXStart() {
        return this.dgdxs;
    }

    public double getPacketXDelta() {
        return this.dgdxd;
    }

    public double getPacketJtime() {
        return this.dgjtime;
    }

    public int getSize() {
        return this.dgdsize;
    }

    public int getBytes() {
        return this.dgdbytes;
    }

    public String getFormat() {
        return this.dgdformat;
    }

    public String getXMLMSGName() {
        return this.msgnameforxml;
    }

    public void setXMLMSGName(String ptemp) {
        this.msgnameforxml = ptemp == null || this.msgnameforxml.length() < 1 ? defaultxmlmsgname : ptemp;
    }

    @Override
    public String toString() {
        return "DG: Host=" + this.host + " Port=" + this.port + " RTP=" + this.rtp;
    }

    @Override
    public int open() {
        try {
            if (!this.init) {
                this.init = true;
                this.dgd = new DatagramData();
                if (this.dgd == null) {
                    this.M.error("sourcedg: Could not open socket");
                    return 9;
                }
                if (this.MA.find("/VERBOSE")) {
                    this.setVerbose(true);
                }
                if (this.MA.find("/TIMECODE")) {
                    this.setTimeCode(true);
                }
                if (this.MA.find("/PACKETS")) {
                    this.setPacketDebug(true);
                }
                if (this.MA.find("/NOXSXD")) {
                    this.setXSXD(false);
                }
                if (this.MA.find("/NORTP")) {
                    this.setRTP(false);
                }
                if (this.MA.find("/ULAW")) {
                    this.linear = false;
                    this.linearin = false;
                }
                if (this.MA.find("/SAP")) {
                    this.setSAP(true);
                }
                if (this.MA.find("/ALLHOSTS")) {
                    this.setAllHosts(true);
                }
                if (this.MA.find("/MIDASSI")) {
                    this.setMidasDataType("SI");
                }
                if (this.MA.find("/ICEHDRINPIPE")) {
                    this.setIceHdrInPipe(true);
                }
                if (this.MA.find("/ICEHDRFRAME")) {
                    this.setIceHdrFrame(true);
                }
                if (this.MA.find("/NORMAL3000")) {
                    this.setXML3000(false);
                }
                if (this.MA.find("/MSGONLY")) {
                    this.setMsgOnly(true);
                }
                this.setFrameSize(this.MA.getL("/FRAMESIZE", 1024), false);
                if (this.MA.find("/FILL")) {
                    this.setFill(true);
                    this.setFillValue(this.MA.getB("/FILLVALUE", (byte)0));
                }
                this.setAutoSeqResetMAX(this.MA.getL("/AUTOFILLRESET", 0));
                this.setMSGID(this.MA.getU("/MSGID"));
                this.setTimeOut(this.MA.getL("/TIMEOUT", 50));
                this.setRTPFilter(this.MA.getL("/RTPFILTER", -1));
                this.setOffset(this.MA.getL("/OFFSET", 0));
                this.midasfiletype = this.MA.getL("/FTYPE", 1000);
                this.intl = this.MA.getL("/INTL", 1000);
                if (this.intl <= 1) {
                    this.intl = 1000;
                }
                this.setXStart(this.MA.getD("/XSTART", 0.0));
                this.setXDelta(this.MA.getD("/XDELTA", 1.0));
                this.setYStartTime(this.MA.getD("/INITIALTIME", -1.0));
                this.setTimeLineLength(this.MA.getL("/TLL", 128));
                this.setXMLMSGName(this.MA.getS("/MSGNAME", defaultxmlmsgname));
                if (this.MA.find("/LOG")) {
                    this.logfile = this.MA.getTextFile("/LOG");
                    if (this.logfile.open(34)) {
                        this.logfile.writeln("sourcedg log started at " + Time.tag());
                    } else {
                        this.M.warning("sourcedg: Unable to open log file " + this.logfile.getName());
                        this.logfile = null;
                    }
                }
                String hostport = this.MA.getS("HOSTPORT", "");
                if (this.verbose) {
                    this.M.info("HOSTPORT=" + hostport);
                }
                this.i = hostport.indexOf(58);
                if (this.i < 0) {
                    if (this.sap) {
                        this.host = "224.2.127.254";
                        this.port = 9875;
                    } else {
                        this.host = defaulthost;
                        this.port = 18800;
                    }
                } else {
                    this.host = hostport.substring(0, this.i).toLowerCase();
                    this.port = Integer.parseInt(hostport.substring(this.i + 1));
                }
                this.setHost(this.host);
                this.setPort(this.port);
                this.setFillBufValue(this.fillValue);
                this.outbuf = new short[32768];
                this.buf = new byte[32768];
                this.decodeTable = this.build_mu_decode_table();
            }
            this.chdr = -1;
            this.outtl = !this.linear ? this.intl * 2 : this.intl;
            if (this.verbose) {
                this.M.info("sourcedg: TimeOut=" + this.timeOut + ". Verbose=" + this.verbose + ". PacketDebug=" + this.packetDebug);
                this.M.info("sourcedg: RTP=" + this.rtp + ". XStart=" + this.xStart + ". XDelta=" + this.xDelta);
                this.M.info("sourcedg: Out Type=" + this.midasdatatype + " .SAP=" + this.sap + " .ALL Hosts=" + this.alladdr);
                this.M.info("sourcedg: Host=" + this.host + ". Port=" + this.port);
            }
            if (this.msgonly) {
                if (this.verbose) {
                    this.M.info("sourcedg: Messaging only");
                }
                if (!this.getDgState() && this.MA.find("/ON")) {
                    this.setDgState(this.MA.getState("/ON"));
                }
                return 0;
            }
            this.pout = this.MA.getDataFile("OUT", "" + this.midasfiletype, this.midasdatatype, 2, 0.0, null);
            if (this.verbose) {
                this.M.info("Pout=" + this.pout);
            }
            if (this.midasfiletype == 2000) {
                this.pout.setType(this.midasfiletype);
                this.pout.setFrameSize(this.framesz);
                if (this.ystartjtime >= 0.0) {
                    this.pout.setYStart(this.ystartjtime);
                }
            } else if (this.midasfiletype == 3000) {
                this.pout.setType(this.midasfiletype);
                try {
                    this.t3kstruct = this.MA.getTable("/STRUCT");
                    String tempstr = "(";
                    Table.Iterator ti = this.t3kstruct.iterator();
                    while (ti.getNext()) {
                        tempstr = tempstr + ti.key + "|" + ti.value + ",";
                    }
                    tempstr = tempstr.substring(0, tempstr.lastIndexOf(","));
                    tempstr = tempstr + ")";
                    if (this.verbose) {
                        this.M.info("sourcedg: Setting 3000 file output");
                    }
                    this.pout.setSubRecords(tempstr);
                }
                catch (Exception e) {
                    throw new MidasException("sourcedg: Type 3000 file structure not defined. Use /STRUCT switch", e);
                }
            }
            this.pout.setTimeLineLength(this.tll);
            this.pout.setXStart(this.xStart);
            this.pout.setXDelta(this.xDelta);
            if (this.ystartjtime >= 0.0) {
                this.pout.setTimeAt(this.ystartjtime);
            }
            if (this.doTimeCode) {
                if (this.doXSXD) {
                    this.pout.setXUnits(3);
                }
                this.pout.setYUnits(1);
                this.dgd.registerTimeCB(this);
            }
            this.pout.open();
            if (this.MA.find("CONVOUT")) {
                if (this.verbose) {
                    this.M.info("sourcedg: Convout created");
                }
                this.convout = this.MA.getDataFile("CONVOUT", "1000", "SI", 2, 1.0, null);
                this.convout.setXStart(this.xStart);
                this.convout.setXDelta(this.xDelta);
                if (this.doTimeCode && this.doXSXD) {
                    this.convout.setXUnits(1);
                }
                this.convout.open();
                this.outdata = this.convout.getDataBuffer(this.outtl, (byte)73);
            }
            if (this.getDgState()) {
                this.setDgState("ON");
            } else if (this.MA.find("/ON")) {
                this.setDgState(this.MA.getState("/ON"));
            }
        }
        catch (Exception e) {
            throw new MidasException("sourcedg: open failed", e);
        }
        return 0;
    }

    @Override
    public int process() {
        if (this.dgdclosed) {
            return -1;
        }
        if (this.abort) {
            return 0;
        }
        return this.read() ? 0 : -1;
    }

    @Override
    public int close() {
        try {
            if (this.verbose) {
                System.out.println("Closing");
            }
            if (this.dgd != null) {
                this.dgd.close();
            }
            this.FillPipeAtEnd();
            if (this.pout != null) {
                this.pout.update();
                this.pout.close();
            }
            if (this.convout != null) {
                this.convout.update();
                this.convout.close();
            }
            if (this.logfile != null) {
                this.logfile.writeln("sourcedg log stopped at " + Time.tag());
                this.logfile.close();
            }
        }
        catch (Exception e) {
            throw new MidasException("sourcedg: close failed", e);
        }
        return 0;
    }

    public void FillPipeAtEnd() {
        try {
            if (this.fill && this.framesz > 0) {
                if (this.verbose) {
                    this.M.info("sourcedg: FillPipeAtEnd and checking for leftover data.");
                }
                if (this.curlen > 0 && this.pktfrcount < this.framesz && this.pktfrcount > 0) {
                    this.fillbuf(this.fbuf, this.framesz - this.pktfrcount);
                    if (this.verbose) {
                        this.M.info("sourcedg: FillPipeAtEnd and filling buffer with " + (this.framesz - this.pktfrcount));
                    }
                    this.pktfrcount = this.framesz;
                }
            }
        }
        catch (Exception e) {
            throw new MidasException("sourcedg: FillPipeAtEnd failed", e);
        }
    }

    @Override
    public synchronized int processMessage(Message msg) {
        if (this.verbose) {
            this.M.info("sourcedg: Processing a message: " + msg.name);
        }
        if (msg.name.equals("OPENNET")) {
            this.setDgState("OFF");
            String hostport = (String)msg.data;
            this.i = hostport.indexOf(58);
            if (this.i < 0) {
                this.host = defaulthost;
                this.port = 18800;
            } else {
                this.host = hostport.substring(0, this.i).toLowerCase();
                this.port = Integer.parseInt(hostport.substring(this.i + 1));
            }
            if (this.verbose) {
                this.M.info("sourcedg: Host=" + this.host + ". Port=" + this.port);
            }
            this.setHost(this.host);
            this.setPort(this.port);
            this.setDgState("ON");
        } else if (msg.name.equals("CLOSENET")) {
            this.setDgState("OFF");
        } else if (msg.name.equals("EXITNET")) {
            this.setDgState("OFF");
            this.close();
            return 9;
        }
        return 0;
    }

    public void setDgState(String pvalue) {
        this.setDgState(StringUtil.isTrue(pvalue));
    }

    public void setDgState(boolean on) {
        if (this.verbose) {
            this.M.info("sourcedg: Set DgState:" + on);
        }
        try {
            this.chdr = -1;
            if (!this.dgdclosed) {
                this.dgdclosed = true;
                if (this.dgd != null) {
                    this.dgd.leave();
                }
                this.FillPipeAtEnd();
            }
            if (on && this.dgd != null) {
                this.dgdclosed = !this.dgd.open();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.M.error("sourcedg: setDgState failed:" + e);
        }
        if (this.verbose) {
            this.M.info("sourcedg: Done:" + on + " and closed set=" + this.dgdclosed);
        }
    }

    public boolean getDgState() {
        return !this.dgdclosed;
    }

    public void setLinear() {
        this.linearin = true;
    }

    public void setULAW() {
        this.linearin = false;
    }

    public void setAutoSeqResetMAX(int value) {
        if (this.dgd == null) {
            return;
        }
        try {
            this.dgd.setAutoSeqResetMAX(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getFrameSize() {
        return this.pout.getFrameSize();
    }

    public void setFrameSize(int value, boolean setpipe) {
        this.framesz = value;
        if (setpipe && this.pout != null) {
            this.pout.setFrameSize(value);
            this.pout.update();
        }
    }

    public void setFrameSize(int value) {
        this.setFrameSize(value, true);
        if (this.fill) {
            this.chdr = -1;
        }
    }

    public double getYDelta() {
        return this.pout.getYDelta();
    }

    public void setYDelta(double value) {
        this.pout.setYDelta(value);
        this.pout.update();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean read() {
        try {
            block48: {
                block49: {
                    block50: {
                        if (this.dgd == null) {
                            return false;
                        }
                        this.len = this.dgd.read(this.buf, this.offsetdata);
                        if (this.len <= 0) {
                            return true;
                        }
                        this.curlen = this.len;
                        this.offset = 0;
                        if (!this.fill) break block48;
                        this.fillnum = this.dgd.getFillNum();
                        if (!this.icehdrframe && this.framesz <= 0) {
                            if (this.verbose) {
                                System.out.println("FILL:: 1000 file fill=" + this.fillnum);
                            }
                            if (this.fillnum <= 0) return true;
                            this.fillbuf(this.fbuf, this.len, this.fillnum);
                            return true;
                        }
                        if (this.verbose) {
                            System.out.println("FILL:: Packet:" + this.dgd.getCurHdrSeq() + ":" + this.dgd.getSeq() + ":" + this.len + ",fn=" + this.fillnum);
                        }
                        if (this.chdr < 0) {
                            if (!this.dgd.isIceHdrPacket()) {
                                if (!this.verbose) return true;
                                System.out.println("FILL:: Skipping startup packets until header");
                                return true;
                            }
                            this.chdr = this.dgd.getCurHdrSeq();
                            if (this.verbose) {
                                System.out.println("FILL:: Startup packet:" + this.chdr);
                            }
                            if (this.icehdrframe) {
                                if (this.dgd.getBytes() > 0) {
                                    if (this.getIceHdrInPipe()) {
                                        this.setFrameSize((this.dgd.getBytes() + 64) / Data.getBPA(this.midasdatatype), true);
                                    } else {
                                        this.setFrameSize(this.dgd.getBytes(), true);
                                    }
                                }
                                if (this.verbose) {
                                    System.out.println("FILL:: Set Frame Size=" + this.framesz);
                                }
                            }
                            this.pktfrcount = 0;
                            this.fillnum = 0;
                            this.dgramTime(this.dgd.getICETime(), this.dgd.getDU2(), this.dgd.getDU1());
                        }
                        if (this.fillnum <= 0) break block49;
                        if (this.pktfrcount < this.framesz) break block50;
                        if (!this.dgd.isIceHdrPacket()) {
                            if (!this.verbose) return true;
                            System.out.println("FILL:: Skip packet, not header and previous frame filled fn=" + this.fillnum + " pktfrcount=" + this.pktfrcount + " framesz=" + this.framesz + " len=" + this.len);
                            return true;
                        }
                        this.pktfrcount = 0;
                        this.dgramTime(this.dgd.getICETime(), this.dgd.getDU2(), this.dgd.getDU1());
                        break block48;
                    }
                    if (this.dgd.isIceHdrPacket()) {
                        this.fillbuf(this.fbuf, this.framesz - this.pktfrcount);
                        if (this.verbose) {
                            System.out.println("FILL:: Header case framesz=" + this.framesz + " pktfrcount=" + this.pktfrcount + ",fn=" + this.fillnum);
                        }
                        this.pktfrcount = 0;
                        this.dgramTime(this.dgd.getICETime(), this.dgd.getDU2(), this.dgd.getDU1());
                        break block48;
                    } else {
                        this.pktsinframe = this.icehdrinpipe ? (this.framesz - 64) / this.len : this.framesz / this.len;
                        this.chdr = this.dgd.getCurHdrSeq();
                        this.seq = this.dgd.getSeq();
                        this.pcount = this.seq - this.chdr;
                        if (this.pcount < 0) {
                            if (this.verbose) {
                                System.out.println("FILL:: rollover or prev case seq=" + this.seq + ",hdr=" + this.chdr);
                            }
                            if (this.pcount > -100) {
                                if (!this.verbose) return true;
                                System.out.println("FILL:: Out of order case seq=" + this.seq + ",hdr=" + this.chdr);
                                return true;
                            }
                            this.pcount += 65536;
                        }
                        if (this.pcount > this.pktsinframe) {
                            this.fillbuf(this.fbuf, this.framesz - this.pktfrcount);
                            if (this.verbose) {
                                System.out.println("FILL:: Skip Cross frame case pktsinframe=" + this.pktsinframe + " fn=" + this.fillnum + " pcount=" + this.pcount + " seq=" + this.seq + " chdr=" + this.chdr + ",fill=" + (this.framesz - this.pktfrcount));
                            }
                            this.pktfrcount = this.framesz;
                            return true;
                        }
                        this.pktfrcount += this.fillbuf(this.fbuf, this.fillnum * this.len);
                        if (this.verbose) {
                            System.out.println("FILL:: Within frame case pktsinframe=" + this.pktsinframe + " fn=" + this.fillnum);
                        }
                    }
                    break block48;
                }
                if (this.dgd.isIceHdrPacket()) {
                    if (this.verbose && this.pktfrcount < this.framesz && this.pktfrcount != 0) {
                        System.out.println("FILL:: ERROR - frame not filled in framesz=" + this.framesz + "," + this.pktfrcount);
                    }
                    this.pktfrcount = 0;
                    this.dgramTime(this.dgd.getICETime(), this.dgd.getDU2(), this.dgd.getDU1());
                } else if (this.pktfrcount >= this.framesz) {
                    if (!this.verbose) return true;
                    System.out.println("FILL:: Skip packet, looking for header and previous frame filled");
                    return true;
                }
            }
            if (this.len <= 0) return true;
            if (this.msgonly) {
                String tmpbuf = new String(this.buf, 0, this.len);
                if (this.verbose) {
                    System.out.println("XML In=" + tmpbuf);
                }
                Table XMLTab = XmlFile.fastXmlToTable(tmpbuf, null, null, -1, true);
                this.sendMessage((MessageHandler)this.msgid, new Message(this.msgnameforxml, 1, XMLTab));
                return true;
            }
            if (this.pout == null) {
                this.M.info("sourcedg: No output pipe.");
                return true;
            }
            if (this.pout.io == null) {
                this.M.error("sourcedg: Pipe open failed");
                return true;
            }
            if (this.midasfiletype == 2000 || this.midasfiletype == 1000) {
                if (this.verbose) {
                    System.out.println("  Writing len=" + this.len);
                }
                this.pout.write(this.buf, 0, this.len);
                if (this.fill) {
                    this.pktfrcount += this.len;
                }
                if (this.pktfrcount > this.framesz) {
                    if (this.verbose) {
                        System.out.println("ERROR IN CALCULATION=" + this.framesz + ">pkt=" + this.pktfrcount);
                    }
                    this.pktfrcount = this.framesz;
                }
                if (this.convout == null) return true;
                if (this.convout.io == null) return true;
                if (this.intl <= 0) return true;
                this.numrecs = this.len / this.intl;
                this.psize = this.len;
                if (this.numrecs < 1L) {
                    this.numrecs = 1L;
                }
                if (this.len > this.intl) {
                    this.psize = this.intl;
                }
                this.offset = 0;
                if (this.convout.avail() < (double)(this.len + this.len)) {
                    this.M.info("sourcedg: Convpipe full: len=" + this.len + ", avail=" + this.convout.avail());
                    return true;
                }
                if (this.linear || this.linearin) {
                    this.convout.write(this.buf, 0, this.len);
                    return true;
                }
            } else {
                if (this.midasfiletype != 3000) return true;
                if (!this.xml3000out) {
                    this.pout.write(this.buf, 0, this.len);
                    return true;
                }
                String tmpbuf = new String(this.buf, 8, this.buf.length - 8);
                if (this.verbose) {
                    System.out.println("SDG: XML '" + tmpbuf + "'");
                }
                Table XMLTab = XmlFile.fastXmlToTable(tmpbuf, null, null, -1, true);
                Table outtab = this.matchTableInfo(this.t3kstruct, XMLTab);
                if (this.verbose) {
                    System.out.println("SDG: XML as a Table " + XMLTab);
                    System.out.println("SDG: OUTPUT Table " + outtab);
                }
                this.pout.setData(1.0, outtab);
                return true;
            }
            this.j = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.M.warning("sourcedg: Read failed. " + e);
            return false;
        }
        while ((long)this.j < this.numrecs) {
            this.outbuf = this.outdata.castI(false);
            this.i = 0;
            while (this.i < this.psize) {
                this.outbuf[this.i] = this.decodeTable[this.buf[this.offset + this.i] + 128];
                ++this.i;
            }
            this.outdata.uncast(this.outbuf, true);
            this.convout.write(this.outdata, this.psize);
            this.offset += this.psize;
            ++this.j;
        }
        return true;
    }

    public int fillbuf(byte[] fbuf, int len, int fillnum) {
        if (fillnum <= 0 || len < 1) {
            return 0;
        }
        return this.fillbuf(fbuf, len * fillnum);
    }

    public int fillbuf(byte[] fbuf, int totbytes) {
        if (this.verbose) {
            System.out.println("  Filling totbytes=" + totbytes);
        }
        if (this.pout == null) {
            return -1;
        }
        if (totbytes < 1) {
            return 0;
        }
        if (totbytes <= fbuf.length) {
            this.pout.write(fbuf, 0, totbytes);
            return totbytes;
        }
        this.fullwrites = totbytes / fbuf.length;
        this.i = 0;
        while (this.i < this.fullwrites) {
            this.pout.write(fbuf, 0, fbuf.length);
            ++this.i;
        }
        this.remain = totbytes - this.fullwrites * fbuf.length;
        if (this.remain > 0) {
            this.pout.write(fbuf, 0, this.remain);
        }
        return totbytes;
    }

    public void sendMessage(MessageHandler msgid, Message msg) {
        if (msgid == msg.from) {
            return;
        }
        msg.to = msgid;
        msg.from = this;
        msgid.processMessage(msg);
    }

    private Table matchTableInfo(Table structure, Table inTable) {
        String keyvals = structure.getKeyList();
        StringTokenizer keyST = new StringTokenizer(keyvals, ",", false);
        Table retTab = new Table();
        while (keyST.hasMoreTokens()) {
            String structKey = keyST.nextToken();
            if (structKey.length() > 4) {
                structKey = structKey.substring(0, 4);
            }
            String fmt = structure.getS(structKey);
            String tblVal = inTable.getS(structKey);
            if (tblVal == null) continue;
            if (fmt.equals("SD")) {
                retTab.put(structKey, Convert.s2d(tblVal));
                continue;
            }
            if (fmt.equals("SL")) {
                retTab.put(structKey, Convert.s2l(tblVal));
                continue;
            }
            retTab.put(structKey, (Object)tblVal);
        }
        return retTab;
    }

    private short[] build_mu_decode_table() {
        short[] convbuf = new short[256];
        for (int i = 0; i < 256; ++i) {
            int j = i - 128;
            int x = j ^ 0x7F;
            int S = 1 - 2 * ((x & 0x80) / 128);
            int L = (x & 0x70) / 16;
            int V = x & 0xF;
            convbuf[i] = (short)Math.round((double)S * (Math.pow(2.0, L) * (double)(2 * V + 33) - 33.0) * 32767.0 / 8031.0);
        }
        return convbuf;
    }

    @Override
    public void dgramTime(double jtime, double inxStart, double inxDelta) {
        try {
            if (this.verbose) {
                this.dgTime.fromJ1950(jtime);
                System.out.println("sourcedg: dgramTime = " + this.dgTime + " XS=" + inxStart + " XD=" + inxDelta);
            }
            this.pout.setTimeAt(jtime);
            if (this.convout != null) {
                this.convout.setTimeAt(jtime);
            }
            this.dgjtime = jtime;
            this.dgdxs = inxStart;
            this.dgdxd = inxDelta;
            this.dgdsize = this.dgd.getSize();
            this.dgdbytes = this.dgd.getBytes();
            this.dgdformat = this.dgd.getFormat();
            if ((this.icehdrframe || this.doXSXD) && (inxStart != this.getXStart() || inxDelta != this.getXDelta())) {
                if (this.verbose) {
                    this.M.info("Update message XS=" + inxStart + "(" + this.getXStart() + ") XD=" + inxDelta + "(" + this.getXDelta() + ")");
                }
                this.setXStart(inxStart);
                this.setXDelta(inxDelta);
                if (this.icehdrframe && this.msgid instanceof MessageHandler) {
                    Table XMLTab = new Table();
                    XMLTab.put("TYPE", (Object)"XSXDUPD");
                    XMLTab.put("XD", inxDelta);
                    XMLTab.put("XS", inxStart);
                    XMLTab.put("SIZE", this.dgdsize);
                    XMLTab.put("BYTES", this.dgdbytes);
                    XMLTab.put("FORMAT", (Object)this.dgdformat);
                    this.sendMessage((MessageHandler)this.msgid, new Message(this.msgnameforxml, 1, XMLTab));
                }
                if (this.doXSXD) {
                    if (this.verbose) {
                        this.M.info("sourcedg: Restarting with xStart=" + inxStart + " xDelta=" + inxDelta);
                    }
                    this.restartSourcedg(jtime);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.M.warning("sourcedg: checkIceParms failed. " + e);
        }
    }

    public void restartSourcedg() {
        this.setState(7);
    }

    private void restartSourcedg(double jtime) {
        this.setYStartTime(jtime);
        this.restartSourcedg();
    }
}

