/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

public class prescaler
extends Primitive {
    protected DataFile hin;
    protected DataFile hout;
    protected double percent;
    protected boolean makingCopy;
    protected boolean isType2000;
    protected int frameSize;
    protected int units;
    protected double dnelem;
    private double ydelta;
    private double ystart;
    protected boolean complex;
    protected int spa;
    protected Data data;
    protected int ngot;
    protected double dmax;
    protected double dmin;
    protected double dmaxOff;
    protected double dminOff;
    protected boolean selectiveRead;
    LinkedList<Integer> selectedReadIndicies;
    @InternalUseOnly(value="Since NeXtMidas 3.9.1")
    public Table table = new Table();
    String resultsName;
    String DEFAULT_RES_TBL_NAME = "PRESCALER_RESULT_TBL";
    public static final String KEYWORD_DEFAULT = "VOLATILE_KW_PLOT_SCALE";
    public static final String KEYWORD_SWITCH = "/SCALEKW";
    public static final int DEFAULT_RANDOM_PERCENT = -10;
    static final int MAX_RANDOM_PERCENT = 20;
    static final int MIN_RANDOM_SAMPLES = 2;
    static int maxForCappedRandom = 1000;
    static boolean useSeededRandom = true;
    static final long RANDOM_SEED = 10125811212113L;
    String prescaleKW = "";
    boolean addPrescaleKeyword;
    public static final int WHOLE_FILE = 100;
    static final float[] PERCENT_DEVIATIONS = new float[]{-0.3f, 0.3f, -0.1f, 0.1f, -0.4f, 0.4f, -0.2f, 0.2f, 0.0f, -0.35f, 0.35f, -0.15f, 0.15f, -0.25f, 0.25f, 0.0f};
    static boolean debugDefault = false;
    boolean debug = false;

    @Override
    public int open() {
        this.hin = this.MA.getDataFile("IN", "1000,2000", "S#,C#", 1);
        this.hin.open();
        if (this.MA.find(KEYWORD_SWITCH)) {
            this.addPrescaleKeyword = true;
            this.prescaleKW = this.MA.getS(KEYWORD_SWITCH);
            if (this.prescaleKW == null || this.prescaleKW == "") {
                this.prescaleKW = KEYWORD_DEFAULT;
            }
        }
        this.units = this.hin.getUnits();
        this.hout = this.MA.getDataFile("OUT", this.hin, 0);
        this.hout.open(64);
        this.makingCopy = this.hout.isOpen;
        this.percent = this.MA.getD("/RANDOM", 100.0, -10.0);
        this.xfer = this.MA.getL("/TL", Math.max(1, (int)((double)this.bufSize / this.hin.dbpe)));
        this.debug = debugDefault || this.MA.find("/DEBUG");
        this.frameSize = this.hin.getFrameSize();
        if (this.hin.typeClass == 2) {
            this.ydelta = this.hin.getYDelta();
            this.ystart = this.hin.getYStart();
        }
        boolean bl = this.isType2000 = this.hin.typeClass == 2;
        if (this.isType2000) {
            this.hin.setFS(0);
            if (this.makingCopy) {
                this.hout.setFS(0);
            }
            this.xfer = this.frameSize;
        }
        int numTLofData = (int)(this.hin.getSize() / (double)this.xfer);
        this.percent = this.adjustPercent(numTLofData);
        if (this.percent < 100.0 && this.percent > 20.0) {
            this.M.info("PRESCALER only supports a random percent of 20% or less. The percent " + this.percent + "% is not supported. Defaulting to processing the whole file");
            this.percent = 100.0;
        }
        boolean bl2 = this.selectiveRead = this.percent < 100.0 && !this.makingCopy && !this.hin.isPipe();
        if (this.selectiveRead) {
            int numValuesInSet = (int)Math.max(this.percent * (double)numTLofData / 100.0, 2.0);
            this.selectedReadIndicies = useSeededRandom ? new LinkedList<Integer>(prescaler.getNRandomMultiplesOfValue(numValuesInSet, numTLofData - 1, this.xfer)) : prescaler.getNScatteredMultiplesOfValue(numValuesInSet, numTLofData - 1, this.xfer);
            if (this.debug) {
                if (useSeededRandom) {
                    System.out.println("Selected Indices based on seeded random:" + this.selectedReadIndicies);
                } else {
                    System.out.println("Selected Indices based on scattered:" + this.selectedReadIndicies);
                }
            }
        }
        this.complex = this.hin.getFormatMode() == 67;
        this.spa = this.hin.getSPA();
        this.data = this.hin.getDataBuffer(this.xfer);
        this.verbose = this.MA.getState("/VERBOSE", false);
        this.resetAccumulators();
        this.resultsName = this.MA.getS("SCALETABLE", this.DEFAULT_RES_TBL_NAME);
        if (this.resultsName.trim().isEmpty()) {
            this.resultsName = this.DEFAULT_RES_TBL_NAME;
        }
        if (this.makingCopy) {
            this.hout.setTimeLineLength(-1);
        }
        return 0;
    }

    @Override
    public int process() {
        if (!this.selectiveRead) {
            this.ngot = this.hin.read(this.data);
        } else if (!this.selectedReadIndicies.isEmpty()) {
            int index = this.selectedReadIndicies.removeFirst();
            this.ngot = this.hin.read(this.data, (double)index, this.xfer);
        } else {
            this.ngot = -1;
        }
        if (this.ngot == 0) {
            return -1;
        }
        if (this.ngot < 0) {
            if (this.makingCopy && this.isType2000) {
                this.hout.setFrameSize(this.frameSize);
                this.hout.setUnits(this.units);
                this.hout.setYDelta(this.ydelta);
                this.hout.setYStart(this.ystart);
            }
            this.outputToResTableAndKeywords();
            return 9;
        }
        double[] dbuf = this.data.castD(true);
        this.computeStatistics(dbuf, this.ngot, this.spa, this.complex);
        this.data.uncast(dbuf, false);
        if (this.makingCopy) {
            this.hout.write(this.data, this.ngot);
        }
        return 0;
    }

    @Override
    public int close() {
        this.hin.close();
        if (this.makingCopy) {
            if (!this.M.isPiped()) {
                this.hout.close();
            } else {
                this.hout.update();
            }
        }
        return 0;
    }

    private double adjustPercent(int numTLofData) {
        if (this.percent < -100.0) {
            this.percent = this.hin.size <= -this.percent ? 100.0 : -10.0;
        }
        boolean cappingRandom = this.percent < 0.0;
        double newPercent = Math.abs(this.percent);
        if (cappingRandom) {
            double maxPercent = Math.min(100.0, 100.0 * (double)maxForCappedRandom / (double)numTLofData);
            this.percent = Math.min(newPercent, maxPercent);
        }
        newPercent = Math.max(newPercent, 200.0 / (double)numTLofData);
        return newPercent;
    }

    protected void computeStatistics(double[] dbuf, int ngot, int spa, boolean complex) {
        if (complex) {
            int i = 0;
            while (i < ngot * spa) {
                double rval = dbuf[i++];
                double ival = dbuf[i++];
                if (this.isType2000) {
                    double dabs = rval * rval + ival * ival;
                    if (dabs > this.dmax) {
                        this.dmax = dabs;
                        this.dmaxOff = this.dnelem;
                    }
                    if (!(dabs < this.dmin)) continue;
                    this.dmin = dabs;
                    this.dminOff = this.dnelem;
                    continue;
                }
                double valMin = Math.min(rval, ival);
                double valMax = Math.max(rval, ival);
                if (valMax > this.dmax) {
                    this.dmax = valMax;
                    this.dmaxOff = this.dnelem;
                }
                if (!(valMin < this.dmin)) continue;
                this.dmin = valMin;
                this.dminOff = this.dnelem;
            }
        } else {
            int i = 0;
            while (i < ngot * spa) {
                int n = i++;
                double dval = dbuf[n];
                if (dval > this.dmax) {
                    this.dmax = dval;
                    this.dmaxOff = this.dnelem;
                }
                if (!(dval < this.dmin)) continue;
                this.dmin = dval;
                this.dminOff = this.dnelem;
            }
        }
    }

    protected void outputToResTableAndKeywords() {
        Table keywordTable = new Table();
        if (!this.isType2000) {
            keywordTable.put("YMIN", this.dmin);
            keywordTable.put("YMAX", this.dmax);
        } else {
            if (this.complex) {
                this.dmin = Math.sqrt(this.dmin);
                this.dmax = Math.sqrt(this.dmax);
            }
            keywordTable.put("ZMIN", this.dmin);
            keywordTable.put("ZMAX", this.dmax);
        }
        if (this.addPrescaleKeyword) {
            if (this.makingCopy) {
                this.hout.keywords.add(this.prescaleKW, keywordTable);
                this.hout.update();
            } else {
                this.hin.close();
                this.hin.setFlags(3);
                this.hin.open();
                this.hin.keywords.put(this.prescaleKW, keywordTable);
                this.hin.update();
            }
        }
        this.table.putAll((Map)keywordTable);
        this.MR.put(this.resultsName, (Object)this.table);
    }

    protected void resetAccumulators() {
        this.dmax = -1.0E37;
        this.dmin = 1.0E37;
        this.dmaxOff = -1.0;
        this.dminOff = -1.0;
        this.dnelem = 0.0;
    }

    @InternalUseOnly
    public static HashSet<Integer> getNRandomMultiplesOfValue(int n, int maxN, int multFactor) {
        if (n > maxN + 1) {
            Shell.warning("prescaler.getNRandomMultiplesOfValue n:" + n + " can not be greater than maxN:" + maxN + " ... setting n to maxValue");
            n = maxN;
        } else if (n < 2) {
            Shell.warning("prescaler.getNRandomMultiplesOfValue n:" + n + " can not be less than 2 - first and last xfer length always included.");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(0);
        set.add(maxN * multFactor);
        Random random = new Random(10125811212113L);
        while (set.size() < n) {
            int thisOne = random.nextInt(maxN + 1) * multFactor;
            set.add(thisOne);
        }
        return set;
    }

    @InternalUseOnly
    public static LinkedList<Integer> getNScatteredMultiplesOfValue(int n, int maxN, int multFactor) {
        if (n > maxN + 1) {
            Shell.warning("prescaler.getNRandomMultiplesOfValue n:" + n + " can not be greater than maxN:" + maxN + " ... setting n to maxValue");
            n = maxN;
        }
        LinkedList<Integer> scatteredIndices = new LinkedList<Integer>();
        int dataGrpIdx = 0;
        float avgSpacing = maxN / n;
        float[] deviations = prescaler.getDeviations(avgSpacing / 2.0f);
        float touchstoneIndex = 0.0f;
        int deviationIdx = 0;
        while (dataGrpIdx < maxN) {
            int thisOne = dataGrpIdx * multFactor;
            scatteredIndices.add(thisOne);
            dataGrpIdx = (int)((touchstoneIndex += avgSpacing) + deviations[deviationIdx]);
            deviationIdx = (deviationIdx + 1) % deviations.length;
        }
        scatteredIndices.add(maxN * multFactor);
        return scatteredIndices;
    }

    private static float[] getDeviations(float maxDeviation) {
        float[] deviations = new float[PERCENT_DEVIATIONS.length];
        for (int i = 0; i < deviations.length; ++i) {
            deviations[i] = maxDeviation * PERCENT_DEVIATIONS[i];
        }
        return deviations;
    }

    public static void setUseSeededRandom(boolean useSeededRandom) {
        prescaler.useSeededRandom = useSeededRandom;
    }

    public static void setUseSeededRandom(String useSeededRandom) {
        prescaler.useSeededRandom = useSeededRandom.toLowerCase().startsWith("t");
    }

    public static void setDebug(String debugOn) {
        debugDefault = debugOn.toLowerCase().startsWith("t");
    }

    public static void setMaxForCappedRandom(int cap) {
        maxForCappedRandom = cap;
    }

    public static int getMaxForCappedRandom() {
        return maxForCappedRandom;
    }
}

