/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.awt.Component;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Message;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.GPrimitive;
import nxm.sys.libg.MJPopup;
import nxm.sys.libg.MWindow;

public class popup
extends GPrimitive {
    @Deprecated
    public static final String blockingOptionsList = "Macro,Mouse";
    private static final int BLOCK_DEFAULT = 2;
    private String msgName;
    private String result;
    private String func;
    private Component parent;
    private MWindow parentMW;
    private Object message;
    private int type;
    private String defValue;
    private Object[] choices;
    private Table parameters;
    private String title;
    private MJPopup popup;
    private int blocking;
    private int[] position;
    private boolean cancelMsg;

    @Override
    public void setArgs(Args args) {
        super.setArgs(args);
        String blockStr = args.getS("/BLOCKING", "MOUSE");
        this.blocking = Parser.mask(blockingOptionsList, blockStr, 2);
        if ((this.blocking & 1) == 0) {
            args.put("/BG", "TRUE");
        } else if (args.getState("/BG", false)) {
            this.blocking &= 0xFFFFFFFE;
            args.put("/BLOCKING", Parser.mask2s(blockingOptionsList, this.blocking));
        }
    }

    @Override
    public int open() {
        Object win;
        String defTitle = this.M.macro == null ? "NeXtMidas" : this.M.macro.name;
        int status = 0;
        String blockStr = this.MA.getS("/BLOCKING", "MOUSE");
        this.result = this.MA.getU("RESULT", "").toUpperCase();
        this.func = this.MA.getU("FUNC", "").toUpperCase();
        this.message = this.MA.getCS("MESSAGE");
        this.type = this.getMessageType(this.MA.getU("TYPE", null));
        this.choices = new String[0];
        this.defValue = this.MA.getCS("DEFAULTS", "");
        this.parameters = this.MA.getTable("PARAMETERS");
        this.title = this.MA.getCS("/TITLE", defTitle);
        this.blocking = Parser.mask(blockingOptionsList, blockStr, 2);
        this.msgName = this.MA.getS("/MSGNAME", "POPUP");
        this.position = this.getPopupPosition(this.MA.getS("/WPOS", "CENTER"));
        this.cancelMsg = this.MA.getState("/CANCELMSG", true);
        String opts = this.MA.getCS("OPTIONS", "");
        if (opts != null && opts.length() > 0) {
            this.choices = opts.split("[|,]");
        }
        if ((win = this.MA.getO("/WIN", null)) instanceof Component) {
            this.parent = (Component)win;
        } else if (GPrimitive.isInstance(win)) {
            this.parentMW = GPrimitive.getMWindowViaReflection(win);
            this.parent = GPrimitive.getGraphicsContainerViaReflection(win);
        } else {
            if (win == null && this.M.macro != null) {
                win = "PANEL";
            }
            if (GPrimitive.isInstance(win = this.MR.get("REG." + win))) {
                this.parentMW = GPrimitive.getMWindowViaReflection(win);
                this.parent = GPrimitive.getGraphicsContainerViaReflection(win);
            }
        }
        this.popup = new MJPopup(this.MA.getL("/POPWIDTH", 80));
        if ((this.blocking & 1) != 0) {
            this.showWindow();
            while (!this.popup.isDone()) {
                Time.sleep(0.5);
            }
            status = 9;
        } else {
            this.showWindow();
        }
        return status;
    }

    @Override
    public int process() {
        int status = 0;
        status = (this.blocking & 1) != 0 ? 9 : (this.popup.isDone() ? 9 : -1);
        return status;
    }

    @Override
    public int close() {
        int info = this.popup.getInfo();
        Object data = this.popup.getValue();
        boolean cancel = this.popup.getCancel();
        if (this.cancelMsg || !cancel) {
            this.sendMessage(new Message(this.msgName, info, data));
        }
        if (this.result != null && this.result.length() > 0) {
            this.MR.put(this.result, data);
        } else if (this.verbose) {
            this.M.type("input = " + data);
        }
        this.popup.dispose();
        return 0;
    }

    @Override
    public int processMessage(Message msg) {
        int status = 0;
        if (msg.name.equals("CANCEL")) {
            this.popup.cancel();
        } else {
            status = super.processMessage(msg);
        }
        return status;
    }

    private void showWindow() {
        if (this.func.equals("GROUP")) {
            this.popup = MJPopup.createGroup(this.parent, this.title, this.type, this.message, this.parameters);
        } else if (this.func.equals("YESNO")) {
            this.popup = MJPopup.createYesNo(this.parent, this.title, this.type, this.message);
        } else if (this.func.equals("YESNOCANCEL")) {
            this.popup = MJPopup.createYesNoCancel(this.parent, this.title, this.type, this.message);
        } else if (this.func.equals("OK")) {
            this.popup = MJPopup.createOk(this.parent, this.title, this.type, this.message);
        } else if (this.func.equals("OKCANCEL")) {
            this.popup = MJPopup.createOkCancel(this.parent, this.title, this.type, this.message);
        } else if (this.func.equals("TEXT")) {
            this.popup = MJPopup.createText(this.parent, this.title, this.type, this.message, this.defValue);
        } else if (this.func.equals("PASSWORD")) {
            this.popup = MJPopup.createPassword(this.parent, this.title, this.type, this.message, this.defValue);
        } else if (this.func.equals("CHOICE")) {
            this.popup = MJPopup.createChoice(this.parent, this.title, this.type, this.message, this.choices, this.defValue);
        } else if (this.func.equals("MASK")) {
            this.popup = MJPopup.createIntMask(this.parent, this.title, this.type, this.message, this.choices, this.defValue);
        } else if (this.func.equals("MASK/S")) {
            this.popup = MJPopup.createMask(this.parent, this.title, this.type, this.message, this.choices, this.defValue);
        } else if (this.func.equals("BUTTONS")) {
            this.popup = MJPopup.createButtons(this.parent, this.title, this.type, this.message, this.choices);
        } else if (this.func.equals("COLOR")) {
            this.popup = MJPopup.createColor(this.parent, this.title, this.type, this.message, this.defValue);
        } else if (this.func.equals("LOGIN")) {
            this.popup = MJPopup.createLogin(this.parent, this.title, this.type, this.message, this.defValue);
        } else if (this.func.equals("ALERT")) {
            this.popup = MJPopup.createAlert(this.parent, this.title, this.type, this.message);
        } else if (this.func.equals("FILE") || this.func.equals("FILE/M")) {
            this.popup = MJPopup.createFile(this.parent, this.title, this.type, this.message, this.defValue, this.MA.getS("FILTER", null), this.MA.getS("AUXLIST", null), this.MA.getS("PATHOPT", null));
        } else {
            if (this.func.equals("FILE/J")) {
                String pathOpt = this.MA.getS("PATHOPT", "FullPath");
                if (!pathOpt.equalsIgnoreCase("FullPath")) {
                    throw new MidasException("Can not use PATHOPT=" + pathOpt + " with a FILE/J popup.");
                }
                throw new UnsupportedOperationException("This version of POPUP does not support FILE/J.");
            }
            throw new MidasException("Unknown function (FUNC=" + this.func + ").");
        }
        this.popup.display(this.parentMW, this.blocking, this.position);
    }

    private int getMessageType(String name) {
        boolean err = true;
        int id = -1;
        String string = name = name != null ? name.toUpperCase() : "null";
        if (name.startsWith("ERR")) {
            id = 0;
            err = false;
        }
        if (name.startsWith("INFO")) {
            id = 1;
            err = false;
        }
        if (name.startsWith("WARN")) {
            id = 2;
            err = false;
        }
        if (name.startsWith("QUEST")) {
            id = 3;
            err = false;
        }
        if (name.startsWith("PLAIN")) {
            id = -1;
            err = false;
        }
        if (err) {
            this.M.warning("Unknown message type (" + name + ") using default.");
        }
        return id;
    }

    private int[] getPopupPosition(String wpos) {
        int[] position = MJPopup.POSITION_CENTER;
        String[] coords = null;
        if (wpos.startsWith("(") && wpos.endsWith(")")) {
            coords = wpos.substring(1, wpos.length() - 1).split(",");
        }
        if (wpos == null || wpos.equalsIgnoreCase("CENTER")) {
            position = MJPopup.POSITION_CENTER;
        } else if (wpos.equalsIgnoreCase("MOUSE")) {
            position = MJPopup.POSITION_MOUSE;
        } else if (coords != null && (coords.length == 2 || coords.length == 4)) {
            position = new int[coords.length];
            for (int i = 0; i < position.length; ++i) {
                position[i] = Convert.s2l(coords[i]);
            }
        } else {
            this.M.warning("POPUP: Illegal window position /WPOS=" + wpos + " expected one of: 'CENTER', 'MOUSE', '(x,y)', or '(x,y,w,h)'.");
        }
        return position;
    }
}

