/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.io.File;
import nxm.sys.inc.Chainable;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.net.HFiles;
import nxm.sys.net.HPage;
import nxm.sys.net.HServer;
import nxm.sys.net.HSource;

public class httpserv
extends Primitive
implements Chainable {
    protected HServer server;
    protected Thread srvThread;

    @Override
    public int open() {
        int port = this.MA.getL("PORT");
        String dirName = this.MA.getCS("NAME");
        String dir = this.MA.getCS("DIR");
        String lname = this.MA.getCS("/MNAME", null);
        String homepage = this.MA.getCS("/HOMEPAGE", null);
        String auxlist = this.MA.getS("/AUXLIST", null);
        int prange = this.MA.getL("/PRANGE", 1);
        HServer.setHttps(this.MA.getState("/HTTPS", this.MA.find("/HTTPS")));
        HServer.setOneWay(this.MA.getState("/ONEWAY", this.MA.find("/ONEWAY")));
        boolean isWin = Shell.isWindows();
        if (isWin) {
            if (dir.startsWith(File.separator)) {
                dir = "C:" + dir;
            } else if (!dir.startsWith("C:")) {
                dir = Shell.getNmRoot() + dir;
            }
        } else if (!dir.startsWith(File.separator)) {
            dir = Shell.getNmRoot() + dir;
        }
        this.server = HServer.launch(this, "HTTP Server", port, prange, homepage, auxlist);
        this.server.setParent(this);
        this.server.addSource(new HFiles(dirName, dir));
        if (lname != null && lname.length() > 0) {
            if (this.getMessageHandler() == null) {
                this.M.warning("HTTPSERV: Found /MNAME= but missing /MSGID=.");
            } else {
                boolean isRoot = lname.equals("/");
                this.server.addSource(new HSListener(lname), isRoot);
            }
        }
        return 0;
    }

    @Override
    public int process() {
        if (this.server.isRunning()) {
            return -1;
        }
        return 9;
    }

    @Override
    public int close() {
        this.server.stopThread();
        return 0;
    }

    @Override
    public Object getNextLink() {
        return this.server;
    }

    @Override
    public Object getPrevLink() {
        return null;
    }

    private class HSListener
    extends HSource {
        public HSListener(String name) {
            super(name);
        }

        @Override
        public void handleRequest(String uri, HPage hp) {
            Table tbl = new Table();
            tbl.put("PARAMETERS", (Object)hp.getParameters());
            tbl.put("SOCKET", (Object)hp);
            httpserv.this.sendMessage("HTTP" + hp.getMethod(), 0, tbl);
            while (!hp.isClosed()) {
                Time.sleep(0.5);
            }
        }
    }
}

