/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.inc.DataTypes;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.TextFile;
import nxm.sys.libm.Tolerance;

public class datalist
extends Primitive
implements DataTypes {
    private BaseFile bf;
    private double start;
    private double size;
    private int flags;
    private int ncols;
    private PacketHandler pkh;
    private boolean absc;
    private boolean showLN;
    private String form;
    private static final int DEF_SIZE = 32;

    @Override
    public int open() {
        DataFile df;
        this.bf = this.MA.getFile("FILE");
        if (!this.bf.open()) {
            return 9;
        }
        if (this.MA.getState("/HS")) {
            this.M.println(this.bf.toString());
        }
        if (this.MA.getState("/H")) {
            this.M.print(this.bf.listHeader());
        }
        if (this.MA.getState("/K")) {
            this.M.print(this.bf.listKeywords());
        }
        this.absc = this.MA.getState("ABSC");
        String startStr = this.MA.getS("START");
        if (startStr.startsWith("~")) {
            this.absc = true;
            startStr = startStr.substring(1);
        }
        this.start = Convert.s2d(startStr, this.M);
        if (!this.absc && this.start % 1.0 != 0.0) {
            this.M.warning("Fractional start position '" + this.start + "' not allowed for index mode. Using start of " + Math.round(this.start));
            this.start = Math.round(this.start);
        }
        int defSize = 32;
        if (this.start < 0.0) {
            if (this.bf.isStreaming()) {
                this.M.error("Use of START=" + this.start + " Not supported for pipes.");
            }
            defSize = (int)Math.ceil(-this.start);
            if (this.bf instanceof TextFile) {
                this.start = ((TextFile)this.bf).getNumberOfRows() + this.start;
                ((TextFile)this.bf).seek(0.0);
            } else {
                this.start = this.bf.getSize() + this.start;
            }
        }
        double d = this.size = this.MA.isPresent("NELEM") ? (double)this.MA.getL("NELEM") : (double)defSize;
        if (this.absc && this.bf instanceof DataFile) {
            double remainder = this.start % 1.0;
            df = (DataFile)this.bf;
            double delta = df.getDelta();
            if (remainder % delta > Tolerance.getTolerance()) {
                this.start -= remainder % delta;
            }
            this.start = df.getIndex(this.start, 5, this.MA.getAddressing());
        }
        this.form = this.MA.getS("FORM");
        if (this.form.equals("")) {
            this.form = null;
        }
        this.showLN = this.MA.getState("/L", true);
        if (this.bf instanceof DataFile) {
            df = (DataFile)this.bf;
            if (this.form != null) {
                df.setFormat(this.form);
            }
            this.pkh = df.getPacketHandler();
            this.form = null;
            this.bf.seek(this.start);
            this.size = this.size < 0.0 ? (double)((int)this.bf.avail()) : Math.min(this.size, (double)((int)this.bf.avail()));
        } else if (this.size < 0.0) {
            this.size = 10000.0;
        }
        if (this.MA.getState("/HEX")) {
            this.flags |= 1;
        } else if (this.MA.getState("/BIN")) {
            this.flags |= 2;
        }
        int tw = this.MA.getL("/SW", this.M.terminal.getColumns());
        if (this.MA.isPresent("/NW")) {
            this.M.deprecate("Use /SW switch to indicate screen width");
            tw = this.MA.getL("/NW", tw);
        }
        this.ncols = this.bf.listElementsPerLine(tw - (this.showLN ? 6 : 1), this.form, this.flags);
        this.ncols = this.MA.getL("/NC", this.ncols);
        this.ncols = Math.max(1, this.ncols);
        return 0;
    }

    @Override
    public int process() {
        int nelem = (int)Math.min((double)this.ncols, this.size);
        nelem = (int)Math.min((double)nelem, this.bf.getSize() - this.start);
        String line = null;
        if (nelem > 0) {
            line = this.bf.listElements(this.start, nelem, this.form, this.flags);
        }
        if (line == null) {
            return 9;
        }
        if (this.pkh != null && this.pkh.hasHeader() && this.MA.getState("/P")) {
            this.M.println(this.pkh.listHeader());
        }
        this.M.print(this.padi(this.start) + line);
        this.start += (double)nelem;
        this.size -= (double)nelem;
        if (this.size <= 0.0) {
            return 9;
        }
        return 0;
    }

    @Override
    public int close() {
        this.bf.close();
        return 0;
    }

    private String padi(double start) {
        if (!this.showLN) {
            return " ";
        }
        String pad = "";
        int off = (int)start;
        if (off < 10) {
            pad = "  ";
        } else if (off < 100) {
            pad = " ";
        }
        return pad + off + ": ";
    }
}

