/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.awt.Color;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.libg.MColor;

public class convertargb
extends Primitive {
    private DataFile hin;
    private DataFile hout;
    private Data data;
    private int alpha;
    private String colormapType;
    private int numColors;
    private Color[] colormap;
    private float scale0;
    private float scale1;
    private int frameSize;

    @Override
    public int open() {
        this.hin = this.MA.getDataFile("IN");
        this.hin.open();
        this.frameSize = this.hin.getFrameSize();
        this.hout = this.MA.getDataFile("OUT", this.hin, 0);
        this.hout.setFormat("SL");
        this.hout.open();
        this.alpha = this.MA.getL("ALPHA", 127);
        this.colormapType = this.MA.getS("COLORMAP", "RAMP");
        this.numColors = this.MA.getL("NUMCOLORS", -1);
        this.colormap = MColor.getColorMap(this.colormapType, this.numColors, this.alpha);
        if (this.colormap.length - 1 != this.numColors) {
            this.numColors = this.colormap.length - 1;
        }
        float min = this.MA.getF("MIN", 0.0f);
        float max = this.MA.getF("MAX", 1.0f);
        this.scale0 = min;
        this.scale1 = (float)this.numColors / (max - min);
        this.xfer = Math.max(1, (int)Math.min(this.hin.getSize(), (double)this.bufSize / this.hin.dbpe));
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.data = this.hin.getDataBuffer(this.xfer);
        if (this.verbose) {
            this.M.info(this.toString());
        }
        return 0;
    }

    @Override
    public int process() {
        int n = this.hin.read(this.data);
        if (n <= 0) {
            if (n == 0) {
                return -1;
            }
            return 9;
        }
        float[] fbuf = this.data.castF(true);
        int[] buf = convertargb.fa2color(null, fbuf, this.frameSize * n, this.scale0, this.scale1, this.colormap);
        Data dataout = new Data(buf);
        this.hout.write(dataout, n);
        this.data.uncast(fbuf, false);
        return 0;
    }

    @Deprecated
    public static int[] fa2color(int[] buf, float[] fbuf, float min, float scale, Color[] colormap) {
        return convertargb.fa2color(buf, fbuf, fbuf.length, min, scale, colormap);
    }

    public static int[] fa2color(int[] buf, float[] fbuf, int size, float min, float scale, Color[] colormap) {
        int numColors = colormap.length - 1;
        if (buf == null || buf.length < fbuf.length) {
            buf = new int[fbuf.length];
        }
        int len = fbuf.length;
        for (int i = 0; i < len && i < size; ++i) {
            int colorIndex = (int)((fbuf[i] - min) * scale);
            if (colorIndex < 0) {
                colorIndex = 0;
            } else if (++colorIndex > numColors) {
                colorIndex = numColors;
            }
            buf[i] = colormap[colorIndex].getRGB();
        }
        return buf;
    }

    @Override
    public int close() {
        this.hin.close();
        this.hout.close();
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" - scale0=").append(this.scale0);
        sb.append(" scale1=").append(this.scale1);
        sb.append(" xfer=").append(this.xfer);
        sb.append(" numColors=").append(this.numColors);
        sb.append(" colormap.length=").append(this.colormap.length);
        sb.append(" colormap=").append(this.colormap);
        return sb.toString();
    }
}

