/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import nxm.sys.inc.IDable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.LimitedFutureSupport;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.RmifInterface;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.MidasThread;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Registry;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;

public class Rmif
implements RmifInterface {
    static final int HEADER_LEN = 8;
    static final int MAX_ADJUNCT_LEN = 127;
    static int MAXPKTBUF = 32768;
    static int MAXMEMBER = 64;
    static int MAXLAT = 2;
    public static final int MULTI = 1;
    static final int RDP_PACKET_QUEUE_SIZE = 128;
    static final int MAX_RDP_SEQ_NUM = 127;
    public static final int MAX_WINDOW = 80;
    static final int MAX_OVERLAP = 10;
    static final int DEFAULT_MAX_RETRY = 5;
    @InternalUseOnly
    public static final int DEFAULT_MAX_WINDOW = 12;
    static final int DEFAULT_MAX_QUEUE = 1024;
    static boolean defaultUsesLegacyRemoteNames = true;
    static boolean origmRemoteReuseEnabled = true;
    static boolean origmAllOriginalMessages = true;
    static boolean origmExtraLoggingEnabled = false;
    static boolean statemAllOriginalMessages = false;
    static boolean statemExtraLoggingEnabled = true;
    static boolean oldRemoteStorage = false;
    static boolean revertSafetyFixes = false;
    boolean stateBasedMsgProcessing = false;
    boolean allOriginalMessages;
    boolean reuseRemotes;
    boolean supplimentalLogging;
    boolean useLegacyRemoteNames;
    int nchannel = 0;
    int nproperty = 0;
    DatagramSocket dsock;
    DatagramPacket dpacki;
    DatagramPacket dpacko;
    TextFile logfile;
    PacketReader packetReader;
    byte[] lutm = new byte[]{0, 1, 2, 3, 4, 5, 6, 8, 10, 12, 15, 18, 21, 24, 28, 32};
    byte[] buffi;
    byte[] buffo;
    byte[] lutl;
    byte[] lutu;
    byte[] uncbuf = new byte[MAXPKTBUF + 16];
    byte[] cbuf = new byte[MAXPKTBUF + 16];
    boolean caseSensitive = false;
    double timePing = 5.0;
    double timeOut = 16.0;
    double timeCloseOut = 1.0;
    double defaultTimeLost = 5.0;
    double defaultTimeRetry = 0.2;
    int socksenderr = 0;
    double linkTime = 0.0;
    int sockrecverr = 0;
    double linkBytes = 0.0;
    boolean verbose = false;
    boolean debug = false;
    boolean reOpen = true;
    boolean requireOpen = false;
    int packetOverhead = 100;
    double maxLinkRate = 2000000.0;
    int testLinkPkt = 0;
    byte[] testLinkBuf = new byte[128];
    Thread recvThread;
    Remote wdef;
    Remote rlast = null;
    int maxRetry = 5;
    int maxWindow = 12;
    int maxQueue = 1024;
    int remoteIndex = 0;
    Midas M;
    Object ref;
    String id = "";
    MessageHandler owner;
    MessageHandler handler;
    String remoteFastID = "";
    private KeyVector remotes = new KeyVector(16);
    final Map<String, Remote> _fastRemotes = Collections.synchronizedMap(new HashMap(16));
    KeyVector properties = new KeyVector(16);
    KeyVector channels = new KeyVector(16);
    int maxErrorsToNotServeProperty = 10;

    @InternalUseOnly
    Rmif() {
    }

    public Rmif(MessageHandler handler) {
        this(null, null, handler);
    }

    public Rmif(Midas M, MessageHandler owner, MessageHandler handler) {
        this(M, owner, handler, false);
    }

    public Rmif(Midas M, MessageHandler owner, MessageHandler handler, boolean stateBasedMsgHandling) {
        this.ref = owner;
        this.M = M != null ? M : new Midas();
        this.owner = owner;
        this.setMessageHandler(handler);
        if (owner instanceof IDable) {
            this.id = ((IDable)((Object)owner)).getID();
        }
        if (this.debug) {
            this.info("Using State Based Message Handling:" + stateBasedMsgHandling);
        }
        this.stateBasedMsgProcessing = stateBasedMsgHandling;
        this.setModeBasedOptions();
    }

    private void setModeBasedOptions() {
        if (!this.stateBasedMsgProcessing) {
            this.reuseRemotes = origmRemoteReuseEnabled;
            this.allOriginalMessages = origmAllOriginalMessages;
            this.supplimentalLogging = origmExtraLoggingEnabled;
            this.useLegacyRemoteNames = defaultUsesLegacyRemoteNames;
        } else {
            this.allOriginalMessages = statemAllOriginalMessages;
            this.supplimentalLogging = statemExtraLoggingEnabled;
        }
    }

    public void open(String host, int port, int prange) {
        String h;
        String string = h = host.trim().equals("") ? "0.0.0.0" : host;
        while (this.dsock == null) {
            try {
                if (port < 0) {
                    port = 0;
                }
                this.dsock = new DatagramSocket(new InetSocketAddress(h, port));
                this.dsock.setSoTimeout(50);
                this.dsock.setSendBufferSize(0x100000);
                this.dsock.setReceiveBufferSize(0x100000);
                this.info("RMIF Connected/bound to Datagram socket port: " + this.getPort());
            }
            catch (Exception e) {
                if (this.allOriginalMessages) {
                    this.info("Port " + port + " not available");
                }
                if (--prange <= 0) {
                    throw new MidasException("No ports available " + port, e);
                }
                ++port;
            }
        }
        this.buffi = new byte[135 + MAXPKTBUF];
        this.dpacki = new DatagramPacket(this.buffi, this.buffi.length);
        this.buffo = new byte[135 + MAXPKTBUF];
        this.dpacko = new DatagramPacket(this.buffo, this.buffo.length);
        this.wdef = new Remote();
        this.wdef.id = "UNKNOWN";
        this.wdef.rmif = this;
        this.wdef.mh = this.owner;
        this.wdef.state = (byte)113;
        if (this.wdef.mh == null) {
            this.warning("open() MessageHandler is null for wdef " + this.wdef);
        }
        this.packetReader = new PacketReader(this);
        this.recvThread = new MidasThread(this.M, (Runnable)this.packetReader, "RmifPacketReader_" + this.id);
        this.recvThread.start();
    }

    public void open(int port, int prange) {
        this.open("", port, prange);
    }

    public void close() {
        double time = Time.current();
        for (String key : this._fastRemotes.keySet()) {
            this.closeRemote(this._fastRemotes.get(key));
        }
        if (this.nchannel > 0) {
            while (Time.current() - time < this.timeCloseOut) {
                boolean ok = true;
                for (int ic = 1; ic <= this.nchannel; ++ic) {
                    if (this.getChannel(ic) == null || this.getChannel((int)ic).state == 116) continue;
                    ok = false;
                }
                if (ok) break;
                Time.sleep(0.1);
            }
        }
        if (this.packetReader != null) {
            this.packetReader.stop();
        }
        if (this.dsock != null) {
            this.dsock.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hardKillForTestingOnly() {
        this.warning("Rmif.hardKillForTestingOnly(): Stopping packet reader " + this.packetReader + ", closing DatagramSocket " + this.dsock);
        if (this.packetReader != null) {
            this.packetReader.stop();
        }
        if (this.dsock != null) {
            this.dsock.close();
        }
        Map<String, Remote> map = this._fastRemotes;
        synchronized (map) {
            for (Remote r : this._fastRemotes.values()) {
                if (r == null || r.id == null || this.M == null) continue;
                this.info("  Removing from registry " + r);
                this.M.registry.remove(r.id);
            }
        }
        this._fastRemotes.clear();
        this.properties.clear();
        this.channels.clear();
    }

    public void setLogFile(TextFile logfile) {
        this.logfile = logfile;
    }

    public TextFile getLogFile() {
        return this.logfile;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setReOpen(boolean reOpen) {
        this.reOpen = reOpen;
    }

    public boolean getReOpen() {
        return this.reOpen;
    }

    public void setRequireOpen(boolean val) {
        this.requireOpen = val;
    }

    public boolean getRequireOpen() {
        return this.requireOpen;
    }

    public void setTimeOut(double time) {
        this.timeOut = time;
    }

    public double getTimeOut() {
        return this.timeOut;
    }

    public void setTimeLost(double time) {
        this.defaultTimeLost = time;
    }

    public double getTimeLost() {
        return this.defaultTimeLost;
    }

    public void setTimeRetry(double time) {
        this.defaultTimeRetry = time;
    }

    public double getTimeRetry() {
        return this.defaultTimeRetry;
    }

    @Deprecated
    public void setTimeOutR(double time) {
        this.deprecate("Rmif: Since NeXtMidas 2.5.0 setTimeOutR(..) is is not used");
    }

    public void setTimeCloseOut(double time) {
        this.timeCloseOut = time;
    }

    public double getTimeCloseOut() {
        return this.timeCloseOut;
    }

    @Deprecated
    public void setTimeDrop(double time) {
    }

    public void setTimePing(double time) {
        this.timePing = time;
    }

    public double getTimePing() {
        return this.timePing;
    }

    public void setRetry(int value) {
        this.maxRetry = value;
    }

    public int getRetry() {
        return this.maxRetry;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean cs) {
        this.caseSensitive = cs;
        if (this.caseSensitive) {
            this.warning("Rmif: Setting table keys to be case sensitive.");
        } else {
            this.info("Rmif: Table keys are not case sensitive.");
        }
    }

    public void setWindow(int value) {
        if (value < 1 || value > 80) {
            throw new MidasException("Rmif: Can not set window for " + this + " to " + value + ". Window size must be in the range 1.." + 80 + ".");
        }
        this.maxWindow = value;
    }

    public int getWindow() {
        return this.maxWindow;
    }

    public void setMaxQueue(int value) {
        if (value < 0) {
            throw new MidasException("Rmif: Can not set maxQueue for " + this + " to " + value + ". Max queue size must be in the range 0..N.");
        }
        this.maxQueue = value;
    }

    public int getMaxQueue() {
        return this.maxQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyVector getRemotes() {
        KeyVector v = new KeyVector();
        Map<String, Remote> map = this._fastRemotes;
        synchronized (map) {
            for (String key : this._fastRemotes.keySet()) {
                v.put(key, this._fastRemotes.get(key));
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote getRemote(String remoteID) {
        Map<String, Remote> map = this._fastRemotes;
        synchronized (map) {
            for (Remote r : this._fastRemotes.values()) {
                if (!r.getID().equals(remoteID)) continue;
                return r;
            }
        }
        return null;
    }

    public Remote getRemote(int i) {
        KeyVector kvRemotes = this.getRemotes();
        return (Remote)kvRemotes.get(i - 1);
    }

    public KeyVector getProperties() {
        return this.properties;
    }

    public Property getProperty(int i) {
        return (Property)this.properties.get(i - 1);
    }

    public Property getProperty(String name) {
        int ip = this.indexProperty(name, -1);
        return this.getProperty(ip);
    }

    public KeyVector getChannels() {
        return this.channels;
    }

    public Channel getChannel(int i) {
        return (Channel)this.channels.get(i - 1);
    }

    public int getPort() {
        return this.dsock == null ? -1 : this.dsock.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int resetRecvQueue(Remote r, int newSeq) {
        if (this.verbose) {
            this.debug("resetRecvQueue for " + r + " newSeq=" + newSeq + " recvChk=" + r.recvChk + " recvQueue=" + r.recvQueue);
        }
        Remote remote = r;
        synchronized (remote) {
            if (this.allOriginalMessages && r.recvQueue > 0) {
                this.warning("resetRecvQueue for " + r + " still have packets in queue: " + r.recvQueue);
            }
            for (int seq = 0; seq != r.recvBuf.length; ++seq) {
                if (newSeq != -1 && seq == newSeq) continue;
                Packet pkt = r.recvBuf[seq];
                pkt.clear(0.0);
            }
            if (newSeq == -1) {
                r.recvReOrder = 0;
                r.recvQueue = 0;
                r.recvChk = 0;
                newSeq = 0;
            } else {
                r.recvChk = newSeq;
            }
        }
        return newSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetSendQueue(Remote r) {
        int sizeSendQueue = r.sendQueue.size();
        if (this.verbose) {
            this.debug("resetSendQueue for " + r + " sendSeq=" + r.sendSeq + " sendChk=" + r.sendChk + " sizeSendQueue=" + sizeSendQueue);
        }
        Remote remote = r;
        synchronized (remote) {
            for (int seq = 0; seq != r.sendBuf.length; ++seq) {
                Packet pkt = r.sendBuf[seq];
                pkt.clear(0.0);
            }
            r.sendSeq = 0;
            r.sendChk = 0;
            r.sendDrop = 0;
            if (this.allOriginalMessages && sizeSendQueue > 0) {
                this.warning("resetSendQueue for " + r + " clearing " + sizeSendQueue + " packets in send queue");
            }
            r.sendQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recvPacket() {
        try {
            Remote r;
            String remoteID;
            this.dpacki.setLength(this.buffi.length);
            this.dsock.receive(this.dpacki);
            int len = this.dpacki.getLength();
            int seq = this.buffi[4];
            byte func = this.buffi[0];
            byte retry = this.buffi[5];
            byte info = this.buffi[2];
            int doff = 8;
            int dlen = len - doff;
            int port = this.dpacki.getPort();
            InetAddress addr = this.dpacki.getAddress();
            if (!this.useLegacyRemoteNames) {
                remoteID = this.createFastLookupKey(addr, port);
                r = this._fastRemotes.get(remoteID);
            } else {
                r = this.indexRemote(port, addr);
                remoteID = "REMOTE";
            }
            boolean sendQuietClose = false;
            String host = addr.getHostAddress();
            if (r == null) {
                r = this.createClientRemote(remoteID, host, port);
            }
            if (func == 109 && info == 115 && (r.state == 116 || r.state == 113)) {
                sendQuietClose = true;
            }
            if (this.requireOpen && !sendQuietClose && r.state != 105 && r.state != 115 && func != 109 && func != 105 && func != 106 && func != 116 && func != 123) {
                if (seq < 0) {
                    if (this.verbose || this.debug) {
                        this.debug("Ignoring unsolicited UDP Packet seq=" + seq + " retry=" + retry + " func=" + func + "(" + Rmif.functionName(func) + ") info=" + info + "(" + Rmif.functionName(info) + ") from " + r);
                    }
                    return false;
                }
                sendQuietClose = true;
            }
            if (sendQuietClose) {
                this.buffi[0] = 106;
                this.buffi[4] = -1;
                this.buffi[2] = -106;
                this.dpacki.setLength(8);
                this.dsock.send(this.dpacki);
                if (this.verbose) {
                    this.debug("Sent Quiet CLOSE to unsolicited remote for Packet seq=" + seq + " retry=" + retry + " func=" + func + "(" + Rmif.functionName(func) + ") info=" + info + "(" + Rmif.functionName(info) + ") from " + r);
                }
                return false;
            }
            if (this.debug) {
                this.debug("recvPacket -> " + new Packet(this.buffi, 0, len, false) + " from " + r);
            }
            this.linkBytes += (double)(len + this.packetOverhead);
            Remote remote = r;
            synchronized (remote) {
                r.linkBytes += (double)(len + this.packetOverhead);
                double currentTime = Time.current();
                if (func == 123) {
                    Packet pkt;
                    Packet packet = pkt = r.sendBuf[seq];
                    synchronized (packet) {
                        double sendTime = pkt.time;
                        double latency = currentTime - sendTime;
                        if (!(sendTime <= 0.0) && !(latency > (double)MAXLAT) && retry <= 0) {
                            r.latency = r.latency == 0.0 ? latency : r.latency * 0.9 + latency * 0.1;
                        }
                        pkt.clear(0.0);
                    }
                    return false;
                }
                if (func == 124) {
                    if (info >= 0 && this.testLinkPkt < 128) {
                        this.testLinkBuf[this.testLinkPkt++] = info;
                    } else if (info == -1) {
                        this.testLinkPkt = 0;
                    } else if (info == -2) {
                        this.sendPacket((byte)124, -3, this.testLinkBuf, r, 1);
                    } else if (info == -3) {
                        this.testLinkReport(r, dlen, this.buffi, doff);
                    } else if (info == -4) {
                        this.testLinkReport(r, this.testLinkPkt, this.testLinkBuf, 0);
                    } else if (info <= -5) {
                        this.testLink(r, -this.buffi[8]);
                    }
                    return false;
                }
                Packet pkt = null;
                if (seq >= 0) {
                    if (this.verbose || this.logfile != null) {
                        int slen = func >= 111 && func <= 118 ? 0 : dlen;
                        String text = "RECV func=" + Rmif.functionName(func) + " seq=" + seq + " try=" + retry + " info=" + this.buffi[2] + " data=" + Convert.unpackS(this.buffi, doff, slen) + " from " + r + " at " + Time.tag();
                        if (this.verbose) {
                            this.info(text);
                        } else {
                            this.logfile.writeln(text);
                        }
                    }
                    pkt = r.recvBuf[seq];
                    int nextExpectedSeq = r.recvChk + 1 & 0x7F;
                    int maxNextSeq = nextExpectedSeq + 80 & 0x7F;
                    boolean outOfRange = nextExpectedSeq < maxNextSeq ? seq < nextExpectedSeq || maxNextSeq < seq : maxNextSeq < seq && seq < nextExpectedSeq;
                    int estimatedPacketsLost = seq - maxNextSeq;
                    if (seq < maxNextSeq) {
                        estimatedPacketsLost += 128;
                    }
                    if (pkt.time > 0.0 && retry == 0) {
                        int overlapCount = seq - nextExpectedSeq;
                        if (seq < nextExpectedSeq) {
                            overlapCount += 128;
                        }
                        if (overlapCount > 10) {
                            if (this.logfile != null) {
                                this.logfile.writeln("WARN: IGNORING new overlapping packet, old=" + pkt.toStringShort());
                            }
                            if (this.supplimentalLogging) {
                                this.warning("IGNORING new overlapping packet seq=" + seq + " retry=" + retry + " func=" + func + "(" + Rmif.functionName(func) + ") info=" + info + "(" + Rmif.functionName(info) + ") from " + r.toString());
                            }
                            return false;
                        }
                    }
                    this.sendReceipt(func, len);
                    if (this.supplimentalLogging && (this.verbose || this.logfile != null) && seq >= 0) {
                        int slen = func >= 111 && func <= 118 ? 0 : dlen;
                        String text = "RECEIPT func=" + Rmif.functionName(func) + " seq=" + seq + " try=" + retry + " info=" + this.buffi[2] + " data=" + Convert.unpackS(this.buffi, doff, slen) + " from " + r + " at " + Time.tag();
                        if (this.verbose) {
                            this.info(text);
                        } else {
                            this.logfile.writeln(text);
                        }
                    }
                    if (seq != nextExpectedSeq && retry > 0) {
                        if (pkt.time > 0.0) {
                            return false;
                        }
                        if (pkt.time < 0.0) {
                            if (outOfRange && estimatedPacketsLost > 10) {
                                return false;
                            }
                            double timeDiff = currentTime + pkt.time;
                            double rtd = r.latency == 0.0 ? r.timeRetry : r.timeRetry + r.latency;
                            double timePeriod = (double)retry * rtd;
                            if (timeDiff < timePeriod) {
                                return false;
                            }
                        }
                    }
                    if (seq != nextExpectedSeq && r.isOpened()) {
                        if (outOfRange) {
                            this.checkRecvQueue(r, estimatedPacketsLost);
                            nextExpectedSeq = r.recvChk + 1 & 0x7F;
                        }
                        for (int k = 0; k < 10 && pkt.time > 0.0 && r.recvQueue > 0; ++k) {
                            estimatedPacketsLost = seq - nextExpectedSeq;
                            if (seq < nextExpectedSeq) {
                                estimatedPacketsLost += 128;
                            }
                            this.checkRecvQueue(r, estimatedPacketsLost);
                            nextExpectedSeq = r.recvChk + 1 & 0x7F;
                        }
                        if (pkt.time > 0.0 && this.logfile != null) {
                            this.logfile.writeln("WARN: OVERWRITTING EXISTING PACKET at seq=" + seq + " old=" + pkt.toStringShort());
                        }
                        if (seq != nextExpectedSeq) {
                            pkt.initialize(this.buffi, 0, len, currentTime, true);
                            ++r.recvQueue;
                            if (r.recvQueue > 80) {
                                String warnMsg = "WARN: RDP receive queue is FULL! recvQueue=" + r.recvQueue;
                                if (this.logfile == null) {
                                    this.warning(warnMsg);
                                } else {
                                    this.logfile.writeln(warnMsg);
                                }
                            }
                            return false;
                        }
                    }
                    r.recvChk = seq;
                }
                this.procPacket(this.buffi, dlen, r);
                if (pkt != null) {
                    pkt.clear(-currentTime);
                }
                if (r.recvQueue > 0) {
                    this.checkRecvQueue(r, -1);
                }
            }
            if (this.sockrecverr > 0) {
                this.info("Total Packet recv errs: " + this.sockrecverr);
                this.sockrecverr = 0;
            }
            return true;
        }
        catch (InterruptedIOException len) {
        }
        catch (Exception e) {
            if (this.packetReader.isAborted()) {
                return false;
            }
            if ("Interrupted system call".equals(e.getMessage())) {
                return false;
            }
            if (this.sockrecverr == 0) {
                this.printStackTrace("Exception in recvPacket", e);
                this.sendLinkProblemReport(null, "Exception in recvPacket: " + e.getMessage(), null);
            }
            ++this.sockrecverr;
        }
        return false;
    }

    void sendReceipt(byte func, int len) throws IOException {
        this.buffi[0] = 123;
        this.dpacki.setLength(8);
        this.dsock.send(this.dpacki);
        this.buffi[0] = func;
        this.dpacki.setLength(len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkRecvQueue(Remote r, int numLost) {
        int ochk = 0;
        Remote remote = r;
        synchronized (remote) {
            int seq = r.recvChk;
            int oseq = numLost > 0 ? seq + 1 & 0x7F : -1;
            double currentTime = Time.current();
            for (int i = 0; i <= 80 && r.recvQueue > 0; ++i) {
                ++seq;
                Packet pkt = r.recvBuf[seq &= 0x7F];
                if (pkt.time <= 0.0) {
                    if (oseq < 0) {
                        oseq = seq;
                    }
                    if (++ochk <= 127) continue;
                    this.sendLinkProblemReport(r, "PKTRQCHK " + r.recvQueue + " seq=" + seq, null);
                    r.recvQueue = 0;
                    return;
                }
                if (oseq >= 0 && oseq != seq) {
                    if (numLost <= 0 && currentTime - pkt.time < r.timeLost) break;
                    for (int lostSeq = oseq; lostSeq != seq && numLost > 0; lostSeq &= 0x7F, --numLost) {
                        Packet lostpkt = r.recvBuf[lostSeq];
                        lostpkt.clear(-currentTime);
                        ++lostSeq;
                    }
                    this.sendLinkProblemReport(r, "PKTLOST Seq " + oseq + " to " + seq, null);
                    oseq = -1;
                    numLost = 0;
                } else {
                    oseq = -1;
                    numLost = 0;
                }
                this.procPacket(pkt.getBufZeroOffset(), pkt.len - 8, r);
                pkt.clear(-currentTime);
                r.recvChk = seq;
                ++r.recvReOrder;
                --r.recvQueue;
            }
            if (oseq >= 0 && numLost > 0 && r.recvQueue > 0) {
                if (r.recvQueue < numLost) {
                    numLost = r.recvQueue;
                }
                int lostSeq = oseq;
                for (int j = 0; j < numLost; ++j) {
                    Packet lostpkt = r.recvBuf[lostSeq];
                    lostpkt.clear(-currentTime);
                    r.recvChk = lostSeq++;
                    --r.recvQueue;
                    lostSeq &= 0x7F;
                }
                this.sendLinkProblemReport(r, "PKTLOST Seq " + oseq + " to " + lostSeq + " reported", null);
            }
            if (r.recvQueue < 0) {
                r.recvQueue = 0;
            }
        }
    }

    public void testLink(Remote r, int mode) {
        if (mode == 0) {
            this.testLink(r, 8);
            this.testLink(r, -8);
            this.testLink(r, 1024);
            this.testLink(r, -1024);
        } else if (mode < 0) {
            this.testLinkPkt = 0;
            byte[] buf = new byte[]{(byte)mode};
            int pktsize = 1;
            while (mode < 0) {
                pktsize *= 2;
                ++mode;
            }
            this.info("Testing Link from " + r.id + "  PktSize=" + pktsize);
            this.sendPacket((byte)124, -5, buf, r, 1);
        } else if (mode > 0) {
            int pktsize = 1;
            while (mode > 0) {
                pktsize *= 2;
                --mode;
            }
            byte[] buf = new byte[pktsize];
            this.info("Testing Link to " + r.id + "  PktSize=" + pktsize);
            this.sendPacket((byte)124, -1, r, 1);
            Time.sleep(0.5);
            for (int i = 0; i < 128; ++i) {
                this.sendPacket((byte)124, i, buf, r, 1);
            }
            Time.sleep(1.0);
            this.sendPacket((byte)124, -4, r, 1);
        }
    }

    void testLinkReport(Remote r, int len, byte[] buf, int off) {
        if (off == 0) {
            this.info("Link Test Results from node: " + r.id);
        } else {
            this.info("Link Test Results to node: " + r.id);
        }
        int i = 0;
        while (i < len) {
            String text = "  ";
            for (int j = 0; j < 10 && i < len; ++j, ++i) {
                text = text + buf[i + off] + " ";
            }
            this.info(text);
        }
        int ooo = 0;
        for (int i2 = 1; i2 < len; ++i2) {
            if (buf[i2 + off] == buf[i2 + off - 1] + 1) continue;
            ++ooo;
        }
        this.info("Total " + len + "/" + 128 + " packets.  OutOfOrder=" + ooo);
    }

    public Remote getRemoteForAddress(RemoteAddress ra) {
        Remote r = this.indexRemote(ra.port, ra.addr);
        if (r == null) {
            r = this.wdef;
            r.addr = ra.addr;
            r.port = ra.port;
        }
        return r;
    }

    public synchronized void sendPacket(byte func, int info, byte[] buffer, int boff, int bytes, Remote r, int flags, double adjval) {
        this.sendPacket(func, info, buffer, boff, bytes, r, flags, adjval, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    synchronized void sendPacket(byte func, int info, byte[] buffer, int boff, int bytes, Remote r, int flags, double adjval, boolean copy) {
        if (bytes > MAXPKTBUF) {
            throw new MidasException("Rmif: Can not send data packet (len=" + bytes + ") > " + MAXPKTBUF + " bytes.");
        }
        if (this.remoteClosedShouldNotSendPacket(r, func)) {
            return;
        }
        byte[] buf = this.dpacko.getData();
        buf[0] = func;
        buf[1] = 0;
        buf[2] = (byte)info;
        buf[3] = 69;
        buf[4] = -1;
        buf[5] = 0;
        buf[6] = 0;
        buf[7] = 0;
        if ((flags & 0x10) != 0) {
            buf[1] = 16;
            Convert.packD(buf, 8, adjval);
            buf[7] = 8;
        }
        if ((flags & 0x20) != 0) {
            buf[1] = 32;
            Convert.packD(buf, 8, adjval);
            buf[7] = 8;
        }
        int doff = 8 + buf[7];
        if (bytes > 0) {
            System.arraycopy(buffer, boff, buf, doff, bytes);
        }
        int len = doff + bytes;
        if (this.debug) {
            String isRDP = (flags & 0xF) == 0 ? "RDP" : "   ";
            this.debug("sendPacket " + isRDP + " -> " + new Packet(buf, 0, len, false) + "  to  " + r);
        }
        if ((flags & 0xF) != 0) {
            r.linkBytes += (double)this.sendPacketRaw(buf, 0, len, r.addr, r.port);
            return;
        }
        if (!this.sendDelayedRdpPackets(r)) {
            r.linkBytes += (double)this.sendPacketRdp(buf, len, r, copy);
            return;
        }
        if (r.sendQueue.size() < this.maxQueue) {
            r.sendQueue.addLast(new Packet(buf, 0, len));
            return;
        }
        String msg = "Rmif: Can not send RDP packet at this time. RDP send queue is full (maxQueue=" + this.maxQueue + ").";
        if (!this.supplimentalLogging) throw new MidasException(msg);
        msg = msg + " For: " + r;
        throw new MidasException(msg);
    }

    boolean remoteClosedShouldNotSendPacket(Remote r, byte func) {
        boolean badState;
        boolean bl = badState = r.state == 116 && func != 105 && func != 109 && func != 110;
        if (badState && this.allOriginalMessages) {
            this.warning("Remote is CLOSED not sending packet func=" + Rmif.functionName(func) + " to " + r);
        }
        return badState;
    }

    int sendPacketRdp(byte[] buf, int len, Remote r, boolean copy) {
        int seq = r.sendSeq++ & 0x7F;
        buf[4] = (byte)seq;
        Packet pkt = r.sendBuf[seq];
        if (pkt.time != 0.0) {
            String msg = "sendPacketRdp: RDP send buffer/book keeping may be corrupt!";
            if (this.supplimentalLogging) {
                msg = msg + " For: " + r;
            }
            this.warning(msg);
        }
        pkt.initialize(buf, 0, len, Time.current(), copy);
        return this.sendPacketRaw(buf, 0, len, r.addr, r.port);
    }

    synchronized boolean sendDelayedRdpPackets(Remote r) {
        while (!r.sendQueue.isEmpty() && !r.isWindowFull()) {
            Packet pack = r.sendQueue.removeFirst();
            this.sendPacketRdp(pack.buffer, pack.buffer.length, r, false);
        }
        return r.isWindowFull();
    }

    public void sendPacket(byte func, int info, byte[] bytes, Remote r, int flags) {
        if (bytes == null) {
            this.sendPacket(func, info, null, 0, 0, r, flags, 0.0);
        } else {
            this.sendPacket(func, info, bytes, 0, bytes.length, r, flags, 0.0);
        }
    }

    public void sendPacket(byte func, int info, Remote r, int flags) {
        this.sendPacket(func, info, null, 0, 0, r, flags, 0.0);
    }

    public synchronized int sendPacketRaw(byte[] buf, int off, int len, InetAddress addr, int port) {
        if (this.dsock != null && this.dsock.isClosed()) {
            return 0;
        }
        if (buf != this.buffo) {
            System.arraycopy(buf, off, this.buffo, 0, len);
        }
        this.dpacko.setLength(len);
        this.dpacko.setPort(port);
        this.dpacko.setAddress(addr);
        try {
            this.dsock.send(this.dpacko);
            if ((this.verbose || this.logfile != null) && this.buffo[4] >= 0) {
                int slen = len - 8;
                if (this.buffo[0] >= 111 && this.buffo[0] <= 118) {
                    slen = 0;
                }
                String text = "SEND func=" + Rmif.functionName(this.buffo[0]) + " seq=" + this.buffo[4] + " try=" + this.buffo[5] + " info=" + this.buffo[2] + " data=" + new String(this.buffo, 8, slen) + " to " + addr + ":" + port + " at " + Time.tag();
                if (this.verbose) {
                    this.info(text);
                } else {
                    this.logfile.writeln(text);
                }
            }
            if (this.socksenderr > 1) {
                this.info("Total Packet send errs: " + this.socksenderr);
            }
            this.socksenderr = 0;
        }
        catch (Exception e) {
            if (this.socksenderr == 0) {
                throw new MidasException("Packet send: " + e + " Addr:" + addr + " " + port, e);
            }
            ++this.socksenderr;
        }
        int totalBytes = len + this.packetOverhead;
        this.linkBytes += (double)totalBytes;
        return totalBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkRemotes() {
        int stat = 0;
        double time = Time.current();
        Map<String, Remote> map = this._fastRemotes;
        synchronized (map) {
            Object[] keys;
            for (Object key : keys = this._fastRemotes.keySet().toArray()) {
                boolean openedRemoteTimedout;
                Remote r = this._fastRemotes.get(key);
                stat += this.checkPacketQueue(r, time);
                if (r.recvQueue > 0) {
                    this.checkRecvQueue(r, -1);
                }
                boolean bl = openedRemoteTimedout = r.isOpened() && time - r.timePong > this.timeOut;
                if (openedRemoteTimedout) {
                    this.unOpenRemote(r, time);
                }
                if (!(time - r.timeLast > this.timePing)) continue;
                if (!openedRemoteTimedout && !r.isClient && (r.isOpened() || r.isOpening())) {
                    this.sendPacket((byte)109, r.state, r, 1);
                }
                r.timeLast = time;
            }
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int checkPacketQueue(Remote r, double time) {
        int stat = 0;
        for (int i = r.sendChk; i < r.sendSeq; ++i) {
            Packet pkt;
            int seq = i & 0x7F;
            Packet packet = pkt = r.sendBuf[seq];
            synchronized (packet) {
                double rtd;
                double t = pkt.time;
                if (t == 0.0) {
                    if (i == r.sendChk) {
                        ++r.sendChk;
                    }
                    continue;
                }
                int retry = pkt.getTry();
                if (time - t < (double)(retry + 1) * (rtd = r.latency == 0.0 ? 1.0 : r.timeRetry + r.latency)) {
                    continue;
                }
                if (t < 0.0 && i - r.sendChk >= r.maxWindow) {
                    continue;
                }
                if (t > 0.0 && ++retry > r.maxRetry) {
                    if (i == r.sendChk) {
                        ++r.sendChk;
                    }
                    ++r.sendDrop;
                    this.sendLinkProblemReport(r, "PKTDROP Retry=" + retry + " Seq=" + seq, pkt.copy());
                    pkt.clear(0.0);
                    continue;
                }
                if (retry > 0) {
                    ++r.retried;
                }
                if (t < 0.0) {
                    pkt.time = Time.current();
                }
                pkt.setTry((byte)retry);
                r.linkBytes += (double)this.sendPacketRaw(pkt.buffer, pkt.off, pkt.len, r.addr, r.port);
                ++stat;
                continue;
            }
        }
        this.sendDelayedRdpPackets(r);
        return stat;
    }

    int handle(String name, int info, Object data, Object from) {
        Message msg = new Message(name, info, data, this.handler, from);
        return this.handler == null ? -1 : this.handler.processMessage(msg);
    }

    void sendLinkProblemReport(Remote r, String text, Packet pack) {
        String rid;
        Table t = new Table();
        String string = rid = r == null ? "<UNKNOWN>" : r.id;
        text = r != null ? (this.supplimentalLogging ? text + " " + r.toString() : text + " (" + Rmif.functionName(r.state) + ")") : "null Remote";
        t.put("TEXT", (Object)text);
        t.put("REMOTE", (Object)rid);
        t.put("PACKET", (Object)pack);
        this.handle("LINKERR", 0, t, this.owner);
    }

    public double getLinkBW() {
        double time = Time.current();
        double rate = this.linkBytes / (time - this.linkTime);
        this.linkTime = time;
        this.linkBytes = 0.0;
        return rate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLinkLatency() {
        int glat = 0;
        Map<String, Remote> map = this._fastRemotes;
        synchronized (map) {
            for (Remote r : this._fastRemotes.values()) {
                int lat = (int)(r.latency * 1000.0);
                if (lat <= glat) continue;
                glat = lat;
            }
        }
        return glat;
    }

    void procPacket(byte[] buf, int len, Remote r) {
        byte info;
        double time = 0.0;
        byte chanNum = info = buf[2];
        byte func = buf[0];
        int seq = buf[4];
        try {
            if ((buf[1] & 0x10) != 0) {
                time = Convert.unpackD(buf, 8);
            }
            int doff = buf[7];
            len -= doff;
            doff += 8;
            double currentTime = Time.current();
            switch (func) {
                case 112: 
                case 117: {
                    Channel chan = this.getChannel(chanNum);
                    if (chan == null || chan.df == null || r == null) {
                        this.warning("Got unSolicited DBUF " + chanNum + " " + r.addr + ":" + r.port);
                        break;
                    }
                    if (seq < 0 && chan.df.io.avail() < (long)len) {
                        this.warning("Pipe full remote " + r + " - dumping unreliable data");
                        break;
                    }
                    if (func == 117) {
                        int uclen;
                        if (time > 0.0) {
                            chan.df.setTimeAt(time);
                        }
                        if ((uclen = this.uncompress(buf, doff, len, this.uncbuf)) <= 0) break;
                        chan.df.write(this.uncbuf, 0, uclen);
                        break;
                    }
                    if (time > 0.0) {
                        chan.df.setTimeAt(time);
                    }
                    chan.df.write(buf, doff, len);
                    break;
                }
                case 111: {
                    Channel chan = this.getChannel(chanNum);
                    if (chan == null) break;
                    DataFile df = chan.df;
                    if (df != null && df.isOpen) {
                        if (!this.reOpen) break;
                        df.flags |= 0x100;
                        df.close();
                    }
                    byte[] db = new byte[512];
                    System.arraycopy(buf, doff, db, 0, 512);
                    df = new DataFile();
                    df.init(this.ref, (Object)chan.name, db, 0);
                    if (!revertSafetyFixes && df.getTypeCodeClass() != 1 && df.getBPE() * 4.0 > (double)df.defPipeSize) {
                        this.info("RMIF: Increase pipe size for: " + chan.name + " to: " + df.getBPE() * 4.0 + " from: " + df.defPipeSize);
                        df.defPipeSize = Math.min(2000000, (int)df.getBPE() * 4);
                    }
                    df.open(2);
                    chan.df = df;
                    break;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    Table tbl = new Table();
                    if (this.caseSensitive) {
                        tbl.setFlags(tbl.getFlagsInt() | 0x40);
                    }
                    tbl.fromBytes(buf, doff, len + doff);
                    String msgname = "BAD";
                    if (tbl.containsKey("MSGNAME")) {
                        msgname = tbl.getString("MSGNAME");
                        tbl.remove("MSGNAME");
                    } else if (func == 101) {
                        msgname = "SET";
                    } else if (func == 103) {
                        msgname = "RET";
                    } else if (func == 102) {
                        msgname = "GET";
                    } else if (func == 104) {
                        msgname = "ACK";
                    }
                    this.handle(msgname, chanNum, tbl, r);
                    break;
                }
                case 107: {
                    break;
                }
                case 108: {
                    break;
                }
                case 125: {
                    Table tbl = new Table();
                    if (this.caseSensitive) {
                        tbl.setFlags(tbl.getFlagsInt() | 0x40);
                    }
                    tbl.fromBytes(buf, doff, len + doff);
                    if (this.verbose) {
                        this.info("Got MFTP from " + r + " " + tbl);
                    }
                    this.processMftpMessage(tbl, r);
                    break;
                }
                case 109: {
                    if (this.verbose) {
                        this.info("Got a PING message from " + r + " info=" + info);
                    }
                    if (r != null && r.isClient) {
                        r.timePong = currentTime;
                    }
                    int protocol = info != 115 ? 1 : 0;
                    this.sendPacket((byte)110, chanNum, r, protocol);
                    break;
                }
                case 110: {
                    if (this.verbose) {
                        this.info("Got PONG from " + r + " info=" + info);
                    }
                    if (r != null && !r.isClient) {
                        r.timePong = currentTime;
                    }
                    if (!r.isOpening()) break;
                    this.openRemote(r);
                    break;
                }
                case 105: {
                    if (this.verbose) {
                        this.info("Got OPEN from " + r + " chan=" + chanNum);
                    }
                    if (chanNum <= 0) {
                        r.rep = buf[3];
                        r.state = (byte)115;
                        r.isClient = true;
                        r.recvChk = seq;
                        r.timePong = currentTime;
                        this.sendPacket((byte)115, 0, r, 0);
                        this.handle("OPEN", chanNum, r, this.owner);
                        break;
                    }
                    if (r.isOpened()) {
                        this.serveChannel(r, chanNum, new String(buf, doff, len));
                        break;
                    }
                    this.warning("Cannot open channel on closed remote");
                    break;
                }
                case 115: {
                    if (r == null) {
                        this.warning("Received unsolicited OPENED packet");
                        break;
                    }
                    if (chanNum == 0) {
                        if (r.isOpened()) {
                            if (!this.verbose) break;
                            this.info("Channel already opened");
                            break;
                        }
                        r.state = (byte)115;
                        r.rep = buf[3];
                        for (int ic = 1; ic <= this.nchannel; ++ic) {
                            Channel chan = this.getChannel(ic);
                            if (chan == null) {
                                if (!this.verbose) continue;
                                this.info("channel is null for " + ic + ",r=" + r);
                                continue;
                            }
                            if ((chan.flags & 1) != 0) {
                                this.openChannel(ic, r);
                                continue;
                            }
                            if (chan.r != r) {
                                this.warning("No channel open for " + ic + ". On different remote " + r);
                                continue;
                            }
                            if (chan.state == 115) {
                                if (!this.verbose) continue;
                                this.info("Channel already open" + r);
                                continue;
                            }
                            if (chan.state != 105) continue;
                            this.openChannel(ic, r);
                        }
                        this.handle("OPENED", chanNum, r, this.owner);
                        break;
                    }
                    if (!this.verbose) break;
                    this.info("Already opened channel n=" + chanNum);
                    break;
                }
                case 106: {
                    if (this.verbose) {
                        this.info("Got CLOSE from " + r + " info/chanNum=" + info);
                    }
                    if (this.handleUnopenedConnectionOrRemoteIsSever(r, chanNum, time)) break;
                    if (chanNum <= 0) {
                        for (int ip = 1; ip <= this.nproperty; ++ip) {
                            this.delMember(r, -1, ip);
                        }
                        if (chanNum != -106) {
                            this.sendPacket((byte)116, 0, r, 0);
                        }
                        r.state = (byte)116;
                        this.resetSendQueue(r);
                        this.handle("CLOSE", chanNum, r, this.owner);
                        break;
                    }
                    for (int ip = 1; ip <= this.nproperty; ++ip) {
                        this.delMember(r, chanNum, ip);
                    }
                    this.sendPacket((byte)116, chanNum, r, 0);
                    break;
                }
                case 116: {
                    if (r == null) {
                        this.warning("Received unsolicited CLOSED packet");
                        break;
                    }
                    if (chanNum == 0) {
                        r.state = (byte)116;
                        this.handle("CLOSED", chanNum, r, this.owner);
                        break;
                    }
                    if (chanNum <= 0) break;
                    this.closedChannel(chanNum, r);
                    break;
                }
                case 114: {
                    if (r == null || !r.isOpened()) {
                        this.warning("Cannot modify an unOpened remote");
                        break;
                    }
                    Table tbl = new Table();
                    if (this.caseSensitive) {
                        tbl.setFlags(tbl.getFlagsInt() | 0x40);
                    }
                    tbl.fromBytes(buf, doff, len + doff);
                    this.procModify(tbl, r);
                    break;
                }
                case 121: {
                    String string = Convert.l2s(this.nproperty);
                    if (chanNum > 0 && chanNum <= this.nproperty) {
                        string = this.getProperty((int)chanNum).name;
                    }
                    this.sendPacket((byte)122, chanNum, string.getBytes(), r, 0);
                    break;
                }
                case 122: {
                    String string = new String(buf, doff, len);
                    if (this.verbose) {
                        this.info("KeyName[" + chanNum + "]=" + string);
                    }
                    if (chanNum == 0) {
                        if (this.verbose) {
                            this.info("Getting individual keys");
                        }
                        int nkeys = Integer.parseInt(string);
                        for (int i = 1; i <= nkeys; ++i) {
                            this.sendPacket((byte)121, i, r, 0);
                        }
                        break;
                    }
                    this.handle("PROPERTY", chanNum, string, r);
                    break;
                }
            }
            if (r != null && r.state == 115) {
                r.timePong = currentTime;
            }
        }
        catch (Exception e) {
            this.printStackTrace("Exception in procPacket from remote " + r, e);
            this.sendLinkProblemReport(r, "Exception in procPacket: " + e.getMessage(), new Packet(buf, 0, len));
        }
    }

    boolean handleUnopenedConnectionOrRemoteIsSever(Remote r, byte chanNum, double time) {
        boolean caseHandled = false;
        if (r == null || !r.isOpened()) {
            if (chanNum != -106) {
                this.warning("Cannot close unOpened remote: " + r);
            }
            caseHandled = true;
        } else if (!r.isClient) {
            caseHandled = true;
            if (chanNum == 0 && r.isOpened()) {
                this.unOpenRemote(r, time);
            } else if (chanNum == -106) {
                if (this.verbose) {
                    this.debug("  Got QUIET CLOSE request from " + r);
                }
                boolean reopen = r.isOpened() || r.isOpening();
                this.unOpenRemote(r, time);
                if (reopen) {
                    this.sendPacket((byte)109, r.state, r, 1);
                }
            }
        }
        return caseHandled;
    }

    String formatName(String name) {
        int i;
        if (name.startsWith("Files/") && (i = (name = name.substring(6)).indexOf("/")) > 0) {
            name = name.substring(i + 1) + "{AUX=" + name.substring(0, i) + "}";
        }
        return name;
    }

    void processMftpMessage(Table t, Remote r) {
        Property p;
        int todo = 0;
        FilePropertyMember fpm = null;
        String func = t.getS("FUNC");
        String name = t.getS("NAME");
        if (t.isEmpty() || func == null || name == null) {
            return;
        }
        int info = 0;
        if (func.equals("EXIST")) {
            String s = this.M.io.find(this.formatName(name)) ? "Y" : "N";
            t.put("EXISTS", (Object)s);
            this.sendPacket((byte)125, info, t.toBytes(), r, 1);
            return;
        }
        int ip = this.indexProperty(name, 5);
        if (ip <= 0 && func.equals("OPEN")) {
            this.addProperty("F:" + name);
            ip = this.indexProperty(name, 5);
        }
        if ((p = this.getProperty(ip)) == null) {
            t.put("LENGTH", -1);
        } else if (func.equals("OPEN")) {
            if (!p.bf.isOpen) {
                p.bf.open();
            }
            t.put("LENGTH", p.bf.getSize());
            fpm = new FilePropertyMember();
            fpm.addr = r.addr;
            fpm.port = r.port;
            fpm.pktlen = t.getL("PKTLEN", 1024);
            fpm.rate = t.getD("RATE", this.maxLinkRate);
            fpm.todo = 0;
            p.pms[++p.members] = fpm;
            r.state = (byte)105;
        } else if (func.equals("READ")) {
            int im = this.findFilePropertyMember(p, r);
            fpm = (FilePropertyMember)p.pms[im];
            if (fpm.todo > 0) {
                fpm.todo = 0;
                Time.sleep(0.001);
            }
            fpm.offset = t.getD("OFFSET");
            fpm.pktlen = t.getL("PKTLEN", fpm.pktlen);
            fpm.rate = t.getD("RATE", fpm.rate);
            fpm.done = 0;
            todo = t.getL("LENGTH");
        } else if (!func.equals("WRITE") && func.equals("CLOSE")) {
            int im = this.findFilePropertyMember(p, r);
            --p.members;
            for (int m = im; m <= p.members; ++m) {
                p.member[m] = p.member[m + 1];
                p.channel[m] = p.channel[m + 1];
                p.pms[m] = p.pms[m + 1];
            }
            if (p.members == 0) {
                p.bf.close();
                this.delProperty(ip);
            }
            r.state = (byte)106;
        }
        this.sendPacket((byte)125, info, t.toBytes(), r, 1);
        if (todo > 0 && fpm != null) {
            fpm.todo = todo;
        }
    }

    int findFilePropertyMember(Property p, Remote r) {
        for (int im = 1; im <= p.members; ++im) {
            FilePropertyMember fpm = (FilePropertyMember)p.pms[im];
            if (fpm.port != r.port || !fpm.addr.equals(r.addr)) continue;
            return im;
        }
        return 0;
    }

    void serveChannel(Remote r, int ic, String name) {
        if (name.startsWith("PIPE:")) {
            String pname = name.substring(5);
            int ip = this.indexProperty(pname, 1);
            if (ip > 0) {
                DataFile df = (DataFile)this.getProperty((int)ip).bf;
                if (df.isOpen) {
                    this.sendPacket((byte)111, ic, df.hb, r, 0);
                }
                this.addMember(r, ic, ip);
            } else {
                this.warning("Pipe not found: " + pname);
            }
        } else if (name.equals("Q:SET")) {
            this.addMember(r, ic, 1);
        } else if (name.equals("Q:GET")) {
            this.addMember(r, ic, 2);
        } else if (name.equals("Q:RET")) {
            this.addMember(r, ic, 3);
        } else if (name.equals("Q:ACK")) {
            this.addMember(r, ic, 4);
        }
    }

    int uncompress(byte[] buf, int offset, int len, byte[] dbuf) {
        int i = 0;
        int funcl = 0;
        byte b = 0;
        byte b2 = 0;
        if (this.lutu == null) {
            this.initTables();
        }
        int n = offset;
        len += offset;
        while (n < len) {
            int m;
            int func = buf[n++];
            if ((m = buf[n++]) < 0) {
                m *= -128;
            }
            switch (func) {
                case 91: {
                    System.arraycopy(buf, n, dbuf, i, m);
                    n += m;
                    i += m;
                    break;
                }
                case 94: {
                    int j = i + m;
                    while (i < j) {
                        b = buf[n++];
                        int k = i + 8;
                        if (k > j) {
                            k = j;
                        }
                        while (i < k) {
                            b2 = buf[n++];
                            dbuf[i++] = (byte)(b - this.lutm[b2 & 0xF]);
                            dbuf[i++] = (byte)(b - this.lutm[b2 >> 4 & 0xF]);
                        }
                    }
                    i = j;
                    break;
                }
                case 92: {
                    int nband = buf[n++];
                    int nbh = nband / 2;
                    int nb = 0;
                    int j = i + m;
                    while (i < j) {
                        if (nb == 0) {
                            dbuf[i++] = b = buf[n++];
                            b2 = buf[n++];
                            nb = nband;
                        } else {
                            dbuf[i++] = nb >= nbh ? b2 : b;
                        }
                        --nb;
                    }
                    i = j;
                    break;
                }
                case 93: {
                    b = buf[n++];
                    int j = i + m;
                    while (i < j) {
                        dbuf[i++] = b;
                    }
                    break;
                }
                default: {
                    Shell.warning("Aborted uncompress due to unhandled function: " + func + " " + funcl);
                    return 0;
                }
            }
            funcl = func;
        }
        return i;
    }

    void initTables() {
        this.lutl = new byte[256];
        this.lutu = new byte[256];
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            if (j < 15 && this.lutm[j + 1] - i < i - this.lutm[j]) {
                ++j;
            }
            this.lutl[i] = (byte)j;
            this.lutu[i] = (byte)(j << 4);
        }
    }

    int compress(PipePropertyMember prop, byte[] tmp, int len, byte[] buf) {
        int kk;
        int i;
        int k;
        int lenchk = 0;
        if (this.lutu == null) {
            this.initTables();
        }
        int i1 = Math.max(0, Math.min(len, prop.trim1));
        int i2 = Math.max(1, Math.min(len, prop.trim2));
        if (i2 == 1) {
            i2 = len;
        }
        int nband = (i2 - i1 + prop.plotwidth / 2) / prop.plotwidth;
        while (i1 < len - 1 && tmp[i1] == tmp[i1 + 1]) {
            ++i1;
        }
        if (i1 < 5) {
            i1 = 0;
        }
        while (i2 > i1 + 2 && tmp[i2 - 2] == tmp[i2 - 1]) {
            --i2;
        }
        if (len - i2 < 5) {
            i2 = len;
        }
        int n = 0;
        for (i = 0; i < i1; i += k) {
            kk = i1 - i;
            k = kk;
            if (k > 127) {
                kk = -k / 128;
                k = -kk * 128;
            }
            buf[n++] = 93;
            buf[n++] = (byte)kk;
            buf[n++] = tmp[i1];
            lenchk += k;
        }
        while (i < i2) {
            byte b;
            byte bmax;
            byte bmin;
            int ip;
            int j;
            int ipk;
            kk = i2 - i;
            k = kk;
            if (k > 127) {
                kk = -k / 128;
                k = -kk * 128;
            }
            if (prop.comp == 1) {
                buf[n++] = 91;
                buf[n++] = (byte)kk;
                System.arraycopy(tmp, i, buf, n, k);
                n += k;
                i += k;
            } else if (nband >= 3) {
                buf[n++] = 92;
                buf[n++] = (byte)kk;
                buf[n++] = (byte)nband;
                int nbh = nband / 2;
                ipk = i + k;
                while (i < ipk) {
                    int imax;
                    j = i + nband;
                    if (j > ipk) {
                        j = ipk;
                    }
                    ip = imax = i;
                    bmax = bmin = tmp[i++];
                    while (i < j) {
                        if ((b = tmp[i++]) > bmax) {
                            bmax = b;
                            imax = i - 1;
                            continue;
                        }
                        if (b >= bmin) continue;
                        bmin = b;
                    }
                    if (imax - ip >= nbh) {
                        buf[n++] = bmin;
                        buf[n++] = bmax;
                        continue;
                    }
                    buf[n++] = bmax;
                    buf[n++] = bmin;
                }
                i = ipk;
            } else {
                buf[n++] = 94;
                buf[n++] = (byte)kk;
                ipk = i + k;
                while (i < ipk) {
                    ip = i;
                    j = i + 8;
                    if (j > ipk) {
                        j = ipk;
                    }
                    bmax = bmin = tmp[i++];
                    while (i < j) {
                        if ((b = tmp[i++]) > bmax) {
                            bmax = b;
                            continue;
                        }
                        if (b >= bmin) continue;
                        bmin = b;
                    }
                    buf[n++] = bmax;
                    i = ip;
                    while (i < j) {
                        b = this.lutl[bmax - tmp[i++]];
                        if (i < j) {
                            b = (byte)(b | this.lutu[bmax - tmp[i++]]);
                        }
                        buf[n++] = b;
                    }
                }
                i = ipk;
            }
            lenchk += k;
        }
        while (i < len) {
            kk = len - i;
            k = kk;
            if (k > 127) {
                kk = -k / 128;
                k = -kk * 128;
            }
            buf[n++] = 93;
            buf[n++] = (byte)kk;
            buf[n++] = tmp[i2];
            lenchk += k;
            i += k;
        }
        if (lenchk == len) {
            return n;
        }
        this.warning("Compression error " + lenchk + " of " + len);
        return 0;
    }

    public void addProperty(String name) {
        int ie;
        int ip = ++this.nproperty;
        if (this.verbose) {
            this.info("Opening property " + ip + ": " + name);
        }
        Property p = new Property();
        if (name.charAt(0) == '{') {
            name = name.substring(1, name.length() - 1);
        }
        if ((ie = name.indexOf(61)) >= 0) {
            p.name = name.substring(0, ie);
            p.rname = name.substring(ie + 1);
        } else {
            p.name = p.rname = name;
        }
        p.name = name;
        if (name.charAt(0) == '_') {
            p.type = 1;
            p.bf = this.ref instanceof MidasReference ? new DataFile((MidasReference)this.ref, (Object)name) : new DataFile(Convert.ref2Midas(this.ref), (Object)name);
            p.bf.setFlags(16384);
            if (p.bf.find(-1)) {
                p.bf.open();
            }
        } else if (name.startsWith("Q:")) {
            p.type = 4;
            p.name = name.substring(2);
        } else if (name.startsWith("F:")) {
            p.type = 5;
            p.name = name.substring(2);
            p.bf = this.ref instanceof MidasReference ? new BaseFile((MidasReference)this.ref, (Object)this.formatName(p.name)) : new BaseFile(Convert.ref2Midas(this.ref), (Object)this.formatName(p.name));
        } else {
            p.type = 2;
        }
        this.properties.put(ip - 1, p.name, p);
    }

    public void delProperty(int ip) {
        this.properties.remove(ip - 1);
        this.nproperty = this.properties.size();
    }

    int indexProperty(String name, int type) {
        for (int ip = 1; ip <= this.nproperty; ++ip) {
            Property p = this.getProperty(ip);
            if (!name.equals(p.name) || type >= 0 && type != p.type) continue;
            return ip;
        }
        return 0;
    }

    int indexMember(Remote r, int ip) {
        Property p = this.getProperty(ip);
        for (int n = 1; n <= p.members; ++n) {
            if (p.member[n] != r) continue;
            return n;
        }
        return 0;
    }

    void addMember(Remote r, int ic, int ip) {
        int n;
        Property p = this.getProperty(ip);
        for (n = 1; n <= p.members; ++n) {
            if (p.member[n] != r) continue;
            return;
        }
        n = p.members + 1;
        if (n >= MAXMEMBER) {
            throw new MidasException("Too many members on " + p);
        }
        p.member[n] = r;
        p.channel[n] = (byte)ic;
        if (p.type == 1) {
            p.pms[n] = new PipePropertyMember();
        }
        if (p.type == 5) {
            p.pms[n] = new FilePropertyMember();
        }
        p.members = n;
    }

    void delMember(Remote r, int ic, int ip) {
        Property p = this.getProperty(ip);
        for (int n = 1; n <= p.members; ++n) {
            if (p.member[n] != r || p.channel[n] != ic && ic >= 0) continue;
            --p.members;
            for (int m = n; m <= p.members; ++m) {
                p.member[m] = p.member[m + 1];
                p.channel[m] = p.channel[m + 1];
                p.pms[m] = p.pms[m + 1];
            }
            return;
        }
    }

    Remote createClientRemote(String id, String host, int port) {
        Table tbl = new Table();
        tbl.put("HOST", (Object)host);
        tbl.put("PORT", port);
        tbl.put("ISCLIENT", true);
        tbl.put("ID", (Object)id);
        return this.addRemote(tbl);
    }

    public Remote addRemote(Table targs) {
        if (this.debug) {
            this.debug("addRemote targs=" + targs);
        }
        Remote r = new Remote(this);
        this.rlast = null;
        try {
            KeyObject.setKeys(r, targs);
            r.addr = InetAddress.getByName(r.host);
            Remote rold = this.indexRemote(r.port, r.addr);
            if (rold != null) {
                if (r.id != null && !r.id.equals(rold.id)) {
                    this.info("Overriding old remote ID " + rold.id + " with " + r.id);
                    rold.setID(r.id);
                }
                r = rold;
            }
            if (r.id != null && this.M != null) {
                this.M.registry.put(r.id, r);
            } else {
                r.id = this.id;
            }
            r.rmif = this;
            r.mh = this.owner;
            if (this.verbose) {
                this.info("Remote address: " + r.addr + " on port " + r.port + " -> " + r);
            }
            if (r.isClosed()) {
                r.state = (byte)113;
            } else if (this.verbose) {
                this.info("ReOpening unclosed remote " + r);
            }
            if (r.mh == null) {
                this.warning("addRemote() MessageHandler is null for " + r);
            }
            String rname = r.id;
            if (!this.useLegacyRemoteNames) {
                rname = this.createFastLookupKey(r.addr, r.port);
            } else if (rname.equals("REMOTE")) {
                rname = rname + "_" + ++this.remoteIndex;
            }
            this._fastRemotes.put(rname, r);
        }
        catch (Exception e) {
            this.info("Problem=" + e.getMessage() + "   with addRemote=" + targs);
            r = null;
        }
        return r;
    }

    Remote indexRemote(int port, InetAddress addr) {
        if (!this.useLegacyRemoteNames) {
            return this._fastRemotes.get(this.createFastLookupKey(addr, port));
        }
        return this.legacyIndexRemote(port, addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Remote legacyIndexRemote(int port, InetAddress addr) {
        Map<String, Remote> map = this._fastRemotes;
        synchronized (map) {
            for (Remote r : this._fastRemotes.values()) {
                if (port != r.port || !addr.equals(r.addr)) continue;
                return r;
            }
        }
        return null;
    }

    public Remote openRemote(Table args) {
        Remote r;
        if (this.debug || this.verbose) {
            this.debug("openRemote args=" + args + " (public method)");
        }
        if ((r = this.addRemote(args)) != null) {
            double currentTime;
            r.timeLast = currentTime = Time.current();
            if (!r.isOpening()) {
                r.timePong = currentTime;
            }
            r.state = (byte)105;
            this.sendPacket((byte)109, 105, r, 1);
        } else {
            this.warning("Failed openRemote for " + args);
        }
        return r;
    }

    void openRemote(Remote r) {
        if (this.debug | this.verbose) {
            this.info("Opening remote " + r);
        }
        if (r != null) {
            if (!this.reuseRemotes) {
                this.resetSendQueue(r);
            }
            this.resetRecvQueue(r, -1);
            this.sendPacket((byte)105, 0, r, 0);
        } else {
            this.warning("Bad remote on openRemote");
        }
    }

    void unOpenRemote(Remote r, double time) {
        if (this.debug) {
            this.debug("unOpenRemote " + r + " time=" + time + " timePong=" + r.timePong + " timeLast(Ping)=" + r.timeLast);
        }
        if (r.isOpening()) {
            return;
        }
        if (r.isClient() && r.timePong == 0.0) {
            return;
        }
        r.state = (byte)105;
        for (int ic = 1; ic <= this.nchannel; ++ic) {
            Channel c = this.getChannel(ic);
            if (c == null || c.r != r) continue;
            c.state = (byte)105;
        }
    }

    public Remote getRemote(Object obj) {
        Remote r = null;
        if (obj instanceof Remote) {
            r = (Remote)obj;
        } else if (obj instanceof Table) {
            r = this.getRemote((Table)obj);
        } else if (obj instanceof RemoteAddress) {
            r = this.getRemoteForAddress((RemoteAddress)obj);
        }
        return r;
    }

    public Remote getRemote(Table targs) {
        if (targs == null) {
            return null;
        }
        String tid = targs.getS("ID");
        if (tid == null) {
            return null;
        }
        return this.getRemote(tid);
    }

    public void removeRemote(Table targs) {
        Remote r = this.getRemote(targs);
        this.removeRemote(r);
    }

    public void removeRemote(Remote r) {
        if (r == null) {
            return;
        }
        String lookupKey = !this.useLegacyRemoteNames ? this.createFastLookupKey(r.addr, r.port) : r.id;
        this._fastRemotes.remove(lookupKey);
        if (r.isOpened()) {
            this.closeRemote(r);
        }
        if (r.isOpening()) {
            this.closeRemote(r);
        }
        if (r.id != null && this.M != null) {
            this.M.registry.remove(r.id);
        }
    }

    public void closeRemote(Remote r) {
        if (this.debug) {
            this.debug("closeRemote r=" + r);
        }
        if (r == null) {
            return;
        }
        if (r.id != null && this.M != null) {
            this.M.registry.remove(r.id);
        }
        if (this.verbose) {
            this.info("Closing remote " + r);
        }
        for (int ic = 1; ic <= this.nchannel; ++ic) {
            Channel c = this.getChannel(ic);
            if (c == null || c.r != r || c.state == 116) continue;
            this.closeChannel(ic);
        }
        for (int ip = 1; ip <= this.nproperty; ++ip) {
            this.delMember(r, -1, ip);
        }
        if (r.isOpened() && (revertSafetyFixes || !r.isClient())) {
            this.sendPacket((byte)106, 0, r, 0);
        }
        if (revertSafetyFixes) {
            r.state = (byte)116;
        }
        this.resetRecvQueue(r, -1);
        this.resetSendQueue(r);
        if (!revertSafetyFixes) {
            r.state = (byte)116;
        }
    }

    public void addChannel(Remote r, int ic, String name) {
        this.addChannel(r, ic, name, 0);
    }

    public void addChannel(Remote r, int ic, String name, int flags) {
        int ie;
        Channel c;
        if (ic <= 0) {
            ic = this.nchannel + 1;
        }
        if (this.verbose) {
            this.info("Adding channel " + ic + ": " + name + " on " + r);
        }
        if ((c = this.getChannel(ic)) == null) {
            c = new Channel();
        }
        if (name.charAt(0) == '{') {
            name = name.substring(1, name.length() - 1);
        }
        if ((ie = name.indexOf(61)) >= 0) {
            c.name = name.substring(0, ie);
            c.rname = name.substring(ie + 1);
        } else {
            c.name = c.rname = name;
        }
        c.r = r;
        c.type = 2;
        c.state = (byte)105;
        c.flags = flags;
        if (name.equals("SET") || name.equals("GET") || name.equals("RET") || name.equals("ACK")) {
            c.type = 3;
        }
        if (name.startsWith("Q:")) {
            c.type = 4;
        }
        if (name.charAt(0) == '_') {
            c.type = 1;
        }
        this.channels.put(ic - 1, c.name, c);
        this.nchannel = Math.max(this.nchannel, ic);
        if (r != null && r.isOpened()) {
            this.openChannel(ic, r);
        }
    }

    void openChannel(int ic, Remote r) {
        Channel c;
        if (this.verbose) {
            this.info("Opening channel " + ic + " on " + r);
        }
        if ((c = this.getChannel(ic)) == null) {
            return;
        }
        if (c.state == 115 && (c.flags & 1) == 0) {
            return;
        }
        if (r == null) {
            r = c.r;
        }
        if (c.type == 1) {
            String rname = "PIPE:" + c.rname;
            this.sendPacket((byte)105, ic, rname.getBytes(), r, 0);
        } else if (c.type == 2) {
            this.sendPacket((byte)105, ic, c.rname.getBytes(), r, 0);
        } else if (c.type == 3) {
            this.sendPacket((byte)105, ic, c.rname.getBytes(), r, 0);
        } else if (c.type == 4) {
            this.sendPacket((byte)105, ic, c.rname.getBytes(), r, 0);
        }
        c.state = (byte)115;
    }

    public void closeChannel(int ic) {
        Channel c;
        if (this.verbose) {
            this.info("Closing channel " + ic);
        }
        if ((c = this.getChannel(ic)) == null) {
            return;
        }
        c.state = (byte)106;
        if (c.type == 1) {
            String name = "PIPE:" + c.name;
            this.sendPacket((byte)106, ic, name.getBytes(), c.r, 0);
        } else {
            this.sendPacket((byte)106, ic, c.name.getBytes(), c.r, 0);
        }
    }

    public void closeChannel(String name) {
        if (this.verbose) {
            this.info("Closing channel " + name);
        }
        for (int ic = 1; ic <= this.nchannel; ++ic) {
            Channel c = this.getChannel(ic);
            if (c == null || !c.name.equals(name) || c.state == 116) continue;
            this.closeChannel(ic);
        }
    }

    void closedChannel(int ic, Remote r) {
        Channel c = this.getChannel(ic);
        if (c.state == 106 && c.r == r) {
            c.state = (byte)116;
        }
    }

    public static String functionName(byte func) {
        return RmifInterface.functionName(func);
    }

    public static String protocolName(int protocol) {
        return Parser.get("RDP,UDP,TCP,IDP", protocol, -1);
    }

    public static String protocolNameForSeq(int seq) {
        return seq >= 0 ? "RDP" : Rmif.protocolName(-seq);
    }

    public static String propTypeName(int type) {
        return Parser.get("Pipe,Result,Key,Message,File", type);
    }

    public String getTag() {
        String hostname = this.dsock.getLocalAddress().getHostName();
        return this.id + "-Local-" + hostname + "-" + this.getPort();
    }

    public int serveProperties() {
        int stat = 0;
        for (int ip = 1; ip <= this.nproperty; ++ip) {
            Property p = this.getProperty(ip);
            try {
                if (p == null) continue;
                if (p.type == 1) {
                    stat += this.servePipeProperty(p);
                } else if (p.type == 2) {
                    stat += this.serveResultProperty(p);
                } else if (p.type == 5) {
                    stat += this.serveFileProperty(p);
                }
                if (stat <= 0) continue;
                p.errorCount = 0;
                continue;
            }
            catch (Exception ex) {
                Table t = new Table();
                t.put("PROPERTY", (Object)p);
                t.put("EXCEPTION", (Object)ex);
                ++p.errorCount;
                if (p.errorCount >= this.maxErrorsToNotServeProperty) {
                    this.delProperty(ip);
                    if (p.bf != null) {
                        p.bf.close();
                    }
                    t.put("COMMENT", (Object)("No longer serving property [" + p + "] after " + p.errorCount + " errors."));
                }
                this.handle("ERROR_SERVING_PROPERTY", 0, t, this.owner);
            }
        }
        return stat;
    }

    public synchronized void servePacket(byte func, int info, byte[] bytes, int flags) {
        Property p = null;
        if (func == 104) {
            p = this.getProperty(4);
        } else if (func == 103) {
            p = this.getProperty(3);
        } else if (func == 101) {
            p = this.getProperty(1);
        } else if (func == 102) {
            p = this.getProperty(2);
        }
        if (p == null) {
            this.warning("Illegal packet to server " + func);
        } else {
            for (int im = 1; im <= p.members; ++im) {
                Remote r = p.member[im];
                if (!r.isOpened()) continue;
                this.sendPacket(func, info, bytes, 0, bytes.length, r, flags, 0.0);
            }
        }
    }

    void procModify(Table t, Remote r) {
        String name;
        int ip;
        if (this.verbose) {
            this.info("Processing Modify on " + r);
        }
        if ((ip = this.indexProperty(name = t.getS("PROPERTY"), -1)) <= 0) {
            return;
        }
        Property p = this.getProperty(ip);
        if (p.type == 1) {
            int im = this.indexMember(r, ip);
            if (im <= 0) {
                return;
            }
            PipePropertyMember ppm = (PipePropertyMember)p.pms[im];
            if (t.containsKey("DEC")) {
                ppm.dec = t.getB("DEC");
            }
            if (t.containsKey("COMP")) {
                ppm.comp = t.getB("COMP");
            }
            if (t.containsKey("TRIM1")) {
                ppm.trim1 = Math.max(0, t.getL("TRIM1") - 1);
            }
            if (t.containsKey("TRIM2")) {
                ppm.trim2 = Math.max(0, t.getL("TRIM2"));
            }
            if (t.containsKey("PLOTWIDTH")) {
                ppm.plotwidth = Math.max(0, t.getL("PLOTWIDTH"));
            }
        }
    }

    @Deprecated
    public int servePipeProperty(Property p) {
        int nr;
        int bytes = 0;
        int stat = 0;
        byte rep = 0;
        byte[] buf = null;
        DataFile df = (DataFile)p.bf;
        double time = 0.0;
        if (!df.isOpen) {
            if (!df.find(-1)) {
                return stat;
            }
            if (!df.open(32)) {
                return stat;
            }
            this.reOpenPipeProperty(p);
        }
        if ((nr = (int)df.avail()) == -1) {
            df.close();
            return stat;
        }
        if (nr == -2) {
            p.bf = df.reOpen();
            this.reOpenPipeProperty(p);
        }
        if (nr <= 0) {
            return stat;
        }
        for (int im = 1; im <= p.members; ++im) {
            Remote r = p.member[im];
            if (!r.isOpened()) continue;
            byte chan = p.channel[im];
            PipePropertyMember ppm = (PipePropertyMember)p.pms[im];
            if (ppm.dec > 1 && (ppm.count = (byte)(ppm.count + 1)) < ppm.dec) continue;
            if (buf == null) {
                if (df.getTimeLineHandler() != null) {
                    time = df.getTimeAt();
                }
                int xfer = df.typeClass == 2 && df.ape == 1 ? (int)((double)MAXPKTBUF / df.dbpe) : (nr == 1 || df.typeClass == 2 ? 1 : (int)(1024.0 / df.dbpe));
                xfer = Math.min(nr, Math.max(1, xfer));
                bytes = (int)((double)xfer * df.dbpe);
                buf = new byte[bytes];
                df.read(buf, 0, bytes);
                rep = Shell.rep;
            }
            if (ppm.comp != 0 && df.dataType == 66) {
                int clen = this.compress(ppm, buf, bytes, this.cbuf);
                int flg = 1;
                if (time > 0.0) {
                    flg |= 0x10;
                }
                this.sendPacket((byte)117, chan, this.cbuf, 0, clen, r, flg, time);
            } else if (df.dataType == 66 || r.rep == rep) {
                int flg = 1;
                if (time > 0.0) {
                    flg |= 0x10;
                }
                this.sendPacket((byte)112, chan, buf, 0, bytes, r, flg, time);
            }
            ++stat;
        }
        if (buf == null) {
            df.skip(nr);
        }
        return stat;
    }

    void reOpenPipeProperty(Property p) {
        for (int im = 1; im <= p.members; ++im) {
            Remote r = p.member[im];
            if (!r.isOpened()) continue;
            byte chan = p.channel[im];
            DataFile df = (DataFile)p.bf;
            this.sendPacket((byte)111, chan, df.hb, r, 0);
        }
    }

    @Deprecated
    public int serveResultProperty(Property p) {
        if (p.members > 0) {
            return 0;
        }
        return 0;
    }

    @Deprecated
    public int serveFileProperty(Property p) {
        int stat = 0;
        for (int im = 1; im <= p.members; ++im) {
            FilePropertyMember fpm = (FilePropertyMember)p.pms[im];
            if (fpm.todo <= 0) continue;
            if (fpm.done == 0) {
                p.bf.seek(fpm.offset);
                if (fpm.dbuf == null || fpm.dbuf.length < fpm.todo) {
                    fpm.dbuf = new byte[fpm.todo];
                }
                p.bf.read(fpm.dbuf, 0, fpm.todo);
                fpm.time = Time.current();
            } else if ((double)fpm.done / (Time.current() - fpm.time) > fpm.rate) continue;
            int doff = fpm.done;
            int dlen = Math.min(fpm.todo, fpm.pktlen);
            this.wdef.addr = fpm.addr;
            this.wdef.port = fpm.port;
            fpm.done += dlen;
            fpm.todo -= dlen;
            this.sendPacket((byte)112, 0, fpm.dbuf, doff, dlen, this.wdef, 33, fpm.offset + (double)doff);
            ++stat;
        }
        return stat;
    }

    void error(String str) {
        str = Time.tag() + " [" + this.id + "] " + str;
        if (this.logfile != null) {
            this.logfile.writeln("ERROR:  " + str);
        }
        if (this.M == null) {
            System.out.println("ERROR:  " + str);
        } else {
            this.M.error(str);
        }
    }

    void info(String str) {
        str = Time.tag() + " [" + this.id + "] " + str;
        if (this.logfile != null) {
            this.logfile.writeln("INFO:  " + str);
        }
        if (this.M == null) {
            System.out.println("INFO:  " + str);
        } else {
            this.M.info(str);
        }
    }

    void warning(String str) {
        str = Time.tag() + " [" + this.id + "] " + str;
        if (this.logfile != null) {
            this.logfile.writeln("WARN:  " + str);
        }
        if (this.M == null) {
            System.out.println("WARN:  " + str);
        } else {
            this.M.warning(str);
        }
    }

    void printStackTrace(String str, Throwable t) {
        if (this.M == null) {
            t.printStackTrace();
        } else {
            this.M.printStackTrace(str, t);
        }
    }

    void deprecate(String str) {
        if (this.M == null) {
            System.out.println("DEPRECATE:" + str);
        } else {
            this.M.deprecate(str);
        }
    }

    void debug(String str) {
        str = "DEBUG: " + Time.tag() + " [" + this.id + "] " + str;
        if (this.logfile != null) {
            this.logfile.writeln(str);
        }
        if (this.M == null) {
            System.out.println(str);
        } else {
            this.M.type(str);
        }
    }

    public MessageHandler setMessageHandler(MessageHandler mh) {
        MessageHandler prev = this.handler;
        this.handler = mh;
        if (this.handler == null) {
            this.warning("Rmif: message handler (for messages received from remotes) is null!");
        }
        return prev;
    }

    public MessageHandler getMessageHandler() {
        return this.handler;
    }

    public int getMaxErrorsToNotServeProperty() {
        return this.maxErrorsToNotServeProperty;
    }

    public void setMaxErrorsToNotServeProperty(int newValue) {
        this.maxErrorsToNotServeProperty = newValue;
    }

    String createFastLookupKey(InetAddress addr, int dport) {
        String host = addr.getHostAddress().replace(".", "_");
        return "REMOTE_" + host + "_" + dport;
    }

    @InternalUseOnly
    public static String getRemoteName(String host, int dport) {
        int start = host.indexOf("/");
        String hostAddr = host.substring(start + 1).replace(".", "_");
        return "REMOTE_" + hostAddr + "_" + dport;
    }

    public static void setDefaultUsesLegacyRemoteNames(boolean defaultUsesLegacyRemoteNames) {
        Rmif.defaultUsesLegacyRemoteNames = defaultUsesLegacyRemoteNames;
    }

    public static void setOrigmRemoteReuse(boolean remoteReuseEnabled) {
        origmRemoteReuseEnabled = remoteReuseEnabled;
    }

    public static void setOrigmOriginalMessages(boolean allOriginalMessages) {
        origmAllOriginalMessages = allOriginalMessages;
    }

    public static void setOrigmExtraLogging(boolean extraLoggingEnabled) {
        origmExtraLoggingEnabled = extraLoggingEnabled;
    }

    public static void setStatemOriginalMessages(boolean allOriginalMessages) {
        statemAllOriginalMessages = allOriginalMessages;
    }

    public static void setStatemExtraLogging(boolean extraLoggingEnabled) {
        statemExtraLoggingEnabled = extraLoggingEnabled;
    }

    @InternalUseOnly
    public static void setOldRemoteStorage(boolean useOldKeyVectorStorage) {
        oldRemoteStorage = useOldKeyVectorStorage;
    }

    @LimitedFutureSupport(value="remove as soon as sure do not need old remote KeyVector storage")
    private int checkRemotesKeyVector() {
        int stat = 0;
        double time = Time.current();
        for (int ir = 1; ir <= this.remotes.size(); ++ir) {
            boolean openedRemoteTimedout;
            Remote r = this.getRemote(ir);
            if (r == null) continue;
            stat += this.checkPacketQueue(r, time);
            if (r.recvQueue > 0) {
                this.checkRecvQueue(r, -1);
            }
            boolean bl = openedRemoteTimedout = r.isOpened() && time - r.timePong > this.timeOut;
            if (openedRemoteTimedout) {
                this.unOpenRemote(r, time);
            }
            if (!(time - r.timeLast > this.timePing)) continue;
            if (openedRemoteTimedout) {
                this.unOpenRemote(r, time);
            } else if (!r.isClient && (r.isOpened() || r.isOpening())) {
                this.sendPacket((byte)109, r.state, r, 1);
            }
            r.timeLast = time;
        }
        return stat;
    }

    @LimitedFutureSupport(value="remove as soon as sure do not need old remote KeyVector storage")
    private int getLinkLatencyKeyVector() {
        int glat = 0;
        for (int ir = 0; ir < this.remotes.size(); ++ir) {
            Remote r = (Remote)this.remotes.get(ir);
            int lat = (int)(r.latency * 1000.0);
            if (lat <= glat) continue;
            glat = lat;
        }
        return glat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LimitedFutureSupport(value="remove as soon as sure do not need old remote KeyVector storage")
    private Remote indexRemoteKeyVector(int port, InetAddress addr) {
        Remote last = this.rlast;
        if (last != null && last.port == port && last.addr.equals(addr)) {
            return last;
        }
        KeyVector keyVector = this.remotes;
        synchronized (keyVector) {
            for (int ir = 0; ir < this.remotes.size(); ++ir) {
                Remote r = (Remote)this.remotes.get(ir);
                if (port != r.port || !addr.equals(r.addr)) continue;
                this.rlast = r;
                return r;
            }
        }
        return null;
    }

    @LimitedFutureSupport(value="remove as soon as sure do not need old remote KeyVector storage")
    private void removeRemoteKeyVector(Remote r) {
        if (r == null) {
            return;
        }
        if (r.isOpened()) {
            this.closeRemote(r);
        }
        if (r.isOpening()) {
            this.closeRemote(r);
        }
        if (r.id != null && this.M != null) {
            this.M.registry.remove(r.id);
        }
        this.remotes.remove(r.id);
        this.rlast = null;
    }

    @LimitedFutureSupport(value="remove as soon as sure do not need old remote KeyVector storage")
    private void clearRemotesKeyVector() {
        for (int ir = 0; ir < this.remotes.size(); ++ir) {
            Remote r = (Remote)this.remotes.get(ir);
            if (r == null || r.id == null || this.M == null) continue;
            this.info("  Removing from registry " + r);
            this.M.registry.remove(r.id);
        }
        this.remotes.clear();
    }

    public class Channel {
        public String name;
        public String rname;
        public Remote r;
        int type;
        int flags;
        DataFile df;
        byte state = (byte)116;

        public String toString() {
            return "RMIF-Client Channel: Name=" + this.name + " Type=" + Rmif.propTypeName(this.type) + " State=" + Rmif.functionName(this.state);
        }

        public boolean equals(Object obj) {
            boolean equal = false;
            if (obj instanceof Channel) {
                Channel c = (Channel)obj;
                equal = (this.name == null && c.name == null || this.name != null && this.name.equals(c.name) || c.name != null && c.name.equals(this.name)) && c.r == this.r && (this.rname == null && c.rname == null || this.rname != null && this.rname.equals(c.rname) || c.rname != null && c.rname.equals(this.rname)) && this.type == c.type && this.flags == c.flags;
            }
            return equal;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public class FilePropertyMember {
        int todo;
        int done;
        int pktlen;
        int port;
        double offset;
        double time;
        double rate;
        InetAddress addr;
        byte[] dbuf;

        public String toString() {
            return "FilePropertyMember: todo=" + this.todo + " done=" + this.done + " offset=" + this.offset + " time=" + this.time + " rate=" + this.rate + " pktlen=" + this.pktlen;
        }
    }

    public class PipePropertyMember {
        byte dec;
        byte count;
        byte comp;
        byte flag;
        int plotwidth = 512;
        int trim1;
        int trim2;

        public String toString() {
            return "PipePropertyMember: dec=" + this.dec + " comp=" + this.comp + " pw=" + this.plotwidth + " trim1=" + this.trim1 + " trim2=" + this.trim2;
        }
    }

    public class Property {
        public String name;
        public String rname;
        int type;
        int members;
        BaseFile bf;
        Remote[] member = new Remote[MAXMEMBER];
        Object[] pms = new Object[MAXMEMBER];
        byte[] channel = new byte[MAXMEMBER];
        int errorCount = 0;

        public String toString() {
            return "RMIF-Server Property: Name=" + this.name + " Type=" + Rmif.propTypeName(this.type) + " Members=" + this.members;
        }
    }

    public class Packet {
        byte[] buffer;
        int off;
        int len;
        double time;

        Packet() {
        }

        public Packet(byte[] buf, int off, int len) {
            this.initialize(buf, off, len, 0.0, true);
        }

        public Packet(byte[] buf, int off, int len, boolean copy) {
            this.initialize(buf, off, len, 0.0, copy);
        }

        Packet(byte[] buf, int off, int len, double time, boolean copy) {
            this.initialize(buf, off, len, time, copy);
        }

        Packet copy() {
            return new Packet(this.buffer, this.off, this.len, this.time, false);
        }

        synchronized void clear(double time) {
            this.buffer = null;
            this.time = time;
        }

        synchronized void initialize(byte[] buf, int off, int len, double time, boolean copy) {
            if (buf == null) {
                throw new MidasException("Rmif: Can not create Packet, invalid packet buffer, buf=null.");
            }
            if (len < 8 || buf.length < off + len || off < 0) {
                throw new MidasException("Rmif: Can not create Packet, invalid buffer length/offset, buf.length=" + buf.length + ", off=" + off + ", len=" + len + ". Minimum length is 8.");
            }
            if (copy) {
                this.buffer = new byte[len];
                this.off = 0;
                this.len = len;
                this.time = time;
                System.arraycopy(buf, off, this.buffer, 0, len);
            } else {
                this.buffer = buf;
                this.off = off;
                this.len = len;
                this.time = time;
            }
        }

        byte[] getBufZeroOffset() {
            if (this.off == 0) {
                return this.buffer;
            }
            byte[] buf = new byte[this.len];
            System.arraycopy(this.buffer, this.off, buf, 0, this.len);
            return buf;
        }

        public byte getFunc() {
            return this.buffer[this.off + 0];
        }

        public byte getFlag() {
            return this.buffer[this.off + 1];
        }

        public byte getInfo() {
            return this.buffer[this.off + 2];
        }

        public byte getRep() {
            return this.buffer[this.off + 3];
        }

        public byte getSeq() {
            return this.buffer[this.off + 4];
        }

        public byte getTry() {
            return this.buffer[this.off + 5];
        }

        public byte getRpt() {
            return this.buffer[this.off + 6];
        }

        public byte getAdj() {
            return this.buffer[this.off + 7];
        }

        void setFunc(byte val) {
            this.buffer[this.off + 0] = val;
        }

        void setFlag(byte val) {
            this.buffer[this.off + 1] = val;
        }

        void setInfo(byte val) {
            this.buffer[this.off + 2] = val;
        }

        void setRep(byte val) {
            this.buffer[this.off + 3] = val;
        }

        void setSeq(byte val) {
            this.buffer[this.off + 4] = val;
        }

        void setTry(byte val) {
            this.buffer[this.off + 5] = val;
        }

        void setRpt(byte val) {
            this.buffer[this.off + 6] = val;
        }

        void setAdj(byte val) {
            this.buffer[this.off + 7] = val;
        }

        public String getFunction() {
            return Rmif.functionName(this.getFunc());
        }

        public String getProtocol() {
            return Rmif.protocolNameForSeq(this.getSeq());
        }

        public String getData() {
            int doff = this.off + 8 + this.buffer[this.getAdj()];
            int dlen = this.len - doff;
            return Convert.unpackS(this.buffer, doff, dlen);
        }

        public String toString() {
            if (this.buffer == null) {
                return "RMIF-Packet: <NULL>";
            }
            return "RMIF-Packet: func=" + this.getFunc() + " (" + this.getFunction() + ") flag=" + this.getFlag() + " info=" + this.getInfo() + " rep=" + (char)this.getRep() + " seq=" + this.getSeq() + " (" + this.getProtocol() + ") try=" + this.getTry() + " rpt=" + this.getRpt() + " adj=" + this.getAdj() + " time=" + Time.toString(this.time);
        }

        public String toStringShort() {
            if (this.buffer == null) {
                return "Packet: buf=null time=" + Time.toString(this.time, 8);
            }
            int length = Math.min(8, this.len - 8);
            return "Packet: func=" + this.getFunction() + " seq=" + this.getSeq() + " try=" + this.getTry() + " time=" + Time.toString(this.time, 8) + " buf=" + Convert.unpackS(this.buffer, this.off + 8, length);
        }
    }

    public class Remote
    implements IDable,
    MessageHandler {
        String id;
        public String host;
        int port;
        InetAddress addr;
        double timeLast = 0.0;
        double timePong = 0.0;
        double timeLost = 5.0;
        double timeRetry = 0.2;
        double latency = 0.0;
        byte rep;
        boolean isClient = false;
        byte state = (byte)116;
        int retried = 0;
        int maxRetry = 5;
        int maxWindow = 12;
        int maxQueue = 1024;
        double linkBytes = 0.0;
        double linkTime = 0.0;
        public Rmif rmif;
        public MessageHandler mh;
        public Remote next;
        int sendSeq = 0;
        int sendChk = 0;
        int sendDrop = 0;
        int recvChk = 0;
        int recvQueue = 0;
        int recvReOrder = 0;
        Packet[] sendBuf = new Packet[128];
        Packet[] recvBuf = new Packet[128];
        LinkedList<Packet> sendQueue = new LinkedList();

        public Remote() {
            for (int i = 0; i < 128; ++i) {
                this.sendBuf[i] = new Packet();
                this.recvBuf[i] = new Packet();
            }
        }

        public Remote(Rmif rmif2) {
            this();
            this.rmif = rmif2;
            this.maxRetry = rmif2.maxRetry;
            this.maxWindow = rmif2.maxWindow;
            this.maxQueue = rmif2.maxQueue;
            this.timeLost = rmif2.defaultTimeLost;
            this.timeRetry = rmif2.defaultTimeRetry;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Deprecated
        public boolean isOpen() {
            Rmif.this.deprecate("Remote: Since NeXtMidas 2.5.0, use isOpening() or isOpened() rather than isOpen().");
            return this.isOpening();
        }

        public boolean isOpened() {
            return this.state == 115;
        }

        public boolean isOpening() {
            return this.state == 105;
        }

        public boolean isClosed() {
            return this.state == 116;
        }

        public void setHP(String hostport) {
            int i = hostport.indexOf(58);
            this.host = hostport.substring(0, i).toLowerCase();
            this.port = Integer.parseInt(hostport.substring(i + 1));
        }

        public void setHost(String host) {
            int i = host.indexOf(47);
            this.host = i > 0 ? host.substring(0, i).toLowerCase() : host.toLowerCase();
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setIsClient(boolean isClient) {
            this.isClient = isClient;
        }

        public boolean isClient() {
            return this.isClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setID(String newID) {
            String oldID = this.id;
            this.id = newID;
            if (!newID.equals(oldID) && Rmif.this.M != null) {
                Registry registry = Rmif.this.M.registry;
                synchronized (registry) {
                    Object prevRemote;
                    if (Rmif.this.M.registry.get(oldID) == this) {
                        Rmif.this.M.registry.remove(oldID);
                    }
                    if ((prevRemote = Rmif.this.M.registry.get(newID)) != null && prevRemote != this) {
                        Rmif.this.warning("Overriding existing registry entry for " + newID + " " + prevRemote + " with " + this.toString());
                    }
                    Rmif.this.M.registry.put(newID, this);
                }
            }
        }

        public void setWindow(int value) {
            if (value < 1 || value > 80) {
                throw new MidasException("Rmif: Can not set window for " + this + " to " + value + ". Window size must be in the range 1.." + 80 + ".");
            }
            this.maxWindow = value;
        }

        public void setMaxQueue(int value) {
            if (value < 0) {
                throw new MidasException("Rmif: Can not set maxQueue for " + this + " to " + value + ". Max queue size must be in the range 0..N.");
            }
            this.maxQueue = value;
        }

        public String getHost() {
            return this.addr != null ? this.addr.toString() : null;
        }

        public int getPort() {
            return this.port;
        }

        public int getState() {
            return this.state;
        }

        public String getStatus() {
            return Rmif.functionName(this.state);
        }

        public String getAliveStatus() {
            return Time.current() - this.timePong < Rmif.this.timeOut ? "ON" : "OFF";
        }

        public int getWindow() {
            return this.maxWindow;
        }

        public int getMaxQueue() {
            return this.maxQueue;
        }

        public int getRetry() {
            return this.maxRetry;
        }

        public void setRetry(int value) {
            this.maxRetry = value;
        }

        public int getRetried() {
            return this.retried;
        }

        public double getLatency() {
            return this.latency;
        }

        public int getSendSeq() {
            return this.sendSeq;
        }

        public int getSendQueue() {
            return this.sendQueue.size();
        }

        public int getDropped() {
            return this.sendDrop;
        }

        public int getRecvSeq() {
            return this.recvChk;
        }

        public int getRecvQueue() {
            return this.recvQueue;
        }

        public int getReOrdered() {
            return this.recvReOrder;
        }

        public void setTimeLost(double time) {
            this.timeLost = time;
        }

        public double getTimeLost() {
            return this.timeLost;
        }

        public double getTimeRetry() {
            return this.timeRetry;
        }

        public void setTimeRetry(double value) {
            this.timeRetry = value;
        }

        boolean isWindowFull() {
            return this.sendSeq - this.sendChk >= this.maxWindow;
        }

        public double getLinkBW() {
            double time = Time.current();
            double rate = this.linkBytes / (time - this.linkTime);
            this.linkTime = time;
            this.linkBytes = 0.0;
            return rate;
        }

        @Override
        public int processMessage(Message msg) {
            return this.mh != null ? this.mh.processMessage(msg) : -1;
        }

        public void setNext(String value) {
            if (Rmif.this.M != null) {
                this.next = (Remote)Rmif.this.M.registry.get(value);
            }
            if (this.next == this) {
                this.next = null;
            }
        }

        public String toString() {
            if (this.host == null) {
                this.host = this.getHost();
            }
            String tmp = "R: RMIF-Remote " + this.host + ":" + this.port + " " + this.id + " (" + Rmif.functionName(this.state) + ") isClient=" + this.isClient;
            if (this.next != null) {
                tmp = tmp + " ->> " + this.next.id;
            }
            return tmp;
        }

        public String getTag() {
            return this.id + "-Remote-" + this.host + "-" + this.port;
        }
    }

    public class RemoteAddress
    implements IDable,
    MessageHandler {
        int port;
        InetAddress addr;
        MessageHandler mh;

        public RemoteAddress(Remote r) {
            this.addr = r.addr;
            this.port = r.port;
            this.mh = r.mh;
        }

        @Override
        public String getID() {
            return "UNKNOWN";
        }

        @Override
        public int processMessage(Message msg) {
            return this.mh.processMessage(msg);
        }

        public String toString() {
            return "R: RMIF-RemoteAddr " + this.addr + ":" + this.port;
        }
    }

    class PacketReader
    implements Runnable {
        Rmif rmif;
        boolean abort = false;

        public PacketReader(Rmif rmif2) {
            this.rmif = rmif2;
        }

        @Override
        public void run() {
            while (!this.abort) {
                this.rmif.recvPacket();
            }
        }

        public void stop() {
            this.abort = true;
        }

        public boolean isAborted() {
            return this.abort;
        }
    }
}

