/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import nxm.sys.lib.Shell;

public class HttpAuthenticator
extends Authenticator {
    private static final HttpAuthenticator INSTANCE = new HttpAuthenticator();
    private static boolean debug = false;
    private boolean enabled = false;
    private TreeMap<String, PasswordAuthentication> credentialsMap = new TreeMap(ReverseComparator.getInstance());
    private CallbackIF callback = null;

    private HttpAuthenticator() {
    }

    public static HttpAuthenticator getInstance() {
        return INSTANCE;
    }

    public static void setDebug(boolean val) {
        debug = val;
    }

    public static boolean getDebug() {
        return debug;
    }

    public synchronized void clear() {
        this.credentialsMap.clear();
    }

    public synchronized void put(String url, String username, String password) {
        if (url == null) {
            throw new NullPointerException("URL cannot not be null.");
        }
        if (password == null) {
            throw new NullPointerException("Password cannot not be null.");
        }
        PasswordAuthentication value = new PasswordAuthentication(username, password.toCharArray());
        this.credentialsMap.put(url, value);
    }

    public synchronized void remove(String url) {
        this.credentialsMap.remove(url);
    }

    public synchronized HttpAuthenticator enable(boolean enable) {
        this.enabled = enable;
        if (enable) {
            Authenticator.setDefault(this);
            return this;
        }
        Authenticator.setDefault(null);
        return null;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpAuthenticator: ");
        sb.append(this.enabled ? "enabled " : "disabled ");
        sb.append("with " + this.credentialsMap.size() + " entries, callback=");
        sb.append(this.callback);
        return sb.toString();
    }

    @Override
    protected synchronized PasswordAuthentication getPasswordAuthentication() {
        String urlStr = this.getRequestingURL().toString();
        PasswordAuthentication result = this.credentialsMap.get(urlStr);
        if (result != null) {
            if (debug) {
                HttpAuthenticator.debug("found exact URL match. key=" + urlStr + " credentials= " + HttpAuthenticator.toDebugStr(result));
            }
            return result;
        }
        if (!this.credentialsMap.isEmpty()) {
            SortedMap<String, PasswordAuthentication> sortedMap = this.credentialsMap.tailMap(urlStr);
            for (String key : sortedMap.keySet()) {
                if (!urlStr.startsWith(key)) continue;
                result = (PasswordAuthentication)sortedMap.get(key);
                if (debug) {
                    HttpAuthenticator.debug("found prefix match, key=" + key + " credentials= " + HttpAuthenticator.toDebugStr(result));
                }
                return result;
            }
        }
        if (this.callback != null) {
            result = this.callback.authenticate(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingPort(), this.getRequestingProtocol(), this.getRequestingPrompt(), this.getRequestingScheme(), this.getRequestingURL(), this.getRequestorType());
            if (debug) {
                HttpAuthenticator.debug("Result from callback, url=" + urlStr + " credentials= " + HttpAuthenticator.toDebugStr(result));
            }
            return result;
        }
        return null;
    }

    private static final String toDebugStr(PasswordAuthentication credential) {
        return credential.getUserName() + " / *" + credential.getPassword().length;
    }

    private static final void debug(String msg) {
        Shell.writeln("HttpAuthenticator: " + msg);
    }

    public CallbackIF setCallback(CallbackIF newCallback) {
        CallbackIF prev = this.callback;
        this.callback = newCallback;
        return prev;
    }

    static final class ReverseComparator
    implements Comparator<String> {
        private static final ReverseComparator INSTANCE = new ReverseComparator();

        private ReverseComparator() {
        }

        public static ReverseComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(String s1, String s2) {
            return -s1.compareTo(s2);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return 71;
        }
    }

    public static interface CallbackIF {
        public PasswordAuthentication authenticate(String var1, InetAddress var2, int var3, String var4, String var5, String var6, URL var7, Authenticator.RequestorType var8);
    }
}

