/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Midas;
import nxm.sys.lib.OS;
import nxm.sys.lib.Parser;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.net.HPage;
import nxm.sys.net.HSource;

public class HSystem
extends HSource {
    private Midas M;

    public HSystem(String name, Midas M) {
        this.M = M;
        this.name = name + "/";
    }

    @Override
    public void handleRequest(String uri, HPage hp) {
        String option = uri.substring(this.name.length() + 1);
        if (option.startsWith("Get?")) {
            this.getPage(option.substring(4), hp);
        } else if (option.startsWith("Set?")) {
            this.setPage(option.substring(4), hp);
        } else if (option.startsWith("Cmd?")) {
            this.cmdPage(option.substring(4), hp);
        } else if (option.startsWith("Top")) {
            this.topPage(hp);
        } else if (option.startsWith("Log")) {
            this.logPage(hp);
        } else if (option.startsWith("DiskStats/")) {
            String aux = option.substring(10);
            this.diskPage(aux, hp);
        } else {
            this.optPage(hp);
        }
    }

    public void getPage(String key, HPage hp) {
        Object value = this.M.results.get(key);
        hp.open();
        hp.writeln(key + "=" + value);
        hp.close();
    }

    public void setPage(String key, HPage hp) {
        int ie = key.indexOf("=");
        if (ie > 0) {
            String value = key.substring(ie + 1);
            key = key.substring(0, ie);
            this.M.results.setKey(key, value);
        }
        this.getPage(key, hp);
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public void cmdPage(String cmd, HPage hp) {
        byte[] buf = new byte[8192];
        cmd = StringUtil.replaceAll(cmd, "%20", " ");
        cmd = StringUtil.replaceAll(cmd, "%22", "\"");
        cmd = StringUtil.replaceAll(cmd, "%27", "'");
        int bytes = OS.runCommand(cmd, 0, buf);
        hp.openToBody("HSystem Cmd Page");
        hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">System Cmd=" + cmd + "</a></h3>");
        hp.writeln("<br><pre>");
        hp.write(buf, 0, bytes);
        hp.writeln("</pre>");
        hp.closeFromBody();
    }

    public void logPage(HPage hp) {
        hp.openToBody("HSystem Log Page");
        hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">System Log</a></h3>");
        hp.writeln("<br><pre>");
        hp.writeln("Log File not opened");
        hp.writeln("</pre>");
        hp.closeFromBody();
    }

    public void topPage(HPage hp) {
        byte[] buf = new byte[8192];
        int bytes = OS.getStats(0, buf);
        hp.openToBody("HSystem Top Page");
        hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">System Top</a></h3>");
        hp.writeln("<br><pre>");
        hp.write(buf, 0, bytes);
        hp.writeln("</pre>");
        hp.closeFromBody();
    }

    public void diskPage(String aux, HPage hp) {
        hp.openToBody("HSystem Disk Page");
        hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">Aux=" + aux + " Disk Stats</a></h3>");
        String list3 = aux;
        if (aux.equals("ALL")) {
            list3 = this.M.results.getS("AUX.READ");
        }
        String[] auxes = StringUtil.cleanSplit(list3, "|");
        hp.writeln("<table border='1' cellpadding='2' cellspacing='2' align='left'>");
        for (int i = 0; i < auxes.length; ++i) {
            aux = auxes[i];
            String path = this.M.io.getAuxPath(aux);
            Table tab = OS.getStatFS(path);
            hp.writeln("<tr>");
            hp.writeln("<td>Aux   = " + aux + "</td>");
            hp.writeln("<td>Path  = " + path + "</td>");
            if (tab != null) {
                hp.writeln("<td>Files = " + tab.getL("FILES") + "</td>");
                hp.writeln("<td>Total = " + tab.getL("TMBY") + " Mby</td>");
                hp.writeln("<td>Free  = " + tab.getL("FMBY") + " Mby</td>");
                hp.writeln("<td>Used  = " + tab.getL("USED") + "%</td>");
            }
            hp.writeln("</tr>");
        }
        hp.closeFromBody();
    }

    public void optPage(HPage hp) {
        hp.openToBody("HSystem Options Page");
        hp.writeln("<h2 style=\"text-align:center;\">NeXtMidas System Information</h2>");
        hp.writeln("<ul>");
        hp.writeln("<li><a href='/nmroot/index.html'>JavaDocs</a> - System tree documentation</li>");
        hp.writeln("<li><a href='LogTop'>System Log</a> - Top of System Log File</li>");
        hp.writeln("<li><a href='LogTail'>System Log</a> - Tail of System Log File</li>");
        hp.writeln("<li><a href='LogAll'>System Log</a> - All of System Log File</li>");
        hp.writeln("<li><a href='TopCPU'>Top CPU/Mem</a> - List of Top CPU/Memory Processes on Server</li>");
        hp.writeln("<li><a href='DiskStats/ALL'>Disk Aux=ALL</a> All Disks Statistics</li>");
        if (this.M != null) {
            Table taux = this.M.results.getTable("AUX");
            String raux = taux.getString("READ");
            Parser auxes = new Parser(raux, '|');
            auxes.reset();
            while (auxes.more()) {
                String aux = auxes.next();
                String path = this.M.io.getAuxPath(aux);
                hp.writeln("<li><a href='DiskStats/" + aux + "'>Disk Aux=" + aux + "</a> Path=" + path + " Disk Stats</li>");
            }
        }
        hp.writeln("</ul>");
        hp.closeFromBody();
    }
}

