/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import nxm.sys.lib.Midas;
import nxm.sys.lib.OS;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Query;
import nxm.sys.lib.Results;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.libg.GLabel;
import nxm.sys.libg.GWidget;
import nxm.sys.net.HPage;
import nxm.sys.net.HSource;
import nxm.sys.prim.panel;

public class HMobile
extends HSource {
    private Midas M;
    private panel panel;
    private String sp7 = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private String sp8 = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private String sp9 = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    public HMobile(String name, Midas M) {
        this.M = M;
        this.name = name + "/";
    }

    @Override
    public void handleRequest(String uri, HPage hp) {
        String option = uri.substring(this.name.length() + 1);
        if (option.equals("Home")) {
            this.homePage(hp);
        } else if (option.equals("TopCPU")) {
            this.topPage(hp);
        } else if (option.equals("LogAll")) {
            this.logPage(hp);
        } else if (option.equals("Registry")) {
            this.queryPage(hp, "REG");
        } else if (option.equals("Controls")) {
            this.queryPage(hp, "THIS.CONTROLS");
        } else if (option.equals("Results")) {
            this.queryPage(hp, "*");
        } else if (option.equals("Pipes")) {
            this.queryPage(hp, "RAM");
        } else if (option.equals("Files")) {
            this.queryPage(hp, "AUX");
        } else if (option.startsWith("Displays")) {
            this.panelPage(hp, "Configuration");
        } else if (option.startsWith("Query/")) {
            this.queryPage(hp, option.substring(6));
        } else if (option.startsWith("Panel/")) {
            this.panelPage(hp, option.substring(6));
        } else if (option.startsWith("Disks")) {
            this.disksPage(hp);
        } else if (option.startsWith("DiskStats?")) {
            this.diskPage(hp, option.substring(10));
        } else {
            this.optPage(hp, option);
        }
    }

    public void openPage(HPage hp) {
        hp.open();
        hp.writeln("<html>");
        hp.writeln("<body bgcolor=black text=grey>");
    }

    public void closePage(HPage hp) {
        hp.writeln("</body>");
        hp.writeln("</html>");
        hp.close();
    }

    public void logPage(HPage hp) {
        this.openPage(hp);
        hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">System Log</a></h3>");
        hp.writeln("<br><pre>");
        hp.writeln("Log File not opened");
        hp.writeln("</pre>");
        this.closePage(hp);
    }

    public void topPage(HPage hp) {
        byte[] buf = new byte[8192];
        int bytes = OS.getStats(0, buf);
        this.openPage(hp);
        hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">System Top</a></h3>");
        hp.writeln("<br><pre>");
        hp.write(buf, 0, bytes);
        hp.writeln("</pre>");
        this.closePage(hp);
    }

    public void diskPage(HPage hp, String aux) {
        this.openPage(hp);
        hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">Aux=" + aux + " Disk Stats</a></h3>");
        String list3 = aux;
        if (aux.equals("ALL")) {
            list3 = this.M.results.getS("AUX.READ");
        }
        String[] auxes = StringUtil.cleanSplit(list3, "|");
        for (int i = 0; i < auxes.length; ++i) {
            aux = auxes[i];
            String path = this.M.io.getAuxPath(aux);
            Table tab = OS.getStatFS(path);
            hp.writeln("<ul>");
            hp.writeln("<li>Aux   = " + aux + "</li>");
            hp.writeln("<li>Path  = " + path + "</li>");
            if (tab != null) {
                hp.writeln("<li>Files = " + tab.getL("FILES") + "</li>");
                hp.writeln("<li>Total = " + tab.getL("TMBY") + " Mby</li>");
                hp.writeln("<li>Free  = " + tab.getL("FMBY") + " Mby</li>");
                hp.writeln("<li>Used  = " + tab.getL("USED") + "%</li>");
            }
            hp.writeln("</ul>");
        }
        this.closePage(hp);
    }

    public void optPage(HPage hp, String path) {
        this.openPage(hp);
        hp.writeln("<div style=\"text-align:center;\"><h2>Mobile NeXtMidas Server</h2>");
        hp.writeln("<h2>Unrecognized path</h2>");
        hp.writeln("<h2>" + path + "</h2></div>");
        this.closePage(hp);
    }

    private void disksPage(HPage hp) {
        String hostaddr = this.server.getHost();
        int hostport = this.server.getPort();
        String appname = this.M.macro.args.name;
        this.openPage(hp);
        hp.writeln("<div style=\"text-align:center;\"><h3>Mobile NextMidas Server</h3>");
        hp.writeln("<b>HostAddress=" + hostaddr + "</b>");
        hp.writeln("<b>HostPort=" + hostport + "</b>");
        hp.writeln("<b>APPName= " + appname + "</b></div>");
        hp.writeln("<br>");
        Table taux = this.M.results.getTable("AUX");
        String raux = taux.getString("READ");
        Parser auxes = new Parser(raux, '|');
        auxes.reset();
        while (auxes.more()) {
            String aux = auxes.next();
            String path = this.M.io.getAuxPath(aux);
            hp.writeln("<a href='DiskStats/" + aux + "'>Disk Aux=" + aux + " Stats</a>");
        }
        hp.writeln("</div>");
        this.closePage(hp);
    }

    private void homePage(HPage hp) {
        String hostaddr = this.server.getHost();
        int hostport = this.server.getPort();
        String appname = this.M.macro.args.name;
        this.openPage(hp);
        hp.writeln("<br>");
        hp.writeln("<div style=\"text-align:center;\"><h3>Mobile NextMidas Server</h3>");
        hp.writeln("<b>HostAddress=" + hostaddr + "</b>");
        hp.writeln("<b>HostPort=" + hostport + "</b>");
        hp.writeln("<b>APPName= " + appname + "</b>");
        hp.writeln("<br>");
        hp.writeln("a href='Displays'>Displays</a>" + this.sp9 + "<a href='Files'>Files</a>");
        hp.writeln("<br>");
        hp.writeln("<a href='Registry'>Registry</a>" + this.sp9 + "<a href='Disks'>Disks</a>");
        hp.writeln("<br>");
        hp.writeln("<a href='Results'>Results</a>  " + this.sp7 + "<a href='LogAll'>SysLog</a>");
        hp.writeln("<br>");
        hp.writeln("<a href='Pipes'>Pipes</a>      " + this.sp8 + "<a href='TopCPU'>TopCPU</a>");
        hp.writeln("<br>");
        hp.writeln("<a href='Controls'>Controls</a></div>");
        this.closePage(hp);
    }

    public void queryPage(HPage hp, String key) {
        boolean view = true;
        String command = null;
        int qm = key.indexOf(63);
        if (qm > 0) {
            command = key.substring(qm + 1);
            key = key.substring(0, qm);
        }
        Results res = this.M.macro.getResults();
        Results obj = key.equals("*") ? res : res.get(key);
        Query q = new Query(obj, null, 256);
        q.parse();
        if (command != null) {
            int es = command.indexOf(61);
            String ekey = command.substring(0, es);
            String value = command.substring(es + 1);
            Object o = q.getObject(ekey);
            if (o instanceof GWidget) {
                ((GWidget)o).setAction(value);
            }
        }
        q.evaluate();
        this.openPage(hp);
        hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">Query</a> = " + key + "</h3>");
        if (obj == res) {
            key = null;
        }
        hp.writeln("<table>");
        for (int i = 0; i < q.getItems(); ++i) {
            String name = q.getName(i);
            Object o = q.getObject(i);
            String ref = key == null ? name : key + "." + name;
            String val = q.getValue(i);
            String value = this.lookForChoices(key, name, val.toString());
            if (view || o instanceof GLabel) {
                hp.writeln("<tr>");
                hp.writeln("<td nowrap><a href =\"/" + this.name + "Query/" + ref + "\">" + name + "</a></td>");
                hp.writeln("<td><font size=1>" + value + "</font></td>");
                hp.writeln("</tr>");
            }
            if (!(o instanceof GLabel)) continue;
            view = ((GLabel)o).getActive() > 0;
        }
        hp.writeln("</table>");
        this.closePage(hp);
    }

    private String lookForChoices(String key, String name, String value) {
        if (value == null) {
            return value;
        }
        int fb = value.indexOf(91);
        int rb = value.indexOf(93);
        if (fb < 0 || rb < 0) {
            return value;
        }
        String selects = "";
        int i = fb;
        while (i < rb) {
            String item;
            int il;
            int j = value.indexOf(44, i + 1);
            if (j < 0) {
                j = rb;
            }
            if ((il = (item = value.substring(i + 1, j)).length() - 1) > 0 && item.charAt(0) == '<' && item.charAt(il) == '>') {
                item = item.substring(1, il);
                selects = selects + " <a href =\"/" + this.name + "Query/" + key + "?" + name + "=" + item + "\"><b>" + item + "</b></a> ";
            } else {
                selects = selects + " <a href =\"/" + this.name + "Query/" + key + "?" + name + "=" + item + "\">" + item + "</a> ";
            }
            if (j != rb) {
                selects = selects + ',';
            }
            i = j;
        }
        return value.substring(0, fb + 1) + selects + value.substring(rb);
    }

    public void panelPage(HPage hp, String name) {
        if (this.panel == null) {
            this.panel = (panel)this.M.registry.get("PANEL");
        }
        ByteArrayOutputStream baos = this.panel.handleMobileRequest(name);
        if (name.startsWith("Status")) {
            this.openPage(hp);
            Object o = this.panel.MW.parent;
            String s = o instanceof Frame ? ((Frame)o).getTitle() : "...";
            hp.write(s + "<br>");
            this.closePage(hp);
        } else if (name.startsWith("Configuration")) {
            boolean tbl = name.endsWith(".tbl");
            panel.Pane[] panes = this.panel.getPanesArray();
            if (!tbl) {
                this.openPage(hp);
                hp.writeln("<br>");
                hp.writeln("<div style=\"text-align:center;\"><h3>Mobile NextMidas Display Server </h3>");
                hp.writeln("<b>APPName= " + this.M.macro.args.name + "</b></div>");
                hp.writeln("<br>");
            }
            for (int i = 0; i < panes.length; ++i) {
                String value;
                String key = i == 0 ? "APP" : panes[i].name;
                String string = value = i == 0 ? this.M.macro.args.name : panes[i].title;
                if (tbl) {
                    hp.write(value + ",");
                    continue;
                }
                hp.writeln("<div style=\"text-align:center;\">" + key + " = " + value + "</div>");
            }
            if (!tbl) {
                this.closePage(hp);
            }
        } else if (baos == null) {
            hp.setStatus(404);
            hp.open();
            hp.close();
        } else {
            hp.setContentType("image/png");
            hp.setContentLength(baos.size());
            hp.open();
            if (!hp.getMethod().equals("HEAD")) {
                hp.write(baos);
            }
            hp.close();
        }
    }
}

