/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Generate {
    private static boolean debug = false;
    String path;
    int inputs;
    int outputs;
    String name;
    String clazz;
    String symbol;
    String flags;
    String text;
    String description;
    private boolean verbose;
    private boolean scaled;
    private int ranks;
    static final int maxLines = 1024;
    int nlines = 0;
    String[] lines = new String[1024];
    static final int maxOps = 1024;
    int nops = 0;
    int[] ops = new int[1024];
    static final int maxCodes = 32;
    int ncodes = 0;
    String[] codes = new String[32];
    String[] precodes = new String[32];
    String[] postcodes = new String[32];
    String declarations;

    private Generate() {
    }

    public static void main(String[] args) {
        Generate.doOpers(args[0], args[1], false);
        System.exit(0);
    }

    private FileWriter getFileWriter(String name) throws IOException {
        return new FileWriter(this.path + name);
    }

    public static void doOpers(String path, String func, boolean verbose) {
        try {
            new Generate().run(path, func, verbose);
        }
        catch (IOException e) {
            System.out.println("Generate.doOpers(...) IO Problem: " + e);
        }
    }

    private void run(String path, String func, boolean verbose) throws IOException {
        this.path = path;
        this.verbose = verbose;
        this.doOpers(func);
    }

    private void doOpers(String func) throws IOException {
        String line;
        int i;
        this.parseConfig("Operators.cnf");
        int did = 0;
        boolean all = func.equals("ALL");
        for (int iop = 0; iop < this.nops; ++iop) {
            this.parseOperator(iop);
            if (!all && !this.name.equals(func)) continue;
            this.doOper();
            ++did;
        }
        if (did == 0) {
            System.out.println("Generate.doOpers(.) No func=" + func + " found in config table");
        }
        if (!all) {
            return;
        }
        FileWriter tf = this.getFileWriter("OpId.java");
        this.writeHeader(tf);
        tf.write("/**\n   Operator enumeration lookup index. <br>\n    See {@link Operator} for a description of the available I/O Modes.\n   @author  Auto-Generated by the {@link Generate} class.\n*/\n");
        tf.write("public interface OpId { \n\n");
        for (i = 0; i < this.nops; ++i) {
            String id = this.getS(this.lines[this.ops[i]], 0);
            String clazz = this.getS(this.lines[this.ops[i]], 1);
            tf.write("  /** Identifier symbol for the " + clazz + " operator.\n      @see " + clazz + "\n   */\n  public static final int " + id + " = " + (i + 1) + ";\n\n");
        }
        tf.write("  /** The total number of operators. */\n  public static final int MAXOPS = " + this.nops + ";\n\n");
        tf.write("}\n");
        tf.close();
        tf = this.getFileWriter("Operators.java");
        if (this.verbose) {
            System.out.println("Generating Operators.java");
        }
        this.writeHeader(tf);
        tf.write("import nxm.sys.inc.*;\n\n");
        tf.write("/**\n   Operator class resolver. <br>\n   @author  Auto-Generated by the {@link Generate} class.\n   @see OpId\n*/\npublic class Operators implements OpId,Constants {\n\n  /** Get an operator based on its identifier symbol.\n      @param id The identifier symbol for the operator.\n                (See {@link OpId} for the set of operator symbol definitions.)\n      @return A new instance of the operator identified by the identifier symbol provided,\n              or <code>null</code> if the identifier provided does not match one of the valid operators.\n   */ \n  public static Operator get (int id) {\n    Operator op=null;\n    if (id==0) op=null;\n");
        for (i = 0; i < this.nops; ++i) {
            line = this.lines[this.ops[i]];
            tf.write("    else if (id==" + this.getS(line, 0) + ") op = new " + this.getS(line, 1) + "();\n");
        }
        tf.write("    return op;\n  }\n\n\n  /** Get an operator based on its identifier symbol.\n      @param id The identifier for the operator.\n                (See <code>Operators.cnf</code> for the definitions of the identifiers.)\n      @return A new instance of the operator identified by the identifier symbol provided,\n              or <code>null</code> if the identifier provided does not match one of the valid operators.\n   */ \n  public static Operator get (String id) {\n    Operator op=null;\n    if (id==null||id.length()==0) op=null;\n");
        for (i = 0; i < this.nlines; ++i) {
            line = this.lines[i];
            boolean oper = line.startsWith("OPERATOR");
            boolean alias = line.startsWith("ALIAS");
            if (!oper && !alias) continue;
            String key = this.getS(line, 0).trim();
            String sym = this.getS(line, 2).trim();
            String myFlagsString = this.getS(line, 5);
            if (this.getFlag(myFlagsString, "NOCALC")) continue;
            tf.write("    else if (id.equals(\"" + key + "\")");
            if (sym != null && sym.length() > 0) {
                tf.write(" || id.equals(\"" + sym + "\")");
            }
            if (oper) {
                tf.write(") op = new " + this.getS(line, 1) + "();\n");
            }
            if (!alias) continue;
            tf.write(") op = new " + this.getS(line, 1) + ";\n");
        }
        tf.write("    return op;\n  }\n}\n");
        tf.close();
        this.writeFileList("GeneratedFiles.lst");
        this.writeFileList(".gitignore");
    }

    private void writeHeader(FileWriter tf) throws IOException {
        tf.write("/***********************************/\n");
        tf.write("/* THIS IS AN AUTO-GENERATED CLASS */\n");
        tf.write("/*       !!! DO NOT EDIT !!!       */\n");
        tf.write("/***********************************/\n");
        tf.write("package nxm.sys.libm;\n\n");
    }

    private void writeFileList(String fname) throws IOException {
        FileWriter tf = this.getFileWriter(fname);
        tf.write("OpId.java\nOperators.java\n");
        for (int iop = 0; iop < this.nops; ++iop) {
            this.parseOperator(iop);
            if (this.getFlag("NOGEN")) continue;
            tf.write(this.clazz + ".java\n");
        }
        tf.write("GeneratedFiles.lst\n");
        tf.write(".gitignore\n");
        tf.close();
    }

    private void doOper() throws IOException {
        if (this.text == null || this.text.length() <= 0) {
            this.text = "Performs the " + this.clazz + " operation on arrays. ";
        }
        if (this.getFlag("NOGEN")) {
            if (this.verbose) {
                System.out.println("Generate=N class " + this.clazz + " in " + this.path);
            }
            return;
        }
        if (this.verbose) {
            System.out.println("Generating class " + this.clazz + " in " + this.path);
        }
        if (this.text.indexOf(". ") == -1) {
            this.text = this.text + ". ";
        }
        String shortDescription = this.description == null ? "" : "   " + this.description + " <br>\n";
        FileWriter tfo = this.getFileWriter(this.clazz + ".java");
        this.writeHeader(tfo);
        tfo.write("import nxm.sys.inc.*;\n\n/**\n   " + this.text + "<br>\n" + shortDescription + "   See {@link Operator} for a description of the available I/O Modes.\n   @author  Auto-Generated by the {@link Generate} class.\n   @see     Operator\n*/\n@SuppressWarnings(\"cast\")\npublic final class " + this.clazz + " extends Operator implements Constants {\n\n");
        this.makeOperator(tfo);
        tfo.write("}\n");
        tfo.close();
    }

    private int makeOperator(FileWriter tf) throws IOException {
        int ok = 0;
        this.ranks = -1;
        this.makeDeclarations(tf);
        this.makeConstructors(tf, this.clazz);
        this.makeValidate(tf);
        ok += this.makeProcessMethod1(tf, "double", 0);
        ok += this.makeProcessMethod1(tf, "double", 1);
        ok += this.makeOperatorMethods(tf, "double");
        ok += this.makeProcessMethod1(tf, "float", 0);
        ok += this.makeProcessMethod1(tf, "float", 1);
        ok += this.makeOperatorMethods(tf, "float");
        ok += this.makeProcessMethod1(tf, "int", 0);
        ok += this.makeProcessMethod1(tf, "int", 1);
        this.makeGetMethods(tf, this.ranks);
        return ok += this.makeOperatorMethods(tf, "int");
    }

    private int makeValidate(FileWriter tf) throws IOException {
        int ok = 0;
        tf.write("  public final int validate (char type, int n, int mode) {\n");
        tf.write("    switch (mode) {\n");
        for (int ic = 0; ic < this.ncodes; ++ic) {
            String mode = this.getS(this.codes[ic], 0);
            int dupe = 0;
            for (int i = 0; i < ic; ++i) {
                if (!mode.equals(this.getS(this.codes[i], 0))) continue;
                ++dupe;
            }
            if (dupe != 0) continue;
            tf.write("      case " + mode + ": return n;\n");
        }
        tf.write("      default: return NOSUPPORT;\n    }\n  }\n\n");
        return ok;
    }

    private int makeProcessMethod1(FileWriter tf, String type, int scale) throws IOException {
        int ok = 0;
        if (scale == 1) {
            tf.write("  public final int process (" + type + "[][] v, int n, int mode, double scale) {\n");
        } else {
            tf.write("  public final int process (" + type + "[][] v, int n, int mode) {\n");
        }
        tf.write("    switch (mode) { \n");
        for (int ic = 0; ic < this.ncodes; ++ic) {
            String line = this.codes[ic];
            if (line.indexOf("CODE_D ") >= 0 && !type.equals("double") || line.indexOf("CODE_F ") >= 0 && !type.equals("float") || line.indexOf("CODE_L ") >= 0 && !type.equals("int")) continue;
            String mode = this.getS(line, 0);
            int rank = mode.length();
            String equ = this.getS(line, 1);
            String scl = this.scaled ? ", scale" : "";
            switch (rank) {
                case 1: {
                    tf.write("      case " + mode + ": " + mode + "(v[0],n" + scl + "); return n;\n");
                    break;
                }
                case 2: {
                    tf.write("      case " + mode + ": " + mode + "(v[0],v[1],n" + scl + "); return n;\n");
                    break;
                }
                case 3: {
                    tf.write("      case " + mode + ": " + mode + "(v[0],v[1],v[2],n" + scl + "); return n;\n");
                    break;
                }
                case 4: {
                    tf.write("      case " + mode + ": " + mode + "(v[0],v[1],v[2],v[3],n" + scl + "); return n;\n");
                }
            }
            ++ok;
            if (this.ranks == -1) {
                this.ranks = rank;
                continue;
            }
            if (rank == this.ranks) continue;
            this.ranks = -2;
        }
        tf.write("      default:  return NOSUPPORT;\n");
        tf.write("    }\n");
        tf.write("  }\n\n");
        return ok;
    }

    private int makeProcessMethod3(FileWriter tf, String type) throws IOException {
        int ok = 0;
        tf.write("  public final int process (" + type + "[] a, " + type + "[] b, " + type + "[] c, " + type + "[] d, int n, int mode) {\n");
        tf.write("    switch (mode) { \n");
        for (int ic = 0; ic < this.ncodes; ++ic) {
            String line = this.codes[ic];
            if (line.indexOf("CODE_D ") >= 0 && !type.equals("double") || line.indexOf("CODE_F ") >= 0 && !type.equals("float") || line.indexOf("CODE_L ") >= 0 && !type.equals("int")) continue;
            String mode = this.getS(line, 0);
            int rank = mode.length();
            String equ = this.getS(line, 1);
            String scl = this.scaled ? ", scale" : "";
            switch (rank) {
                case 1: {
                    tf.write("      case " + mode + ": " + mode + "(a,n" + scl + "); return n;\n");
                    break;
                }
                case 2: {
                    tf.write("      case " + mode + ": " + mode + "(a,b,n" + scl + "); return n;\n");
                    break;
                }
                case 3: {
                    tf.write("      case " + mode + ": " + mode + "(a,b,c,n" + scl + "); return n;\n");
                    break;
                }
                case 4: {
                    tf.write("      case " + mode + ": " + mode + "(a,b,c,d,n" + scl + "); return n;\n");
                }
            }
            ++ok;
        }
        tf.write("      default:   return NOSUPPORT;\n");
        tf.write("    }\n");
        tf.write("  }\n\n");
        return ok;
    }

    private int makeOperatorMethods(FileWriter tf, String type) throws IOException {
        int ok = 0;
        for (int ic = 0; ic < this.ncodes; ++ic) {
            int i;
            boolean hasInputSSS;
            int i2;
            String line = this.codes[ic];
            if (line.indexOf("CODE_D ") >= 0 && !type.equals("double") || line.indexOf("CODE_F ") >= 0 && !type.equals("float") || line.indexOf("CODE_L ") >= 0 && !type.equals("int")) continue;
            String mode = this.getS(line, 0);
            int rank = mode.length();
            String equ = this.getS(line, 1);
            String[] vname = new String[]{"a", "b", "c", "d"};
            String[] vpos = new String[]{"first", "second", "third", "fourth"};
            tf.write("  /** Apply this operator to mode {@link Operator#" + mode + "} data.\n");
            for (i2 = 0; i2 < rank; ++i2) {
                tf.write("      @param " + vname[i2] + "     The " + vpos[i2] + "  operand.\n");
            }
            tf.write("      @param n     The number of elements to operate on.\n");
            if (this.scaled) {
                tf.write("      @param scale The scale factor.\n");
                tf.write("      @see #process(" + type + "[][],int,int,double)\n");
            } else {
                tf.write("      @see #process(" + type + "[][],int,int)\n");
            }
            tf.write("   */\n");
            if (this.declarations != null) {
                tf.write("  public final void " + mode + " (");
            } else {
                tf.write("  public static final void " + mode + " (");
            }
            for (i2 = 0; i2 < rank; ++i2) {
                tf.write(type + "[] " + vname[i2] + ", ");
            }
            if (this.scaled) {
                tf.write("int n, double scale) {\n");
            } else {
                tf.write("int n) {\n");
            }
            boolean hasS = mode.indexOf(83) >= 0;
            boolean hasC = mode.indexOf(67) >= 0 || mode.indexOf(71) >= 0;
            boolean hasV = mode.indexOf(86) >= 0;
            boolean hasSC = mode.equals("SC");
            boolean oconst = this.getFlag("OSE");
            int pconst = oconst ? rank : -1;
            this.inputs = rank - this.outputs;
            boolean bl = hasInputSSS = mode.startsWith("SSS") && this.inputs == 3;
            if (this.precodes[ic] != null) {
                tf.write("    " + this.doSubs(this.getS(this.precodes[ic], 1), type, "abcdefg", mode.length(), pconst) + "\n");
            }
            if (this.inputs == 3) {
                for (i = this.inputs; i >= 0; --i) {
                    for (int secondConst = i - 1; secondConst >= 0; --secondConst) {
                        if (this.inputs > 1) {
                            if (i == 0) {
                                tf.write("    } else {\n");
                            } else if (i < this.inputs || secondConst < i - 1) {
                                tf.write("    } else ");
                            } else {
                                tf.write("    ");
                            }
                        }
                        block0 : switch (i) {
                            case 1: {
                                tf.write("if (a.length == 1) {\n");
                                break;
                            }
                            case 2: {
                                switch (secondConst) {
                                    case 0: {
                                        tf.write("if (b.length  == 1) {\n");
                                        break;
                                    }
                                    case 1: {
                                        tf.write("if ((b.length  == 1) && (a.length == 1)) {\n");
                                    }
                                }
                                break;
                            }
                            case 3: {
                                switch (secondConst) {
                                    case 0: {
                                        tf.write("if (c.length == 1) {\n");
                                        break block0;
                                    }
                                    case 1: {
                                        tf.write("if ((c.length == 1) && (a.length == 1)) {\n");
                                        break block0;
                                    }
                                    case 2: {
                                        tf.write("if ((c.length == 1) && (b.length == 1)) {\n");
                                    }
                                }
                            }
                        }
                        if (hasSC) {
                            tf.write("      for (int i=n-1,j=i+i; i>=0; i--,j-=2) {\n");
                        } else if (hasC) {
                            tf.write("      for (int i=0,j=0; i<n; i++,j+=2) {\n");
                        } else if (hasV) {
                            tf.write("      for (int i=0,k=0; i<n; i++,k+=3) {\n");
                        } else {
                            tf.write("      for (int i=0; i<n; i++) {\n");
                        }
                        tf.write("        ");
                        tf.write(this.doSubs(equ, type, "abcdefg", mode.length(), i, secondConst));
                        tf.write("\n      }\n");
                        if (this.inputs <= 1 || i != 0) continue;
                        tf.write("    }\n");
                    }
                    if (i != 0) continue;
                    tf.write("    } else {\n");
                    if (hasSC) {
                        tf.write("      for (int i=n-1,j=i+i; i>=0; i--,j-=2) {\n");
                    } else if (hasC) {
                        tf.write("      for (int i=0,j=0; i<n; i++,j+=2) {\n");
                    } else if (hasV) {
                        tf.write("      for (int i=0,k=0; i<n; i++,k+=3) {\n");
                    } else {
                        tf.write("      for (int i=0; i<n; i++) {\n");
                    }
                    tf.write("        ");
                    tf.write(this.doSubs(equ, type, "abcdefg", mode.length(), i));
                    tf.write("\n      }\n");
                    tf.write("    }\n");
                }
                if (this.postcodes[ic] != null) {
                    tf.write("    " + this.doSubs(this.getS(this.postcodes[ic], 1), type, "abcdefg", mode.length(), pconst) + "\n");
                }
            } else {
                for (i = this.inputs; i >= 0; --i) {
                    if (this.inputs == 1 && i == 1) continue;
                    if (this.inputs > 1) {
                        if (i == 0) {
                            tf.write("    } else {\n");
                        } else if (i < this.inputs) {
                            tf.write("    } else ");
                        } else {
                            tf.write("    ");
                        }
                    }
                    switch (i) {
                        case 1: {
                            tf.write("if (a.length == " + this.getModeLength(mode, i) + ") {\n");
                            break;
                        }
                        case 2: {
                            tf.write("if (b.length == " + this.getModeLength(mode, i) + ") {\n");
                            break;
                        }
                        case 3: {
                            tf.write("if (c.length == " + this.getModeLength(mode, i) + ") {\n");
                        }
                    }
                    if (hasSC) {
                        tf.write("      for (int i=n-1,j=i+i; i>=0; i--,j-=2) {\n");
                    } else if (hasC) {
                        tf.write("      for (int i=0,j=0; i<n; i++,j+=2) {\n");
                    } else if (hasV) {
                        tf.write("      for (int i=0,k=0; i<n; i++,k+=3) {\n");
                    } else {
                        tf.write("      for (int i=0; i<n; i++) {\n");
                    }
                    tf.write("        ");
                    tf.write(this.doSubs(equ, type, "abcdefg", mode.length(), oconst ? rank : i));
                    tf.write("\n      }\n");
                    if (this.inputs <= 1 || i != 0) continue;
                    tf.write("    }\n");
                }
                if (this.postcodes[ic] != null) {
                    tf.write("    " + this.doSubs(this.getS(this.postcodes[ic], 1), type, "abcdefg", mode.length(), pconst) + "\n");
                }
            }
            tf.write("  }\n\n");
            ++ok;
        }
        return ok;
    }

    private int getModeLength(String modes, int i) {
        char m = modes.charAt(i - 1);
        if (m == 'C' || m == 'G') {
            return 2;
        }
        if (m == 'V') {
            return 3;
        }
        return 1;
    }

    private String doSubs(String equ, String type, String vs, int ns, int iconst, int secondConst) {
        for (int i = 0; i < ns; ++i) {
            char v = vs.charAt(i);
            if (i + 1 == iconst || i + 1 == secondConst) {
                equ = this.doSub(equ, v + "", v + "[0]");
                equ = this.doSub(equ, v + "r", v + "[0]");
                equ = this.doSub(equ, v + "i", v + "[1]");
                equ = this.doSub(equ, v + "x", v + "[0]");
                equ = this.doSub(equ, v + "y", v + "[1]");
                equ = this.doSub(equ, v + "z", v + "[2]");
                continue;
            }
            equ = this.doSub(equ, v + "", v + "[i]");
            equ = this.doSub(equ, v + "r", v + "[j]");
            equ = this.doSub(equ, v + "i", v + "[j+1]");
            equ = this.doSub(equ, v + "x", v + "[k]");
            equ = this.doSub(equ, v + "y", v + "[k+1]");
            equ = this.doSub(equ, v + "z", v + "[k+2]");
        }
        equ = this.doSub(equ, "type", type);
        if (type.equals("int")) {
            type = "Integer";
        }
        if (type.equals("float")) {
            type = "Float";
        }
        if (type.equals("double")) {
            type = "Double";
        }
        equ = this.doSub(equ, "Type", type);
        return equ;
    }

    private String doSubs(String equ, String type, String vs, int ns, int iconst) {
        for (int i = 0; i < ns; ++i) {
            char v = vs.charAt(i);
            if (i + 1 == iconst) {
                equ = this.doSub(equ, v + "", v + "[0]");
                equ = this.doSub(equ, v + "r", v + "[0]");
                equ = this.doSub(equ, v + "i", v + "[1]");
                equ = this.doSub(equ, v + "x", v + "[0]");
                equ = this.doSub(equ, v + "y", v + "[1]");
                equ = this.doSub(equ, v + "z", v + "[2]");
                continue;
            }
            equ = this.doSub(equ, v + "", v + "[i]");
            equ = this.doSub(equ, v + "r", v + "[j]");
            equ = this.doSub(equ, v + "i", v + "[j+1]");
            equ = this.doSub(equ, v + "x", v + "[k]");
            equ = this.doSub(equ, v + "y", v + "[k+1]");
            equ = this.doSub(equ, v + "z", v + "[k+2]");
        }
        equ = this.doSub(equ, "type", type);
        if (type.equals("int")) {
            type = "Integer";
        }
        if (type.equals("float")) {
            type = "Float";
        }
        if (type.equals("double")) {
            type = "Double";
        }
        equ = this.doSub(equ, "Type", type);
        return equ;
    }

    private String doSub(String equ, String s1, String s2) {
        String delimiters = " ()[]+-*/;:?<>#$=,|&!~^%.";
        int i = 0;
        while ((i = equ.indexOf(s1, i)) >= 0) {
            int c = i == 0 ? 32 : (int)equ.charAt(i - 1);
            if (delimiters.indexOf(c) >= 0 && delimiters.indexOf(c = i + s1.length() == equ.length() ? 32 : (int)equ.charAt(i + s1.length())) >= 0) {
                equ = equ.substring(0, i) + s2 + equ.substring(i + s1.length());
            }
            ++i;
        }
        return equ;
    }

    private void makeGetMethods(FileWriter tf, int rank) throws IOException {
        if (rank > 0 && this.inputs < 0) {
            this.inputs = rank - this.outputs;
        }
        tf.write("  public int getInputs() { return " + this.inputs + "; }\n");
        tf.write("  public int getOutputs() { return " + this.outputs + "; }\n");
    }

    private void makeDeclarations(FileWriter tf) throws IOException {
        if (this.declarations != null) {
            tf.write("  /* Parameter declarations. */\n  " + this.declarations + "\n\n");
        }
    }

    private void makeConstructors(FileWriter tf, String name) throws IOException {
        tf.write("  /** Create a new instance. */\n  public " + name + "() {\n    super();\n  }\n\n  /** Create a new instance.\n      @param flags The processing flags to use.\n   */\n  public " + name + " (int flags) {\n    super(flags);\n  }\n\n  /** Create a new instance.\n      @param scale The scale factor to use.\n   */\n  public " + name + " (double scale) {\n    super(scale);\n  }\n\n  /** Create a new instance.\n      @param flags The processing flags to use.\n      @param scale The scale factor to use.\n   */\n  public " + name + " (int flags, double scale) {\n    super(flags,scale);\n  }\n\n");
    }

    private void parseConfig(String name) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(this.path + name));
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("!")) continue;
            if (line.startsWith("OPERATOR")) {
                this.ops[this.nops++] = this.nlines;
            }
            while (line.endsWith("\\")) {
                line = line.substring(0, line.length() - 1) + "\n";
                String nextLine = br.readLine();
                if (nextLine == null) break;
                line = line + "        " + nextLine.trim();
            }
            this.lines[this.nlines++] = line + ",,,,,,,";
        }
        this.ops[this.nops] = this.nlines;
        br.close();
    }

    private void parseOperator(int iop) {
        int i;
        String line = this.lines[this.ops[iop]];
        this.name = this.getS(line, 0);
        this.clazz = this.getS(line, 1);
        this.symbol = this.getS(line, 2);
        this.inputs = this.getL(line, 3, -1);
        this.outputs = this.getL(line, 4, 1);
        this.flags = this.getS(line, 5);
        this.text = this.getS(line, 6);
        this.ncodes = 0;
        this.scaled = false;
        this.declarations = null;
        this.description = null;
        for (i = 0; i < 32; ++i) {
            this.postcodes[i] = null;
            this.precodes[i] = null;
            this.codes[i] = null;
        }
        for (i = this.ops[iop]; i < this.ops[iop + 1]; ++i) {
            String curLine = this.lines[i];
            if (debug) {
                System.out.println("processing line for [" + this.name + "]: " + curLine);
            }
            if (curLine.startsWith("INITCODE")) {
                this.precodes[this.ncodes] = curLine;
            }
            if (curLine.startsWith("LOOPCODE")) {
                this.codes[this.ncodes++] = curLine;
            }
            if (curLine.startsWith("EXITCODE")) {
                this.postcodes[this.ncodes - 1] = curLine;
            }
            if (curLine.startsWith("TEXT")) {
                this.description = this.getS(curLine, -1).trim();
            }
            if (curLine.startsWith("VARIABLE")) {
                this.declarations = this.getS(curLine, -1);
                continue;
            }
            if (curLine.indexOf("scale") < 0) continue;
            this.scaled = true;
        }
    }

    private String getS(String line, int index) {
        int inQuote = 0;
        int inParen = 0;
        int iSpace = line.indexOf(" ");
        int iEqual = line.indexOf("=");
        if (index == 0) {
            return line.substring(iSpace + 1, iEqual);
        }
        if (index == -1) {
            index = 1;
            iEqual = iSpace;
        }
        int j = iEqual;
        int k = 0;
        for (int i = iEqual + 1; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"') {
                inQuote = 1 - inQuote;
            } else if (c == '(') {
                ++inParen;
            } else if (c == ')') {
                --inParen;
            }
            if (inQuote > 0 || inParen > 0 || c != ',') continue;
            if (++k < index) {
                j = i;
                continue;
            }
            if (line.charAt(j + 1) == '\"') {
                return line.substring(j + 2, i - 1);
            }
            return line.substring(j + 1, i);
        }
        return "";
    }

    private int getL(String line, int index, int def) {
        String s = this.getS(line, index);
        if (s == null || s.length() == 0) {
            return def;
        }
        char c = s.charAt(0);
        if (c == '0') {
            return 0;
        }
        if (c == '1') {
            return 1;
        }
        if (c == '2') {
            return 2;
        }
        if (c == '3') {
            return 3;
        }
        if (c == '4') {
            return 4;
        }
        return def;
    }

    private boolean getFlag(String flagsString, String flag) {
        return flagsString != null && flagsString.indexOf(flag) >= 0;
    }

    private boolean getFlag(String flag) {
        return this.flags != null && this.flags.indexOf(flag) >= 0;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static void setDebug(boolean val) {
        debug = val;
    }
}

