/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

import nxm.sys.inc.Constants;
import nxm.sys.libm.Operator;

public final class DotProduct
extends Operator
implements Constants {
    public DotProduct() {
    }

    public DotProduct(int flags) {
        super(flags);
    }

    public DotProduct(double scale) {
        super(scale);
    }

    public DotProduct(int flags, double scale) {
        super(flags, scale);
    }

    @Override
    public final int validate(char type, int n, int mode) {
        switch (mode) {
            case 273: {
                return n;
            }
            case 290: {
                return n;
            }
            case 307: {
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode) {
        switch (mode) {
            case 273: {
                DotProduct.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 290: {
                DotProduct.CCS(v[0], v[1], v[2], n);
                return n;
            }
            case 307: {
                DotProduct.VVS(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 273: {
                DotProduct.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 290: {
                DotProduct.CCS(v[0], v[1], v[2], n);
                return n;
            }
            case 307: {
                DotProduct.VVS(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    public static final void SSS(double[] a, double[] b, double[] c, int n) {
        if (b.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = a[i] * b[0];
            }
        } else if (a.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = a[0] * b[i];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                c[i] = a[i] * b[i];
            }
        }
    }

    public static final void CCS(double[] a, double[] b, double[] c, int n) {
        if (b.length == 2) {
            int i = 0;
            int j = 0;
            while (i < n) {
                c[i] = a[j] * b[0] + a[j + 1] * b[1];
                ++i;
                j += 2;
            }
        } else if (a.length == 2) {
            int i = 0;
            int j = 0;
            while (i < n) {
                c[i] = a[0] * b[j] + a[1] * b[j + 1];
                ++i;
                j += 2;
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < n) {
                c[i] = a[j] * b[j] + a[j + 1] * b[j + 1];
                ++i;
                j += 2;
            }
        }
    }

    public static final void VVS(double[] a, double[] b, double[] c, int n) {
        if (b.length == 3) {
            int i = 0;
            int k = 0;
            while (i < n) {
                c[i] = a[k] * b[0] + a[k + 1] * b[1] + a[k + 2] * b[2];
                ++i;
                k += 3;
            }
        } else if (a.length == 3) {
            int i = 0;
            int k = 0;
            while (i < n) {
                c[i] = a[0] * b[k] + a[1] * b[k + 1] + a[2] * b[k + 2];
                ++i;
                k += 3;
            }
        } else {
            int i = 0;
            int k = 0;
            while (i < n) {
                c[i] = a[k] * b[k] + a[k + 1] * b[k + 1] + a[k + 2] * b[k + 2];
                ++i;
                k += 3;
            }
        }
    }

    @Override
    public final int process(float[][] v, int n, int mode) {
        switch (mode) {
            case 273: {
                DotProduct.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 290: {
                DotProduct.CCS(v[0], v[1], v[2], n);
                return n;
            }
            case 307: {
                DotProduct.VVS(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(float[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 273: {
                DotProduct.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 290: {
                DotProduct.CCS(v[0], v[1], v[2], n);
                return n;
            }
            case 307: {
                DotProduct.VVS(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    public static final void SSS(float[] a, float[] b, float[] c, int n) {
        if (b.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = a[i] * b[0];
            }
        } else if (a.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = a[0] * b[i];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                c[i] = a[i] * b[i];
            }
        }
    }

    public static final void CCS(float[] a, float[] b, float[] c, int n) {
        if (b.length == 2) {
            int i = 0;
            int j = 0;
            while (i < n) {
                c[i] = a[j] * b[0] + a[j + 1] * b[1];
                ++i;
                j += 2;
            }
        } else if (a.length == 2) {
            int i = 0;
            int j = 0;
            while (i < n) {
                c[i] = a[0] * b[j] + a[1] * b[j + 1];
                ++i;
                j += 2;
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < n) {
                c[i] = a[j] * b[j] + a[j + 1] * b[j + 1];
                ++i;
                j += 2;
            }
        }
    }

    public static final void VVS(float[] a, float[] b, float[] c, int n) {
        if (b.length == 3) {
            int i = 0;
            int k = 0;
            while (i < n) {
                c[i] = a[k] * b[0] + a[k + 1] * b[1] + a[k + 2] * b[2];
                ++i;
                k += 3;
            }
        } else if (a.length == 3) {
            int i = 0;
            int k = 0;
            while (i < n) {
                c[i] = a[0] * b[k] + a[1] * b[k + 1] + a[2] * b[k + 2];
                ++i;
                k += 3;
            }
        } else {
            int i = 0;
            int k = 0;
            while (i < n) {
                c[i] = a[k] * b[k] + a[k + 1] * b[k + 1] + a[k + 2] * b[k + 2];
                ++i;
                k += 3;
            }
        }
    }

    @Override
    public final int process(int[][] v, int n, int mode) {
        switch (mode) {
            case 273: {
                DotProduct.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 290: {
                DotProduct.CCS(v[0], v[1], v[2], n);
                return n;
            }
            case 307: {
                DotProduct.VVS(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(int[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 273: {
                DotProduct.SSS(v[0], v[1], v[2], n);
                return n;
            }
            case 290: {
                DotProduct.CCS(v[0], v[1], v[2], n);
                return n;
            }
            case 307: {
                DotProduct.VVS(v[0], v[1], v[2], n);
                return n;
            }
        }
        return -1;
    }

    public static final void SSS(int[] a, int[] b, int[] c, int n) {
        if (b.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = a[i] * b[0];
            }
        } else if (a.length == 1) {
            for (int i = 0; i < n; ++i) {
                c[i] = a[0] * b[i];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                c[i] = a[i] * b[i];
            }
        }
    }

    public static final void CCS(int[] a, int[] b, int[] c, int n) {
        if (b.length == 2) {
            int i = 0;
            int j = 0;
            while (i < n) {
                c[i] = a[j] * b[0] + a[j + 1] * b[1];
                ++i;
                j += 2;
            }
        } else if (a.length == 2) {
            int i = 0;
            int j = 0;
            while (i < n) {
                c[i] = a[0] * b[j] + a[1] * b[j + 1];
                ++i;
                j += 2;
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < n) {
                c[i] = a[j] * b[j] + a[j + 1] * b[j + 1];
                ++i;
                j += 2;
            }
        }
    }

    public static final void VVS(int[] a, int[] b, int[] c, int n) {
        if (b.length == 3) {
            int i = 0;
            int k = 0;
            while (i < n) {
                c[i] = a[k] * b[0] + a[k + 1] * b[1] + a[k + 2] * b[2];
                ++i;
                k += 3;
            }
        } else if (a.length == 3) {
            int i = 0;
            int k = 0;
            while (i < n) {
                c[i] = a[0] * b[k] + a[1] * b[k + 1] + a[2] * b[k + 2];
                ++i;
                k += 3;
            }
        } else {
            int i = 0;
            int k = 0;
            while (i < n) {
                c[i] = a[k] * b[k] + a[k + 1] * b[k + 1] + a[k + 2] * b[k + 2];
                ++i;
                k += 3;
            }
        }
    }

    @Override
    public int getInputs() {
        return 2;
    }

    @Override
    public int getOutputs() {
        return 1;
    }
}

